/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import java.math.BigDecimal;

public class CheckQtyAndBaseqtyVRule
extends AbstractServerVRule {
    public CheckQtyAndBaseqtyVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz) || StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillBaseInfo invBillBaseInfo = (SCMBillBaseInfo)bean;
        if ((invBillBaseInfo instanceof OtherInWarehsBillInfo || invBillBaseInfo instanceof OtherIssueBillInfo) && ("mxmcXEczQ52MGxLV1Oyh9SQHQ1w=".equals(invBillBaseInfo.getBizType().getId().toString()) || "KVe1UEnNT260YmBCLwKZKSQHQ1w=".equals(invBillBaseInfo.getBizType().getId().toString()))) {
            return;
        }
        IObjectCollection entrys = invBillBaseInfo.getEntries();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            SCMBillEntryBaseInfo entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
            if (entry == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString())) {
                if (entry.getBigDecimal("qty").compareTo(entry.getBigDecimal("baseQty")) != 0) {
                    throw new InvBizException(InvBizException.BASEQTYNOTMATCH, new Object[]{"", String.valueOf(j + 1)});
                }
            } else {
                MeasureUnitInfo unit = entry.getUnit();
                MaterialInfo aMaterialInfo = entry.getMaterial();
                BigDecimal qty = entry.getBigDecimal("qty");
                if (entry.getMaterial() != null) {
                    BigDecimal baseQty = InvServerUtils.getBaseUnitQty((Context)this.getCtx(), (MeasureUnitInfo)unit, (MaterialInfo)aMaterialInfo, (BigDecimal)qty);
                    if (baseQty == null) {
                        throw new SCMBillException(SCMBillException.BASEUNIT_ERROR, new Object[]{j + 1, aMaterialInfo.getNumber()});
                    }
                    if (baseQty.compareTo(entry.getBigDecimal("baseQty")) != 0) {
                        throw new InvBizException(InvBizException.BASEQTYNOTMATCH, new Object[]{"", String.valueOf(j + 1)});
                    }
                }
            }
            if (entry.getBigDecimal("qty") == null || SysConstant.BIGZERO.compareTo(entry.getBigDecimal("qty")) == 0 || entry.getBigDecimal("baseQty") != null && entry.getBigDecimal("baseQty").compareTo(SysConstant.BIGZERO) != 0) continue;
            throw new InvBizException(InvBizException.BASEQTYNULL, new Object[]{String.valueOf(j + 1)});
        }
    }
}

