/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.im.reservation.AbstractReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.util.MDUtil;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.io.Serializable;

public class ReservationSchemaInfo
extends AbstractReservationSchemaInfo
implements Serializable {
    private EntityObjectInfo billEntity;
    BillReservationTableSettingCollection tblSettingCollection = null;

    public ReservationSchemaInfo() {
    }

    protected ReservationSchemaInfo(String pkField) {
        super(pkField);
    }

    private void initEntity() {
        if (this.billEntity == null && !StringUtil.isEmpty((String)this.getBillFullName())) {
            this.billEntity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.getBillFullName()));
        }
    }

    public String getOrgFieldAlias() {
        if (StringUtil.isEmpty((String)this.getBillFullName()) || StringUtil.isEmpty((String)this.getOrgField())) {
            return null;
        }
        this.initEntity();
        return this.getBillAlias() + "." + MDUtil.getEntityPropertyAlias(this.billEntity, this.getOrgField());
    }

    public String getDateFieldAlias() {
        if (StringUtil.isEmpty((String)this.getBillFullName()) || StringUtil.isEmpty((String)this.getDateField())) {
            return null;
        }
        this.initEntity();
        return this.getBillAlias() + "." + MDUtil.getEntityPropertyAlias(this.billEntity, this.getDateField());
    }

    public FilterInfo getFilterInfo() throws Exception {
        FilterInfo filter = new FilterInfo(this.getDataFilter());
        return filter;
    }

    public ReservationSupplyObjectInfo getInventoryEntry() {
        for (int i = 0; i < this.getEntry().size(); ++i) {
            if (!this.getEntry().get(i).isIsInventoryObject()) continue;
            return this.getEntry().get(i);
        }
        return null;
    }

    public ReservationSupplyObjectCollection getSupplyBillEntry() {
        ReservationSupplyObjectCollection coll = new ReservationSupplyObjectCollection();
        for (int i = 0; i < this.getEntry().size(); ++i) {
            if (this.getEntry().get(i).isIsInventoryObject()) continue;
            coll.add(this.getEntry().get(i));
        }
        return coll;
    }

    public void removeSupplyBillEntry() {
        for (int i = 0; i < this.getEntry().size(); ++i) {
            if (this.getEntry().get(i).isIsInventoryObject()) continue;
            this.getEntry().removeObject(i);
        }
    }

    public String toReport() throws Exception {
        String newLine = "\t\n";
        StringBuffer reportStr = new StringBuffer();
        reportStr.append(ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_TITLE")).append(this.getNumber()).append("_").append(this.getName()).append(newLine);
        reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_REQUIREBILL")).append(this.getBillAlias()).append(newLine);
        reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_RESERVATIONSOU")).append(this.getOrgFieldAlias()).append(newLine);
        reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_REQUIREDATE")).append(this.getDateFieldAlias()).append(newLine);
        String filterAlias = MDUtil.getFilterInfoAlias(this.getFilterInfo(), MetaDataPK.create((String)this.getBillQueryPK()));
        reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_REQUIREBILLFILTER")).append(filterAlias).append(newLine);
        ReservationSupplyObjectInfo supplyObject = this.getInventoryEntry();
        reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_INVENTORYSETTING")).append(newLine);
        filterAlias = MDUtil.getFilterInfoAlias(supplyObject.getFilterInfo(), MetaDataPK.create((String)supplyObject.getBillQueryPK()));
        reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_INVENTORYFILTER")).append(filterAlias).append(newLine);
        reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_INVENTORYMATCH")).append(supplyObject.getMatchPropertyCollection(this.getBillFullName()).getAlias()).append(newLine);
        if (this.isIsAutoSchema()) {
            String sortorAlias = MDUtil.getSortorItemCollAlias(supplyObject.getSorterItemCollection(), MetaDataPK.create((String)supplyObject.getBillQueryPK()));
            reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_INVENTORYORDER")).append(sortorAlias).append(newLine);
        } else {
            reportStr.append("  " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERBILLSETTING")).append(newLine);
            ReservationSupplyObjectCollection coll = this.getSupplyBillEntry();
            for (int i = 0; i < coll.size(); ++i) {
                supplyObject = coll.get(i);
                reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERBILL")).append(supplyObject.getBillAlias()).append(newLine);
                reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERSOU")).append(supplyObject.getOrgFieldAlias()).append(newLine);
                reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERDATE")).append(supplyObject.getDateFieldAlias()).append(newLine);
                filterAlias = MDUtil.getFilterInfoAlias(supplyObject.getFilterInfo(), MetaDataPK.create((String)supplyObject.getBillQueryPK()));
                reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERBILLFILTER")).append(filterAlias).append(newLine);
                reportStr.append("      " + ReservationUtil.getResourceString("RESERVATIONSCHEMA_REPORT_SUPPLIERBILLMATCH")).append(supplyObject.getMatchPropertyCollection(this.getBillFullName()).getAlias()).append(newLine);
                reportStr.append(newLine);
            }
        }
        return reportStr.toString();
    }

    void initTblSettingCollection() {
        if (this.tblSettingCollection == null) {
            String settingStr = this.getBillTableSetting();
            this.tblSettingCollection = new BillReservationTableSettingCollection(settingStr);
        }
    }

    public String getBillIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBillIDFieldName();
    }

    public String getEntryIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryIDFieldName();
    }

    public String getEntryPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryPropertyName();
    }

    public String getEntryMaterialIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryMaterialIDFieldName();
    }

    public String getEntryMaterialPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryMaterialPropertyName();
    }

    public String getBaseQtyFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBaseQtyFieldName();
    }

    public String getBaseQtyPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBaseQtyPropertyName();
    }

    public String getAssistQtyFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getAssistQtyFieldName();
    }

    public String getAssistQtyPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getAssistQtyPropertyName();
    }

    public boolean isReservationBillHead() {
        return false;
    }

    public String getOrderByStr() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getOrderByStr();
    }

    public String toString() {
        return this.getNumber() + "-" + this.getName();
    }
}

