/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.reservation.IReservationFacade;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractBill2BillReservationOptionUI;
import com.kingdee.eas.scm.im.reservation.client.Object2BillReservationOptionUI;
import com.kingdee.eas.scm.im.reservation.client.ObjectReservationFilterUI;
import com.kingdee.eas.scm.im.reservation.model.ReservationConversionModel;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class Bill2BillReservationOptionUI
extends AbstractBill2BillReservationOptionUI {
    private static final long serialVersionUID = 2073969146095224998L;
    private static final Logger logger = CoreUIObject.getLogger(Object2BillReservationOptionUI.class);
    private String requireBillIDFieldName = "";
    private String requireEntryIDFieldName = "";
    private String requireEntryMaterialIDFieldName = "";
    static final String TB_RESERVATIONBASEQTY = "auto_add_reservationBaseQty";
    static final String TB_UNRESERVATIONBASEQTY = "auto_add_unReservationBaseQty";
    static final String TB_CURRESERVATIONBASEQTY = "auto_add_curReservationBaseQty";
    static final String TB_RESERVATIONASSISTQTY = "auto_add_reservationAssistQty";
    static final String TB_UNRESERVATIONASSISTQTY = "auto_add_unReservationAssistQty";
    static final String TB_CURRESERVATIONASSISTQTY = "auto_add_curReservationAssistQty";
    private KDTSortManager upSortMger = new KDTSortManager(this.tblMain);
    private int upSort = 0;
    private KDTSortManager requireTableUpSortMger = null;
    private int requireTableUpSort = 0;
    Map<Integer, TabBillReservationData> tabBillReservationMap = new HashMap<Integer, TabBillReservationData>();
    KDTable[] tabs = null;
    ReservationSchemaInfo reservationSchemaInfo = null;
    IObjectValue billInfo = null;
    KDTable requireBillTable = null;
    String requireBillEntryTableName = "";
    FilterInfo defaultReservationFilter;
    private ListUI curentBillListUI = null;
    String curSelectRequireBillMaterialID = "";
    MaterialInfo curMaterialInfo = null;
    MeasureUnitInfo curBaseUnit = null;
    MeasureUnitInfo curAssistUnit = null;
    int curBaseUnitPrecision = 4;
    int curAssistUnitPrecision = 4;
    Map<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
    Map<String, MeasureUnitInfo> baseUnitMap = new HashMap<String, MeasureUnitInfo>();
    Map<String, MeasureUnitInfo> assistUnitMap = new HashMap<String, MeasureUnitInfo>();
    String preSelectRequireBillMaterialID = "";
    String curSelectRequireBillEntryID = "";
    int selectRowIndex = 0;
    IObjectValue curEntryInfo = null;
    String curSelectStorageUnitID = "";
    Map<String, MultiMeasureUnitInfo> multiBaseUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
    Map<String, MultiMeasureUnitInfo> multiAssistUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
    Map<String, IObjectValue> requireBillEntryMap = new HashMap<String, IObjectValue>(6);
    int curSelectTab = 0;
    TabBillReservationData curTabBillReservationData = null;
    String maskString = "";
    String entryBosType = "";
    String supplyBillEntryTableName = "";
    private boolean hasBillPanelChange = false;
    Map<String, String> billQuerySqlMap = new HashMap<String, String>(10);
    Map<String, IRowSet> billQueryRowSetMap = new HashMap<String, IRowSet>(10);
    private ObjectReservationFilterUI filterUI = null;
    public CommonQueryDialog commonQueryDialog = null;
    Map<String, IObjectValue> objectMap = new HashMap<String, IObjectValue>();
    Map<String, String> bosTypeMap = new HashMap<String, String>();

    public Bill2BillReservationOptionUI() throws Exception {
        this.defaultReservationFilter = new FilterInfo();
        this.defaultReservationFilter.getFilterItems().add(new FilterItemInfo("reservationType", (Object)1, CompareType.EQUALS));
        this.upSortMger = new KDTSortManager(this.tblMain);
        this.upSortMger.setSortAuto(true);
        for (int i = 0; i < this.tblMain.getColumnCount() - 1; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                    Bill2BillReservationOptionUI.this.OrderByForTable(e);
                    return;
                }
            }
        });
    }

    private void OrderByForTable(KDTMouseEvent e) {
        for (int i = 0; i < this.tblMain.getColumnCount() - 1; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        if (e.getType() == 0) {
            String columnName = null;
            columnName = this.tblMain.getColumn(e.getColIndex()).getKey();
            if (columnName == null) {
                return;
            }
            this.upSort = this.upSort == 0 ? 1 : 0;
            this.upSortMger.sort(e.getColIndex(), this.upSort);
        }
    }

    private void OrderByForReqTable(KDTMouseEvent e) {
        if (this.requireBillTable == null || this.requireTableUpSortMger == null) {
            return;
        }
        for (int i = 0; i < this.requireBillTable.getColumnCount() - 1; ++i) {
            this.requireBillTable.getColumn(i).setSortable(true);
        }
        if (e.getType() == 0) {
            String columnName = null;
            columnName = this.requireBillTable.getColumn(e.getColIndex()).getKey();
            if (columnName == null) {
                return;
            }
            this.requireTableUpSort = this.requireTableUpSort == 0 ? 1 : 0;
            this.requireTableUpSortMger.sort(e.getColIndex(), this.requireTableUpSort);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        this.reservationSchemaInfo = (ReservationSchemaInfo)uiContext.get("RESERVATIONSCHEMA");
        this.billInfo = (IObjectValue)uiContext.get("BILLINFO");
        if (null == this.reservationSchemaInfo || null == this.billInfo) {
            return;
        }
        EntityViewInfo requireBillView = new EntityViewInfo();
        if (this.billInfo.get("id") != null) {
            FilterInfo requireBillFilter = this.reservationSchemaInfo.getFilterInfo();
            if (requireBillFilter == null) {
                requireBillFilter = new FilterInfo();
            }
            FilterInfo billFilter = new FilterInfo();
            billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.billInfo.get("id").toString(), CompareType.EQUALS));
            requireBillFilter.mergeFilter(billFilter, "AND");
            requireBillView.setFilter(requireBillFilter);
        }
        this.requireBillIDFieldName = this.reservationSchemaInfo.getBillIDFieldName();
        this.requireEntryIDFieldName = this.reservationSchemaInfo.getEntryIDFieldName();
        this.requireEntryMaterialIDFieldName = this.reservationSchemaInfo.getEntryMaterialIDFieldName();
        int width = 720;
        int height = 150;
        this.requireBillTable = ReservationUtil.buildTable(this.reservationSchemaInfo.getBillTableSetting());
        this.fillBillTableData(this.reservationSchemaInfo.getBillQueryPK(), requireBillView, this.requireBillTable, true);
        this.requireBillTable.setName(this.reservationSchemaInfo.getBillBosType());
        this.requireBillTable.getSelectManager().setSelectMode(2);
        this.requireBillTable.setName(this.reservationSchemaInfo.getBillBosType());
        this.requireBillTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    Bill2BillReservationOptionUI.this.requireBillSelectChange(e);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.requireBillTable.setBounds(new Rectangle(0, 0, this.requireBillPanel.getWidth() - 5, this.requireBillPanel.getHeight() - 20));
        this.requireBillPanel.setLayout((LayoutManager)new BorderLayout());
        this.requireBillTable.setBounds(new Rectangle(10, 10, width - 10, height - 10));
        this.requireBillTable.setVisible(true);
        this.requireBillPanel.removeAll();
        this.requireBillPanel.add((Component)this.requireBillTable, (Object)"Center");
        this.requireBillPanel.validate();
        this.initSelectRowInfo(this.requireBillTable, 0);
        EntityObjectInfo parentObject = null;
        EntityObjectInfo entryObject = null;
        parentObject = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.reservationSchemaInfo.getBillFullName()));
        entryObject = ReservationUtil.getEntryEntityObject(parentObject);
        this.requireBillEntryTableName = entryObject.getTable().getName();
        this.addReservationCell(this.requireBillTable, this.reservationSchemaInfo.getEntryIDFieldName(), this.reservationSchemaInfo.getBaseQtyFieldName(), this.reservationSchemaInfo.getAssistQtyFieldName(), "FREQUIREBILLENTRYID");
        ReservationUtil.removeHasCompleteReservationRow(this.requireBillTable, TB_UNRESERVATIONBASEQTY);
        if (null == this.requireBillTable || this.requireBillTable.getRowCount() == 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NO_BILL_ENTRY_CAN_RESERVATION"));
            SysUtil.abort();
        }
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.requireBillTable.getSelectManager().select(0, 0);
        this.tblMain.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                Bill2BillReservationOptionUI.this.supplyBillTableValueChange(e);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.requireBillTable.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                Bill2BillReservationOptionUI.this.requireBillTableValueChange(e);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.requireTableUpSortMger = new KDTSortManager(this.requireBillTable);
        this.requireTableUpSortMger.setSortAuto(true);
        this.requireBillTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                    Bill2BillReservationOptionUI.this.OrderByForReqTable(e);
                    return;
                }
            }
        });
    }

    void requireBillSelectChange(KDTSelectEvent e) throws BOSException {
        KDTable table = (KDTable)e.getSource();
        this.selectRowIndex = table.getSelectManager().get().getTop();
        if (e.getPrevSelectBlock() != null) {
            int preSelectRowIndex = e.getPrevSelectBlock().getTop();
            this.preSelectRequireBillMaterialID = table.getRow(preSelectRowIndex).getCell(this.requireEntryMaterialIDFieldName).getValue().toString();
        }
        this.initSelectRowInfo(table, this.selectRowIndex);
        this.selectRequireBillRow(table, this.selectRowIndex);
    }

    void initSelectRowInfo(KDTable table, int selectRowIndex) throws BOSException {
        this.curSelectRequireBillMaterialID = table.getRow(selectRowIndex).getCell(this.requireEntryMaterialIDFieldName).getValue().toString();
        try {
            if (this.materialMap.containsKey(this.curSelectRequireBillMaterialID)) {
                this.curMaterialInfo = this.materialMap.get(this.curSelectRequireBillMaterialID);
            } else {
                IMaterial imaterial = MaterialFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("baseUnit.id"));
                sic.add(new SelectorItemInfo("baseUnit.number"));
                sic.add(new SelectorItemInfo("baseUnit.name"));
                sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
                sic.add(new SelectorItemInfo("assistUnit.id"));
                sic.add(new SelectorItemInfo("assistUnit.number"));
                sic.add(new SelectorItemInfo("assistUnit.name"));
                sic.add(new SelectorItemInfo("assistUnit.qtyPrecision"));
                this.curMaterialInfo = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(this.curSelectRequireBillMaterialID), sic);
                this.materialMap.put(this.curSelectRequireBillMaterialID, this.curMaterialInfo);
            }
            if (this.curMaterialInfo != null) {
                this.curBaseUnit = this.curMaterialInfo.getBaseUnit();
                this.curAssistUnit = this.curMaterialInfo.getAssistUnit();
                MultiMeasureUnitInfo multiBaseUnit = null;
                if (this.multiBaseUnitMap.containsKey(this.curBaseUnit.getId().toString())) {
                    multiBaseUnit = this.multiBaseUnitMap.get(this.curBaseUnit.getId().toString());
                } else {
                    IMultiMeasureUnit iMulti = MultiMeasureUnitFactory.getRemoteInstance();
                    multiBaseUnit = iMulti.getMultiUnit(this.curSelectRequireBillMaterialID, this.curBaseUnit.getId().toString());
                    this.multiBaseUnitMap.put(this.curBaseUnit.getId().toString(), multiBaseUnit);
                }
                this.curBaseUnitPrecision = multiBaseUnit != null ? multiBaseUnit.getQtyPrecision() : this.curBaseUnit.getQtyPrecision();
                if (this.curAssistUnit != null) {
                    MultiMeasureUnitInfo multiAssistUnit = null;
                    if (this.multiAssistUnitMap.containsKey(this.curAssistUnit.getId().toString())) {
                        multiAssistUnit = this.multiAssistUnitMap.get(this.curAssistUnit.getId().toString());
                    } else {
                        IMultiMeasureUnit iMulti = MultiMeasureUnitFactory.getRemoteInstance();
                        multiAssistUnit = iMulti.getMultiUnit(this.curSelectRequireBillMaterialID, this.curAssistUnit.getId().toString());
                        this.multiAssistUnitMap.put(this.curAssistUnit.getId().toString(), multiAssistUnit);
                    }
                    this.curAssistUnitPrecision = multiAssistUnit != null ? multiAssistUnit.getQtyPrecision() : this.curAssistUnit.getQtyPrecision();
                } else {
                    this.curAssistUnitPrecision = 4;
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        this.curSelectRequireBillEntryID = table.getRow(selectRowIndex).getCell(this.requireEntryIDFieldName).getValue().toString();
        if (!this.requireBillEntryMap.containsKey(this.curSelectRequireBillEntryID)) {
            ObjectUuidPK requireBillEntryPK = new ObjectUuidPK(this.curSelectRequireBillEntryID);
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            this.curEntryInfo = iDynamicObject.getValue(requireBillEntryPK.getObjectType(), (IObjectPK)requireBillEntryPK);
            this.requireBillEntryMap.put(this.curSelectRequireBillEntryID, this.curEntryInfo);
        } else {
            this.curEntryInfo = this.requireBillEntryMap.get(this.curSelectRequireBillEntryID);
        }
        this.curSelectStorageUnitID = ReservationUtil.getRequireBillStorageUnit(this.reservationSchemaInfo, this.billInfo, this.curEntryInfo);
    }

    public void selectRequireBillRow(KDTable table, int selectRowIndex) {
        if (table == null || selectRowIndex < 0) {
            return;
        }
        try {
            FilterInfo reservationFilter = new FilterInfo();
            if (this.defaultReservationFilter != null) {
                reservationFilter = (FilterInfo)this.defaultReservationFilter.clone();
            }
            try {
                FilterInfo commonFilter;
                if (!StringUtil.isEmpty((String)this.curSelectRequireBillMaterialID)) {
                    reservationFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.curSelectRequireBillMaterialID, CompareType.EQUALS));
                }
                if (!StringUtil.isEmpty((String)this.curSelectStorageUnitID)) {
                    reservationFilter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)this.curSelectStorageUnitID, CompareType.EQUALS));
                }
                if (this.billInfo.get("id") != null) {
                    reservationFilter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)this.billInfo.get("id").toString(), CompareType.NOTEQUALS));
                }
                this.commonQueryDialog = this.getDialog();
                if (this.commonQueryDialog != null && (commonFilter = this.commonQueryDialog.getCommonFilter()) != null) {
                    reservationFilter.mergeFilter(commonFilter, "AND");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mainQuery.setFilter(reservationFilter);
            this.execQuery();
            this.addReservationCell();
            this.requireBillTable.getColumn(TB_CURRESERVATIONASSISTQTY).getStyleAttributes().setLocked(true);
            if (this.curAssistUnit == null) {
                this.tblMain.getColumn(TB_CURRESERVATIONASSISTQTY).getStyleAttributes().setLocked(true);
                ((KDFormattedTextField)this.requireBillTable.getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(this.curBaseUnitPrecision);
                ((KDFormattedTextField)this.tblMain.getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(this.curBaseUnitPrecision);
            } else {
                this.tblMain.getColumn(TB_CURRESERVATIONASSISTQTY).getStyleAttributes().setLocked(false);
                ((KDFormattedTextField)this.requireBillTable.getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(this.curBaseUnitPrecision);
                ((KDFormattedTextField)this.requireBillTable.getColumn(TB_CURRESERVATIONASSISTQTY).getEditor().getComponent()).setPrecision(this.curAssistUnitPrecision);
                ((KDFormattedTextField)this.tblMain.getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(this.curBaseUnitPrecision);
                ((KDFormattedTextField)this.tblMain.getColumn(TB_CURRESERVATIONASSISTQTY).getEditor().getComponent()).setPrecision(this.curAssistUnitPrecision);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    void loadReservationListUI() throws Exception {
        this.hasBillPanelChange = true;
        this.commonQueryDialog = this.getDialog();
        this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
        this.curTabBillReservationData = null;
        FilterInfo reservationFilter = new FilterInfo();
        if (this.defaultReservationFilter != null) {
            reservationFilter = (FilterInfo)this.defaultReservationFilter.clone();
        }
        try {
            FilterInfo commonFilter;
            if (!StringUtil.isEmpty((String)this.curSelectRequireBillMaterialID)) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.curSelectRequireBillMaterialID, CompareType.EQUALS));
            }
            if (!StringUtil.isEmpty((String)this.curSelectStorageUnitID)) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)this.curSelectStorageUnitID, CompareType.EQUALS));
            }
            if (this.billInfo.get("id") != null) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)this.billInfo.get("id").toString(), CompareType.NOTEQUALS));
            }
            this.commonQueryDialog = this.getDialog();
            if (this.commonQueryDialog != null && (commonFilter = this.commonQueryDialog.getCommonFilter()) != null) {
                reservationFilter.mergeFilter(commonFilter, "AND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mainQuery.setFilter(reservationFilter);
        this.execQuery();
        this.addReservationCell();
    }

    public KDTable getMainTable() {
        if (this.curentBillListUI == null) {
            return super.getMainTable();
        }
        return this.curTabBillReservationData.getMainTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tHelper.setUserPreferenceData(null);
        this.tHelper.init();
    }

    private void addReservationCell() {
        if (this.tblMain.getColumn(TB_RESERVATIONBASEQTY) == null && this.tblMain.getColumn(TB_CURRESERVATIONBASEQTY) == null && this.tblMain.getColumn(TB_UNRESERVATIONBASEQTY) == null) {
            IColumn column = null;
            column = this.tblMain.addColumn(0);
            column.setKey(TB_RESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_RESERVATIONBASEQTY"));
            column = this.tblMain.addColumn(1);
            column.setKey(TB_UNRESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(1).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONBASEQTY"));
            column = this.tblMain.addColumn(2);
            column.setKey(TB_CURRESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(false);
            this.tblMain.getHeadRow(0).getCell(2).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_CURRESERVATIONBASEQTY"));
            KDFormattedTextField detailTable_curReservationBaseQty_TextField = new KDFormattedTextField();
            detailTable_curReservationBaseQty_TextField.setName("detailTable_curReservationBaseQty_TextField");
            detailTable_curReservationBaseQty_TextField.setVisible(true);
            detailTable_curReservationBaseQty_TextField.setEditable(true);
            detailTable_curReservationBaseQty_TextField.setHorizontalAlignment(2);
            detailTable_curReservationBaseQty_TextField.setDataType(1);
            detailTable_curReservationBaseQty_TextField.setPrecision(this.curBaseUnitPrecision);
            detailTable_curReservationBaseQty_TextField.setSupportedEmpty(true);
            detailTable_curReservationBaseQty_TextField.setMinimumValue((Comparable)Integer.valueOf(0));
            KDTDefaultCellEditor detailTable_curReservationBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationBaseQty_TextField);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setRequired(true);
            column.setEditor((ICellEditor)detailTable_curReservationBaseQty_CellEditor);
            column = this.tblMain.addColumn(3);
            column.setKey(TB_RESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(3).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_RESERVATIONASSISTQTY"));
            column = this.tblMain.addColumn(4);
            column.setKey(TB_UNRESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            this.tblMain.getHeadRow(0).getCell(4).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONASSISTQTY"));
            column = this.tblMain.addColumn(5);
            column.setKey(TB_CURRESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(false);
            this.tblMain.getHeadRow(0).getCell(5).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_CURRESERVATIONASSISTQTY"));
            KDFormattedTextField detailTable_curReservationAssistQty_TextField = new KDFormattedTextField();
            detailTable_curReservationAssistQty_TextField.setName("detailTable_curReservationAssistQty_TextField");
            detailTable_curReservationAssistQty_TextField.setVisible(true);
            detailTable_curReservationAssistQty_TextField.setEditable(true);
            detailTable_curReservationAssistQty_TextField.setHorizontalAlignment(2);
            detailTable_curReservationAssistQty_TextField.setDataType(1);
            detailTable_curReservationAssistQty_TextField.setPrecision(this.curAssistUnitPrecision);
            detailTable_curReservationAssistQty_TextField.setSupportedEmpty(true);
            detailTable_curReservationAssistQty_TextField.setMinimumValue((Comparable)Integer.valueOf(0));
            KDTDefaultCellEditor detailTable_curReservationAssistQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationAssistQty_TextField);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setRequired(true);
            column.setEditor((ICellEditor)detailTable_curReservationAssistQty_CellEditor);
            this.tblMain.setColumnMoveable(true);
            int INDEX_RESERVATIONBASEQTY = this.tblMain.getColumnIndex(TB_RESERVATIONBASEQTY);
            int INDEX_UNRESERVATIONBASEQTY = this.tblMain.getColumnIndex(TB_UNRESERVATIONBASEQTY);
            int INDEX_CURRESERVATIONBASEQTY = this.tblMain.getColumnIndex(TB_CURRESERVATIONBASEQTY);
            int INDEX_RESERVATIONASSISTQTY = this.tblMain.getColumnIndex(TB_RESERVATIONASSISTQTY);
            int INDEX_UNRESERVATIONASSISTQTY = this.tblMain.getColumnIndex(TB_UNRESERVATIONASSISTQTY);
            int INDEX_CURRESERVATIONASSISTQTY = this.tblMain.getColumnIndex(TB_CURRESERVATIONASSISTQTY);
            this.tblMain.moveColumn(INDEX_RESERVATIONBASEQTY, 0);
            this.tblMain.moveColumn(INDEX_UNRESERVATIONBASEQTY, 1);
            this.tblMain.moveColumn(INDEX_CURRESERVATIONBASEQTY, 2);
            this.tblMain.moveColumn(INDEX_RESERVATIONASSISTQTY, 3);
            this.tblMain.moveColumn(INDEX_UNRESERVATIONASSISTQTY, 4);
            this.tblMain.moveColumn(INDEX_CURRESERVATIONASSISTQTY, 5);
        }
        int count = this.tblMain.getRowCount();
        for (int n = 0; n < count; ++n) {
            IRow row = this.tblMain.getRow(n);
            if (row.getCell("reservationBaseQty").getValue() == null) {
                row.getCell("reservationBaseQty").setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            }
            BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
            baseQty = row.getCell("reservationBaseQty").getValue() instanceof BigDecimal ? (BigDecimal)row.getCell("reservationBaseQty").getValue() : new BigDecimal(row.getCell("reservationBaseQty").getValue().toString());
            row.getCell(TB_RESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            baseQty = baseQty == null ? NumericUtil.BIGDECIMAL_ZERO : baseQty.setScale(this.curBaseUnitPrecision);
            row.getCell(TB_UNRESERVATIONBASEQTY).setValue((Object)baseQty);
            if (row.getCell("reservationAssistQty").getValue() == null) {
                row.getCell("reservationAssistQty").setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            }
            BigDecimal assistQty = NumericUtil.BIGDECIMAL_ZERO;
            assistQty = row.getCell("reservationAssistQty").getValue() instanceof BigDecimal ? (BigDecimal)row.getCell("reservationAssistQty").getValue() : new BigDecimal(row.getCell("reservationAssistQty").getValue().toString());
            row.getCell(TB_RESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            assistQty = assistQty == null ? NumericUtil.BIGDECIMAL_ZERO : assistQty.setScale(this.curAssistUnitPrecision);
            row.getCell(TB_UNRESERVATIONASSISTQTY).setValue((Object)assistQty);
        }
    }

    private void addReservationCell(KDTable table, String entryIDColumnName, String entryBaseQtyColumnName, String entryAssistQtyColumnName, String groupField) {
        if (table.getColumn(TB_RESERVATIONBASEQTY) == null && table.getColumn(TB_CURRESERVATIONBASEQTY) == null && table.getColumn(TB_UNRESERVATIONBASEQTY) == null) {
            IColumn column = null;
            column = table.addColumn(0);
            column.setKey(TB_RESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            table.getHeadRow(0).getCell(0).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_RESERVATIONBASEQTY"));
            column = table.addColumn(1);
            column.setKey(TB_UNRESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            table.getHeadRow(0).getCell(1).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONBASEQTY"));
            column = table.addColumn(2);
            column.setKey(TB_CURRESERVATIONBASEQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(false);
            table.getHeadRow(0).getCell(2).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_CURRESERVATIONBASEQTY"));
            KDFormattedTextField detailTable_curReservationBaseQty_TextField = new KDFormattedTextField();
            detailTable_curReservationBaseQty_TextField.setName("detailTable_curReservationBaseQty_TextField");
            detailTable_curReservationBaseQty_TextField.setVisible(true);
            detailTable_curReservationBaseQty_TextField.setEditable(true);
            detailTable_curReservationBaseQty_TextField.setHorizontalAlignment(2);
            detailTable_curReservationBaseQty_TextField.setDataType(1);
            detailTable_curReservationBaseQty_TextField.setPrecision(this.curBaseUnitPrecision);
            detailTable_curReservationBaseQty_TextField.setSupportedEmpty(true);
            detailTable_curReservationBaseQty_TextField.setMinimumValue((Comparable)Integer.valueOf(0));
            KDTDefaultCellEditor detailTable_curReservationBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationBaseQty_TextField);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setRequired(true);
            column.setEditor((ICellEditor)detailTable_curReservationBaseQty_CellEditor);
            column = table.addColumn(3);
            column.setKey(TB_RESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            table.getHeadRow(0).getCell(3).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_RESERVATIONASSISTQTY"));
            column = table.addColumn(4);
            column.setKey(TB_UNRESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(true);
            table.getHeadRow(0).getCell(4).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_UNRESERVATIONASSISTQTY"));
            column = table.addColumn(5);
            column.setKey(TB_CURRESERVATIONASSISTQTY);
            column.setWidth(-1);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.getStyleAttributes().setLocked(false);
            table.getHeadRow(0).getCell(5).setValue((Object)ReservationUtil.getResourceString("COL_TITLE_CURRESERVATIONASSISTQTY"));
            KDFormattedTextField detailTable_curReservationAssistQty_TextField = new KDFormattedTextField();
            detailTable_curReservationAssistQty_TextField.setName("detailTable_curReservationAssistQty_TextField");
            detailTable_curReservationAssistQty_TextField.setVisible(true);
            detailTable_curReservationAssistQty_TextField.setEditable(true);
            detailTable_curReservationAssistQty_TextField.setHorizontalAlignment(2);
            detailTable_curReservationAssistQty_TextField.setDataType(1);
            detailTable_curReservationAssistQty_TextField.setPrecision(this.curAssistUnitPrecision);
            detailTable_curReservationAssistQty_TextField.setSupportedEmpty(true);
            detailTable_curReservationAssistQty_TextField.setMinimumValue((Comparable)Integer.valueOf(0));
            KDTDefaultCellEditor detailTable_curReservationAssistQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationAssistQty_TextField);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setRequired(true);
            column.setEditor((ICellEditor)detailTable_curReservationAssistQty_CellEditor);
            table.setColumnMoveable(true);
            int INDEX_RESERVATIONBASEQTY = table.getColumnIndex(TB_RESERVATIONBASEQTY);
            int INDEX_UNRESERVATIONBASEQTY = table.getColumnIndex(TB_UNRESERVATIONBASEQTY);
            int INDEX_CURRESERVATIONBASEQTY = table.getColumnIndex(TB_CURRESERVATIONBASEQTY);
            int INDEX_RESERVATIONASSISTQTY = table.getColumnIndex(TB_RESERVATIONASSISTQTY);
            int INDEX_UNRESERVATIONASSISTQTY = table.getColumnIndex(TB_UNRESERVATIONASSISTQTY);
            int INDEX_CURRESERVATIONASSISTQTY = table.getColumnIndex(TB_CURRESERVATIONASSISTQTY);
            table.moveColumn(INDEX_RESERVATIONBASEQTY, 0);
            table.moveColumn(INDEX_UNRESERVATIONBASEQTY, 1);
            table.moveColumn(INDEX_CURRESERVATIONBASEQTY, 2);
            table.moveColumn(INDEX_RESERVATIONASSISTQTY, 3);
            table.moveColumn(INDEX_UNRESERVATIONASSISTQTY, 4);
            table.moveColumn(INDEX_CURRESERVATIONASSISTQTY, 5);
        }
        try {
            if (StringUtil.isEmpty((String)entryIDColumnName) || table.getRowCount() == 0) {
                return;
            }
            ArrayList<String> idList = new ArrayList<String>();
            IRow row = null;
            int rowCount = table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = table.getRow(i);
                idList.add(row.getCell(entryIDColumnName).getValue().toString());
            }
            try {
                IReservationFacade iReservationFacade = ReservationFacadeFactory.getRemoteInstance();
                List list = iReservationFacade.getReservationData(groupField, idList);
                ReservationModel reservationModel = null;
                int size = list.size();
                block5: for (int i = 0; i < size; ++i) {
                    reservationModel = (ReservationModel)list.get(i);
                    int count = table.getRowCount();
                    for (int n = 0; n < count; ++n) {
                        row = table.getRow(n);
                        if (!reservationModel.getFieldValue().equals(row.getCell(entryIDColumnName).getValue().toString())) continue;
                        row.getCell(TB_RESERVATIONBASEQTY).setValue((Object)reservationModel.getTotalReservationBaseQty().setScale(this.curBaseUnitPrecision));
                        row.getCell(TB_RESERVATIONASSISTQTY).setValue((Object)reservationModel.getTotalReservationAssistQty().setScale(this.curAssistUnitPrecision));
                        continue block5;
                    }
                }
            }
            catch (Exception e1) {
                SysUtil.abort();
            }
            int count = table.getRowCount();
            for (int n = 0; n < count; ++n) {
                row = table.getRow(n);
                if (row.getCell(entryBaseQtyColumnName).getValue() == null) {
                    row.getCell(entryBaseQtyColumnName).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                }
                BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
                baseQty = row.getCell(entryBaseQtyColumnName).getValue() instanceof BigDecimal ? (BigDecimal)row.getCell(entryBaseQtyColumnName).getValue() : new BigDecimal(row.getCell(entryBaseQtyColumnName).getValue().toString());
                if (row.getCell(TB_RESERVATIONBASEQTY).getValue() == null) {
                    row.getCell(TB_RESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                }
                BigDecimal reservationBaseQty = (BigDecimal)row.getCell(TB_RESERVATIONBASEQTY).getValue();
                row.getCell(TB_UNRESERVATIONBASEQTY).setValue((Object)baseQty.subtract(reservationBaseQty).setScale(this.curBaseUnitPrecision));
                if (this.reservationSchemaInfo.getBillBosType().equals(table.getName())) {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)baseQty.subtract(reservationBaseQty).setScale(this.curBaseUnitPrecision));
                } else {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                }
                if (StringUtil.isEmpty((String)entryAssistQtyColumnName)) continue;
                if (row.getCell(entryAssistQtyColumnName).getValue() == null) {
                    row.getCell(entryAssistQtyColumnName).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                }
                BigDecimal assistQty = NumericUtil.BIGDECIMAL_ZERO;
                assistQty = row.getCell(entryAssistQtyColumnName).getValue() instanceof BigDecimal ? (BigDecimal)row.getCell(entryAssistQtyColumnName).getValue() : new BigDecimal(row.getCell(entryAssistQtyColumnName).getValue().toString());
                if (row.getCell(TB_RESERVATIONASSISTQTY).getValue() == null) {
                    row.getCell(TB_RESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                }
                BigDecimal reservationAssistQty = (BigDecimal)row.getCell(TB_RESERVATIONASSISTQTY).getValue();
                row.getCell(TB_UNRESERVATIONASSISTQTY).setValue((Object)assistQty.subtract(reservationAssistQty).setScale(this.curAssistUnitPrecision));
                if (this.reservationSchemaInfo.getBillBosType().equals(table.getName())) {
                    row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)assistQty.subtract(reservationAssistQty).setScale(this.curAssistUnitPrecision));
                    continue;
                }
                row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            }
            if (this.reservationSchemaInfo.getBillBosType().equals(table.getName())) {
                boolean hasRemove = ReservationUtil.removeHasCompleteReservationRow(table, TB_UNRESERVATIONBASEQTY);
                if (table.getRowCount() == 0) {
                    this.destroyWindow();
                }
                if (hasRemove) {
                    table.getSelectManager().select(0, 0);
                    this.initSelectRowInfo(table, 0);
                    this.selectRequireBillRow(table, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void fillBillTableData(String billQueryPK, EntityViewInfo view, KDTable table, boolean isRequireBill) throws Exception {
        if (StringUtil.isEmpty((String)billQueryPK) || null == view || null == table) {
            return;
        }
        table.removeRows();
        String sql = "";
        try {
            sql = this.getBillQuerySql(billQueryPK, view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sql = this.parseQuerySql(sql, table, isRequireBill);
        IRowSet rs = this.getBillQueryRowSet(sql);
        IRow row = null;
        ICell cell = null;
        while (rs.next()) {
            row = table.addRow();
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                IColumn column = table.getColumn(i);
                cell = row.getCell(i);
                String columnName = column.getKey();
                if (TB_RESERVATIONBASEQTY.equals(columnName) || TB_CURRESERVATIONBASEQTY.equals(columnName) || TB_UNRESERVATIONBASEQTY.equals(columnName)) continue;
                try {
                    if (rs.getObject(columnName) == null) continue;
                    if (rs.getObject(columnName) instanceof BigDecimal) {
                        if (rs.getBigDecimal(columnName).compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
                            cell.setValue((Object)rs.getBigDecimal(columnName).negate());
                            cell.getStyleAttributes().setFontColor(Color.RED);
                        } else {
                            cell.setValue((Object)rs.getBigDecimal(columnName));
                        }
                    } else {
                        cell.setValue((Object)rs.getString(columnName));
                    }
                    String alias = ReservationUtil.getEnumAlias(ReservationUtil.getQueryBizEnumInfo(billQueryPK, columnName), rs.getString(columnName));
                    if (StringUtil.isEmpty((String)alias)) continue;
                    cell.setValue((Object)alias);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void fillBillTableData(String billQueryPK, EntityViewInfo view, KDTable table, int max_row_count) throws Exception {
        if (StringUtil.isEmpty((String)billQueryPK) || null == view || null == table) {
            return;
        }
        table.removeRows();
        String sql = this.getBillQuerySql(billQueryPK, view);
        sql = this.parseQuerySql(sql, table, max_row_count);
        IRowSet rs = this.getBillQueryRowSet(sql);
        IRow row = null;
        ICell cell = null;
        while (rs.next()) {
            row = table.addRow();
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                IColumn column = table.getColumn(i);
                cell = row.getCell(i);
                String columnName = column.getKey();
                try {
                    if (rs.getObject(columnName) == null) continue;
                    if (rs.getObject(columnName) instanceof BigDecimal) {
                        if (rs.getBigDecimal(columnName).compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
                            cell.setValue((Object)rs.getBigDecimal(columnName).negate());
                            cell.getStyleAttributes().setFontColor(Color.RED);
                        } else {
                            cell.setValue((Object)rs.getBigDecimal(columnName));
                        }
                    } else {
                        cell.setValue((Object)rs.getString(columnName));
                    }
                    String alias = ReservationUtil.getEnumAlias(ReservationUtil.getQueryBizEnumInfo(billQueryPK, columnName), rs.getString(columnName));
                    if (StringUtil.isEmpty((String)alias)) continue;
                    cell.setValue((Object)alias);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getBillQuerySql(String billQueryPK, EntityViewInfo view) throws Exception {
        String sql = "";
        String key = this.curSelectRequireBillMaterialID + billQueryPK;
        if (this.billQuerySqlMap.containsKey(key)) {
            sql = this.billQuerySqlMap.get(key);
        } else {
            IQueryDataAccess qda = QueryDataAccessFactory.getRemoteInstance();
            sql = qda.getQuerySql((IMetaDataPK)MetaDataPK.create((String)billQueryPK), view);
        }
        return sql;
    }

    IRowSet getBillQueryRowSet(String sql) throws Exception {
        IRowSet rs;
        if (this.curTabBillReservationData == null) {
            IReservationFacade iReservationFacade = ReservationFacadeFactory.getRemoteInstance();
            rs = iReservationFacade.getBillRowSet(sql);
        } else {
            String key = this.curSelectRequireBillMaterialID + this.curTabBillReservationData.getMainQueryPK();
            if (this.billQueryRowSetMap.containsKey(key)) {
                rs = this.billQueryRowSetMap.get(key);
            } else {
                IReservationFacade iReservationFacade = ReservationFacadeFactory.getRemoteInstance();
                rs = iReservationFacade.getBillRowSet(sql);
            }
        }
        rs.beforeFirst();
        return rs;
    }

    private String parseQuerySql(String sql, KDTable table, boolean isRequireBill) {
        String field;
        int len;
        if (StringUtil.isEmpty((String)sql) || table == null) {
            return sql;
        }
        int max_row_count = 0;
        max_row_count = isRequireBill ? this.reservationSchemaInfo.getBillTableMaxRow() : this.curTabBillReservationData.getTableMaxRow();
        if (max_row_count <= 0) {
            max_row_count = 200;
        }
        if (sql.lastIndexOf(" ORDER BY ") > 1) {
            sql = sql.substring(0, sql.lastIndexOf(" ORDER BY "));
        }
        StringBuffer needFields = new StringBuffer(512);
        String entryMaterialfield = "";
        String sqlFrom = "";
        String sqlFields = "";
        if (sql.split("FROM").length > 2) {
            sqlFrom = sql.substring(6);
            sqlFields = sql;
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    if (!(field = field.substring(1, field.length() - 1)).equalsIgnoreCase(this.reservationSchemaInfo.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception i) {}
        } else {
            sqlFields = sql.substring(6, sql.indexOf("FROM"));
            sqlFrom = sql.substring(sql.indexOf("FROM"));
            String[] fieldArr = sqlFields.toUpperCase().split(",");
            try {
                len = fieldArr.length;
                for (int i = 0; i < len; ++i) {
                    field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                    field = field.substring(1, field.length() - 1);
                    int columnCount = table.getColumnCount();
                    for (int n = 0; n < columnCount; ++n) {
                        IColumn column = table.getColumn(n);
                        String columnName = column.getKey();
                        if (!columnName.equalsIgnoreCase(field)) continue;
                        needFields.append("," + fieldArr[i]);
                        break;
                    }
                    if (!field.equalsIgnoreCase(this.reservationSchemaInfo.getEntryMaterialIDFieldName())) continue;
                    entryMaterialfield = fieldArr[i].substring(0, fieldArr[i].indexOf(" AS ")).trim();
                }
                if (needFields.length() > 0) {
                    needFields.delete(0, 1);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        String realSql = "";
        realSql = needFields.length() > 0 ? "SELECT TOP " + max_row_count + needFields.toString() + " " + sqlFrom : "SELECT TOP " + max_row_count + " " + sqlFrom;
        if (!StringUtil.isEmpty((String)entryMaterialfield)) {
            EntityObjectInfo entity = null;
            String orgField = null;
            String dbFieldName = null;
            String billQuery = null;
            String fieldName = "";
            String tableAlias = "";
            if (isRequireBill) {
                entity = ReservationUtil.getEntityObjectInfo(this.reservationSchemaInfo.getBillBosType());
                Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(entity);
                orgField = this.reservationSchemaInfo.getOrgField();
                PropertyInfo property = map.get(orgField);
                dbFieldName = property.getMappingField().getName();
                billQuery = this.reservationSchemaInfo.getBillQueryPK();
                fieldName = orgField.indexOf(".") > 1 ? this.reservationSchemaInfo.getEntryIDFieldName() : this.reservationSchemaInfo.getBillIDFieldName();
                tableAlias = ReservationUtil.getQueryPropertyParentAlias(billQuery, fieldName);
                tableAlias = "\"" + tableAlias + "\"";
                dbFieldName = tableAlias + "." + dbFieldName;
            } else {
                entity = ReservationUtil.getEntityObjectInfo(this.curTabBillReservationData.getBosType());
                Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(entity);
                orgField = this.curTabBillReservationData.getSupplyObject().getOrgField();
                PropertyInfo property = map.get(orgField);
                dbFieldName = property.getMappingField().getName();
                billQuery = this.curTabBillReservationData.getMainQueryPK();
                fieldName = orgField.indexOf(".") > 1 ? this.curTabBillReservationData.getEntryIDFieldName() : this.curTabBillReservationData.getBillIDFieldName();
                tableAlias = ReservationUtil.getQueryPropertyParentAlias(billQuery, fieldName);
                tableAlias = "\"" + tableAlias + "\"";
                dbFieldName = tableAlias + "." + dbFieldName;
            }
            realSql = realSql + " AND " + entryMaterialfield + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + dbFieldName + ")";
        }
        return realSql;
    }

    private String parseQuerySql(String sql, KDTable table, int max_row_count) {
        if (max_row_count <= 0) {
            max_row_count = 200;
        }
        String sqlFields = sql.substring(6, sql.indexOf("FROM"));
        String sqlFrom = sql.substring(sql.indexOf("FROM"));
        String[] fieldArr = sqlFields.toUpperCase().split(",");
        StringBuffer needFields = new StringBuffer(512);
        try {
            int len = fieldArr.length;
            block2: for (int i = 0; i < len; ++i) {
                String field = fieldArr[i].substring(fieldArr[i].indexOf(" AS ") + 4).trim();
                field = field.substring(1, field.length() - 1);
                int columnCount = table.getColumnCount();
                for (int n = 0; n < columnCount; ++n) {
                    IColumn column = table.getColumn(n);
                    String columnName = column.getKey();
                    if (!columnName.equalsIgnoreCase(field)) continue;
                    needFields.append("," + fieldArr[i]);
                    continue block2;
                }
            }
            if (needFields.length() > 0) {
                needFields.delete(0, 1);
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        String realSql = "";
        realSql = needFields.length() > 0 ? "SELECT TOP " + max_row_count + needFields.toString() + " " + sqlFrom : sql;
        return realSql;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InventoryFactory.getRemoteInstance();
    }

    @Override
    protected void btnFillData_actionPerformed(ActionEvent e) throws Exception {
        super.btnFillData_actionPerformed(e);
        this.fillReservationData();
    }

    private void fillReservationData() {
        BigDecimal curReservationBaseQty = (BigDecimal)this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONBASEQTY).getValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
            return;
        }
        IRow row = null;
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal totalCurReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationAssistqty = NumericUtil.BIGDECIMAL_ZERO;
        try {
            int i;
            int rowCount = this.tblMain.getRowCount();
            for (i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
                row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            }
            rowCount = this.tblMain.getRowCount();
            for (i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                unReservationBaseQty = (BigDecimal)row.getCell(TB_UNRESERVATIONBASEQTY).getValue();
                unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                unReservationAssistQty = (BigDecimal)row.getCell(TB_UNRESERVATIONASSISTQTY).getValue();
                if (unReservationAssistQty == null) {
                    unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                }
                if (unReservationBaseQty == null || unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
                if (curReservationBaseQty.compareTo(unReservationBaseQty) > 0) {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)unReservationBaseQty);
                    if (this.curAssistUnit != null) {
                        curReservationAssistqty = ReservationUtil.getUnitQty(null, unReservationBaseQty, this.curSelectRequireBillMaterialID, this.curBaseUnit.getId().toString(), this.curAssistUnit.getId().toString());
                        if (curReservationBaseQty.compareTo(unReservationAssistQty) >= 0) {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
                        } else {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistqty);
                        }
                    }
                    curReservationBaseQty = curReservationBaseQty.subtract(unReservationBaseQty);
                } else {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)curReservationBaseQty);
                    if (this.curAssistUnit != null) {
                        curReservationAssistqty = ReservationUtil.getUnitQty(null, curReservationBaseQty, this.curSelectRequireBillMaterialID, this.curBaseUnit.getId().toString(), this.curAssistUnit.getId().toString());
                        if (curReservationBaseQty.compareTo(unReservationAssistQty) >= 0) {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
                        } else {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistqty);
                        }
                    }
                    curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                }
                curReservationAssistqty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue();
                if (curReservationAssistqty == null) {
                    curReservationAssistqty = NumericUtil.BIGDECIMAL_ZERO;
                }
                if (curReservationAssistqty.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) {
                    totalCurReservationAssistQty = totalCurReservationAssistQty.add(curReservationAssistqty);
                }
                if (curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) break;
            }
            this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)totalCurReservationAssistQty);
            BigDecimal bigDecimal = (BigDecimal)this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_UNRESERVATIONASSISTQTY).getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearReservationData() {
        IRow row = null;
        this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(TB_CURRESERVATIONBASEQTY).getValue() == null) continue;
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
    }

    void supplyBillTableValueChange(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        IRow row = kDTable.getRow(selectRow);
        BigDecimal totalCurReservationBaseQty = (BigDecimal)this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONBASEQTY).getValue();
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationBaseQty = (BigDecimal)row.getCell(TB_UNRESERVATIONBASEQTY).getValue();
        if (unReservationBaseQty == null || unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        if ((curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue()).compareTo(unReservationBaseQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONQTY_CANNOT_GREATTHAN_UNRESERVATIONQTY"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)unReservationBaseQty);
        }
        BigDecimal totalSupply = this.getSupplyBillTotalCurReservationBaseQty();
        curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
        if (totalSupply.compareTo(totalCurReservationBaseQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("SUPPLYTOTALRESERVATIONQTY_GREATTHAN_CURRESERVATIONQTY"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)curReservationBaseQty.subtract(totalSupply.subtract(totalCurReservationBaseQty)));
        }
        if (kDTable.getColumnKey(selectCol).equals(TB_CURRESERVATIONBASEQTY) && this.curAssistUnit != null) {
            try {
                BigDecimal curReservationAssistQty = ReservationUtil.getUnitQty(null, curReservationBaseQty, this.curSelectRequireBillMaterialID, this.curBaseUnit.getId().toString(), this.curAssistUnit.getId().toString());
                row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistQty);
                this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)this.getSupplyBillTotalCurReservationAssistQty());
            }
            catch (Exception curReservationAssistQty) {
                // empty catch block
            }
        }
        BigDecimal totalCurReservationAssistQty = (BigDecimal)this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_UNRESERVATIONASSISTQTY).getValue();
        BigDecimal unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationAssistQty = (BigDecimal)row.getCell(TB_UNRESERVATIONASSISTQTY).getValue();
        if (unReservationAssistQty == null || unReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        BigDecimal curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        curReservationAssistQty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue();
        if (curReservationAssistQty == null || curReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        if (curReservationAssistQty.compareTo(unReservationAssistQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONASSISTQTY_CANNOT_GREATTHAN_UNRESERVATIONASSISTQTY"));
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
        }
        if ((curReservationAssistQty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue()) == null) {
            curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        }
        if (this.curAssistUnit != null) {
            try {
                this.requireBillTable.getRow(this.selectRowIndex).getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)this.getSupplyBillTotalCurReservationAssistQty());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private BigDecimal getSupplyBillTotalCurReservationBaseQty() {
        BigDecimal totalCurReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            curReservationBaseQty = (BigDecimal)this.tblMain.getRow(i).getCell(TB_CURRESERVATIONBASEQTY).getValue();
            if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            totalCurReservationBaseQty = totalCurReservationBaseQty.add(curReservationBaseQty);
        }
        return totalCurReservationBaseQty;
    }

    private BigDecimal getSupplyBillTotalCurReservationAssistQty() {
        BigDecimal totalCurReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            curReservationAssistQty = (BigDecimal)this.tblMain.getRow(i).getCell(TB_CURRESERVATIONASSISTQTY).getValue();
            if (curReservationAssistQty == null || curReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            totalCurReservationAssistQty = totalCurReservationAssistQty.add(curReservationAssistQty);
        }
        return totalCurReservationAssistQty;
    }

    void requireBillTableValueChange(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        this.clearReservationData();
        int selectRow = e.getRowIndex();
        KDTable kDTable = (KDTable)e.getSource();
        IRow row = kDTable.getRow(selectRow);
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationBaseQty = (BigDecimal)row.getCell(TB_UNRESERVATIONBASEQTY).getValue();
        if (unReservationBaseQty == null || unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        if ((curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue()).compareTo(unReservationBaseQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONQTY_CANNOT_GREATTHAN_UNRESERVATIONQTY"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)unReservationBaseQty);
        }
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSave_actionPerformed(e);
        BigDecimal totalCurReservationBaseQty = this.getSupplyBillTotalCurReservationBaseQty();
        if (totalCurReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NORESERVATION_TO_SAVE"));
            SysUtil.abort();
        }
        this.doBillReservation();
    }

    void doBillReservation() throws Exception {
        ArrayList<ReservationConversionModel> list = new ArrayList<ReservationConversionModel>();
        IRow row = null;
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (StringUtil.isEmpty((String)this.curSelectStorageUnitID)) {
                throw new InvReservationException(InvReservationException.RESERVATIONSCHEMA_STORAGEORG_ISNULL, new Object[]{this.reservationSchemaInfo.getNumber()});
            }
            row = this.tblMain.getRow(i);
            curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
            curReservationAssistQty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue();
            if (curReservationAssistQty == null) {
                curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
            }
            if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            ReservationConversionModel model = new ReservationConversionModel();
            model.setStorageOrgId(this.curSelectStorageUnitID);
            model.setMaterialId(this.curSelectRequireBillMaterialID);
            model.setRequireBillBosType(this.reservationSchemaInfo.getBillBosType());
            model.setRequireBillId(this.billInfo.get("id").toString());
            model.setRequireBillEntryId(this.curSelectRequireBillEntryID);
            model.setReservationId(row.getCell("id").getValue().toString());
            model.setConversionBaseQty(curReservationBaseQty);
            model.setBaseUnitId(this.curBaseUnit.getId().toString());
            if (this.curAssistUnit != null) {
                model.setAssistUnitId(this.curAssistUnit.getId().toString());
                model.setConversionAssistQty(curReservationAssistQty);
            }
            model.setReservationSchemaId(this.reservationSchemaInfo.getId().toString());
            list.add(model);
        }
        long begintime = System.currentTimeMillis();
        IReservationFacade iReservationFacade = ReservationFacadeFactory.getRemoteInstance();
        iReservationFacade.object2BillReservation(list);
        this.addReservationCell();
        this.addReservationCell(this.requireBillTable, this.reservationSchemaInfo.getEntryIDFieldName(), this.reservationSchemaInfo.getBaseQtyFieldName(), this.reservationSchemaInfo.getAssistQtyFieldName(), "FREQUIREBILLENTRYID");
        this.refreshList();
        String msg = ReservationUtil.getResourceString("RESERVATION_SUCC");
        ReservationUtil.showReservationMessageBar(this.lblMsg, msg);
        long endtime = System.currentTimeMillis();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private boolean hasReservationDataChange() {
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        return false;
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ObjectReservationFilterUI();
        }
        return this.filterUI;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain != null && !"tblMain".equals(this.tblMain.getName())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"22_Bill2BillReservationOptionUI"));
            SysUtil.abort();
        }
        super.actionQuery_actionPerformed(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo reservationView = new EntityViewInfo();
        FilterInfo reservationFilter = new FilterInfo();
        if (this.defaultReservationFilter != null) {
            reservationFilter = (FilterInfo)this.defaultReservationFilter.clone();
        }
        try {
            FilterInfo commonFilter;
            if (!StringUtil.isEmpty((String)this.curSelectRequireBillMaterialID)) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.curSelectRequireBillMaterialID, CompareType.EQUALS));
            }
            if (!StringUtil.isEmpty((String)this.curSelectStorageUnitID)) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)this.curSelectStorageUnitID, CompareType.EQUALS));
            }
            if (this.billInfo.get("id") != null) {
                reservationFilter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)this.billInfo.get("id").toString(), CompareType.NOTEQUALS));
            }
            this.commonQueryDialog = this.getDialog();
            if (this.commonQueryDialog != null && (commonFilter = this.commonQueryDialog.getCommonFilter()) != null) {
                reservationFilter.mergeFilter(commonFilter, "AND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reservationView.setFilter(reservationFilter);
        return super.getQueryExecutor(queryPK, reservationView);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.tblMain != null && "tblMain".equals(this.tblMain.getName())) {
            this.addReservationCell();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setUiObject(null);
        this.commonQueryDialog.setShowSorter(false);
        return this.commonQueryDialog;
    }

    @Override
    protected void btnFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    protected void btnQuit_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            IObjectValue model = null;
            while (rowSet.next()) {
                EntityObjectInfo entity;
                if (rowSet.getString("objectID") != null) {
                    String objectID = rowSet.getString("objectID");
                    if (this.objectMap.get(objectID) != null) {
                        model = this.objectMap.get(objectID);
                    } else {
                        ObjectUuidPK objectPK = new ObjectUuidPK(objectID);
                        model = iDynamicObject.getValue(objectPK.getObjectType(), (IObjectPK)objectPK);
                        this.objectMap.put(objectID, model);
                    }
                    rowSet.updateString("objectID", (String)model.get("name"));
                }
                if (rowSet.getString("requireBillBosType") != null) {
                    String requireBillBosTypeID = rowSet.getString("requireBillBosType");
                    String requireBillAlias = "";
                    if (this.bosTypeMap.get(requireBillBosTypeID) != null) {
                        requireBillAlias = this.bosTypeMap.get(requireBillBosTypeID);
                    } else {
                        entity = ReservationUtil.getEntityObjectInfo(requireBillBosTypeID);
                        requireBillAlias = entity.getAlias();
                        this.bosTypeMap.put(requireBillBosTypeID, requireBillAlias);
                    }
                    rowSet.updateString("requireBillBosType", requireBillAlias);
                }
                if (rowSet.getString("supplierBillBosType") == null) continue;
                String supplierBillBosTypeID = rowSet.getString("supplierBillBosType");
                String supplierBillAlias = "";
                if (this.bosTypeMap.get(supplierBillBosTypeID) != null) {
                    supplierBillAlias = this.bosTypeMap.get(supplierBillBosTypeID);
                } else {
                    entity = ReservationUtil.getEntityObjectInfo(supplierBillBosTypeID);
                    supplierBillAlias = entity.getAlias();
                    this.bosTypeMap.put(supplierBillBosTypeID, supplierBillAlias);
                }
                rowSet.updateString("supplierBillBosType", supplierBillAlias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    final class TabBillReservationData {
        String listUIName = "";
        String mainQueryPK = "";
        String entityAlias = "";
        String bosType = "";
        EntityViewInfo mainQuery = null;
        String maskString = "";
        KDTable mainTable = null;
        String entryBosType = "";
        String entryTableName = "";
        String tableSetting = "";
        String billIDFieldName = "";
        String entryIDFieldName = "";
        String materialIDFieldName = "";
        String materialPropertyName = "";
        String baseQtyFieldName = "";
        String assistQtyFieldName = "";
        ReservationSupplyObjectInfo supplyObject;
        int tableMaxRow = 0;
        FilterInfo filter = null;
        Map uiContext = null;
        boolean isInited = false;
        KDPanel panel = null;

        TabBillReservationData() {
        }

        public String getMaterialPropertyName() {
            return this.materialPropertyName;
        }

        public void setMaterialPropertyName(String materialPropertyName) {
            this.materialPropertyName = materialPropertyName;
        }

        public String getAssistQtyFieldName() {
            return this.assistQtyFieldName;
        }

        public void setAssistQtyFieldName(String assistQtyFieldName) {
            this.assistQtyFieldName = assistQtyFieldName;
        }

        public ReservationSupplyObjectInfo getSupplyObject() {
            return this.supplyObject;
        }

        public void setSupplyObject(ReservationSupplyObjectInfo supplyObject) {
            this.supplyObject = supplyObject;
        }

        public int getTableMaxRow() {
            return this.tableMaxRow;
        }

        public void setTableMaxRow(int tableMaxRow) {
            this.tableMaxRow = tableMaxRow;
        }

        public String getBaseQtyFieldName() {
            return this.baseQtyFieldName;
        }

        public void setBaseQtyFieldName(String baseQtyFieldName) {
            this.baseQtyFieldName = baseQtyFieldName;
        }

        public String getBillIDFieldName() {
            return this.billIDFieldName;
        }

        public void setBillIDFieldName(String billIDFieldName) {
            this.billIDFieldName = billIDFieldName;
        }

        public String getEntryIDFieldName() {
            return this.entryIDFieldName;
        }

        public void setEntryIDFieldName(String entryIDFieldName) {
            this.entryIDFieldName = entryIDFieldName;
        }

        public String getMaterialIDFieldName() {
            return this.materialIDFieldName;
        }

        public void setMaterialIDFieldName(String materialIDFieldName) {
            this.materialIDFieldName = materialIDFieldName;
        }

        public String getTableSetting() {
            return this.tableSetting;
        }

        public void setTableSetting(String tableSetting) {
            this.tableSetting = tableSetting;
        }

        public String getEntryTableName() {
            return this.entryTableName;
        }

        public void setEntryTableName(String entryTableName) {
            this.entryTableName = entryTableName;
        }

        public String getEntryBosType() {
            return this.entryBosType;
        }

        public void setEntryBosType(String entryBosType) {
            this.entryBosType = entryBosType;
        }

        public KDTable getMainTable() {
            return this.mainTable;
        }

        public void setMainTable(KDTable mainTable) {
            this.mainTable = mainTable;
        }

        public String getMainQueryPK() {
            return this.mainQueryPK;
        }

        public String getMaskString() {
            return this.maskString;
        }

        public void setMaskString(String maskString) {
            this.maskString = maskString;
        }

        public void setMainQueryPK(String mainQueryPK) {
            this.mainQueryPK = mainQueryPK;
        }

        public EntityViewInfo getMainQuery() {
            return this.mainQuery;
        }

        public void setMainQuery(EntityViewInfo mainQuery) {
            this.mainQuery = mainQuery;
        }

        public String getListUIName() {
            return this.listUIName;
        }

        public void setListUIName(String listUIName) {
            this.listUIName = listUIName;
        }

        public String getEntityAlias() {
            return this.entityAlias;
        }

        public void setEntityAlias(String entityAlias) {
            this.entityAlias = entityAlias;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }

        public FilterInfo getFilter() {
            return this.filter;
        }

        public void setFilter(FilterInfo filter) {
            this.filter = filter;
        }

        public Map getUiContext() {
            return this.uiContext;
        }

        public void setUiContext(Map uiContext) {
            this.uiContext = uiContext;
        }

        public boolean isInited() {
            return this.isInited;
        }

        public void setInited(boolean isInited) {
            this.isInited = isInited;
        }

        public KDPanel getPanel() {
            return this.panel;
        }

        public void setPanel(KDPanel panel) {
            this.panel = panel;
        }
    }
}

