/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeGroupEnum;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.client.AbstractObjectReservationOptionUI;
import com.kingdee.eas.scm.im.reservation.client.ObjectReservationFilterUI;
import com.kingdee.eas.scm.im.reservation.client.ReservationTypePriorityOptionUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ObjectReservationOptionUI
extends AbstractObjectReservationOptionUI
implements TreeSelectionListener,
TreeWillExpandListener,
KDTEditListener {
    private static final long serialVersionUID = -3330873778725078927L;
    private static final Logger logger = CoreUIObject.getLogger(ObjectReservationOptionUI.class);
    private String reservationObjectID = null;
    private int reservationType = 0;
    DataChangeListener customerDataChangeListener = null;
    DataChangeListener salesmanDataChangeListener = null;
    DataChangeListener adminOrgUnitDataChangeListener = null;
    DataChangeListener saleOrgUnitDataChangeListener = null;
    DataChangeListener storageOrgUnitDataChangeListener = null;
    String colFormat = "%{" + CtrlFormatUtilities.getDecimalFormatString() + "}f";
    private final String ROOTTAG = "root";
    private final String SUBTAG = "sub";
    private KDTreeNode rootTreeNode = null;
    private ObjectReservationFilterUI filterUI = null;
    public CommonQueryDialog commonQueryDialog = null;
    private static final BOSUuid rootUuid = BOSUuid.read((String)"111111111111111111111111111=");
    boolean kDTreeMaterialFirstLoad = true;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;
    private ItemListener groupStandardListener = null;
    private ItemListener reservationTypeListener = null;
    private HashSet materialGroupSet = new HashSet();
    private FilterInfo matFilter = null;
    private FilterInfo wareFilter = null;
    private FilterInfo inventoryFilter = null;
    private Set authorizedStorageSet = new LinkedHashSet();
    private Set authorizedSouIdSet = new HashSet();
    private static final String permItem = "inventory";
    List<ReservationInfo> reservationObjectList = new ArrayList<ReservationInfo>();
    static final String TB_INVENTORYID = "id";
    static final String TB_MATERIAL_NUMBER = "material.number";
    static final String TB_TOTALRESERVATIONBASEQTY = "totalReservationBaseQty";
    static final String TB_TOTALUNRESERVATIONBASEQTY = "totalUnReservationBaseQty";
    static final String TB_CURRESERVATIONBASEQTY = "curReservationBaseQty";
    static final String TB_BASEQTY = "baseQty";
    static final String TB_TOTALRESERVATIONASSISTQTY = "totalReservationAssistQty";
    static final String TB_TOTALUNRESERVATIONASSISTQTY = "totalUnReservationAssistQty";
    static final String TB_CURRESERVATIONASSISTQTY = "curReservationAssistQty";
    static final String TB_ASSISTQTY = "curStoreAssistQty";
    Map<String, String> materialMap = new HashMap<String, String>();
    private static boolean hasMoreThanOne = false;
    int max_baseUnitPrecision = 0;
    int max_assistUnitPrecision = 0;

    public ObjectReservationOptionUI() throws Exception {
        this.prmtReservationObject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ObjectReservationOptionUI.this.reservationObjectChange();
            }
        });
    }

    private void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                SysUtil.abort();
            }
        }
    }

    private void initSou() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object mainOrgs = null;
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.ControlUnit, (String)"objectReservation_addnew");
        HashSet<String> idSet = new HashSet<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
            FullOrgUnitInfo cu = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                cu = collection.get(i);
                if (cu == null) continue;
                idSet.add(cu.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("CU.id", idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)Character.valueOf('0'), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        this.prmtStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ObjectReservationOptionUI.this.doCheck(e);
            }
        });
        view.setTopCount(1);
        StorageOrgUnitCollection storageCollection = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
        if (storageCollection != null && storageCollection.size() > 0) {
            StorageOrgUnitInfo currentMainOrg = storageCollection.get(0);
            this.prmtStorageOrgUnit.setValue((Object)currentMainOrg);
        }
    }

    void selectCheck(SelectorEvent e) {
    }

    void doCheck(PreChangeEvent e) {
        if (e.getData() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            this.prmtStorageOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    void reservationObjectChange() {
        this.prmtReservationObjectValue.setValue(null);
        ReservationObjectInfo reservationObject = (ReservationObjectInfo)this.prmtReservationObject.getValue();
        if (reservationObject == null) {
            this.prmtReservationObjectValue.setEnabled(false);
        } else if (reservationObject.isIsUserNullObject()) {
            this.prmtReservationObjectValue.setEnabled(false);
            this.prmtReservationObjectValue.setData(null);
            this.prmtReservationObjectValue.setUserData(null);
        } else {
            String bosType = reservationObject.getEntityBosType();
            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(bosType);
            if (entity.getExtendedProperty("defaultF7Query") == null) {
                this.prmtReservationObjectValue.setEnabled(false);
            } else {
                this.prmtReservationObjectValue.setEntityViewInfo(null);
                String queryInfo = entity.getExtendedProperty("defaultF7Query").toString();
                this.prmtReservationObjectValue.setQueryInfo(queryInfo);
                this.prmtReservationObjectValue.getQueryAgent().setEntityViewInfo(null);
                this.prmtReservationObjectValue.getQueryAgent().setDefaultFilterInfo(null);
                this.prmtReservationObjectValue.getQueryAgent().setHasCUDefaultFilter(false);
                this.prmtReservationObjectValue.getQueryAgent().resetRuntimeEntityView();
                this.prmtReservationObjectValue.setFilterInfoProducer(null);
                this.prmtReservationObjectValue.setEnabled(true);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(TB_INVENTORYID, (Object)"12345", CompareType.EQUALS));
                view.setFilter(filter);
            }
        }
    }

    void initStorageOrgUnitDataChangeListener() {
        if (null == this.storageOrgUnitDataChangeListener) {
            this.storageOrgUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationOptionUI.this.prmtStorageOrgUnitDataChange(e);
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChangeListener);
    }

    private void prmtStorageOrgUnitDataChange(DataChangeEvent e) {
        if (null == e || null == e.getNewValue()) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)e.getNewValue();
        OrgUnitCollection orgCol = InvClientUtils.getSaleOrgsInfo(sou);
        HashSet<String> saleOrgIDSet = new HashSet<String>();
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            saleOrgIDSet.add(orgCol.get(i).getId().toString());
        }
        EntityViewInfo view = InvClientUtils.getSaleOrgF7Filter(orgCol);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public OrgType getMainType() {
        return super.getMainType();
    }

    private boolean initKDTreeMain(JTree kdTree) throws Exception {
        kdTree.setModel(new DefaultTreeModel((TreeNode)this.createRootNode()));
        kdTree.setShowsRootHandles(true);
        this.expandAll(kdTree, new TreePath(this.rootTreeNode));
        return true;
    }

    private void expandAll(JTree tree, TreePath parent) {
        KDTreeNode node = (KDTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                KDTreeNode n = (KDTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void addChildrenToNode(BillTypeGroupEnum billTypeGroupEnum, KDTreeNode treeNode) throws Exception {
        IBillType iBillType = BillTypeFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)new Integer(12), CompareType.EQUALS));
        entityView.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.setFilter(filterInfo);
        BillTypeCollection collection = iBillType.getBillTypeCollection(entityView);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                BillTypeInfo aBillTypeInfo = collection.get(i);
                KDTreeNode childrenNode = new KDTreeNode((Object)aBillTypeInfo);
                treeNode.add((MutableTreeNode)childrenNode);
            }
        }
    }

    public void onLoad() throws Exception {
        this.getAuthorizedStorageSet();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.loadGroupStandard();
        this.firstExpendkDTreeMaterial();
        this.kDTreeMaterial.addTreeSelectionListener((TreeSelectionListener)this);
        this.kDTreeMaterial.addTreeWillExpandListener((TreeWillExpandListener)this);
        super.onLoad();
        this.initStorageOrgUnitDataChangeListener();
        this.initCurReservationBaseQtyCell();
        this.tblMain.addKDTEditListener((KDTEditListener)this);
        this.prmtReservationObjectValue.setHasCUDefaultFilter(false);
        this.ctnMain.add((Action)((Object)this.actionFilter));
        this.ctnMain.add((Action)((Object)this.actionSaveObjectReservation));
        this.reservationObjectChange();
        this.fmtReservationBaseQty.setMinimumNumber((Number)0);
        this.fmtReservationBaseQty.setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        this.initSou();
    }

    void initCurReservationBaseQtyCell() {
        KDFormattedTextField detailTable_curReservationBaseQty_TextField = new KDFormattedTextField();
        detailTable_curReservationBaseQty_TextField.setName("detailTable_curReservationBaseQty_TextField");
        detailTable_curReservationBaseQty_TextField.setVisible(true);
        detailTable_curReservationBaseQty_TextField.setEditable(true);
        detailTable_curReservationBaseQty_TextField.setHorizontalAlignment(2);
        detailTable_curReservationBaseQty_TextField.setDataType(1);
        detailTable_curReservationBaseQty_TextField.setPrecision(6);
        detailTable_curReservationBaseQty_TextField.setSupportedEmpty(true);
        detailTable_curReservationBaseQty_TextField.setMinimumValue((Comparable)Integer.valueOf(0));
        KDTDefaultCellEditor detailTable_curReservationBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationBaseQty_TextField);
        this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).getStyleAttributes().setLocked(false);
        this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).setEditor((ICellEditor)detailTable_curReservationBaseQty_CellEditor);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            this.materialTree_valueChanged(e);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ObjectReservationFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            try {
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    private IRowSet getMaterialGroupSet() throws Exception {
        MaterialGroupStandardInfo materialGroupStandard;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        if (this.filterUI == null) {
            this.getFilterUI();
        }
        if ((materialGroupStandard = (MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()) != null) {
            fi.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)materialGroupStandard.getId().toString()));
        }
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.InventoryMaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private void addMaterialGroupNodes(KDTreeNode treeNode) throws Exception {
        IRowSet rs = this.getMaterialGroupSet();
        while (rs.next()) {
        }
    }

    public DefaultKingdeeTreeNode buildkDTreeMaterialByRowSet(IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        MaterialGroupInfo mGroupInfo = this.createRootMaterialGroupInfo();
        rootTreeNode = new DefaultKingdeeTreeNode((Object)mGroupInfo);
        rootTreeNode.setAllowsChildren(true);
        rootTreeNode.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"56_InventoryListUI"));
        nodeMap.put(mGroupInfo.getId().toString(), rootTreeNode);
        while (rows.next()) {
            mGroupInfo = this.createMaterialGroup(rows);
            subTreeNode = new KDTreeNode((Object)mGroupInfo);
            if (!nodeMap.containsKey(mGroupInfo.getParent().getId().toString())) continue;
            parentNode = (DefaultKingdeeTreeNode)nodeMap.get(mGroupInfo.getParent().getId().toString());
            parentNode.add((MutableTreeNode)subTreeNode);
            subTreeNode.setText(mGroupInfo.getNumber() + "(" + mGroupInfo.getName() + ")");
            subTreeNode.setAllowsChildren(true);
            nodeMap.put(mGroupInfo.getId().toString(), subTreeNode);
        }
        this.fillkDTreeMaterialLeaf(rootTreeNode);
        return rootTreeNode;
    }

    private MaterialGroupInfo createRootMaterialGroupInfo() throws Exception {
        MaterialGroupInfo mGroupInfo = new MaterialGroupInfo();
        mGroupInfo.setId(rootUuid);
        mGroupInfo.setName(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"56_InventoryListUI"));
        mGroupInfo.setNumber("");
        return mGroupInfo;
    }

    private MaterialGroupInfo createMaterialGroup(IRowSet row) throws Exception {
        MaterialGroupInfo mGroupInfo = new MaterialGroupInfo();
        mGroupInfo.setId(BOSUuid.read((String)row.getString(TB_INVENTORYID)));
        mGroupInfo.setName(row.getString("name"));
        mGroupInfo.setNumber(row.getString("number"));
        mGroupInfo.setLongNumber(row.getString("longNumber"));
        mGroupInfo.setLevel(row.getInt("level"));
        mGroupInfo.setIsLeaf(row.getBoolean("isLeaf"));
        MaterialGroupInfo parentInfo = new MaterialGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo.setId(rootUuid);
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        mGroupInfo.setParent(parentInfo);
        return mGroupInfo;
    }

    public void fillkDTreeMaterialLeaf(DefaultKingdeeTreeNode parentNode) throws Exception {
        MaterialGroupInfo mGroupInfo = (MaterialGroupInfo)parentNode.getUserObject();
        IRowSet rows = null;
        rows = mGroupInfo.getId().equals((Object)rootUuid) && this.kDTreeMaterialFirstLoad ? this.getNoGroupMaterialSet() : this.getMaterialSet(mGroupInfo);
        MaterialInfo materialInfo = new MaterialInfo();
        KDTreeNode subTreeNode = null;
        while (rows.next()) {
            materialInfo = this.createMaterial(rows);
            subTreeNode = new KDTreeNode((Object)materialInfo);
            subTreeNode.setText(materialInfo.getNumber() + "(" + materialInfo.getName() + ")");
            subTreeNode.setAllowsChildren(false);
            parentNode.add((MutableTreeNode)subTreeNode);
        }
    }

    private IRowSet getNoGroupMaterialSet() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("materialGroup.id", null));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getMaterialSet(MaterialGroupInfo mGroupInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("materialGroup.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)mGroupInfo.getId().toString()));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private MaterialInfo createMaterial(IRowSet row) throws Exception {
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)row.getString(TB_INVENTORYID)));
        materialInfo.setName(row.getString("name"));
        materialInfo.setNumber(row.getString("number"));
        return materialInfo;
    }

    public void firstExpendkDTreeMaterial() throws Exception {
        if (this.kDTreeMaterialFirstLoad) {
            this.fillkDTreeMaterial();
            this.kDTreeMaterialFirstLoad = false;
        }
    }

    private void fillkDTreeMaterial() throws Exception {
        this.kDTreeMaterial.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.createRootNode()));
        this.kDTreeMaterial.setShowsRootHandles(true);
        if (this.kDTreeMaterial.getModel() != null) {
            ((KingdeeTreeModel)this.kDTreeMaterial.getModel()).setAsksAllowsChildren(true);
            this.kDTreeMaterial.setShowsRootHandles(true);
        }
    }

    private DefaultKingdeeTreeNode createRootNode() throws Exception {
        IRowSet rows = this.getMaterialGroupSet();
        return this.buildkDTreeMaterialByRowSet(rows);
    }

    private void reservationTypeChange(ItemEvent e) {
    }

    private void loadGroupStandard() throws Exception {
        this.groupStandardListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectReservationOptionUI.this.itemChanaged(e);
            }
        };
        this.comboGroupStandard.removeItemListener(this.groupStandardListener);
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
            this.comboGroupStandard.addItemListener(this.groupStandardListener);
        }
    }

    private void itemChanaged(ItemEvent e) {
        try {
            this.fillkDTreeMaterial();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void materialTree_valueChanged(TreeSelectionEvent e) throws Exception {
        this.firstExpendkDTreeMaterial();
        if (e.getNewLeadSelectionPath() != null) {
            try {
                TreePath path = this.kDTreeMaterial.getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (node != null && node.getUserObject() instanceof MaterialGroupInfo && !this.materialGroupSet.contains(((MaterialGroupInfo)node.getUserObject()).getId())) {
                    this.fillkDTreeMaterialLeaf(node);
                    this.materialGroupSet.add(((MaterialGroupInfo)node.getUserObject()).getId());
                }
                this.mainQuery = this.getQueryViewInfo();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    public void materialTree_treeWillExpand(TreeExpansionEvent e) throws Exception {
        this.firstExpendkDTreeMaterial();
        if (e.getPath() != null) {
            try {
                TreePath path = e.getPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof MaterialGroupInfo && !this.materialGroupSet.contains(((MaterialGroupInfo)node.getUserObject()).getId())) {
                    this.fillkDTreeMaterialLeaf(node);
                    this.kDTreeMaterial.repaint();
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        try {
            this.materialTree_treeWillExpand(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (null == viewInfo || null == viewInfo.getFilter()) {
            viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_INVENTORYID, (Object)"111"));
            viewInfo.setFilter(filter);
        }
        if (null == viewInfo || null == viewInfo.getFilter() || CollectionUtil.isEmpty((AbstractObjectCollection)viewInfo.getFilter().getFilterItems())) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(TB_INVENTORYID, (Object)"111"));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public EntityViewInfo getQueryViewInfo() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo evFilter = new FilterInfo();
        FilterInfo authorizedStorageFilter = new FilterInfo();
        evFilter = this.mergeFilter(evFilter, this.getStoreOrgUnitFilterInfo(), "AND");
        TreePath path = this.kDTreeMaterial.getSelectionPath();
        if (path != null) {
            MaterialInfo materialInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)node.getUserObject();
                if (!materialGroupInfo.getId().equals((Object)rootUuid)) {
                    evFilter = this.mergeFilter(evFilter, this.getMaterialGroupFilterInfo(materialGroupInfo), "AND");
                }
            } else if (node.getUserObject() instanceof MaterialInfo && !(materialInfo = (MaterialInfo)node.getUserObject()).getId().equals((Object)rootUuid)) {
                evFilter = this.mergeFilter(evFilter, this.getMaterialFilterInfo(materialInfo), "AND");
            }
        }
        if (this.matFilter != null) {
            evFilter.mergeFilter(this.matFilter, "AND");
        }
        if (this.wareFilter != null) {
            evFilter.mergeFilter(this.wareFilter, "AND");
        }
        if (this.inventoryFilter != null) {
            evFilter.mergeFilter(this.inventoryFilter, "AND");
        }
        authorizedStorageFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.authorizedStorageSet, CompareType.INCLUDE));
        evFilter = this.mergeFilter(evFilter, authorizedStorageFilter, "AND");
        if (this.prmtStorageOrgUnit.getValue() != null) {
            FilterInfo souFilter = new FilterInfo();
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            souFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)sou.getNumber(), CompareType.EQUALS));
            evFilter = this.mergeFilter(evFilter, souFilter, "AND");
        }
        ev.setFilter(evFilter);
        return ev;
    }

    public FilterInfo getStoreOrgUnitFilterInfo() {
        Object object = this.prmtStorageOrgUnit.getData();
        FilterInfo filterInfo = new FilterInfo();
        if (object != null) {
            try {
                if (object instanceof StorageOrgUnitInfo) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)object).getId(), CompareType.EQUALS));
                } else if (object instanceof FullOrgUnitInfo) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((FullOrgUnitInfo)object).getId(), CompareType.EQUALS));
                }
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        return filterInfo;
    }

    public FilterInfo getMaterialGroupFilterInfo(MaterialGroupInfo materialGroupInfo) {
        FilterInfo filterInfo = new FilterInfo();
        if (materialGroupInfo != null && !materialGroupInfo.getNumber().equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.number", (Object)materialGroupInfo.getNumber(), CompareType.EQUALS));
            FilterInfo filterInfo2 = new FilterInfo();
            String longNumer = materialGroupInfo.getLongNumber();
            if (!StringUtil.isEmpty((String)longNumer)) {
                filterInfo2.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)(longNumer + "%"), CompareType.LIKE));
            }
            try {
                filterInfo.mergeFilter(filterInfo2, "or");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public FilterInfo mergeFilter(FilterInfo filterInfo, FilterInfo addFilterInfo, String logicStr) throws BOSException {
        if (filterInfo.getFilterItems().size() > 0) {
            if (addFilterInfo.getFilterItems().size() > 0) {
                filterInfo.mergeFilter(addFilterInfo, logicStr);
            }
        } else {
            filterInfo = addFilterInfo;
        }
        if (filterInfo.getFilterItems().size() > 0 && (filterInfo.getMaskString() == null || filterInfo.getMaskString().equals(""))) {
            filterInfo.setMaskString("#0");
        }
        return filterInfo;
    }

    public FilterInfo getMaterialFilterInfo(MaterialInfo materialInfo) {
        FilterInfo filterInfo = new FilterInfo();
        if (materialInfo != null && !materialInfo.getNumber().equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_NUMBER, (Object)materialInfo.getNumber(), CompareType.EQUALS));
        }
        return filterInfo;
    }

    protected void getAuthorizedStorageSet() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int count = storageOrgs.length;
        if (count > 0) {
            OrgUnitInfo orgUnit = null;
            String number = null;
            for (int i = 0; i < count; ++i) {
                orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || (number = orgUnit.getNumber()) == null) continue;
                this.authorizedSouIdSet.add(orgUnit.getId().toString());
                this.authorizedStorageSet.add(number);
            }
        }
    }

    private void checkReservationValidate() {
        int isOK;
        BigDecimal curReservationBaseQty;
        BigDecimal totalUnReservationBaseQty;
        if (this.prmtReservationObject.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"38_ObjectReservationOptionUI"));
            SysUtil.abort();
        } else {
            ReservationObjectInfo reservationObject = (ReservationObjectInfo)this.prmtReservationObject.getValue();
            if (!reservationObject.isIsUserNullObject() && this.prmtReservationObjectValue.getValue() == null) {
                MsgBox.showWarning((String)ReservationUtil.getResourceString("RESERVATIONOBJECT_CANNOT_NULL"));
                SysUtil.abort();
            }
        }
        if (this.getDetailTable() == null || this.getDetailTable().getRowCount() == 0) {
            SysUtil.abort();
        }
        if (null != this.fmtReservationBaseQty.getNumberValue() && (totalUnReservationBaseQty = this.getTotalUnReservationBaseQty(curReservationBaseQty = (BigDecimal)this.fmtReservationBaseQty.getNumberValue())).compareTo(curReservationBaseQty) < 0 && (isOK = MsgBox.showConfirm2((String)ReservationUtil.getResourceString("MATERIAL_TOTALUNRESERVATIONBASEQTY LESSTHAN_CURRESERVATIONBASEQTY"))) != 0) {
            SysUtil.abort();
        }
        IRow row = null;
        BigDecimal curReservationBaseQty2 = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            curReservationBaseQty2 = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
            unReservationBaseQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONBASEQTY).getValue();
            if (curReservationBaseQty2 == null || curReservationBaseQty2.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0 || curReservationBaseQty2.compareTo(unReservationBaseQty) <= 0) continue;
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONBASEQTY_CANNOT_GREATTHAN_TOTALUNRESERVATIONBASEQTY"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue(null);
        }
    }

    boolean hasMoreThanOneMaterial() {
        if (null == this.getDetailTable() || 0 == this.getDetailTable().getRowCount()) {
            return false;
        }
        HashMap materialMap = new HashMap();
        IRow row = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            materialMap.put(row.getCell(TB_MATERIAL_NUMBER).getValue().toString(), null);
            if (materialMap.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void fillReservationData() {
        this.reservationObjectList.clear();
        BigDecimal curReservationBaseQty = (BigDecimal)this.fmtReservationBaseQty.getNumberValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
            return;
        }
        IRow row = null;
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationAssistqty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal totalCurReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        String curBaseUnitId = "";
        String curAssistUnitId = "";
        String curMaterialId = "";
        try {
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                curBaseUnitId = (String)row.getCell("baseUnit.id").getValue();
                curAssistUnitId = (String)row.getCell("assistUnit.id").getValue();
                curMaterialId = (String)row.getCell("material.id").getValue();
                unReservationBaseQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONBASEQTY).getValue();
                unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                unReservationAssistQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONASSISTQTY).getValue();
                if (unReservationBaseQty == null || unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
                if (curReservationBaseQty.compareTo(unReservationBaseQty) > 0) {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)unReservationBaseQty);
                    if (curAssistUnitId != null) {
                        curReservationAssistqty = ReservationUtil.getUnitQty(null, unReservationBaseQty, curMaterialId, curBaseUnitId, curAssistUnitId);
                        if (curReservationBaseQty.compareTo(unReservationAssistQty) >= 0) {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
                        } else {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistqty);
                        }
                    }
                    curReservationBaseQty = curReservationBaseQty.subtract(unReservationBaseQty);
                } else {
                    row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)curReservationBaseQty);
                    if (curAssistUnitId != null) {
                        curReservationAssistqty = ReservationUtil.getUnitQty(null, curReservationBaseQty, curMaterialId, curBaseUnitId, curAssistUnitId);
                        if (curReservationBaseQty.compareTo(unReservationAssistQty) >= 0) {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
                        } else {
                            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistqty);
                        }
                    }
                    curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                }
                curReservationAssistqty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue();
                if (curReservationAssistqty == null) {
                    curReservationAssistqty = NumericUtil.BIGDECIMAL_ZERO;
                }
                if (curReservationAssistqty.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) {
                    totalCurReservationAssistQty = totalCurReservationAssistQty.add(curReservationAssistqty);
                }
                if (curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) break;
            }
            this.fmtReservationAssistQty.setValue((Object)totalCurReservationAssistQty);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void buildObjectReservationList() {
        this.reservationObjectList.clear();
        IRow row = null;
        ReservationInfo reservationInfo = null;
        ReservationObjectInfo reservationObject = (ReservationObjectInfo)this.prmtReservationObject.getValue();
        ReservationTypeEnum reservationType = null;
        if (reservationObject.isIsUserNullObject()) {
            reservationType = ReservationTypeEnum.ReservationType_UserNullObject;
            this.reservationObjectID = null;
        } else {
            reservationType = ReservationTypeEnum.ReservationType_UserObject;
            IObjectValue model = (IObjectValue)this.prmtReservationObjectValue.getValue();
            this.reservationObjectID = model.get(TB_INVENTORYID).toString();
        }
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            if (row.getCell(TB_CURRESERVATIONBASEQTY).getValue() == null || ((BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue()).compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            reservationInfo = new ReservationInfo();
            reservationInfo.setId(BOSUuid.create((String)"8D307D69"));
            reservationInfo.setReservationType(reservationType);
            reservationInfo.setReservationObject(reservationObject);
            reservationInfo.setObjectID(this.reservationObjectID);
            reservationInfo.setInventoryID(row.getCell(TB_INVENTORYID).getValue().toString());
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)row.getCell("storageOrgUnit.id").getValue().toString()));
            reservationInfo.setStorageOrg(sou);
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)row.getCell("baseUnit.id").getValue().toString()));
            reservationInfo.setBaseUnit(baseUnit);
            reservationInfo.setReservationBaseQty((BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue());
            MeasureUnitInfo assistUnit = new MeasureUnitInfo();
            assistUnit.setId(BOSUuid.read((String)row.getCell("assistUnit.id").getValue().toString()));
            reservationInfo.setAssistUnit(assistUnit);
            reservationInfo.setReservationAssistQty((BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue());
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)row.getCell("material.id").getValue().toString()));
            reservationInfo.setMaterial(material);
            this.reservationObjectList.add(reservationInfo);
        }
    }

    void clearCurReservationCell() {
        IRow row = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue(null);
        }
    }

    void doObjectReservation() throws BOSException, EASBizException, Exception {
        long begintime = System.currentTimeMillis();
        this.buildObjectReservationList();
        if (CollectionUtil.isEmpty(this.reservationObjectList)) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NOTMATCHEDRECORD_CANNOT_RESERVATION"));
            SysUtil.abort();
        }
        IReservation iReservation = ReservationFactory.getRemoteInstance();
        iReservation.doObjectReservation(this.reservationObjectList);
        this.refreshList();
        String msg = ReservationUtil.getResourceString("RESERVATION_SUCC");
        this.setMessageText(msg);
        this.showMessage();
    }

    private void showMessageBar(String msg) {
        final KDLabel barLabel = this.lblMsg;
        barLabel.setForeground(SHOW_MESSAGE_FG_DEFAULT);
        Icon icon = this.getMessageIcon();
        final Color bg = this.getMessageBgcolor();
        String message = msg;
        final String nextMessage = null;
        if (icon != null) {
            barLabel.setIcon(icon);
        }
        if (message != null && message.length() > 0) {
            barLabel.setText(message);
        } else {
            barLabel.setText(nextMessage);
        }
        if (bg != null && !this.isShowTextOnly()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 1; ++i) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setBackground(bg);
                                    barLabel.setOpaque(true);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(1000L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setOpaque(false);
                                    barLabel.repaint();
                                }
                            });
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        if (nextMessage == null || nextMessage.length() == 0) {
                            barLabel.setIcon(null);
                        }
                        barLabel.setText(nextMessage);
                        barLabel.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)e);
                    }
                }
            }).start();
        }
    }

    private BigDecimal getTotalUnReservationBaseQty(BigDecimal curReservationBaseQty) {
        BigDecimal totalUnReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        ArrayList retList = new ArrayList();
        BigDecimal baseqty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal totalreservationbaseqty = NumericUtil.BIGDECIMAL_ZERO;
        int index_baseqty = this.getDetailTable().getColumnIndex(TB_BASEQTY);
        int index_totalreservationbaseqty = this.getDetailTable().getColumnIndex(TB_TOTALRESERVATIONBASEQTY);
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            baseqty = (BigDecimal)row.getCell(index_baseqty).getValue();
            if (baseqty == null) {
                baseqty = NumericUtil.BIGDECIMAL_ZERO;
            }
            if ((totalreservationbaseqty = (BigDecimal)row.getCell(index_totalreservationbaseqty).getValue()) == null) {
                totalreservationbaseqty = NumericUtil.BIGDECIMAL_ZERO;
            }
            if ((totalUnReservationBaseQty = totalUnReservationBaseQty.add(baseqty.subtract(totalreservationbaseqty))).compareTo(curReservationBaseQty) >= 0) break;
        }
        return totalUnReservationBaseQty;
    }

    @Override
    protected void btnFillData_actionPerformed(ActionEvent e) throws Exception {
        this.fillReservationData();
        super.btnFillData_actionPerformed(e);
    }

    @Override
    public void actionSaveObjectReservation_actionPerformed(ActionEvent e) throws Exception {
        this.checkReservationValidate();
        this.doObjectReservation();
        super.actionSaveObjectReservation_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        HashMap materialMap = new HashMap();
        hasMoreThanOne = false;
        int precision = 0;
        try {
            while (rowSet.next()) {
                precision = rowSet.getInt("multiBaseUnit.qtyPrecision");
                if (rowSet.getBigDecimal(TB_TOTALRESERVATIONBASEQTY) == null) {
                    rowSet.updateBigDecimal(TB_TOTALRESERVATIONBASEQTY, NumericUtil.BIGDECIMAL_ZERO);
                }
                if (rowSet.getBigDecimal(TB_BASEQTY).compareTo(rowSet.getBigDecimal(TB_TOTALRESERVATIONBASEQTY)) == 0) {
                    rowSet.updateBigDecimal(TB_TOTALUNRESERVATIONBASEQTY, NumericUtil.BIGDECIMAL_ZERO);
                } else {
                    rowSet.updateBigDecimal(TB_TOTALUNRESERVATIONBASEQTY, rowSet.getBigDecimal(TB_BASEQTY).subtract(rowSet.getBigDecimal(TB_TOTALRESERVATIONBASEQTY)));
                }
                if (rowSet.getBigDecimal(TB_TOTALRESERVATIONASSISTQTY) == null) {
                    rowSet.updateBigDecimal(TB_TOTALRESERVATIONASSISTQTY, NumericUtil.BIGDECIMAL_ZERO);
                }
                if (rowSet.getBigDecimal(TB_ASSISTQTY) == null) {
                    rowSet.updateBigDecimal(TB_ASSISTQTY, NumericUtil.BIGDECIMAL_ZERO);
                }
                rowSet.updateBigDecimal(TB_TOTALUNRESERVATIONASSISTQTY, rowSet.getBigDecimal(TB_ASSISTQTY).subtract(rowSet.getBigDecimal(TB_TOTALRESERVATIONASSISTQTY)));
                materialMap.put(rowSet.getString(TB_MATERIAL_NUMBER), null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ((KDFormattedTextField)this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(precision);
        if (materialMap.size() > 1) {
            hasMoreThanOne = true;
            materialMap.clear();
            materialMap = null;
            return;
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        this.max_baseUnitPrecision = 0;
        this.max_assistUnitPrecision = 0;
        int count = this.tblMain.getRowCount();
        if (count >= 200) {
            count = 200;
        }
        IRow row = null;
        String baseUnitId = "";
        String assistUnitId = "";
        int baseUnitPrecision = 4;
        int assistUnitPrecision = 4;
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            baseUnitId = row.getCell("baseUnit.id").getValue() != null ? row.getCell("baseUnit.id").getValue().toString() : "";
            baseUnitPrecision = row.getCell("multiBaseUnit.qtyPrecision").getValue() != null ? Integer.parseInt(row.getCell("multiBaseUnit.qtyPrecision").getValue().toString()) : 4;
            if (baseUnitPrecision > this.max_baseUnitPrecision) {
                this.max_baseUnitPrecision = baseUnitPrecision;
            }
            KDFormattedTextField text1 = new KDFormattedTextField();
            text1.setName("detailTable_curReservationBaseQty_TextField");
            text1.setVisible(true);
            text1.setEditable(true);
            text1.setHorizontalAlignment(2);
            text1.setDataType(1);
            text1.setPrecision(baseUnitPrecision);
            text1.setSupportedEmpty(true);
            text1.setMinimumValue((Comparable)Integer.valueOf(0));
            KDTDefaultCellEditor editor1 = new KDTDefaultCellEditor((JTextField)text1);
            row.getCell(TB_CURRESERVATIONBASEQTY).getStyleAttributes().setLocked(false);
            row.getCell(TB_CURRESERVATIONBASEQTY).setEditor((ICellEditor)editor1);
            assistUnitId = row.getCell("assistUnit.id").getValue() != null ? row.getCell("assistUnit.id").getValue().toString() : "";
            if (!StringUtil.isEmpty((String)assistUnitId)) {
                assistUnitPrecision = row.getCell("multiAssistUnit.qtyPrecision").getValue() != null ? Integer.parseInt(row.getCell("multiAssistUnit.qtyPrecision").getValue().toString()) : 4;
                if (assistUnitPrecision > this.max_assistUnitPrecision) {
                    this.max_assistUnitPrecision = assistUnitPrecision;
                }
                KDFormattedTextField text2 = new KDFormattedTextField();
                text2.setName("detailTable_curReservationBaseQty_TextField");
                text2.setVisible(true);
                text2.setEditable(true);
                text2.setHorizontalAlignment(2);
                text2.setDataType(1);
                text2.setPrecision(assistUnitPrecision);
                text2.setSupportedEmpty(true);
                text2.setMinimumValue((Comparable)Integer.valueOf(0));
                KDTDefaultCellEditor editor2 = new KDTDefaultCellEditor((JTextField)text2);
                row.getCell(TB_CURRESERVATIONASSISTQTY).getStyleAttributes().setLocked(false);
                row.getCell(TB_CURRESERVATIONASSISTQTY).setEditor((ICellEditor)editor2);
                continue;
            }
            row.getCell(TB_CURRESERVATIONASSISTQTY).getStyleAttributes().setLocked(true);
        }
        this.fmtReservationBaseQty.setPrecision(this.max_baseUnitPrecision);
        this.fmtReservationAssistQty.setPrecision(this.max_assistUnitPrecision);
        super.afterTableFillData(e);
        this.setQtyEditorPrecision();
    }

    @Override
    protected void btnQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().trim().length() > 0 || this.prmtMaterial.getText() != null && this.prmtMaterial.getText().trim().length() > 0) {
            this.mainQuery = this.getQuickQueryViewInfo();
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"StorageOrgAndMaterailNotBlank"));
            SysUtil.abort();
        }
    }

    private void setQtyEditorPrecision() {
        IRow row = null;
        int baseQtyPrecision = 8;
        int assistQtyPrecision = 8;
        int invQtyPrecision = 8;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            baseQtyPrecision = (Integer)row.getCell("multiBaseUnit.qtyPrecision").getValue();
            assistQtyPrecision = (Integer)row.getCell("multiAssistUnit.qtyPrecision").getValue();
            invQtyPrecision = (Integer)row.getCell("multiInventoryUnit.qtyPrecision").getValue();
            SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{TB_TOTALRESERVATIONBASEQTY, TB_TOTALUNRESERVATIONBASEQTY, TB_CURRESERVATIONBASEQTY, TB_BASEQTY}, (int)baseQtyPrecision, (boolean)false);
            SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{TB_TOTALRESERVATIONASSISTQTY, TB_TOTALUNRESERVATIONASSISTQTY, TB_CURRESERVATIONASSISTQTY, TB_ASSISTQTY}, (int)assistQtyPrecision, (boolean)false);
            SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{"curMatStoreQty", "curStoreQty"}, (int)invQtyPrecision, (boolean)false);
        }
    }

    public EntityViewInfo getQuickQueryViewInfo() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo evFilter = new FilterInfo();
        evFilter = this.mergeFilter(evFilter, this.getStoreOrgUnitFilterInfo(), "AND");
        FilterInfo materialFilter = new FilterInfo();
        if (this.prmtMaterial.getValue() != null) {
            materialFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
        }
        FilterInfo souFilter = new FilterInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            souFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        evFilter = this.mergeFilter(evFilter, materialFilter, "AND");
        evFilter = this.mergeFilter(evFilter, souFilter, "AND");
        FilterInfo authorizedStorageFilter = new FilterInfo();
        authorizedStorageFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.authorizedStorageSet, CompareType.INCLUDE));
        evFilter = this.mergeFilter(evFilter, authorizedStorageFilter, "AND");
        if (this.matFilter != null) {
            evFilter.mergeFilter(this.matFilter, "AND");
        }
        if (this.wareFilter != null) {
            evFilter.mergeFilter(this.wareFilter, "AND");
        }
        ev.setFilter(evFilter);
        return ev;
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void tableValueChanged(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        IRow row = kDTable.getRow(selectRow);
        BigDecimal totalCurReservationBaseQty = (BigDecimal)this.fmtReservationBaseQty.getNumberValue();
        if (totalCurReservationBaseQty == null) {
            totalCurReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        }
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationBaseQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONBASEQTY).getValue();
        if (unReservationBaseQty == null || unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        if ((curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue()).compareTo(unReservationBaseQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONQTY_CANNOT_GREATTHAN_UNRESERVATIONQTY"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue((Object)unReservationBaseQty);
        }
        BigDecimal totalSupply = this.getSupplyBillTotalCurReservationBaseQty();
        curReservationBaseQty = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
        String curBaseUnitId = (String)row.getCell("baseUnit.id").getValue();
        String curAssistUnitId = (String)row.getCell("assistUnit.id").getValue();
        String curMaterialId = (String)row.getCell("material.id").getValue();
        if (kDTable.getColumnKey(selectCol).equals(TB_CURRESERVATIONBASEQTY) && curBaseUnitId != null) {
            try {
                BigDecimal curReservationAssistQty = ReservationUtil.getUnitQty(null, curReservationBaseQty, curMaterialId, curBaseUnitId, curAssistUnitId);
                row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)curReservationAssistQty);
                this.fmtReservationAssistQty.setValue((Object)this.getSupplyBillTotalCurReservationAssistQty());
            }
            catch (Exception curReservationAssistQty) {
                // empty catch block
            }
        }
        BigDecimal unReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        unReservationAssistQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONASSISTQTY).getValue();
        if (unReservationAssistQty == null || unReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        BigDecimal curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        curReservationAssistQty = (BigDecimal)row.getCell(TB_CURRESERVATIONASSISTQTY).getValue();
        if (curReservationAssistQty == null || curReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
        }
        if (curReservationAssistQty.compareTo(unReservationAssistQty) > 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("CURRESERVATIONASSISTQTY_CANNOT_GREATTHAN_UNRESERVATIONASSISTQTY"));
            row.getCell(TB_CURRESERVATIONASSISTQTY).setValue((Object)unReservationAssistQty);
        }
        this.fmtReservationBaseQty.setValue((Object)this.getSupplyBillTotalCurReservationBaseQty());
        this.fmtReservationAssistQty.setValue((Object)this.getSupplyBillTotalCurReservationAssistQty());
    }

    private BigDecimal getSupplyBillTotalCurReservationBaseQty() {
        BigDecimal totalCurReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            curReservationBaseQty = (BigDecimal)this.tblMain.getRow(i).getCell(TB_CURRESERVATIONBASEQTY).getValue();
            if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            totalCurReservationBaseQty = totalCurReservationBaseQty.add(curReservationBaseQty);
        }
        return totalCurReservationBaseQty;
    }

    private BigDecimal getSupplyBillTotalCurReservationAssistQty() {
        BigDecimal totalCurReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal curReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            curReservationAssistQty = (BigDecimal)this.tblMain.getRow(i).getCell(TB_CURRESERVATIONASSISTQTY).getValue();
            if (curReservationAssistQty == null || curReservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
            totalCurReservationAssistQty = totalCurReservationAssistQty.add(curReservationAssistQty);
        }
        return totalCurReservationAssistQty;
    }

    @Override
    public void actionReservationPriority_actionPerformed(ActionEvent e) throws Exception {
        super.actionReservationPriority_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"className", (Object)this.getMetaDataPK().getFullName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReservationTypePriorityOptionUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected void execQuery() {
        try {
            HashMap nationmap = NantionalServiceFacadeFactory.getRemoteInstance().getNationalConfig(null, null, SysContext.getSysContext().getLocale().getLanguage());
            String[] fileds = new String[]{TB_TOTALRESERVATIONBASEQTY, TB_TOTALUNRESERVATIONBASEQTY, TB_CURRESERVATIONBASEQTY, TB_TOTALRESERVATIONASSISTQTY, TB_TOTALUNRESERVATIONASSISTQTY, TB_CURRESERVATIONASSISTQTY, TB_BASEQTY, "curStoreQty", TB_ASSISTQTY, "lockQty", "lockBaseQty", "lockAssistQty", "lockAssistQty", "curMatStoreQty"};
            for (int i = 0; i < fileds.length; ++i) {
                this.tblMain.getColumn(fileds[i]).getStyleAttributes().setNumberFormat(this.colFormat);
            }
            super.execQuery();
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }
}

