/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.framework.client.SelectEntityUI;
import com.kingdee.eas.scm.framework.client.TreeNodeTypeEnum;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.reservation.IReservationEx;
import com.kingdee.eas.scm.im.reservation.ReservationExEntryInfo;
import com.kingdee.eas.scm.im.reservation.ReservationExFactory;
import com.kingdee.eas.scm.im.reservation.ReservationExInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationExEditUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ReservationExEditUI
extends AbstractReservationExEditUI
implements ChangeListener {
    private static final long serialVersionUID = -5622778150026349871L;
    private static final Logger logger = CoreUIObject.getLogger(ReservationExEditUI.class);
    private EntityObjectInfo billEntity;
    private static final EntityObjectInfo reservationEntity = ReservationUtil.getEntityObjectInfo("8D307D69");
    private static final String COLNAME_FIELD = "field";
    private static final String COLNAME_FIELD_NAME = "fieldName";
    private static final String COLNAME_FIELD_ALIAS = "fieldAlias";
    private static final String COLNAME_BILLFIELD = "billField";
    private static final String COLNAME_BILLFIELD_NAME = "billFieldName";
    private static final String COLNAME_BILLFIELD_ALIAS = "billFieldAlias";
    KDBizPromptBox prmtReservationF7 = new KDBizPromptBox();
    KDBizPromptBox prmtBillF7 = new KDBizPromptBox();
    KDComboBox reservationComboBox = new KDComboBox();
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";

    public ReservationExEditUI() throws Exception {
        this.tblMain.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.innerStoreFields();
    }

    private void innerStoreFields() {
        if (this.billEntity == null) {
            return;
        }
        this.editData.setBillBosType(this.billEntity.getType().toString());
        this.editData.setBillAlias(this.billEntity.getAlias());
        this.editData.setBillFullName(this.billEntity.getFullName());
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.setBtnStatus("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_HAS_ACTION_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() != 0) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_ISNOT_SAVESTATE_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        int currentRowSize = this.getDetailTable().getRowCount();
        IRow row = this.getDetailTable().addRow(currentRowSize);
    }

    private IRow insertRow(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.insertRow(this.getDetailTable());
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.tblMain.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.tblMain.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                this.tblMain.removeRow(rowIndex);
            }
            if (this.tblMain.getRow(0) != null) {
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
    }

    protected IObjectValue createNewData() {
        ReservationExInfo ex = new ReservationExInfo();
        ex.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        ex.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ex.getEntry().add(new ReservationExEntryInfo());
        return ex;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationExFactory.getRemoteInstance();
    }

    private void initComponent() {
        this.prmtBillType.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtBillType.setReadOnly(true);
        this.prmtBillType.setEditable(false);
        this.prmtBillType.setRequired(true);
        this.prmtBillType.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ReservationExEditUI.this.initBillTypeF7(null);
                }
                catch (Exception e1) {
                    ReservationExEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtBillType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getOldValue() != null && e.getNewValue() != null) {
                    ReservationExEditUI.this.tblMain.removeRows(true);
                    ReservationExEditUI.this.tblMain.addRow();
                }
            }
        });
    }

    public void initBillTypeF7(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("STATUS_CANCELCANCEL")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", EntitySelectorType.BizBill);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCanceled()) {
            this.billEntity = (EntityObjectInfo)ui.getReturnObject();
            this.prmtBillType.setValue((Object)this.billEntity.getAlias());
            this.editData.setBillBosType(this.billEntity.getType().toString());
            this.editData.setBillAlias(this.billEntity.getAlias());
            this.editData.setBillFullName(this.billEntity.getFullName());
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    private void initEntryF7() {
        this.reservationComboBox.setRequired(true);
        PropertyCollection col = reservationEntity.getProperties();
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (property == null) continue;
            this.reservationComboBox.addItem((Object)new ReservationItem(property));
        }
        this.reservationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e == null) {
                    return;
                }
                ReservationItem item = (ReservationItem)e.getItem();
                int rowIndex = ReservationExEditUI.this.getDetailTable().getSelectManager().getActiveRowIndex();
                IRow row = ReservationExEditUI.this.getDetailTable().getRow(rowIndex);
                String fullAlias = item.getFieldAlias();
                String fullName = item.getFieldName();
                if (!StringUtil.isEmpty((String)fullAlias)) {
                    row.getCell(ReservationExEditUI.COLNAME_FIELD_ALIAS).setValue((Object)fullAlias);
                }
                if (!StringUtil.isEmpty((String)fullName)) {
                    row.getCell(ReservationExEditUI.COLNAME_FIELD_NAME).setValue((Object)fullName);
                }
            }
        });
        this.getDetailTable().getColumn(COLNAME_FIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.reservationComboBox));
        this.prmtBillF7.setReadOnly(true);
        this.prmtBillF7.setEditable(false);
        this.prmtBillF7.setRequired(true);
        this.prmtBillF7.setDisplayFormat("$alias$");
        this.prmtBillF7.setEditFormat("$alias$");
        this.prmtBillF7.setCommitFormat("$alias$");
        this.prmtBillF7.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtBillF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PropertyInfo property;
                if (ReservationExEditUI.this.getOprtState().equals(OprtState.VIEW) || ReservationExEditUI.this.getOprtState().equals("STATUS_CANCELCANCEL")) {
                    return;
                }
                if (ReservationExEditUI.this.billEntity == null) {
                    MsgBox.showInfo((String)ReservationUtil.getResourceString("SELECT_REQUIREBILL_FIRST"));
                    SysUtil.abort();
                }
                if ((property = ReservationExEditUI.this.selectProperty(ReservationExEditUI.this.billEntity, false, EntitySelectorType.Property, TreeNodeTypeEnum.normal)) != null) {
                    ReservationExEditUI.this.prmtBillF7.setUserObject((Object)((String)property.get("fullName")));
                    ReservationExEditUI.this.prmtBillF7.setValue((Object)((String)property.get("fullAlias")));
                }
            }
        });
        this.prmtBillF7.addChangeListener((ChangeListener)this);
        this.getDetailTable().getColumn(COLNAME_BILLFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBillF7));
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected PropertyInfo selectProperty(EntityObjectInfo entity, boolean isOnlyShowLinkProperty, EntitySelectorType selectorType, TreeNodeTypeEnum treeNodeType) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("entity", entity);
        uiContext.put("selectBizType", EntitySelectorType.Property);
        if (isOnlyShowLinkProperty) {
            uiContext.put("ISONLYSHOWLINKPROPERTY", isOnlyShowLinkProperty);
        }
        if (treeNodeType != null) {
            uiContext.put("TREENODETYPE", treeNodeType);
        }
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCanceled()) {
            PropertyInfo property = (PropertyInfo)ui.getReturnObject();
            return property;
        }
        return null;
    }

    public void onLoad() throws Exception {
        this.getUIContext().remove("checkLicense");
        super.onLoad();
        this.initComponent();
        this.initEntryF7();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.innerLoadFields();
        this.setBtnStatus("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
    }

    private void innerLoadFields() {
        this.prmtBillType.setValue((Object)this.editData.getBillAlias());
        if (!StringUtil.isEmpty((String)this.editData.getBillBosType())) {
            this.billEntity = ReservationUtil.getEntityObjectInfo(this.editData.getBillBosType());
            this.prmtBillType.setUserObject((Object)this.billEntity);
        }
        IRow row = null;
        ReservationExEntryInfo entry = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            entry = (ReservationExEntryInfo)row.getUserObject();
            row.getCell(COLNAME_FIELD).setValue((Object)entry.getFieldAlias());
            row.getCell(COLNAME_BILLFIELD).setValue((Object)entry.getBillFieldAlias());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billBosType"));
        sic.add(new SelectorItemInfo("billAlias"));
        sic.add(new SelectorItemInfo("billFullName"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("entry.*"));
        return sic;
    }

    private void tableValueChange(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        String colName = kDTable.getColumnKey(e.getColIndex());
        IRow curRow = kDTable.getRow(selectRow);
        if (COLNAME_FIELD.equals(colName) || COLNAME_BILLFIELD.equals(colName)) {
            // empty if block
        }
    }

    private void tableValueChange(ChangeEvent e) {
        KDTSelectBlock ksb = this.tblMain.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow row = this.tblMain.getRow(beginRow);
        if (e.getSource().equals(this.prmtReservationF7)) {
            String fullAlias = (String)this.prmtReservationF7.getValue();
            String fullName = (String)this.prmtReservationF7.getUserObject();
            if (!StringUtil.isEmpty((String)fullAlias)) {
                row.getCell(COLNAME_FIELD_ALIAS).setValue((Object)fullAlias);
            }
            if (!StringUtil.isEmpty((String)fullName)) {
                row.getCell(COLNAME_FIELD_NAME).setValue((Object)fullName);
            }
        } else if (e.getSource().equals(this.prmtBillF7)) {
            String billFullAlias = (String)this.prmtBillF7.getValue();
            String billFullName = (String)this.prmtBillF7.getUserObject();
            if (!StringUtil.isEmpty((String)billFullAlias)) {
                row.getCell(COLNAME_BILLFIELD_ALIAS).setValue((Object)billFullAlias);
            }
            if (!StringUtil.isEmpty((String)billFullName)) {
                row.getCell(COLNAME_BILLFIELD_NAME).setValue((Object)billFullName);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tableValueChange(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (StringUtil.isEmpty((String)this.txtNumber.getStringValue())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NUMBER_CANNOT_NULL"));
            SysUtil.abort();
        }
        if (this.txtName.getSelectedItemData() == null || StringUtil.isEmpty((String)this.txtName.getSelectedItemData().toString())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NAME_CANNOT_NULL"));
            SysUtil.abort();
        }
        IReservationEx iReservationEx = ReservationExFactory.getRemoteInstance();
        this.editData.setNumber(this.txtNumber.getStringValue());
        this.editData.setName((String)this.txtName.getSelectedItemData());
        iReservationEx.checkNumberDup(this.editData);
        iReservationEx.checkNameDup(this.editData);
        this.checkEntry();
    }

    void checkEntry() {
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"ENTRY_ISNULL"));
            SysUtil.abort();
        }
        IRow row = null;
        StringBuffer sb = new StringBuffer(512);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            PropertyInfo property;
            String propertyName;
            row = this.tblMain.getRow(i);
            String fieldDataType = null;
            String billFieldDataType = null;
            StringBuffer sb1 = new StringBuffer(128);
            if (row.getCell(COLNAME_FIELD).getValue() == null) {
                sb1.append(",").append(EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"CHECK_ENTRY_1"));
            } else {
                propertyName = (String)row.getCell(COLNAME_FIELD_NAME).getValue();
                property = CommonUtils.getPropertyByMuch((String)propertyName, (EntityObjectInfo)reservationEntity);
                fieldDataType = this.getPropertyDataType(property);
            }
            if (row.getCell(COLNAME_BILLFIELD).getValue() == null) {
                sb1.append(",").append(EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"CHECK_ENTRY_2"));
            } else {
                propertyName = (String)row.getCell(COLNAME_BILLFIELD_NAME).getValue();
                property = CommonUtils.getPropertyByMuch((String)propertyName, (EntityObjectInfo)this.billEntity);
                billFieldDataType = this.getPropertyDataType(property);
            }
            if (!(StringUtil.isEmpty((String)fieldDataType) || StringUtil.isEmpty(billFieldDataType) || fieldDataType.equals(billFieldDataType))) {
                sb1.append(",").append(EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"CHECK_ENTRY_3"));
            }
            if (sb1.length() <= 0) continue;
            sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"CHECK_ENTRY_4", (Object[])new Object[]{i + 1})).append(sb1.toString()).append("\n");
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
    }

    public String getPropertyDataType(PropertyInfo property) {
        String dataType = "";
        boolean isLinkProperty = property instanceof LinkPropertyInfo;
        if (!isLinkProperty) {
            dataType = property.getString("dataType");
            if ("Enum".equals(dataType)) {
                dataType = (String)property.get("metadataRef");
            }
        } else {
            dataType = ((LinkPropertyInfo)property).getRelationship().getSupplierObject().getType().toString();
        }
        return dataType;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().getValue() != 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_CANNOT_INACTIVE"));
            SysUtil.abort();
        }
        this.setState(UseStatusEnum.INACTIVE);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_HAS_ACTIVE"));
            SysUtil.abort();
        }
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SCHEMA_NOT_SAVE"));
            SysUtil.abort();
        }
        this.beforeStoreFields(e);
        this.storeFields();
        this.setState(UseStatusEnum.ACTIVE);
    }

    public void setState(UseStatusEnum state) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(this.editData.getId().toString());
        List errors = ReservationExFactory.getRemoteInstance().setState(pkList, state);
        String msg = "";
        msg = UseStatusEnum.ACTIVE.equals((Object)state) ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess");
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
            this.unLockUI();
        }
        StringBuffer errMsg = new StringBuffer();
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.loadFields();
        this.setMessageText(msg);
        this.showMessage();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
    }

    void setBtnStatus(boolean flag) {
        this.actionAddRow.setEnabled(flag);
        this.actionInsertRow.setEnabled(flag);
        this.actionDeleteRow.setEnabled(flag);
    }

    class ReservationItem {
        private String fieldName = "";
        private String fieldAlias = "";
        private String fieldBosType = "";
        private String dataType = "";
        private boolean isLinkProperty = false;

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFieldAlias() {
            return this.fieldAlias;
        }

        public String getDataType() {
            return this.dataType;
        }

        public ReservationItem(PropertyInfo property) {
            this.isLinkProperty = property instanceof LinkPropertyInfo;
            this.dataType = ReservationExEditUI.this.getPropertyDataType(property);
            this.fieldName = property.getName();
            this.fieldAlias = property.getAlias();
        }

        public String toString() {
            return this.fieldAlias;
        }
    }
}

