/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.reservation.IReservationObject;
import com.kingdee.eas.scm.im.reservation.ReservationObjectFactory;
import com.kingdee.eas.scm.im.reservation.ReservationObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationFilterUI;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReservationFilterUI
extends AbstractReservationFilterUI {
    private static final long serialVersionUID = 5457216138441300939L;
    private static final Logger logger = CoreUIObject.getLogger(ReservationFilterUI.class);
    private ItemListener reservationTypeListener = null;
    DataChangeListener prmtSupplierBillTypeFromDataChangeListener = null;
    DataChangeListener prmtRequireBillTypeFromDataChangeListener = null;
    DataChangeListener prmtMaterialFromDataChangeListener = null;
    DataChangeListener prmtSalesmanFromDataChangeListener = null;
    DataChangeListener prmtSalesmanToDataChangeListener = null;
    DataChangeListener prmtCustomerFromChangeListener = null;
    DataChangeListener prmtSaleOrgUnitFromChangeListener = null;
    DataChangeListener prmtAdminOrgUnitFromChangeListener = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitCollection authorizedMainOrgs = null;
    OrgUnitInfo[] mainOrgs = null;
    boolean isLoadData = false;

    private void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initReservationType();
        this.initPrmtBillType();
        this.initPrmtMaterial();
        this.initSou();
        this.prmtMaterialFrom.setCommitFormat("$number$");
        this.prmtMaterialTo.setCommitFormat("$number$");
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit)) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        try {
            if (this.authorizedMainOrgs == null) {
                this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.ControlUnit, "reservation_view");
            } else {
                int size = this.authorizedMainOrgs.size();
                this.mainOrgs = new OrgUnitInfo[size];
                if (size > 0) {
                    Object[] objects = this.authorizedMainOrgs.toArray();
                    System.arraycopy(objects, 0, this.mainOrgs, 0, size);
                }
            }
            if (this.mainOrgs == null) {
                this.mainOrgs = new OrgUnitInfo[0];
            }
            if (this.mainOrgs.length > 0) {
                this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initSou() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object mainOrgs = null;
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.ControlUnit, (String)"reservation_view");
        HashSet<String> idSet = new HashSet<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
            FullOrgUnitInfo cu = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                cu = collection.get(i);
                if (cu == null) continue;
                idSet.add(cu.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("CU.id", idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)Character.valueOf('0'), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        this.prmtStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ReservationFilterUI.this.doCheck(e);
            }
        });
        view.setTopCount(1);
        StorageOrgUnitCollection storageCollection = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
        if (storageCollection != null && storageCollection.size() > 0) {
            StorageOrgUnitInfo currentMainOrg = storageCollection.get(0);
            this.prmtStorageOrgUnit.setValue((Object)currentMainOrg);
        }
        Timestamp t = SCMUtils.getSCMQueryTime((Date)new Date(), (String)"endDate");
        Calendar calendar = Calendar.getInstance();
        if (t != null) {
            calendar.setTime(t);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        calendar.add(5, -7);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        this.dateReservationBeginDateFrom.setValue((Object)calendar.getTime());
        SCMQueryFormat.formatEndTime((KDDatePicker)this.dateReservationBeginDateTo);
    }

    public boolean verify() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            this.prmtStorageOrgUnit.requestFocus();
            return false;
        }
        return super.verify();
    }

    void doCheck(PreChangeEvent e) {
        if (e.getData() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            this.prmtStorageOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    void selectCheck(SelectorEvent e) {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"39_ReservationFilterUI"));
            this.prmtStorageOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    private void initReservationType() {
        this.comboReservationType.removeItemListener(this.reservationTypeListener);
        this.reservationTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReservationFilterUI.this.reservationTypeChange(e);
            }
        };
        this.comboReservationType.addItemListener(this.reservationTypeListener);
    }

    private void reservationTypeChange(ItemEvent e) {
        if (this.isLoadData) {
            return;
        }
        ReservationTypeEnum reservationTypeEnum = (ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem());
        int selectValue = reservationTypeEnum.getValue();
        if (selectValue == -1) {
            this.prmtSupplierBillTypeFrom.setValue(null);
            this.prmtSupplierBillTypeFrom.setEnabled(true);
            this.txtSupplierBillNumberFrom.setText(null);
            this.txtSupplierBillNumberFrom.setEnabled(true);
            this.prmtRequireBillTypeFrom.setValue(null);
            this.prmtRequireBillTypeFrom.setEnabled(true);
            this.txtRequireBillNumberFrom.setText(null);
            this.txtRequireBillNumberFrom.setEnabled(true);
            this.prmtReservationObject.setValue(null);
            this.prmtReservationObject.setEnabled(true);
            EntityViewInfo view = new EntityViewInfo();
            this.prmtReservationObject.setEntityViewInfo(view);
        } else if (0 == selectValue) {
            this.prmtSupplierBillTypeFrom.setValue(null);
            this.prmtSupplierBillTypeFrom.setEnabled(false);
            this.txtSupplierBillNumberFrom.setText(null);
            this.txtSupplierBillNumberFrom.setEnabled(false);
            this.prmtRequireBillTypeFrom.setValue(null);
            this.prmtRequireBillTypeFrom.setEnabled(false);
            this.txtRequireBillNumberFrom.setText(null);
            this.txtRequireBillNumberFrom.setEnabled(false);
            this.prmtReservationObject.setValue(null);
            this.prmtReservationObject.setEnabled(true);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isUserNullObject", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReservationObject.setEntityViewInfo(view);
        } else if (1 == selectValue) {
            this.prmtSupplierBillTypeFrom.setValue(null);
            this.prmtSupplierBillTypeFrom.setEnabled(true);
            this.txtSupplierBillNumberFrom.setText(null);
            this.txtSupplierBillNumberFrom.setEnabled(true);
            this.prmtRequireBillTypeFrom.setValue(null);
            this.prmtRequireBillTypeFrom.setEnabled(true);
            this.txtRequireBillNumberFrom.setText(null);
            this.txtRequireBillNumberFrom.setEnabled(true);
            this.prmtReservationObject.setValue(null);
            this.prmtReservationObject.setEnabled(false);
        } else if (2 == selectValue) {
            this.prmtSupplierBillTypeFrom.setValue(null);
            this.prmtSupplierBillTypeFrom.setEnabled(false);
            this.txtSupplierBillNumberFrom.setText(null);
            this.txtSupplierBillNumberFrom.setEnabled(false);
            this.prmtRequireBillTypeFrom.setValue(null);
            this.prmtRequireBillTypeFrom.setEnabled(false);
            this.txtRequireBillNumberFrom.setText(null);
            this.txtRequireBillNumberFrom.setEnabled(false);
            this.prmtReservationObject.setValue(null);
            this.prmtReservationObject.setEnabled(true);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isUserNullObject", (Object)0, CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReservationObject.setEntityViewInfo(view);
        }
    }

    private void initPrmtBillType() {
        if (this.prmtSupplierBillTypeFromDataChangeListener == null) {
            this.prmtSupplierBillTypeFromDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ReservationFilterUI.this.prmtSupplierBillTypeFromDataChange(e);
                }
            };
        }
        this.prmtSupplierBillTypeFrom.addDataChangeListener(this.prmtSupplierBillTypeFromDataChangeListener);
        if (this.prmtRequireBillTypeFromDataChangeListener == null) {
            this.prmtRequireBillTypeFromDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ReservationFilterUI.this.prmtRequireBillTypeFromDataChange(e);
                }
            };
        }
        this.prmtRequireBillTypeFrom.addDataChangeListener(this.prmtRequireBillTypeFromDataChangeListener);
    }

    void prmtSupplierBillTypeFromDataChange(DataChangeEvent e) {
        if (e == null) {
            return;
        }
        if (e.getNewValue() == null) {
            return;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.doMultiSelect(this.prmtSupplierBillTypeFrom, null);
    }

    void prmtRequireBillTypeFromDataChange(DataChangeEvent e) {
        if (e == null) {
            return;
        }
        if (e.getNewValue() == null) {
            return;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.doMultiSelect(this.prmtRequireBillTypeFrom, null);
    }

    private void initPrmtMaterial() {
        if (this.prmtMaterialFromDataChangeListener == null) {
            this.prmtMaterialFromDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ReservationFilterUI.this.prmtMaterialFromDataChange(e);
                }
            };
        }
        this.prmtMaterialFrom.addDataChangeListener(this.prmtMaterialFromDataChangeListener);
    }

    private void prmtMaterialFromDataChange(DataChangeEvent e) {
        if (e == null) {
            return;
        }
        if (e.getNewValue() == null) {
            return;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
    }

    public FilterInfo getFilterInfo() {
        ReservationTypeEnum reservationTypeEnum;
        int selectValue;
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer(128);
        int maskIndex = 0;
        FilterItemInfo filterItem = null;
        filterItem = this.getBizFilterInfo(this.prmtStorageOrgUnit, "storageOrg.id", CompareType.INCLUDE);
        if (filterItem != null) {
            filter.getFilterItems().add(filterItem);
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (this.dateReservationBeginDateFrom.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("reservationBeginDate", (Object)this.dateReservationBeginDateFrom.getTimestamp(), CompareType.GREATER_EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (this.dateReservationBeginDateTo.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("reservationBeginDate", (Object)this.dateReservationBeginDateTo.getTimestamp(), CompareType.LESS_EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if ((filterItem = this.getBizFilterInfo(this.prmtMaterialFrom, "material.number", "number", CompareType.GREATER_EQUALS)) != null) {
            filter.getFilterItems().add(filterItem);
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if ((filterItem = this.getBizFilterInfo(this.prmtMaterialTo, "material.number", "number", CompareType.LESS_EQUALS)) != null) {
            filter.getFilterItems().add(filterItem);
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (-1 == (selectValue = (reservationTypeEnum = (ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem())).getValue())) {
            ReservationObjectInfo reservationObject;
            filterItem = this.getBizFilterInfo(this.prmtSupplierBillTypeFrom, "supplierBillBosType", "BOSTYPE", CompareType.GREATER_EQUALS);
            if (filterItem != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if (!StringUtil.isEmpty((String)this.txtSupplierBillNumberFrom.getText()) && (filterItem = new FilterItemInfo("supplierBillNum", (Object)this.txtSupplierBillNumberFrom.getText(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if ((filterItem = this.getBizFilterInfo(this.prmtRequireBillTypeFrom, "requireBillBosType", "BOSTYPE", CompareType.GREATER_EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if (!StringUtil.isEmpty((String)this.txtRequireBillNumberFrom.getText()) && (filterItem = new FilterItemInfo("requireBillNum", (Object)this.txtRequireBillNumberFrom.getText(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if ((reservationObject = (ReservationObjectInfo)this.prmtReservationObject.getValue()) != null && (filterItem = new FilterItemInfo("reservationObject.id", (Object)reservationObject.getId().toString(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
        } else if (0 == selectValue) {
            filterItem = new FilterItemInfo("reservationType", (Object)selectValue, CompareType.EQUALS);
            if (filterItem != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
        } else if (1 == selectValue) {
            filterItem = this.getBizFilterInfo(this.prmtSupplierBillTypeFrom, "supplierBillBosType", "BOSTYPE", CompareType.GREATER_EQUALS);
            if (filterItem != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if (!StringUtil.isEmpty((String)this.txtSupplierBillNumberFrom.getText()) && (filterItem = new FilterItemInfo("supplierBillNum", (Object)this.txtSupplierBillNumberFrom.getText(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if ((filterItem = this.getBizFilterInfo(this.prmtRequireBillTypeFrom, "requireBillBosType", "BOSTYPE", CompareType.GREATER_EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if (!StringUtil.isEmpty((String)this.txtRequireBillNumberFrom.getText()) && (filterItem = new FilterItemInfo("requireBillNum", (Object)this.txtRequireBillNumberFrom.getText(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if ((filterItem = new FilterItemInfo("reservationType", (Object)selectValue, CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
        } else if (2 == selectValue) {
            ReservationObjectInfo reservationObject = (ReservationObjectInfo)this.prmtReservationObject.getValue();
            if (reservationObject != null && (filterItem = new FilterItemInfo("reservationObject.id", (Object)reservationObject.getId().toString(), CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if ((filterItem = new FilterItemInfo("reservationType", (Object)selectValue, CompareType.EQUALS)) != null) {
                filter.getFilterItems().add(filterItem);
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
        }
        if (this.chkInventoryReservation.isSelected()) {
            filterItem = new FilterItemInfo("inventory.id", null, CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (this.chkIsAutoReservation.isSelected()) {
            filterItem = new FilterItemInfo("isAutoReservation", (Object)1, CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        return filter;
    }

    private void doMultiSelect(KDBizPromptBox prmtFrom, KDBizPromptBox prmtTo) {
        if (prmtFrom == null || prmtTo == null) {
            return;
        }
        if (prmtFrom.getValue() == null) {
            prmtTo.setEnabled(true);
        }
        if (prmtFrom.getValue() instanceof Object[]) {
            Object[] values = (Object[])prmtFrom.getValue();
            if (!ArrayUtil.isEmpty((Object[])values)) {
                if (values.length > 1) {
                    prmtTo.setValue(null);
                    prmtTo.setEnabled(false);
                } else {
                    prmtTo.setEnabled(true);
                }
            } else {
                prmtTo.setEnabled(true);
            }
        }
    }

    private FilterItemInfo getBizFilterInfo(KDBizPromptBox prmt, String alias, CompareType compareType) {
        Object filterItem = null;
        if (prmt == null || prmt.getValue() == null) {
            return null;
        }
        if (prmt.getValue() instanceof Object[]) {
            Object[] values = (Object[])prmt.getValue();
            if (!ArrayUtil.isEmpty((Object[])values)) {
                DataBaseInfo dataBase = null;
                if (values.length > 1) {
                    HashSet<String> set = new HashSet<String>();
                    int len = values.length;
                    for (int i = 0; i < len; ++i) {
                        dataBase = (DataBaseInfo)values[i];
                        set.add(dataBase.getId().toString());
                    }
                    filterItem = new FilterItemInfo(alias, set, CompareType.INCLUDE);
                } else {
                    dataBase = (DataBaseInfo)values[0];
                    filterItem = dataBase == null ? null : new FilterItemInfo(alias, (Object)dataBase.getId().toString(), compareType);
                }
            } else {
                filterItem = null;
            }
        } else {
            DataBaseInfo dataBase = null;
            dataBase = (DataBaseInfo)prmt.getValue();
            filterItem = dataBase == null ? null : new FilterItemInfo(alias, (Object)dataBase.getId().toString(), compareType);
        }
        return this.getBizFilterInfo(prmt, alias, "ID", compareType);
    }

    private FilterItemInfo getBizFilterInfo(KDBizPromptBox prmt, String alias, String fieldName, CompareType compareType) {
        Object filterItem = null;
        if (prmt == null || prmt.getValue() == null) {
            return null;
        }
        if (prmt.getValue() instanceof Object[]) {
            Object[] values = (Object[])prmt.getValue();
            if (!ArrayUtil.isEmpty((Object[])values)) {
                DataBaseInfo dataBase = null;
                if (values.length > 1) {
                    HashSet<String> set = new HashSet<String>();
                    int len = values.length;
                    for (int i = 0; i < len; ++i) {
                        dataBase = (DataBaseInfo)values[i];
                        if (StringUtil.isEmpty((String)this.getDataBaseFieldValue(dataBase, fieldName))) continue;
                        set.add(this.getDataBaseFieldValue(dataBase, fieldName));
                    }
                    filterItem = new FilterItemInfo(alias, set, CompareType.INCLUDE);
                } else {
                    dataBase = (DataBaseInfo)values[0];
                    filterItem = dataBase == null ? null : new FilterItemInfo(alias, (Object)this.getDataBaseFieldValue(dataBase, fieldName), compareType);
                }
            } else {
                filterItem = null;
            }
        } else {
            DataBaseInfo dataBase = null;
            dataBase = (DataBaseInfo)prmt.getValue();
            filterItem = dataBase == null ? null : new FilterItemInfo(alias, (Object)this.getDataBaseFieldValue(dataBase, fieldName), compareType);
        }
        return filterItem;
    }

    private String getDataBaseFieldValue(DataBaseInfo dataBase, String fieldName) {
        return dataBase.get(fieldName) != null ? dataBase.get(fieldName).toString() : null;
    }

    private SalePersonInfo getSalePersonInfo(BOSUuid pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        ISalePerson iSalePerson = SalePersonFactory.getRemoteInstance();
        return iSalePerson.getSalePersonInfo((IObjectPK)new ObjectUuidPK(pk), sic);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        if (entityViewInfo == null || entityViewInfo.getFilter() == null) {
            return;
        }
        FilterItemCollection items = entityViewInfo.getFilter().getFilterItems();
        if (items == null || items.size() == 0) {
            return;
        }
        FilterItemInfo item = null;
        try {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                BillTypeCollection billCol;
                IBillType iBillType;
                FilterInfo filter;
                EntityViewInfo view;
                item = items.get(i);
                String propertyName = item.getPropertyName();
                CompareType compareType = item.getCompareType();
                Object compareValue = item.getCompareValue();
                if (StringUtil.isEmpty((String)propertyName)) continue;
                if (compareValue instanceof Set) {
                    BillTypeCollection billCol2;
                    IBillType iBillType2;
                    Set set = (Set)compareValue;
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    if ("storageOrg.id".equals(propertyName)) {
                        IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                        view.setFilter(filter);
                        FullOrgUnitCollection orgCol = iOrgUnit.getFullOrgUnitCollection(view);
                        if (orgCol == null) continue;
                        this.prmtStorageOrgUnit.setData((Object)orgCol.toArray());
                        continue;
                    }
                    if ("requireBillBosType".equals(propertyName)) {
                        iBillType2 = BillTypeFactory.getRemoteInstance();
                        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)set, CompareType.INCLUDE));
                        view.setFilter(filter);
                        billCol2 = iBillType2.getBillTypeCollection(view);
                        if (billCol2 == null) continue;
                        this.prmtRequireBillTypeFrom.setData((Object)billCol2.toArray());
                        continue;
                    }
                    if (!"supplierBillBosType".equals(propertyName)) continue;
                    iBillType2 = BillTypeFactory.getRemoteInstance();
                    filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)set, CompareType.INCLUDE));
                    view.setFilter(filter);
                    billCol2 = iBillType2.getBillTypeCollection(view);
                    if (billCol2 == null) continue;
                    this.prmtSupplierBillTypeFrom.setData((Object)billCol2.toArray());
                    continue;
                }
                if ("storageOrg.id".equals(propertyName)) {
                    String orgId = (String)compareValue;
                    IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                    FullOrgUnitInfo orgInfo = iOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                    if (orgInfo == null) continue;
                    this.prmtStorageOrgUnit.setData((Object)orgInfo);
                    continue;
                }
                if ("reservationBeginDate".equals(propertyName)) {
                    if (!(compareValue instanceof Date)) continue;
                    if (CompareType.GREATER_EQUALS == compareType) {
                        this.dateReservationBeginDateFrom.setValue((Object)((Date)compareValue));
                        continue;
                    }
                    this.dateReservationBeginDateTo.setValue((Object)((Date)compareValue));
                    continue;
                }
                if ("material.number".equals(propertyName)) {
                    String materialNum = (String)compareValue;
                    IMaterial iMaterial = MaterialFactory.getRemoteInstance();
                    EntityViewInfo view2 = new EntityViewInfo();
                    FilterInfo filter2 = new FilterInfo();
                    filter2.getFilterItems().add(new FilterItemInfo("number", (Object)materialNum, CompareType.EQUALS));
                    view2.setFilter(filter2);
                    MaterialCollection col = iMaterial.getMaterialCollection(view2);
                    MaterialInfo material = null;
                    if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                        material = col.get(0);
                    }
                    if (CompareType.GREATER_EQUALS == compareType) {
                        this.prmtMaterialFrom.setValue((Object)material);
                        continue;
                    }
                    this.prmtMaterialTo.setValue((Object)material);
                    continue;
                }
                if ("supplierBillBosType".equals(propertyName)) {
                    iBillType = BillTypeFactory.getRemoteInstance();
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)((String)compareValue), CompareType.EQUALS));
                    view.setFilter(filter);
                    billCol = iBillType.getBillTypeCollection(view);
                    if (billCol == null) continue;
                    this.prmtSupplierBillTypeFrom.setData((Object)billCol.get(0));
                    continue;
                }
                if ("supplierBillNum".equals(propertyName)) {
                    this.txtSupplierBillNumberFrom.setText((String)compareValue);
                    continue;
                }
                if ("requireBillBosType".equals(propertyName)) {
                    iBillType = BillTypeFactory.getRemoteInstance();
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)((String)compareValue), CompareType.EQUALS));
                    view.setFilter(filter);
                    billCol = iBillType.getBillTypeCollection(view);
                    if (billCol == null) continue;
                    this.prmtRequireBillTypeFrom.setData((Object)billCol.get(0));
                    continue;
                }
                if ("requireBillNum".equals(propertyName)) {
                    this.txtRequireBillNumberFrom.setText((String)compareValue);
                    continue;
                }
                if ("reservationObject.id".equals(propertyName)) {
                    String reservationObjectId = (String)compareValue;
                    IReservationObject iReservationObject = ReservationObjectFactory.getRemoteInstance();
                    ReservationObjectInfo info = iReservationObject.getReservationObjectInfo((IObjectPK)new ObjectUuidPK(reservationObjectId));
                    if (info == null) continue;
                    this.prmtReservationObject.setValue((Object)info);
                    continue;
                }
                if ("reservationType".equals(propertyName)) {
                    this.isLoadData = true;
                    String value = compareValue.toString();
                    this.comboReservationType.setSelectedIndex(this.getIdxOfComboBox(this.comboReservationType, value));
                    this.isLoadData = false;
                    continue;
                }
                if ("inventory.id".equals(propertyName)) {
                    this.chkInventoryReservation.setSelected(true);
                    continue;
                }
                if (!"isAutoReservation".equals(propertyName)) continue;
                this.chkIsAutoReservation.setSelected(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getIdxOfComboBox(KDComboBox cobox, String value) {
        int count = cobox.getItemCount();
        if (value == null || count <= 0) {
            return -1;
        }
        boolean isIntEnum = cobox.getItemAt(0) instanceof IntEnum;
        int intValue = -1;
        if (isIntEnum) {
            intValue = Integer.valueOf(value);
        }
        for (int idx = 0; idx < count; ++idx) {
            Object item = cobox.getItemAt(idx);
            if (item == null || !(isIntEnum ? ((IntEnum)item).getValue() == intValue : ((StringEnum)item).getValue().equals(value))) continue;
            return idx;
        }
        return -1;
    }

    public void clear() {
        super.clear();
        this.prmtStorageOrgUnit.setValue(null);
        this.dateReservationBeginDateFrom.setValue(null);
        this.dateReservationBeginDateTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.comboReservationType.setSelectedIndex(0);
        this.prmtRequireBillTypeFrom.setValue(null);
        this.txtRequireBillNumberFrom.setText(null);
        this.prmtSupplierBillTypeFrom.setValue(null);
        this.txtSupplierBillNumberFrom.setText(null);
        this.prmtReservationObject.setValue(null);
        this.chkInventoryReservation.setSelected(false);
        this.chkIsAutoReservation.setSelected(false);
        try {
            this.initSou();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

