/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.framework.client.SelectEntityUI;
import com.kingdee.eas.scm.im.reservation.IReservationObject;
import com.kingdee.eas.scm.im.reservation.ReservationObjectCollection;
import com.kingdee.eas.scm.im.reservation.ReservationObjectFactory;
import com.kingdee.eas.scm.im.reservation.ReservationObjectInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationObjectEditUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ReservationObjectEditUI
extends AbstractReservationObjectEditUI {
    private static final long serialVersionUID = 8103127384219452095L;
    private static final Logger logger = CoreUIObject.getLogger(ReservationObjectEditUI.class);
    private SelectorListener billSelectorListener;
    private SelectorListener fieldSelectorListener;
    private PreChangeListener billPreChangeListener = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            try {
                ReservationObjectEditUI.this.transBillTypeResult(e);
                e.setResult(1);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    };
    private PreChangeListener fieldPreChangeListener;
    private DataChangeListener changeListener;
    private ChangeListener isNullObjectChangeListener;
    private String currentCUID;
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";

    public ReservationObjectEditUI() throws Exception {
        this.fieldSelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ReservationObjectEditUI.this.initFieldF7();
            }
        };
        this.fieldPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    ReservationObjectEditUI.this.transFieldResult(e);
                    e.setResult(1);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.isNullObjectChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReservationObjectEditUI.this.setBillTypeEnable(ReservationObjectEditUI.this.chkBoxIsNullObject.isSelected());
            }
        };
    }

    private void setBillTypeEnable(boolean isSelect) {
        if (isSelect) {
            this.prmtBillProperty.setValue(null);
            this.prmtBillProperty.setData(null);
            this.prmtBillProperty.setUserObject(null);
        }
        this.prmtBillProperty.setEnabled(!isSelect);
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = SubSystemUtils.getEntityObjectInfo((MetaDataBriefInfo)((MetaDataBriefInfo)e.getData()));
            if (entity != null) {
                e.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void initFieldF7() {
        this.prmtBillProperty.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ReservationObjectEditUI.this.selectBillTypeF7(null, ReservationObjectEditUI.this.prmtBillProperty);
                }
                catch (Exception e1) {
                    ReservationObjectEditUI.this.handleException(e1);
                }
            }
        });
    }

    private void selectBillTypeF7(ActionEvent e, KDBizPromptBox f7) throws Exception {
        if (f7 == null) {
            return;
        }
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("STATUS_CANCELCANCEL")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", EntitySelectorType.BaseData);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCanceled()) {
            f7.setValue(ui.getReturnObject());
            f7.setData(ui.getReturnObject());
            f7.setUserData(ui.getReturnObject());
            f7.setUserObject(ui.getReturnObject());
        }
    }

    private void transFieldResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = (EntityObjectInfo)e.getData();
            f7Box.setData((Object)entity.getAlias());
            f7Box.setValue((Object)entity.getAlias());
            f7Box.setUserObject((Object)entity);
            e.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
            f7Box.setUserObject((Object)entity);
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.innerStoreFields();
        this.editData.setSyncOldValue(false);
    }

    private void innerStoreFields() {
        EntityObjectInfo entity = (EntityObjectInfo)this.prmtBillProperty.getUserObject();
        if (entity != null) {
            String fullName = entity.getFullName();
            String bosType = entity.getType().toString();
            String alias = entity.getAlias();
            String name = entity.getName();
            this.editData.setEntityBosType(bosType);
            this.editData.setEntityName(name);
            this.editData.setEntityFullName(fullName);
            this.editData.setEntityAlias(alias);
        }
    }

    private void removeListener() {
        this.prmtBillProperty.removeSelectorListener(this.fieldSelectorListener);
        this.prmtBillProperty.removePreChangeListener(this.fieldPreChangeListener);
        this.chkBoxIsNullObject.removeChangeListener(this.isNullObjectChangeListener);
    }

    private void addListener() {
        this.prmtBillProperty.addPreChangeListener(this.fieldPreChangeListener);
        this.chkBoxIsNullObject.addChangeListener(this.isNullObjectChangeListener);
        this.initFieldF7();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.innerLoadFields();
        this.addListener();
    }

    private void innerLoadFields() {
        try {
            if (null == this.editData || !this.editData.isIsUserNullObject() && StringUtil.isEmpty((String)this.editData.getEntityBosType())) {
                return;
            }
            if (!StringUtil.isEmpty((String)this.editData.getEntityBosType())) {
                EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(this.editData.getEntityBosType());
                this.prmtBillProperty.setData((Object)this.editData.getEntityAlias());
                this.prmtBillProperty.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
                this.prmtBillProperty.setUserObject((Object)entity);
            }
            this.setBillTypeEnable(this.editData.isIsUserNullObject());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected IObjectValue createNewData() {
        ReservationObjectInfo reservationObject = new ReservationObjectInfo();
        reservationObject.setState(UseStatusEnum.SAVED);
        return reservationObject;
    }

    protected boolean isSubmitLoad() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationObjectFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBillProperty.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtBillProperty.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtBillProperty.setRequired(true);
        this.prmtBillProperty.setDisplayFormat("$alias$");
        this.prmtBillProperty.setEditFormat("$alias$");
        this.prmtBillProperty.setCommitFormat("$alias$");
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.comboState.setEnabled(false);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_disable");
        if (this.editData.getState().getValue() != 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT CANNOT_INACTIVE"));
            SysUtil.abort();
        }
        this.setState(UseStatusEnum.INACTIVE);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_enable");
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT HAS_ACTIVE"));
            SysUtil.abort();
        }
        this.setState(UseStatusEnum.ACTIVE);
    }

    public void setState(UseStatusEnum state) throws Exception {
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(this.editData.getId().toString());
        ReservationObjectFactory.getRemoteInstance().setState(pkList, state);
        String msg = "";
        msg = UseStatusEnum.ACTIVE.equals((Object)state) ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess");
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
            this.unLockUI();
        }
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.loadFields();
        this.setMessageText(msg);
        this.showMessage();
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT_HAS_ACTION_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() != 0) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT_ISNOT_SAVESTATE_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    protected void checkCUEnable() throws Exception {
        String cuid = this.editData.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_update");
        this.checkCUEnable();
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.setBillTypeEnable(this.editData.isIsUserNullObject());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_delete");
        this.checkCUEnable();
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (StringUtil.isEmpty((String)this.txtNumber.getStringValue())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NUMBER_CANNOT_NULL"));
            SysUtil.abort();
        }
        if (this.txtName.getSelectedItemData() == null || StringUtil.isEmpty((String)this.txtName.getSelectedItemData().toString())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("NAME_CANNOT_NULL"));
            SysUtil.abort();
        }
        if (!this.chkBoxIsNullObject.isSelected() && this.prmtBillProperty.getUserObject() == null) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("OBJECT_CANNOT_NULL"));
            SysUtil.abort();
        }
        IReservationObject iReservationObject = ReservationObjectFactory.getRemoteInstance();
        this.editData.setNumber(this.txtNumber.getStringValue());
        this.editData.setName((String)this.txtName.getSelectedItemData());
        iReservationObject.checkNumberDup(this.editData);
        iReservationObject.checkNameDup(this.editData);
        if (!this.chkBoxIsNullObject.isSelected()) {
            EntityObjectInfo entity = (EntityObjectInfo)this.prmtBillProperty.getUserObject();
            String fullName = entity.getFullName();
            String bosType = entity.getBOSType().toString();
            String alias = entity.getAlias();
            String name = entity.getName();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("entityBosType", (Object)bosType, CompareType.EQUALS));
            if (this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            ReservationObjectCollection reservationObjectCol = iReservationObject.getReservationObjectCollection(view);
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)reservationObjectCol)) {
                MsgBox.showWarning((String)(this.editData.getEntityAlias() + ReservationUtil.getResourceString("OBJECT_HAS_CONFIG")));
                SysUtil.abort();
            }
        }
        if (this.chkBoxIsNullObject.isSelected()) {
            this.editData.setEntityAlias(null);
            this.editData.setEntityBosType(null);
            this.editData.setEntityFullName(null);
            this.editData.setEntityName(null);
        }
        super.beforeStoreFields(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_addnew");
        this.prmtBillProperty.setValue(null);
        this.prmtBillProperty.setData(null);
        this.prmtBillProperty.setUserObject(null);
        this.editData.setSyncOldValue(true);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(null);
        this.editData.setName(null);
        this.editData.setState(UseStatusEnum.SAVED);
        super.actionCopy_actionPerformed(e);
    }

    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState())) {
            return false;
        }
        if (!"ADDNEW".equals(this.getOprtState()) && this.editData.compareNewToOld()) {
            return false;
        }
        return super.isModify();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ReservationObjectInfo schemaInfo = (ReservationObjectInfo)newData;
        schemaInfo.setNumber(null);
        schemaInfo.setName(null);
        schemaInfo.setState(UseStatusEnum.SAVED);
        schemaInfo.setCU(null);
    }

    public void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }
}

