/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.reservation.ReservationObjectCollection;
import com.kingdee.eas.scm.im.reservation.ReservationObjectFactory;
import com.kingdee.eas.scm.im.reservation.ReservationObjectInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationObjectListUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ReservationObjectListUI
extends AbstractReservationObjectListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReservationObjectListUI.class);
    private static final String TB_COLNAME_STATE = "state";
    private static final String TB_COLNAME_CUID = "CU.id";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationObjectFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.reservation.client.ReservationObjectEditUI";
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_disable");
        this.setState(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setState(UseStatusEnum.ACTIVE, e);
    }

    private void setState(UseStatusEnum state, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReservationObjectCollection col = ReservationObjectFactory.getRemoteInstance().getReservationObjectCollection(view);
        ReservationObjectInfo reserObject = null;
        ArrayList<String> numberList = new ArrayList<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reserObject = col.get(i);
                String cu = reserObject.getCU() != null ? reserObject.getCU().getId().toString() : null;
                numberList.add(reserObject.getNumber());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
                pks.remove(reserObject.getId().toString());
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)this.bdScmImRes, (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        List errors = ReservationObjectFactory.getRemoteInstance().setState(pks, state);
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setLog(numberList, "invupdatetype_enable", ReservationUtil.getResourceString("METHOD_ACTIVE"));
        } else {
            this.setLog(numberList, "invupdatetype_disable", ReservationUtil.getResourceString("METHOD_INACTIVE"));
        }
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.refresh(e);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void setLog(List<String> numberList, String logItemName, String methodName) throws Exception {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"92F29A08"), null, (String)numberList.get(i), (String)logItemName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(TB_COLNAME_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT_HAS_ACTION_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(TB_COLNAME_STATE).getValue();
        if (state.getInt() != 0) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONOBJECT_ISNOT_SAVESTATE_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    protected void checkCUEnable() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String cuid = row.getCell(TB_COLNAME_CUID).getValue().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUEnable();
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUEnable();
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_addnew");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationObject_view");
        super.actionView_actionPerformed(e);
    }
}

