/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SubSystemPromptBox;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.framework.client.EntityPropertySelector;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.framework.client.SelectEntityUI;
import com.kingdee.eas.scm.framework.client.TreeNodeTypeEnum;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationSupplyObjectEditUI;
import com.kingdee.eas.scm.im.reservation.client.CommonMatchFilterPanel;
import com.kingdee.eas.scm.im.reservation.impl.ITableSetting;
import com.kingdee.eas.scm.im.reservation.util.MDUtil;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class ReservationSupplyObjectEditUI
extends AbstractReservationSupplyObjectEditUI {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_QUERY = "com.kingdee.eas.base.message.MsgQuery";
    private boolean isConfirm = false;
    private ReservationSchemaInfo parent;
    private ReservationSupplyObjectInfo supplyInfo;
    private CommonFilterPanel billFilterPanel;
    private CommonMatchFilterPanel matchFilterPanel;
    private SelectorListener billSelectorListener = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            ReservationSupplyObjectEditUI.this.initRequestBillF7(e);
        }
    };
    private SelectorListener fieldSelectorListener1 = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            ReservationSupplyObjectEditUI.this.initFieldF7(e, TreeNodeTypeEnum.storage_org);
        }
    };
    private SelectorListener fieldSelectorListener2 = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            ReservationSupplyObjectEditUI.this.initFieldF7(e, TreeNodeTypeEnum.datetime);
        }
    };
    private PreChangeListener billPreChangeListener = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            try {
                ReservationSupplyObjectEditUI.this.transBillTypeResult(e);
                e.setResult(1);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    };
    private PreChangeListener fieldPreChangeListener;
    private DataChangeListener changeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            try {
                ReservationSupplyObjectEditUI.this.supplyBillTypeChanged(e);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    };
    EntityObjectInfo billEntity = null;

    public ReservationSupplyObjectEditUI() throws Exception {
        this.fieldPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    ReservationSupplyObjectEditUI.this.transFieldResult(e);
                    e.setResult(1);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.parent = (ReservationSchemaInfo)this.getUIContext().get("ParentNode");
        this.supplyInfo = (ReservationSupplyObjectInfo)this.getUIContext().get("InitDataObject");
        if (this.supplyInfo == null) {
            throw new InvReservationException(InvReservationException.NO_INPUT_SUPPLYBILL_RESERVATIONOBJECT);
        }
        this.innerLoadFields();
        this.addListener();
    }

    private void innerLoadFields() {
        try {
            this.prmtBillType.setData((Object)this.supplyInfo.getBillAlias());
            if (!StringUtil.isEmpty((String)this.supplyInfo.getBillFullName())) {
                this.billEntity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.supplyInfo.getBillFullName()));
                this.prmtBillType.setUserObject((Object)this.billEntity);
            }
            this.prmtOrgField.setData((Object)this.supplyInfo.getOrgFieldAlias());
            this.prmtOrgField.setUserObject((Object)this.supplyInfo.getOrgField());
            this.prmtDateField.setData((Object)this.supplyInfo.getDateFieldAlias());
            this.prmtDateField.setUserObject((Object)this.supplyInfo.getDateField());
            this.txtAheadDays.setValue((Object)this.supplyInfo.getAheadDays());
            this.setFieldF7Show(false);
            this.initFilterPanel();
            this.initMatchFilterPanel();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setFieldF7Show(boolean isBillChanged) {
        if (this.prmtBillType.getValue() == null) {
            this.prmtOrgField.setEnabled(false);
            this.prmtDateField.setEnabled(false);
        } else {
            this.prmtOrgField.setEnabled(true);
            this.prmtDateField.setEnabled(true);
            this.prmtOrgField.setSelector(null);
            this.prmtDateField.setSelector(null);
        }
        if (isBillChanged) {
            this.prmtOrgField.setValue(null);
            this.prmtOrgField.setUserObject(null);
            this.prmtDateField.setValue(null);
            this.prmtDateField.setUserObject(null);
        }
    }

    private void initFilterPanel() throws Exception {
        FilterInfo filter = new FilterInfo();
        String queryPK = DEFAULT_QUERY;
        if (!StringUtil.isEmpty((String)this.supplyInfo.getBillFullName())) {
            filter = this.supplyInfo.getFilterInfo();
            queryPK = this.supplyInfo.getBillQueryPK();
        }
        this.billFilterPanel = new CommonFilterPanel(ReservationUtil.getResourceString("BILL_FILTER_CONDITION"), MetaDataPK.create((String)queryPK), filter, new FilterInfo(), null, null, 625, 190, 7);
        this.panelFilter.add((Component)this.billFilterPanel);
        this.billFilterPanel.setBounds(3, 15, 625, 190);
    }

    private void initMatchFilterPanel() throws Exception {
        MetaDataPK srcPK = MetaDataPK.create((String)this.parent.getBillFullName());
        MetaDataPK destPK = MetaDataPK.create((String)this.supplyInfo.getBillFullName());
        this.matchFilterPanel = new CommonMatchFilterPanel(this.getUIWindow(), srcPK, destPK, this.supplyInfo.getMatchPropertyCollection(this.parent.getBillFullName()), 625, 190, 7, ReservationUtil.getResourceString("SUPPLYBILL"), ReservationUtil.getResourceString("REQUIREBILL_INFO"));
        this.panelMatchFilter.add((Component)((Object)this.matchFilterPanel));
        this.matchFilterPanel.setBounds(3, 15, 625, 190);
    }

    public void beforeStoreFields() {
        if (this.prmtBillType.getUserObject() == null) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SUPPLYBILL_TYPE_CANNOT_NULL"));
            this.prmtBillType.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtOrgField.getUserObject() == null) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SUPPLYBILL_STORAGE_CANNOT_NULL"));
            this.prmtOrgField.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtDateField.getUserObject() == null) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SUPPLYBILL_DATE_CANNOT_NULL"));
            this.prmtDateField.requestFocus();
            SysUtil.abort();
        }
        if (this.billFilterPanel != null && this.billFilterPanel.getFilterInfo() != null && this.billFilterPanel.getFilterInfo().toString().length() > 1000) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("MAX_FILTERSTR_LENGTH"));
            SysUtil.abort();
        }
        if (this.matchFilterPanel != null && this.matchFilterPanel.getMatchFilter() != null && this.matchFilterPanel.getMatchFilter().toString().length() > 1000) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("MAX_FILTERSTR_LENGTH"));
            SysUtil.abort();
        }
    }

    private void innerStoreFields() {
        this.beforeStoreFields();
        this.billEntity = (EntityObjectInfo)this.prmtBillType.getUserObject();
        this.supplyInfo.setBillBosType(this.billEntity.getType().toString());
        this.supplyInfo.setBillFullName(this.billEntity.getFullName());
        String listUI = this.billEntity.getExtendedProperty("listUI");
        this.supplyInfo.setBillListUI(listUI);
        this.supplyInfo.setBillQueryPK(MDUtil.getListUIMainQuery(listUI));
        String propFullName = this.prmtOrgField.getUserObject().toString();
        this.supplyInfo.setOrgField(propFullName);
        propFullName = this.prmtDateField.getUserObject().toString();
        this.supplyInfo.setDateField(propFullName);
        int aheadDays = this.txtAheadDays.getIntegerValue();
        this.supplyInfo.setAheadDays(aheadDays);
        String filter = this.billFilterPanel.getFilterInfo().toString();
        this.supplyInfo.setDataFilter(filter);
        String matchFilter = this.matchFilterPanel.getMatchFilter().toString();
        this.supplyInfo.setMatchFilter(matchFilter);
        this.supplyInfo.setIsInventoryObject(false);
    }

    private void addListener() {
        this.prmtBillType.addPreChangeListener(this.billPreChangeListener);
        this.prmtBillType.addDataChangeListener(this.changeListener);
        this.prmtOrgField.addPreChangeListener(this.fieldPreChangeListener);
        this.prmtDateField.addPreChangeListener(this.fieldPreChangeListener);
    }

    private void removeListener() {
        this.prmtBillType.removeSelectorListener(this.billSelectorListener);
        this.prmtBillType.removePreChangeListener(this.billPreChangeListener);
        this.prmtBillType.removeDataChangeListener(this.changeListener);
        this.prmtOrgField.removeSelectorListener(this.fieldSelectorListener1);
        this.prmtOrgField.removePreChangeListener(this.fieldPreChangeListener);
        this.prmtDateField.removeSelectorListener(this.fieldSelectorListener2);
        this.prmtDateField.removePreChangeListener(this.fieldPreChangeListener);
    }

    private void initRequestBillF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof SubSystemPromptBox)) {
            SubSystemPromptBox selector = SubSystemUtils.createSubSystemF7((IUIObject)this, (boolean)false, (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY}, (String)"com_kingdee_eas_base_botp", (boolean)true, (boolean)true);
            String title = ReservationUtil.getResourceString("REQUIREBILL_TITLE");
            selector.setTitle(title);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    private void initFieldF7(SelectorEvent e, TreeNodeTypeEnum treeNodeType) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntityPropertySelector)) {
            EntityObjectInfo destEntity = (EntityObjectInfo)this.prmtBillType.getUserObject();
            EntityPropertySelector selector = new EntityPropertySelector(this.getUIWindow(), destEntity);
            selector = new EntityPropertySelector(this.getUIWindow(), destEntity, false, EntitySelectorType.Property, treeNodeType);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = SubSystemUtils.getEntityObjectInfo((MetaDataBriefInfo)((MetaDataBriefInfo)e.getData()));
            if (entity != null) {
                e.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void transFieldResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            PropertyInfo property = (PropertyInfo)e.getData();
            e.setData((Object)property.get("fullAlias").toString());
            f7Box.setUserObject((Object)property.get("fullName").toString());
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void supplyBillTypeChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == e.getOldValue()) {
            return;
        }
        this.setFieldF7Show(true);
        EntityObjectInfo destEntity = (EntityObjectInfo)this.prmtBillType.getUserObject();
        String queryPK = DEFAULT_QUERY;
        String entityName = null;
        if (destEntity != null) {
            String listUI = destEntity.getExtendedProperty("listUI");
            queryPK = MDUtil.getListUIMainQuery(listUI);
            this.supplyInfo.setBillQueryPK(queryPK);
            this.supplyInfo.setBillFullName(destEntity.getFullName());
            entityName = destEntity.getFullName();
        }
        this.billFilterPanel.setQueryInfo(MetaDataPK.create((String)queryPK));
        this.billFilterPanel.reInitTable();
        this.matchFilterPanel.setDestEntity(MetaDataPK.create(entityName));
        this.matchFilterPanel.reInitTable();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public ReservationSupplyObjectInfo getResult() {
        return this.supplyInfo;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtil.isEmpty((String)this.supplyInfo.getBillTableSetting())) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SUPPLYBILL_TABLE_NOT_SETTING"));
            SysUtil.abort();
        }
        if (this.supplyInfo.getDataFilter() != null && this.supplyInfo.getDataFilter().length() > 1000) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("MAX_FILTERSTR_LENGTH"));
            SysUtil.abort();
        }
        if (this.supplyInfo.getMatchFilter() != null && this.supplyInfo.getMatchFilter().length() > 1000) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("MAX_FILTERSTR_LENGTH"));
            SysUtil.abort();
        }
        if (this.supplyInfo.getSortFields() != null && this.supplyInfo.getSortFields().length() > 200) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("MAX_FILTERSTR_LENGTH"));
            SysUtil.abort();
        }
        this.innerStoreFields();
        this.isConfirm = true;
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnTableSetting_actionPerformed(ActionEvent e) throws Exception {
        super.btnTableSetting_actionPerformed(e);
        if (this.supplyInfo == null || this.supplyInfo.getBillQueryPK() == null) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("SELECT_SUPPLYBILL_FIRST"));
            SysUtil.abort();
        }
        MetaDataPK billQueryPK = MetaDataPK.create((String)this.supplyInfo.getBillQueryPK());
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", (Object)this);
        uiContext.put("InitDataObject", billQueryPK);
        uiContext.put("RESERVATION_BILLTYPE", "SUPPLYBILL");
        uiContext.put("BILLFULLNAME", this.supplyInfo.getBillFullName());
        uiContext.put("BILLQUERYPK", this.supplyInfo.getBillQueryPK());
        uiContext.put("BILLTABLESETTING", this.supplyInfo.getBillTableSetting());
        uiContext.put("BILLTABLEMAXROW", this.supplyInfo.getBillTableMaxRow());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.reservation.client.TableSettingUI", uiContext, null, null);
        uiWindow.show();
        if (((ITableSetting)uiWindow.getUIObject()).isCancel()) {
            return;
        }
        String tableSettingStr = ((ITableSetting)uiWindow.getUIObject()).getTableSettingStr();
        this.supplyInfo.setBillTableSetting(tableSettingStr);
        int max_row_count = ((ITableSetting)uiWindow.getUIObject()).getMaxRowCount();
        this.supplyInfo.setBillTableMaxRow(max_row_count);
    }

    public void actionDestBillEntityF7_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("STATUS_CANCELCANCEL")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", EntitySelectorType.BizBill);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCanceled()) {
            this.billEntity = (EntityObjectInfo)ui.getReturnObject();
            if (this.billEntity != null) {
                this.prmtBillType.setUserObject((Object)this.billEntity);
                this.prmtBillType.setValue((Object)this.billEntity.getAlias());
            }
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtBillType.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtBillType.setReadOnly(true);
        this.prmtBillType.setEditable(false);
        this.prmtBillType.setRequired(true);
        this.prmtBillType.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ReservationSupplyObjectEditUI.this.actionDestBillEntityF7_actionPerformed(null);
                }
                catch (Exception e1) {
                    ReservationSupplyObjectEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtOrgField.setReadOnly(true);
        this.prmtOrgField.setEditable(false);
        this.prmtOrgField.setRequired(true);
        this.prmtOrgField.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtOrgField.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PropertyInfo property;
                if (ReservationSupplyObjectEditUI.this.getOprtState().equals(OprtState.VIEW) || ReservationSupplyObjectEditUI.this.getOprtState().equals("STATUS_CANCELCANCEL")) {
                    return;
                }
                if (ReservationSupplyObjectEditUI.this.billEntity == null) {
                    MsgBox.showInfo((String)ReservationUtil.getResourceString("SELECT_SUPPLYBILL_FIRST"));
                    SysUtil.abort();
                }
                if ((property = ReservationSupplyObjectEditUI.this.selectProperty(ReservationSupplyObjectEditUI.this.billEntity, false, EntitySelectorType.Property, TreeNodeTypeEnum.storage_org)) != null) {
                    ReservationSupplyObjectEditUI.this.prmtOrgField.setUserObject((Object)((String)property.get("fullName")));
                    ReservationSupplyObjectEditUI.this.prmtOrgField.setValue((Object)((String)property.get("fullAlias")));
                }
            }
        });
        this.prmtDateField.setReadOnly(true);
        this.prmtDateField.setEditable(false);
        this.prmtDateField.setRequired(true);
        this.prmtDateField.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtDateField.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PropertyInfo property;
                if (ReservationSupplyObjectEditUI.this.getOprtState().equals(OprtState.VIEW) || ReservationSupplyObjectEditUI.this.getOprtState().equals("STATUS_CANCELCANCEL")) {
                    return;
                }
                if (ReservationSupplyObjectEditUI.this.billEntity == null) {
                    MsgBox.showInfo((String)ReservationUtil.getResourceString("SELECT_SUPPLYBILL_FIRST"));
                    SysUtil.abort();
                }
                if ((property = ReservationSupplyObjectEditUI.this.selectProperty(ReservationSupplyObjectEditUI.this.billEntity, false, EntitySelectorType.Property, TreeNodeTypeEnum.datetime)) != null) {
                    ReservationSupplyObjectEditUI.this.prmtDateField.setUserObject((Object)((String)property.get("fullName")));
                    ReservationSupplyObjectEditUI.this.prmtDateField.setValue((Object)((String)property.get("fullAlias")));
                }
            }
        });
    }

    protected PropertyInfo selectProperty(EntityObjectInfo entity, boolean isOnlyShowLinkProperty, EntitySelectorType selectorType, TreeNodeTypeEnum treeNodeType) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("entity", entity);
        uiContext.put("selectBizType", EntitySelectorType.Property);
        if (isOnlyShowLinkProperty) {
            uiContext.put("ISONLYSHOWLINKPROPERTY", isOnlyShowLinkProperty);
        }
        if (treeNodeType != null) {
            uiContext.put("TREENODETYPE", treeNodeType);
        }
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCanceled()) {
            PropertyInfo property = (PropertyInfo)ui.getReturnObject();
            return property;
        }
        return null;
    }
}

