/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.im.reservation.ReservationDirectionEnum;
import com.kingdee.eas.scm.im.reservation.SortTypeEnum;
import com.kingdee.eas.scm.im.reservation.client.AbstractTableSettingUI;
import com.kingdee.eas.scm.im.reservation.impl.ITableSetting;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingProperty;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TableSettingUI
extends AbstractTableSettingUI
implements KDTEditListener,
ITableSetting {
    private static final Logger logger = CoreUIObject.getLogger(TableSettingUI.class);
    private boolean isCancel = true;
    public static final String TB_COLNAME_HEADNAME = "headName";
    public static final String TB_COLNAME_FIELDNAME = "fieldName";
    public static final String TB_COLNAME_ISSHOW = "isShow";
    public static final String TB_COLNAME_ISNUMERIC = "isNumeric";
    public static final String TB_COLNAME_COLUMNWIDTH = "columnWidth";
    public static final String TB_COLNAME_SORTTYPE = "sortType";
    ItemListener itemChangeListener = null;
    private String reservation_billtype = "";
    private String billFullName = "";
    private String billQueryPK = "";
    private EntityObjectInfo parentObject = null;
    private EntityObjectInfo entryObject = null;
    private boolean isDefault = false;
    BillReservationTableSettingCollection tabSettingCollection = new BillReservationTableSettingCollection();
    private static Map<String, EntityObjectInfo> billEntityMap = new HashMap<String, EntityObjectInfo>();
    private static Map<String, EntityObjectInfo> entryEntityMap = new HashMap<String, EntityObjectInfo>();
    int selectRowIndex = -1;

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public TableSettingUI() throws Exception {
        this.itemChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TableSettingUI.this.comboItemChange(e);
            }
        };
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblSetting.addKDTEditListener((KDTEditListener)this);
        this.numMaxRowNum.setMaximumNumber((Number)200);
        this.reservation_billtype = (String)this.getUIContext().get("RESERVATION_BILLTYPE");
        this.billFullName = (String)this.getUIContext().get("BILLFULLNAME");
        this.billQueryPK = (String)this.getUIContext().get("BILLQUERYPK");
        if ("SUPPLYBILL".equals(this.reservation_billtype)) {
            this.setUITitle(ReservationUtil.getResourceString("TABLESETTING_TITLE_SUPPLYBILL"));
        } else {
            this.setUITitle(ReservationUtil.getResourceString("TABLESETTING_TITLE_REQUIREBILL"));
        }
        if (billEntityMap.containsKey(this.billFullName)) {
            this.parentObject = billEntityMap.get(this.billFullName);
        } else {
            this.parentObject = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.billFullName));
            billEntityMap.put(this.billFullName, this.parentObject);
        }
        if (entryEntityMap.containsKey(this.billFullName)) {
            this.entryObject = entryEntityMap.get(this.billFullName);
        } else {
            this.entryObject = ReservationUtil.getEntryEntityObject(this.parentObject);
            entryEntityMap.put(this.billFullName, this.entryObject);
        }
        this.initCombox();
        this.addListener();
    }

    void comboItemChange(ItemEvent e) {
        this.isDefault = false;
    }

    private void addListener() {
        this.comboBillID.addItemListener(this.itemChangeListener);
        this.comboEntryID.addItemListener(this.itemChangeListener);
        this.comboEntryMaterialID.addItemListener(this.itemChangeListener);
        this.comboBaseQty.addItemListener(this.itemChangeListener);
        this.comboAssistQty.addItemListener(this.itemChangeListener);
    }

    private void removeListener() {
        this.comboBillID.removeItemListener(this.itemChangeListener);
        this.comboEntryID.removeItemListener(this.itemChangeListener);
        this.comboEntryMaterialID.removeItemListener(this.itemChangeListener);
        this.comboBaseQty.removeItemListener(this.itemChangeListener);
        this.comboAssistQty.removeItemListener(this.itemChangeListener);
    }

    void initCombox() throws Exception {
        BillReservationTableSettingProperty property = null;
        property = new BillReservationTableSettingProperty();
        this.comboBillID.addItem((Object)property);
        this.comboEntryID.addItem((Object)property);
        this.comboEntryMaterialID.addItem((Object)property);
        this.comboAssistQty.addItem((Object)property);
        this.comboBaseQty.addItem((Object)property);
        Map uiCtx = this.getUIContext();
        IMetaDataPK billQueryPK = (IMetaDataPK)uiCtx.get("InitDataObject");
        if (billQueryPK == null) {
            SysUtil.abort();
        }
        QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
        SelectorInfo selectorInfo = query.getSelector();
        ArrayList fields = selectorInfo.getFields();
        for (QueryFieldInfo field : fields) {
            if (field.getRefPropertyName().equalsIgnoreCase("id")) {
                property = new BillReservationTableSettingProperty();
                property.setFieldName(field.getName());
                property.setHeadName(field.getDisplayName());
                this.comboBillID.addItem((Object)property);
                this.comboEntryID.addItem((Object)property);
                this.comboEntryMaterialID.addItem((Object)property);
            }
            if (SQLType.NUMERIC != field.getMappingFieldType()) continue;
            property = new BillReservationTableSettingProperty();
            property.setFieldName(field.getName());
            property.setHeadName(field.getDisplayName());
            property.setNumeric(true);
            this.comboBaseQty.addItem((Object)property);
            this.comboAssistQty.addItem((Object)property);
        }
        this.initCombDefaultValue();
    }

    void doCombDefaultValue(KDComboBox combo, Pattern pattern) {
        if (combo == null || pattern == null) {
            return;
        }
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (int i = 0; i < count; ++i) {
            Matcher matcher;
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    void doCombDefaultValue(KDComboBox combo, String firstRegex, String secondRegex) {
        Matcher matcher;
        int i;
        if (combo == null || StringUtil.isEmpty((String)firstRegex)) {
            return;
        }
        Pattern pattern = Pattern.compile(firstRegex);
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
        if (StringUtil.isEmpty((String)secondRegex)) {
            return;
        }
        pattern = Pattern.compile(secondRegex);
        count = combo.getItemCount();
        for (i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    void doCombDefaultValue(KDComboBox combo, String firstRegex) {
        this.doCombDefaultValue(combo, firstRegex, null);
    }

    void initCombDefaultValue() {
        String propertyName_entry = ReservationUtil.getBillEntryPropertyName(this.parentObject);
        if (!StringUtil.isEmpty((String)propertyName_entry)) {
            propertyName_entry = propertyName_entry.toUpperCase();
        }
        String regex1 = "ID";
        String regex2 = propertyName_entry + "\\.ID";
        String regex30 = "MATERIAL.ID";
        String regex31 = "MATERIAL.ID|MATERIAL.*\\.ID|.*MATERIAL.*";
        String regex40 = propertyName_entry + "\\.BASEQTY";
        String regex41 = propertyName_entry + "\\.BASEQTY|.*BASEQTY|.*BASEUNITQTY|.*BASE";
        String regex50 = propertyName_entry + "\\.ASSISTQTY";
        String regex51 = propertyName_entry + "\\.ASSISTQTY|.*ASSISTQTY|.*ASSISTUNITQTY|.*ASSIST";
        this.doCombDefaultValue(this.comboBillID, regex1);
        this.doCombDefaultValue(this.comboEntryID, regex2);
        this.doCombDefaultValue(this.comboEntryMaterialID, regex30, regex31);
        this.doCombDefaultValue(this.comboBaseQty, regex40, regex41);
        this.doCombDefaultValue(this.comboAssistQty, regex50, regex51);
        this.isDefault = true;
    }

    void initTableSetting() {
        Icon imgTbtn_movedown = EASResource.getIcon((String)"imgTbtn_movedown");
        Icon imgTbtn_movetop = EASResource.getIcon((String)"imgTbtn_movetop");
        Icon imgTbtn_movebottom = EASResource.getIcon((String)"imgTbtn_movebottom");
        Icon imgTbtn_movetop1 = EASResource.getIcon((String)"imgTbtn_movetop1");
        this.btnMoveUp.setIcon(imgTbtn_movetop);
        this.btnMoveDown.setIcon(imgTbtn_movedown);
        this.btnMoveTop.setIcon(imgTbtn_movetop1);
        this.btnMoveBottom.setIcon(imgTbtn_movebottom);
        Map uiCtx = this.getUIContext();
        IMetaDataPK billQueryPK = (IMetaDataPK)uiCtx.get("InitDataObject");
        if (billQueryPK == null) {
            SysUtil.abort();
        }
        try {
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            IRow row = null;
            for (QueryFieldInfo field : fields) {
                field.getRefPropertyName();
                if (field.getRefPropertyName().equalsIgnoreCase("id")) continue;
                row = this.tblSetting.addRow();
                row.getCell(TB_COLNAME_HEADNAME).setValue((Object)field.getDisplayName());
                row.getCell(TB_COLNAME_FIELDNAME).getStyleAttributes().setLocked(true);
                row.getCell(TB_COLNAME_FIELDNAME).setValue((Object)field.getName());
                row.getCell(TB_COLNAME_ISSHOW).setValue((Object)false);
                ICell cell = row.getCell(TB_COLNAME_SORTTYPE);
                KDComboBox sortCombo = new KDComboBox(SortTypeEnum.getEnumList().toArray());
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)SortTypeEnum.SortType_NOSORT);
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)sortCombo);
                cell.setEditor((ICellEditor)editor);
                row.getCell(TB_COLNAME_COLUMNWIDTH).setValue((Object)-1);
                row.getCell(TB_COLNAME_ISNUMERIC).getStyleAttributes().setLocked(true);
                if (SQLType.NUMERIC == field.getMappingFieldType()) {
                    row.getCell(TB_COLNAME_ISNUMERIC).setValue((Object)true);
                    continue;
                }
                row.getCell(TB_COLNAME_ISNUMERIC).setValue((Object)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.isDefault && MsgBox.showConfirm2((String)ReservationUtil.getResourceString("SURE_USE_DEFAULT_SETTING")) != 0) {
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboBillID.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_BILLID"));
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboEntryID.getSelectedItem()).getFieldName())) {
            if ("REQUIREBILL".equals(this.reservation_billtype)) {
                MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_ENTRYID"));
                SysUtil.abort();
            } else if (MsgBox.showConfirm2((String)ReservationUtil.getResourceString("SURE_RESERVATION_BILLHEAD_MATERIAL")) != 0) {
                SysUtil.abort();
            }
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboEntryMaterialID.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_MATERIALID"));
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboBaseQty.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_BASEQTY"));
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboAssistQty.getSelectedItem()).getFieldName())) {
            // empty if block
        }
        if (this.numMaxRowNum.getNumberValue() == null || this.numMaxRowNum.getNumberValue().intValue() <= 0) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("MAXROW_INVALIDATE"));
            SysUtil.abort();
        }
        this.fillTableSettingCollection();
        this.getTabSettingCollection();
        this.setCancel(false);
        this.destroyWindow();
    }

    @Override
    protected void btnCancelSetting_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancelSetting_actionPerformed(e);
        this.setCancel(true);
        this.destroyWindow();
    }

    public BillReservationTableSettingCollection getTabSettingCollection() {
        return this.tabSettingCollection;
    }

    @Override
    public String getTableSettingStr() {
        return this.tabSettingCollection.parse2SettingStr();
    }

    @Override
    public int getMaxRowCount() {
        return this.numMaxRowNum.getNumberValue() == null ? 200 : this.numMaxRowNum.getNumberValue().intValue();
    }

    @Override
    public ReservationDirectionEnum getReservationDirection() {
        return (ReservationDirectionEnum)((Object)this.comboDirection.getSelectedItem());
    }

    private void fillTableSettingCollection() {
        int i;
        IRow row = null;
        BillReservationTableSettingProperty property = null;
        this.tabSettingCollection.clear();
        property = (BillReservationTableSettingProperty)this.comboBaseQty.getSelectedItem();
        int rowCount = this.tblSetting.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            row = this.tblSetting.getRow(i);
            if (!Boolean.valueOf(row.getCell(TB_COLNAME_ISSHOW).getValue().toString()).booleanValue() || !row.getCell(TB_COLNAME_FIELDNAME).getValue().toString().equals(property.getFieldName())) continue;
            row.getCell(TB_COLNAME_ISSHOW).setValue((Object)false);
            break;
        }
        rowCount = this.tblSetting.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            row = this.tblSetting.getRow(i);
            if (!Boolean.valueOf(row.getCell(TB_COLNAME_ISSHOW).getValue().toString()).booleanValue()) continue;
            property = new BillReservationTableSettingProperty();
            if (row.getCell(TB_COLNAME_HEADNAME).getValue() == null) {
                property.setHeadName(ReservationUtil.getResourceString("PROPERTY_NAME_UNDEFINE"));
            } else {
                property.setHeadName(row.getCell(TB_COLNAME_HEADNAME).getValue().toString());
            }
            property.setFieldName(row.getCell(TB_COLNAME_FIELDNAME).getValue().toString());
            property.setNumeric(Boolean.valueOf(row.getCell(TB_COLNAME_ISNUMERIC).getValue().toString()));
            property.setShow(Boolean.valueOf(row.getCell(TB_COLNAME_ISSHOW).getValue().toString()));
            property.setColumnWidth(Integer.parseInt(row.getCell(TB_COLNAME_COLUMNWIDTH).getValue().toString()));
            property.setColumnSeq(i);
            if (row.getCell(TB_COLNAME_SORTTYPE).getValue() != null) {
                property.setSortType(((SortTypeEnum)((Object)row.getCell(TB_COLNAME_SORTTYPE).getValue())).getValue());
            } else {
                property.setSortType("");
            }
            this.tabSettingCollection.addProperty(property);
        }
        Map uiCtx = this.getUIContext();
        String billBosType = "";
        if (this.parentObject != null) {
            billBosType = this.parentObject.getType().toString();
        }
        String entryBosType = "";
        if (this.entryObject != null) {
            entryBosType = this.entryObject.getType().toString();
        }
        property = (BillReservationTableSettingProperty)this.comboBillID.getSelectedItem();
        property.setBillID(true);
        property.setSortType("NOSORT");
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboEntryID.getSelectedItem();
        String propertyName_entry = ReservationUtil.getBillEntryPropertyName(this.parentObject);
        property.setPropertyName(propertyName_entry);
        property.setEntryID(true);
        property.setSortType("NOSORT");
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboEntryMaterialID.getSelectedItem();
        property.setEntryMaterialID(true);
        property.setSortType("NOSORT");
        String field_material = property.getFieldName();
        String propertyName_material = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_material);
        property.setPropertyName(propertyName_material);
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboAssistQty.getSelectedItem();
        property.setAssistQty(true);
        property.setSortType("NOSORT");
        String field_assistQty = property.getFieldName();
        String propertyName_assistQty = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_assistQty);
        property.setPropertyName(propertyName_assistQty);
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboBaseQty.getSelectedItem();
        property.setBaseQty(true);
        property.setSortType("NOSORT");
        String field_baseQty = property.getFieldName();
        String propertyName_baseQty = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_baseQty);
        property.setPropertyName(propertyName_baseQty);
        property.setShow(true);
        this.tabSettingCollection.addProperty(property);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.innerLoadReservationSchemaTableSetting();
    }

    private void innerLoadReservationSchemaTableSetting() {
        if (this.getUIContext().get("BILLTABLESETTING") == null) {
            return;
        }
        String settingStr = this.getUIContext().get("BILLTABLESETTING").toString();
        BillReservationTableSettingCollection storeBillTableSettingCol = new BillReservationTableSettingCollection(settingStr);
        if (CollectionUtil.isEmpty(storeBillTableSettingCol.getTabSettingCollection())) {
            return;
        }
        IRow row = null;
        int rowCount = this.tblSetting.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblSetting.getRow(i);
            for (BillReservationTableSettingProperty property : storeBillTableSettingCol.getTabSettingCollection()) {
                if (!property.getFieldName().equals(row.getCell(TB_COLNAME_FIELDNAME).getValue().toString())) continue;
                row.getCell(TB_COLNAME_HEADNAME).setValue((Object)property.getHeadName());
                if (property.isBaseQty()) {
                    row.getCell(TB_COLNAME_ISSHOW).setValue((Object)false);
                    row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(true);
                } else {
                    row.getCell(TB_COLNAME_ISSHOW).setValue((Object)property.isShow());
                    row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(!property.isShow());
                    String sortType = property.getSortType();
                    row.getCell(TB_COLNAME_SORTTYPE).setValue((Object)SortTypeEnum.getEnum(sortType));
                }
                row.getCell(TB_COLNAME_COLUMNWIDTH).setValue((Object)property.getColumnWidth());
            }
        }
        for (BillReservationTableSettingProperty property : storeBillTableSettingCol.getTabSettingCollection()) {
            if (property.isBillID()) {
                this.initComboSelectItem(this.comboBillID, property);
            }
            if (property.isEntryID()) {
                this.initComboSelectItem(this.comboEntryID, property);
            }
            if (property.isEntryMaterialID()) {
                this.initComboSelectItem(this.comboEntryMaterialID, property);
            }
            if (property.isBaseQty()) {
                this.initComboSelectItem(this.comboBaseQty, property);
            }
            if (!property.isAssistQty()) continue;
            this.initComboSelectItem(this.comboAssistQty, property);
        }
        this.handleColumnSeq();
        this.isDefault = false;
    }

    private void initComboSelectItem(KDComboBox combo, BillReservationTableSettingProperty property) {
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (int i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (!item.getFieldName().equals(property.getFieldName())) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    private void innerLoadReservationSchemaTableMaxRow() {
        if (this.getUIContext().get("BILLTABLEMAXROW") == null) {
            this.numMaxRowNum.setNumberValue((Number)50);
            return;
        }
        this.numMaxRowNum.setNumberValue((Number)((Integer)this.getUIContext().get("BILLTABLEMAXROW")));
        if (this.numMaxRowNum.getNumberValue() == null || this.numMaxRowNum.getNumberValue().intValue() == 0) {
            this.numMaxRowNum.setNumberValue((Number)50);
        }
    }

    private void innerLoadReservationDirection() {
        if (this.getUIContext().get("RESERVATIONDIRECTION") == null) {
            return;
        }
        ReservationDirectionEnum item = (ReservationDirectionEnum)((Object)this.getUIContext().get("RESERVATIONDIRECTION"));
        this.comboDirection.setSelectedItem((Object)item);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblSetting.getSelectManager().setSelectMode(2);
        IColumn column = this.tblSetting.getColumn(TB_COLNAME_COLUMNWIDTH);
        column.setWidth(-1);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.getStyleAttributes().setLocked(false);
        KDFormattedTextField detailTable_curReservationBaseQty_TextField = new KDFormattedTextField();
        detailTable_curReservationBaseQty_TextField.setName("detailTable_curReservationBaseQty_TextField");
        detailTable_curReservationBaseQty_TextField.setVisible(true);
        detailTable_curReservationBaseQty_TextField.setEditable(true);
        detailTable_curReservationBaseQty_TextField.setHorizontalAlignment(2);
        detailTable_curReservationBaseQty_TextField.setDataType(0);
        detailTable_curReservationBaseQty_TextField.setSupportedEmpty(false);
        detailTable_curReservationBaseQty_TextField.setMaximumValue((Comparable)Integer.valueOf(200));
        detailTable_curReservationBaseQty_TextField.setMinimumValue((Comparable)Integer.valueOf(-1));
        KDTDefaultCellEditor detailTable_curReservationBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationBaseQty_TextField);
        column.getStyleAttributes().setLocked(false);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.setRequired(false);
        column.setEditor((ICellEditor)detailTable_curReservationBaseQty_CellEditor);
        this.initTableSetting();
        this.innerLoadReservationSchemaTableSetting();
        this.innerLoadReservationSchemaTableMaxRow();
        this.innerLoadReservationDirection();
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
        this.tableValueChanged(e);
    }

    public void tableValueChanged(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        String colName = kDTable.getColumnKey(selectCol);
        IRow row = kDTable.getRow(selectRow);
        if (TB_COLNAME_ISSHOW.equals(colName)) {
            if (!Boolean.valueOf(e.getValue().toString()).booleanValue()) {
                row.getCell(TB_COLNAME_SORTTYPE).setValue(null);
                row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(false);
                row.getCell(TB_COLNAME_SORTTYPE).setValue((Object)SortTypeEnum.SortType_NOSORT);
            }
        }
    }

    @Override
    protected void btnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveUp_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.selectRowIndex - 1);
        this.tblSetting.getSelectManager().select(this.selectRowIndex - 1, 0);
    }

    @Override
    protected void btnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveDown_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.selectRowIndex + 1);
        this.tblSetting.getSelectManager().select(this.selectRowIndex + 1, 0);
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveTop_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, 0);
        this.tblSetting.getSelectManager().select(0, 0);
    }

    @Override
    protected void btnMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveBottom_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.tblSetting.getRowCount() - 1);
        this.tblSetting.getSelectManager().select(this.tblSetting.getRowCount() - 1, 0);
    }

    void handleColumnSeq() {
        if (this.getUIContext().get("BILLTABLESETTING") == null) {
            return;
        }
        String settingStr = this.getUIContext().get("BILLTABLESETTING").toString();
        BillReservationTableSettingCollection storeBillTableSettingCol = new BillReservationTableSettingCollection(settingStr);
        if (CollectionUtil.isEmpty(storeBillTableSettingCol.getTabSettingCollection())) {
            return;
        }
        IRow row = null;
        int rowCount = this.tblSetting.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblSetting.getRow(i);
            for (BillReservationTableSettingProperty property : storeBillTableSettingCol.getTabSettingCollection()) {
                if (!property.getFieldName().equals(row.getCell(TB_COLNAME_FIELDNAME).getValue().toString())) continue;
                this.tblSetting.moveRow(i, property.getColumnSeq());
            }
        }
    }
}

