/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.impl.IBillReservationQtyCheck;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;

public abstract class AbstractBillReservationQtyCheckImpl
implements IBillReservationQtyCheck {
    private boolean isNeedCheck = false;
    protected KDTable mainTable = null;
    protected String baseQtyColumnName = "";

    public void setNeedCheck(boolean isNeedCheck) {
        this.isNeedCheck = isNeedCheck;
    }

    @Override
    public KDTable getBillDetailTable() {
        return this.mainTable;
    }

    @Override
    public String getTableBaseQtyColumnName() {
        return this.baseQtyColumnName;
    }

    @Override
    public boolean isNeedCheck() {
        return this.isNeedCheck;
    }

    public AbstractBillReservationQtyCheckImpl(KDTable mainTable, String baseQtyColumnName) {
        this.mainTable = mainTable;
        this.baseQtyColumnName = baseQtyColumnName;
    }

    @Override
    public void qtyCheck() throws BOSException, EASBizException {
        if (!this.isNeedCheck()) {
            return;
        }
        if (this.getBillDetailTable() == null || StringUtil.isEmpty((String)this.getTableBaseQtyColumnName())) {
            return;
        }
        IDynamicObject iDynamicObject = null;
        iDynamicObject = DynamicObjectFactory.getRemoteInstance();
        IRow row = null;
        ICell cell = null;
        KDTable table = this.getBillDetailTable();
        String baseQtyColumnName = this.getTableBaseQtyColumnName();
        BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
        IObjectValue rowEntry = null;
        String reservationId = "";
        ObjectUuidPK reservationPk = null;
        StringBuffer errors = new StringBuffer(512);
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            ReservationInfo reservationInfo;
            row = table.getRow(i);
            rowEntry = (IObjectValue)row.getUserObject();
            if (rowEntry == null || rowEntry.get("reservationId") == null || (reservationInfo = (ReservationInfo)iDynamicObject.getValue((reservationPk = new ObjectUuidPK(reservationId = rowEntry.get("reservationId").toString())).getObjectType(), (IObjectPK)reservationPk)) == null) continue;
            BigDecimal reservationBaseQty = reservationInfo.getReservationBaseQty();
            cell = row.getCell(baseQtyColumnName);
            if (cell == null) continue;
            if (!(cell.getValue() instanceof BigDecimal)) {
                throw new InvReservationException(InvReservationException.BILL_QTYCOLUMN_ERROR);
            }
            BigDecimal bigDecimal = baseQty = cell.getValue() == null ? NumericUtil.BIGDECIMAL_ZERO : (BigDecimal)cell.getValue();
            if (baseQty.compareTo(reservationBaseQty) <= 0) continue;
            errors.append(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"qtyError", (String[])new String[]{String.valueOf(i + 1), reservationBaseQty.toString()}));
            errors.append("\n");
        }
        if (errors.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"billSubmitFaild"), (String)errors.toString(), (int)0);
            SysUtil.abort();
        }
    }
}

