/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.IReservationFacade;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.impl.IReservationReplace;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationBalanceUtil;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractReservationReplaceImpl
implements IReservationReplace {
    public IObjectValue model;
    public IObjectValue entry;

    @Override
    public boolean isBaseUnitUpdateInventory(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        return true;
    }

    @Override
    public abstract IObjectValue getStorageOrgUnitInfo(IObjectValue var1, IObjectValue var2);

    @Override
    public abstract IObjectValue getSupplierInfo(IObjectValue var1, IObjectValue var2);

    @Override
    public abstract IObjectValue getCustomerInfo(IObjectValue var1, IObjectValue var2);

    @Override
    public abstract IObjectValue getStoreTypeInfo(IObjectValue var1, IObjectValue var2);

    @Override
    public abstract IObjectValue getStoreStateInfo(IObjectValue var1, IObjectValue var2);

    @Override
    public InventoryInfo matchInventory(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        String inventoryId = ReservationBalanceUtil.matchInventoryId(ctx, model, entry, null);
        if (inventoryId == null) {
            return null;
        }
        return InventoryFactory.getLocalInstance(ctx).getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryId));
    }

    @Override
    public void reservationReplace(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            EntityObjectInfo billEntity = Util.getEntity((BOSObjectType)model.getBOSType());
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return;
        }
        IObjectValue entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            if (entry == null || entry.get("id") == null || entry.get("reservationId") == null) continue;
            this.reservationReplace(ctx, model, entry);
        }
    }

    @Override
    public abstract void reservationReplace(Context var1, IObjectValue var2, IObjectValue var3) throws BOSException, EASBizException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reservationReplace(Context ctx, InventoryInfo inventory, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        block20: {
            String entryId = "";
            String reservationId = "";
            BigDecimal baseQty = BigDecimal.ZERO;
            if (model instanceof InvBillBaseInfo && entry instanceof InvBillBaseEntryInfo) {
                InvBillBaseEntryInfo invEntry = (InvBillBaseEntryInfo)entry;
                entryId = invEntry.getId().toString();
                reservationId = invEntry.getReservationId();
                baseQty = invEntry.getBaseQty();
            }
            ReservationUtil.requestMutex(ctx, inventory.getId().toString());
            ReservationUtil.requestMutex(ctx, entryId);
            try {
                if (entry == null || entry.get("reservationId") == null) {
                    return;
                }
                if (StringUtil.isEmpty((String)reservationId)) {
                    reservationId = (String)entry.get("reservationId");
                }
                ReservationUtil.requestMutex(ctx, reservationId);
                IReservation iReservation = ctx == null ? ReservationFactory.getRemoteInstance() : ReservationFactory.getLocalInstance(ctx);
                ObjectUuidPK reservationPk = new ObjectUuidPK(reservationId);
                boolean isExist = iReservation.exists((IObjectPK)reservationPk);
                if (!isExist) {
                    return;
                }
                ReservationInfo reservationInfo = iReservation.getReservationInfo((IObjectPK)reservationPk);
                if (reservationInfo == null || !StringUtil.isEmpty((String)reservationInfo.getInventoryID()) && inventory.getId().toString().equals(reservationInfo.getInventoryID())) {
                    return;
                }
                ReservationModel reservationModel = new ReservationModel("FINVENTORYID");
                IReservationFacade iReservationFacade = null;
                iReservationFacade = ctx == null ? ReservationFacadeFactory.getRemoteInstance() : ReservationFacadeFactory.getLocalInstance(ctx);
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(inventory.getId().toString());
                List list = iReservationFacade.getReservationData("FINVENTORYID", idList);
                if (!CollectionUtil.isEmpty((Collection)list)) {
                    reservationModel = (ReservationModel)list.get(0);
                }
                BigDecimal invTotalReservationBaseQty = reservationModel.getTotalReservationBaseQty();
                BigDecimal unReservationBaseQty = inventory.getBaseQty().subtract(invTotalReservationBaseQty);
                if (unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
                    return;
                }
                if (unReservationBaseQty.compareTo(baseQty) >= 0) {
                    BigDecimal reservationBaseQty = reservationInfo.getReservationBaseQty();
                    if (reservationBaseQty.compareTo(baseQty) >= 0) {
                        ReservationInfo newReservationInfo = (ReservationInfo)reservationInfo.clone();
                        newReservationInfo.setId(null);
                        newReservationInfo.setInventoryID(inventory.getId().toString());
                        newReservationInfo.setReservationBaseQty(baseQty);
                        reservationInfo.setReservationBaseQty(reservationBaseQty.subtract(baseQty));
                        IObjectPK pk = iReservation.save((CoreBaseInfo)newReservationInfo);
                        if (pk != null) {
                            String newReservationId = pk.toString();
                            entry.put("reservationId", (Object)newReservationId);
                            EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, entry.getBOSType().toString());
                            DataTableInfo tableInfo = entity.getTable();
                            if (tableInfo != null) {
                                String entryTableName = tableInfo.getName();
                                String updateSql = "update " + entryTableName + " set FRESERVATIONID='" + newReservationId + "' where fid='" + entryId + "'";
                                DbUtil.execute((Context)ctx, (String)updateSql);
                            }
                        }
                        if (reservationInfo.getReservationBaseQty().compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
                            iReservation.delete((IObjectPK)reservationPk);
                        } else {
                            String updateSql = "update t_im_reservation set FRESERVATIONBASEQTY=" + reservationInfo.getReservationBaseQty() + " where fid='" + reservationId + "'";
                            DbUtil.execute((Context)ctx, (String)updateSql);
                        }
                        break block20;
                    }
                    throw new InvReservationException(InvReservationException.NOT_ENOUGH_RESERVATION_BASEQTY);
                }
                throw new InvReservationException(InvReservationException.NOT_ENOUGH_INVENTORY_BASEQTY);
            }
            finally {
                ReservationUtil.releaseMutex(ctx, inventory.getId().toString());
                ReservationUtil.releaseMutex(ctx, entryId);
                ReservationUtil.releaseMutex(ctx, reservationId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reservationReplace(Context ctx, InventoryInfo inventory, String entryId, BigDecimal baseQty, String reservationId) throws BOSException, EASBizException {
        ReservationUtil.requestMutex(ctx, inventory.getId().toString());
        ReservationUtil.requestMutex(ctx, entryId);
        try {
            ObjectUuidPK entryPk = new ObjectUuidPK(entryId);
            IDynamicObject iDynamicObject = null;
            iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            boolean isExists = iDynamicObject.exists(entryPk.getObjectType(), (IObjectPK)entryPk);
            if (!isExists) {
                return;
            }
            IObjectValue entry = iDynamicObject.getValue(entryPk.getObjectType(), (IObjectPK)entryPk);
            if (entry == null || entry.get("reservationId") == null) {
                return;
            }
            if (StringUtil.isEmpty((String)reservationId)) {
                reservationId = (String)entry.get("reservationId");
            }
            ReservationUtil.requestMutex(ctx, reservationId);
            IReservation iReservation = ctx == null ? ReservationFactory.getRemoteInstance() : ReservationFactory.getLocalInstance(ctx);
            ObjectUuidPK reservationPk = new ObjectUuidPK(reservationId);
            boolean isExist = iReservation.exists((IObjectPK)reservationPk);
            if (!isExist) {
                return;
            }
            ReservationInfo reservationInfo = iReservation.getReservationInfo((IObjectPK)reservationPk);
            if (reservationInfo == null || !StringUtil.isEmpty((String)reservationInfo.getInventoryID()) && inventory.getId().toString().equals(reservationInfo.getInventoryID())) {
                return;
            }
            ReservationModel reservationModel = new ReservationModel("FINVENTORYID");
            IReservationFacade iReservationFacade = null;
            iReservationFacade = ctx == null ? ReservationFacadeFactory.getRemoteInstance() : ReservationFacadeFactory.getLocalInstance(ctx);
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(inventory.getId().toString());
            List list = iReservationFacade.getReservationData("FINVENTORYID", idList);
            if (!CollectionUtil.isEmpty((Collection)list)) {
                reservationModel = (ReservationModel)list.get(0);
            }
            BigDecimal invTotalReservationBaseQty = reservationModel.getTotalReservationBaseQty();
            BigDecimal unReservationBaseQty = inventory.getBaseQty().subtract(invTotalReservationBaseQty);
            if (unReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) {
                return;
            }
            if (unReservationBaseQty.compareTo(baseQty) < 0) {
                throw new InvReservationException(InvReservationException.NOT_ENOUGH_INVENTORY_BASEQTY);
            }
            BigDecimal reservationBaseQty = reservationInfo.getReservationBaseQty();
            if (reservationBaseQty.compareTo(baseQty) >= 0) {
                ReservationInfo newReservationInfo = (ReservationInfo)reservationInfo.clone();
                newReservationInfo.setId(null);
                newReservationInfo.setInventoryID(inventory.getId().toString());
                newReservationInfo.setReservationBaseQty(baseQty);
                newReservationInfo.setBaseUnit(inventory.getBaseUnit());
                newReservationInfo.setStorageOrg(inventory.getStorageOrgUnit());
                newReservationInfo.setAssistUnit(inventory.getAssistUnit());
                reservationInfo.setReservationBaseQty(reservationBaseQty.subtract(baseQty));
                IObjectPK pk = iReservation.save((CoreBaseInfo)newReservationInfo);
                if (pk != null) {
                    String newReservationId = pk.toString();
                    entry.put("reservationId", (Object)newReservationId);
                    EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, entry.getBOSType().toString());
                    DataTableInfo tableInfo = entity.getTable();
                    if (tableInfo != null) {
                        String entryTableName = tableInfo.getName();
                        String updateSql = "update " + entryTableName + " set FRESERVATIONID='" + newReservationId + "' where fid='" + entryId + "'";
                        DbUtil.execute((Context)ctx, (String)updateSql);
                    }
                }
                if (reservationInfo.getReservationBaseQty().compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
                    iReservation.delete((IObjectPK)reservationPk);
                } else {
                    String updateSql = "update t_im_reservation set FRESERVATIONBASEQTY=" + reservationInfo.getReservationBaseQty() + " where fid='" + reservationId + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            } else {
                ReservationInfo newReservationInfo = (ReservationInfo)reservationInfo.clone();
                newReservationInfo.setId(null);
                newReservationInfo.setInventoryID(inventory.getId().toString());
                newReservationInfo.setReservationBaseQty(baseQty);
                newReservationInfo.setBaseUnit(inventory.getBaseUnit());
                newReservationInfo.setStorageOrg(inventory.getStorageOrgUnit());
                newReservationInfo.setAssistUnit(inventory.getAssistUnit());
                IObjectPK pk = iReservation.save((CoreBaseInfo)newReservationInfo);
                if (pk != null) {
                    String newReservationId = pk.toString();
                    entry.put("reservationId", (Object)newReservationId);
                    EntityObjectInfo entity = ReservationUtil.getEntityObjectInfo(ctx, entry.getBOSType().toString());
                    DataTableInfo tableInfo = entity.getTable();
                    if (tableInfo != null) {
                        String entryTableName = tableInfo.getName();
                        String updateSql = "update " + entryTableName + " set FRESERVATIONID='" + newReservationId + "' where fid='" + entryId + "'";
                        DbUtil.execute((Context)ctx, (String)updateSql);
                    }
                }
                iReservation.delete((IObjectPK)reservationPk);
            }
        }
        finally {
            ReservationUtil.releaseMutex(ctx, inventory.getId().toString());
            ReservationUtil.releaseMutex(ctx, entryId);
            ReservationUtil.releaseMutex(ctx, reservationId);
        }
    }
}

