/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.reservation.AutoReservationModeEnum;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationDirectionEnum;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.ReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.impl.IBillAutoReservation;
import com.kingdee.eas.scm.im.reservation.model.MatchPropertyCollection;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillAutoReservationImpl
implements IBillAutoReservation {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.reservation.impl.BillAutoReservationImpl");

    @Override
    public List<EASBizException> doBillAutoReservation(Context ctx, IObjectCollection billCollection) throws BOSException, EASBizException {
        ArrayList<EASBizException> batchList = new ArrayList<EASBizException>();
        if (CollectionUtil.isEmpty((IObjectCollection)billCollection)) {
            return batchList;
        }
        List<Object> list = new ArrayList();
        IObjectValue model = null;
        int size = billCollection.size();
        for (int i = 0; i < size; ++i) {
            model = billCollection.getObject(i);
            list = this.doBillAutoReservation(ctx, model);
            batchList.addAll(list);
        }
        return batchList;
    }

    private Map<String, MaterialInfo> getEntryMaterial(Context ctx, Set idSet) throws BOSException {
        HashMap<String, MaterialInfo> map = new HashMap<String, MaterialInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        view.setSelector(sic);
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            MaterialInfo material = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                material = col.get(i);
                if (material == null) continue;
                map.put(material.getId().toString(), material);
            }
        }
        return map;
    }

    @Override
    public List<EASBizException> doBillAutoReservation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
        ArrayList<EASBizException> list = new ArrayList<EASBizException>();
        if (null == model || null == model.get("ID")) {
            return list;
        }
        String billID = model.get("ID").toString();
        ReservationSchemaInfo reservationSchemaInfo = ReservationUtil.getBillAutoReservationSchema(ctx, model);
        if (reservationSchemaInfo == null) {
            return list;
        }
        AutoReservationModeEnum autoReservationModeEnum = reservationSchemaInfo.getAutoReservationMode();
        ReservationDirectionEnum reservationDirection = reservationSchemaInfo.getReservationDirection();
        if (reservationDirection == null) {
            reservationDirection = ReservationDirectionEnum.ReservationDirection_Positive;
        }
        EntityObjectInfo billEntity = null;
        billEntity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillFullName()));
        String entryPropertyName = "";
        entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
        EntityViewInfo requireBillView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(entryPropertyName + ".id"));
        requireBillView.setSelector(sic);
        FilterInfo dataFilter = null;
        try {
            dataFilter = reservationSchemaInfo.getFilterInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == dataFilter) {
            dataFilter = new FilterInfo();
        }
        FilterInfo billFilter = new FilterInfo();
        billFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billID, CompareType.EQUALS));
        String orgField = reservationSchemaInfo.getOrgField();
        Map<String, PropertyInfo> map = ReservationUtil.getEntityProperty(ctx, reservationSchemaInfo.getBillBosType());
        PropertyInfo property = map.get(orgField);
        String dbFieldName = property.getMappingField().getName();
        String fieldName = orgField.indexOf(".") > 1 ? reservationSchemaInfo.getEntryIDFieldName() : reservationSchemaInfo.getBillIDFieldName();
        String alias = ReservationUtil.getQueryFeildShowValue(reservationSchemaInfo.getBillQueryPK(), fieldName);
        String storageAlias = "";
        if (!StringUtil.isEmpty((String)alias)) {
            storageAlias = alias.split("\\.")[0] + "." + dbFieldName;
        }
        String materialAlias = ReservationUtil.getQueryFeildShowValue(reservationSchemaInfo.getBillQueryPK(), reservationSchemaInfo.getEntryMaterialIDFieldName());
        dataFilter.mergeFilter(billFilter, "AND");
        requireBillView.setFilter(dataFilter);
        IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance((Context)ctx);
        QueryExecuteOption option = new QueryExecuteOption();
        option.isIgnorePermissionCheck = true;
        String sql = qda.getQuerySql((IMetaDataPK)MetaDataPK.create((String)reservationSchemaInfo.getBillQueryPK()), requireBillView, option);
        String[] sqlArr = sql.split("ORDER BY");
        StringBuffer excSql = new StringBuffer();
        if (sqlArr.length > 1) {
            excSql.append(sqlArr[0]).append(" and ").append(materialAlias).append("  in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=").append(storageAlias).append(") ORDER BY ").append(sqlArr[1]);
            sql = excSql.toString();
        } else {
            sql = sql + " and " + materialAlias + " in (SELECT FMATERIALID FROM T_BD_MATERIALINVENTORY WHERE FISRESERVATION = 1 AND FOrgUnit=" + storageAlias + ")";
        }
        HashSet<String> entryId = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                entryId.add(rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (entryId.isEmpty()) {
            return list;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)billID, CompareType.EQUALS));
        iReservation.delete(filter);
        List<String> reservationList = ReservationUtil.getBillReservationList(ctx, model, false);
        if (!CollectionUtil.isEmpty(reservationList)) {
            return list;
        }
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (entries == null) {
            entryPropertyName = ReservationUtil.getBillEntryPropertyName(billEntity);
            entries = (IObjectCollection)model.get(entryPropertyName);
        }
        if (CollectionUtil.isEmpty((IObjectCollection)entries)) {
            return list;
        }
        String PROPERTY_MATERIAL = reservationSchemaInfo.getEntryMaterialPropertyName();
        String PROPERTY_BASEQTY = reservationSchemaInfo.getBaseQtyPropertyName();
        String PROPERTY_ASSISTQTY = reservationSchemaInfo.getAssistQtyPropertyName();
        ReservationSupplyObjectInfo inventorySchema = reservationSchemaInfo.getInventoryEntry();
        EntityViewInfo invView = null;
        FilterInfo invDataFilter = null;
        if (inventorySchema == null) {
            inventorySchema = new ReservationSupplyObjectInfo();
        }
        MatchPropertyCollection propertyCol = inventorySchema.getMatchPropertyCollection(reservationSchemaInfo.getBillFullName());
        IObjectValue entry = null;
        ReservationInfo reservationInfo = null;
        try {
            SorterItemCollection sortCol = inventorySchema.getSorterItemCollection();
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("baseQty");
            aSorterItemInfo.setSortType(SortType.DESCEND);
            if (!sortCol.contains(aSorterItemInfo)) {
                sortCol.add(aSorterItemInfo);
            }
            IInventory iInventory = InventoryFactory.getLocalInstance(ctx);
            HashSet<String> idSet = new HashSet<String>();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                String materialID = "";
                IObjectValue obj = null;
                obj = (IObjectValue)entry.get(PROPERTY_MATERIAL);
                if (obj == null) continue;
                materialID = obj.get("id").toString();
                idSet.add(materialID);
            }
            Map<String, MaterialInfo> materialMap = this.getEntryMaterial(ctx, idSet);
            MaterialInfo materialInfo = null;
            MeasureUnitInfo baseUnitInfo = null;
            MeasureUnitInfo assistUnitInfo = null;
            int size2 = entries.size();
            block8: for (int i = 0; i < size2; ++i) {
                BigDecimal validInvAssistQty;
                BigDecimal validInvBaseQty;
                ReservationModel inventoryReservation;
                String inventoryID;
                String storageUnitID;
                entry = entries.getObject(i);
                String entryID = entry.get("id").toString();
                if (!entryId.contains(entryID)) continue;
                String materialID = "";
                IObjectValue obj = null;
                obj = (IObjectValue)entry.get(PROPERTY_MATERIAL);
                if (obj == null) {
                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK billEntryPK = new ObjectUuidPK(entryID);
                    entry = iDynamicObject.getValue(billEntryPK.getObjectType(), (IObjectPK)billEntryPK);
                }
                if ((obj = (IObjectValue)entry.get(PROPERTY_MATERIAL)) != null) {
                    materialID = obj.get("id").toString();
                    materialInfo = materialMap.get(materialID);
                    if (materialInfo == null) continue;
                    baseUnitInfo = materialInfo.getBaseUnit();
                    assistUnitInfo = materialInfo.getAssistUnit();
                }
                if (materialInfo == null) continue;
                BigDecimal billBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                if (entry.get(PROPERTY_BASEQTY) != null) {
                    billBaseQty = (BigDecimal)entry.get(PROPERTY_BASEQTY);
                }
                BigDecimal billAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                if (entry.get(PROPERTY_ASSISTQTY) != null) {
                    billAssistQty = (BigDecimal)entry.get(PROPERTY_ASSISTQTY);
                }
                int sign = billBaseQty.signum();
                if (reservationDirection == ReservationDirectionEnum.ReservationDirection_Positive) {
                    if (sign <= 0) {
                        continue;
                    }
                } else if (reservationDirection == ReservationDirectionEnum.ReservationDirection_Negative) {
                    if (sign >= 0) continue;
                    billBaseQty = billBaseQty.abs();
                    billAssistQty = billAssistQty.abs();
                } else {
                    billBaseQty = billBaseQty.abs();
                    billAssistQty = billAssistQty.abs();
                }
                if (StringUtil.isEmpty((String)(storageUnitID = ReservationUtil.getRequireBillStorageUnit(reservationSchemaInfo, model, entry)))) {
                    throw new InvReservationException(InvReservationException.RESERVATIONSCHEMA_STORAGEORG_ISNULL, new Object[]{model.get("number")});
                }
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)storageUnitID));
                invView = new EntityViewInfo();
                invDataFilter = inventorySchema.getFilterInfo();
                if (invDataFilter == null) {
                    invDataFilter = new FilterInfo();
                }
                FilterInfo inventoryMatchfilter = ReservationUtil.getMatchFilterInfo(propertyCol, model, entry);
                invDataFilter.mergeFilter(inventoryMatchfilter, "AND");
                FilterInfo requireBillFilter = new FilterInfo();
                requireBillFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitID, CompareType.EQUALS));
                requireBillFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
                requireBillFilter.getFilterItems().add(new FilterItemInfo("baseQty", (Object)0, CompareType.GREATER));
                invDataFilter.mergeFilter(requireBillFilter, "AND");
                invView.setFilter(invDataFilter);
                invView.setSorter(sortCol);
                InventoryCollection invCollection = iInventory.getInventoryCollection(invView);
                ReservationUtil.lockInventoryRecords(ctx, (IObjectCollection)invCollection);
                InventoryInfo inventoryInfo = null;
                String isCheckAssistQtyStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(storageUnitID), "INM180");
                boolean isCheckAssistQty = isCheckAssistQtyStr == null ? false : Boolean.parseBoolean(isCheckAssistQtyStr);
                BigDecimal totalValidInvBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                BigDecimal totalValidInvAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                int colSize = invCollection.size();
                for (int n = 0; n < colSize; ++n) {
                    inventoryInfo = invCollection.get(n);
                    inventoryID = inventoryInfo.getId().toString();
                    inventoryReservation = ReservationUtil.getInventoryReservationData(ctx, inventoryID);
                    validInvBaseQty = inventoryInfo.getBaseQty().subtract(inventoryReservation.getTotalReservationBaseQty());
                    totalValidInvBaseQty = totalValidInvBaseQty.add(validInvBaseQty);
                    validInvAssistQty = inventoryInfo.getCurStoreAssistQty().subtract(inventoryReservation.getTotalReservationAssistQty());
                    totalValidInvAssistQty = totalValidInvAssistQty.add(validInvAssistQty);
                }
                if (billBaseQty.compareTo(totalValidInvBaseQty) > 0) {
                    String baseUnitName = "";
                    if (baseUnitInfo != null) {
                        baseUnitName = baseUnitInfo.getName();
                    }
                    if (autoReservationModeEnum.getValue() != 1) {
                        if (autoReservationModeEnum.getValue() == 2) {
                            InvReservationException ex = new InvReservationException(InvReservationException.AUTORESERVATIONQTY_INVENTORY_LESSTHAN_ENTRY_CONTINUE, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber() + "\u3001" + materialInfo.getName(), billBaseQty, baseUnitName, totalValidInvBaseQty, baseUnitName, billBaseQty.subtract(totalValidInvBaseQty), baseUnitName});
                            list.add(ex);
                        } else {
                            if (autoReservationModeEnum.getValue() == 0) {
                                InvReservationException ex = new InvReservationException(InvReservationException.AUTORESERVATIONQTY_INVENTORY_LESSTHAN_ENTRY_STOP, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber() + "\u3001" + materialInfo.getName(), billBaseQty, baseUnitName, totalValidInvBaseQty, baseUnitName, billBaseQty.subtract(totalValidInvBaseQty), baseUnitName});
                                list.add(ex);
                                continue;
                            }
                            if (autoReservationModeEnum.getValue() == 3) {
                                InvReservationException ex = new InvReservationException(InvReservationException.AUTORESERVATIONQTY_INVENTORY_LESSTHAN_ENTRY_ROLLBACK, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber() + "\u3001" + materialInfo.getName(), billBaseQty, baseUnitName, totalValidInvBaseQty, baseUnitName, billBaseQty.subtract(totalValidInvBaseQty), baseUnitName});
                                list.add(ex);
                                continue;
                            }
                        }
                    }
                } else if (isCheckAssistQty && billAssistQty.compareTo(totalValidInvAssistQty) > 0 && null != assistUnitInfo && autoReservationModeEnum.getValue() != 1) {
                    if (autoReservationModeEnum.getValue() == 2) {
                        InvReservationException ex = new InvReservationException(InvReservationException.UNRESERVATIONEX_USED_LESS, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber(), materialInfo.getName(), billAssistQty, assistUnitInfo.getName(), totalValidInvAssistQty, assistUnitInfo.getName(), billAssistQty.subtract(totalValidInvAssistQty), assistUnitInfo.getName()});
                        list.add(ex);
                    } else {
                        if (autoReservationModeEnum.getValue() == 0) {
                            InvReservationException ex = new InvReservationException(InvReservationException.UNRESERVATIONEX_CANUSED_LESS, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber(), materialInfo.getName(), billAssistQty, assistUnitInfo.getName(), totalValidInvAssistQty, assistUnitInfo.getName(), billAssistQty.subtract(totalValidInvAssistQty), assistUnitInfo.getName()});
                            list.add(ex);
                            continue;
                        }
                        if (autoReservationModeEnum.getValue() == 3) {
                            InvReservationException ex = new InvReservationException(InvReservationException.UNSUBMIT_CANUSED_LESS, new Object[]{model.get("number"), entry.get("seq"), materialInfo.getNumber(), materialInfo.getName(), billAssistQty, assistUnitInfo.getName(), totalValidInvAssistQty, assistUnitInfo.getName(), billAssistQty.subtract(totalValidInvAssistQty), assistUnitInfo.getName()});
                            list.add(ex);
                            continue;
                        }
                    }
                }
                if (3 == autoReservationModeEnum.getValue() && !CollectionUtil.isEmpty(list)) continue;
                colSize = invCollection.size();
                for (int n = 0; n < colSize; ++n) {
                    inventoryInfo = invCollection.get(n);
                    inventoryID = inventoryInfo.getId().toString();
                    inventoryReservation = ReservationUtil.getInventoryReservationData(ctx, inventoryID);
                    validInvBaseQty = inventoryInfo.getBaseQty().subtract(inventoryReservation.getTotalReservationBaseQty());
                    if (validInvBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) <= 0) continue;
                    validInvAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                    if (assistUnitInfo != null) {
                        validInvAssistQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)validInvBaseQty, (String)materialID, (String)baseUnitInfo.getId().toString(), (String)assistUnitInfo.getId().toString());
                    }
                    reservationInfo = new ReservationInfo();
                    reservationInfo.setIsAutoReservation(true);
                    reservationInfo.setReservationType(ReservationTypeEnum.ReservationType_Bill);
                    reservationInfo.setInventoryID(inventoryID);
                    reservationInfo.setStorageOrg(sou);
                    reservationInfo.setMaterial(materialInfo);
                    reservationInfo.setBaseUnit(baseUnitInfo);
                    reservationInfo.setAssistUnit(assistUnitInfo);
                    reservationInfo.setRequireBillBosType(reservationSchemaInfo.getBillBosType());
                    reservationInfo.setRequireBillID(billID);
                    reservationInfo.setRequireBillEntryID(entryID);
                    if (validInvBaseQty.compareTo(billBaseQty) < 0) {
                        reservationInfo.setReservationBaseQty(validInvBaseQty);
                        reservationInfo.setReservationAssistQty(validInvAssistQty);
                        if (reservationInfo.getReservationAssistQty() == null || reservationInfo.getReservationAssistQty().compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
                            reservationInfo.setReservationAssistQty(NumericUtil.BIGDECIMAL_ZERO);
                        }
                        billBaseQty = billBaseQty.subtract(validInvBaseQty);
                        billAssistQty = billAssistQty.subtract(validInvAssistQty);
                        ReservationUtil.matchReservationEx(ctx, reservationInfo, reservationSchemaInfo, model, entry);
                        iReservation.addBillReservation(reservationInfo);
                        continue;
                    }
                    reservationInfo.setReservationBaseQty(billBaseQty);
                    if (assistUnitInfo != null) {
                        validInvAssistQty = inventoryInfo.getCurStoreAssistQty().subtract(inventoryReservation.getTotalReservationAssistQty());
                        if (isCheckAssistQty && validInvAssistQty.compareTo(billAssistQty) < 0) {
                            reservationInfo.setReservationAssistQty(validInvAssistQty);
                        } else {
                            reservationInfo.setReservationAssistQty(billAssistQty);
                        }
                        if (reservationInfo.getReservationAssistQty() == null || reservationInfo.getReservationAssistQty().compareTo(NumericUtil.BIGDECIMAL_ZERO) < 0) {
                            reservationInfo.setReservationAssistQty(NumericUtil.BIGDECIMAL_ZERO);
                        }
                    }
                    ReservationUtil.matchReservationEx(ctx, reservationInfo, reservationSchemaInfo, model, entry);
                    iReservation.addBillReservation(reservationInfo);
                    continue block8;
                }
            }
            if (3 == autoReservationModeEnum.getValue() && !CollectionUtil.isEmpty(list)) {
                EASBizException ex = null;
                StringBuffer msg = new StringBuffer(250);
                int size3 = list.size();
                for (int i = 0; i < size3; ++i) {
                    ex = (EASBizException)((Object)list.get(i));
                    msg.append(ex.getMessage() + "\n");
                }
                if (msg.length() > 0) {
                    throw new Exception(msg.toString());
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return list;
    }
}

