/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.model;

import com.kingdee.eas.scm.im.reservation.model.Property;
import com.kingdee.eas.scm.util.string.StringUtil;

public class MatchProperty {
    private static final String EQUAL_SIGN = "=";
    private static final String LFET_BRACKET_SIGN = "(";
    private static final String RIGHT_BRACKET_SIGN = ")";
    private Property srcProperty;
    private Property destProperty;

    public MatchProperty(String srcEntity, String destEntity, String matchStr) {
        this.parse(srcEntity, destEntity, matchStr);
    }

    public MatchProperty(Property srcProperty, Property destProperty) {
        this.srcProperty = srcProperty;
        this.destProperty = destProperty;
    }

    private void parse(String srcEntity, String destEntity, String matchStr) {
        if (StringUtil.isEmpty((String)matchStr) || matchStr.length() < 2) {
            return;
        }
        String tmpMatchStr = this.removeBracketSign(matchStr);
        String destProp = tmpMatchStr.substring(0, tmpMatchStr.indexOf(EQUAL_SIGN)).trim();
        this.destProperty = new Property(destEntity, destProp);
        String srcProp = tmpMatchStr.substring(tmpMatchStr.indexOf(EQUAL_SIGN) + 1);
        this.srcProperty = new Property(srcEntity, srcProp);
    }

    private String removeBracketSign(String matchStr) {
        return matchStr.substring(matchStr.indexOf(LFET_BRACKET_SIGN) + 1, matchStr.indexOf(RIGHT_BRACKET_SIGN));
    }

    public Property getSrcProperty() {
        return this.srcProperty;
    }

    public void setSrcProperty(Property srcProperty) {
        this.srcProperty = srcProperty;
    }

    public Property getDestProperty() {
        return this.destProperty;
    }

    public void setDestProperty(Property destProperty) {
        this.destProperty = destProperty;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.srcProperty == null || this.destProperty == null) {
            return str.toString();
        }
        str.append(LFET_BRACKET_SIGN);
        str.append(this.destProperty.toString()).append(EQUAL_SIGN).append(this.srcProperty.toString());
        str.append(RIGHT_BRACKET_SIGN);
        return str.toString();
    }

    public String getAlias() {
        StringBuffer str = new StringBuffer();
        if (this.srcProperty == null || this.destProperty == null) {
            return str.toString();
        }
        str.append(LFET_BRACKET_SIGN);
        str.append(this.destProperty.getAlias()).append(EQUAL_SIGN).append(this.srcProperty.getAlias());
        str.append(RIGHT_BRACKET_SIGN);
        return str.toString();
    }
}

