/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.model;

import com.kingdee.eas.scm.im.reservation.model.MatchProperty;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class MatchPropertyCollection {
    private static final String JOIN_AND = " AND ";
    private String srcEntity;
    private String destEntity;
    private List<MatchProperty> matchPropertyList;

    public MatchPropertyCollection(String srcEntity, String destEntity, List<MatchProperty> matchPropertyList) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.matchPropertyList = matchPropertyList;
    }

    public MatchPropertyCollection(String srcEntity, String destEntity, String matchListStr) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.matchPropertyList = new ArrayList<MatchProperty>();
        this.parse(matchListStr);
    }

    private void parse(String matchListStr) {
        if (StringUtil.isEmpty((String)matchListStr)) {
            return;
        }
        String[] matchPropStr = matchListStr.split(JOIN_AND);
        MatchProperty matchProp = null;
        for (int i = 0; i < matchPropStr.length; ++i) {
            matchProp = new MatchProperty(this.srcEntity, this.destEntity, matchPropStr[i]);
            this.matchPropertyList.add(matchProp);
        }
    }

    public List<MatchProperty> getMatchPropertyList() {
        return this.matchPropertyList;
    }

    public void setMatchPropertyList(List<MatchProperty> matchPropertyList) {
        this.matchPropertyList = matchPropertyList;
    }

    public String toString() {
        StringBuffer matchFilterStr = new StringBuffer();
        MatchProperty matchProp = null;
        for (int i = 0; i < this.matchPropertyList.size(); ++i) {
            matchProp = this.matchPropertyList.get(i);
            if (i > 0) {
                matchFilterStr.append(JOIN_AND);
            }
            matchFilterStr.append(matchProp.toString());
        }
        return matchFilterStr.toString();
    }

    public String getAlias() {
        StringBuffer alias = new StringBuffer();
        MatchProperty matchProp = null;
        for (int i = 0; i < this.matchPropertyList.size(); ++i) {
            matchProp = this.matchPropertyList.get(i);
            if (i > 0) {
                alias.append(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"and"));
            }
            alias.append(matchProp.getAlias());
        }
        return alias.toString();
    }
}

