/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class IMRptUtils {
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    public static final int DEFAULT_PRICISION = 2;
    private static String rptResource = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private static final String groupStandardId = "dR8lnQEPEADgAAWKwKgSxZeb4R8=";
    public static final String spinQtyPrecission = "spinQtyPrecission";
    public static final String spinAssQtyPrecission = "spinAssQtyPrecission";
    public static final String spinPricePrecission = "spinPricePrecission";
    public static final String spinAmountPrecission = "spinAmountPrecission";

    public static Object[] initFullOrgUnit(Object[] fullStorageOrgUnit, Object[] storageOrgUnit) {
        Object[] retObj = fullStorageOrgUnit;
        if (ArrayUtil.isEmpty((Object[])fullStorageOrgUnit) && !ArrayUtil.isEmpty((Object[])storageOrgUnit)) {
            retObj = storageOrgUnit;
            for (int i = 0; i < retObj.length; ++i) {
                if (!(retObj[i] instanceof OrgUnitInfo)) continue;
                ((OrgUnitInfo)retObj[i]).setLevel(1);
            }
        }
        return retObj;
    }

    public static String getFmtDate(Date date, String fmtStr) {
        SimpleDateFormat df = new SimpleDateFormat(fmtStr);
        return df.format(date);
    }

    public static String getFmtDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String getFmtDateAndTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static Date getDate(Date d) {
        Date bdate = new Date(d.getYear(), d.getMonth(), d.getDate());
        return bdate;
    }

    public static String getFilterBeginDate(Date d) {
        Date bdate = new Date(d.getYear(), d.getMonth(), d.getDate());
        return IMRptUtils.getFmtDateAndTime(bdate);
    }

    public static int getDateNumber(Date d) {
        int date = 0;
        if (d != null) {
            date = (d.getYear() + 1900) * 10000 + (d.getMonth() + 1) * 100 + d.getDate();
        }
        return date;
    }

    public static String getFilterEndDate(Date d) {
        Date bdate = new Date(d.getYear(), d.getMonth(), d.getDate());
        long dl = bdate.getTime();
        Date nDate = new Date(dl += 86399999L);
        return IMRptUtils.getFmtDateAndTime(nDate);
    }

    public static String getFilterWeekBeforeDate(Date d) {
        long dl = d.getTime();
        Date nDate = new Date(dl -= 604800000L);
        return IMRptUtils.getFmtDateAndTime(nDate);
    }

    public static Date getStrDate(String str, String fmt) throws ParseException {
        if (fmt == null) {
            fmt = "yyyy-MM-dd";
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        Date cDate = df.parse(str);
        return cDate;
    }

    public static void changeTableColPrecisionByMaterial(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo, KDTable table, String[] fieldNames) throws EASBizException, BOSException {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        if (measureUnitInfo != null && materialInfo != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        String colPrecision = SCMClientUtils.getFormatPattern((int)precision);
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            if (table.getColumn(fieldNames[i]) == null) continue;
            table.getColumn(fieldNames[i]).getStyleAttributes().setNumberFormat(colPrecision);
        }
    }

    public static boolean checkSameCurrency(String[] storageOrgIDs) throws BOSException {
        if (storageOrgIDs.length == 0) {
            return true;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id where fromUnit.id in (");
        int size = storageOrgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(storageOrgIDs[i]).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl.size() == 0) {
            return true;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        oql = new StringBuffer();
        oql.append("select  id,name,number,baseCurrency.id,isLeaf where id in (");
        int size2 = orgRelColl.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            FullOrgUnitInfo toOrgUnit = orgRelColl.get(i).getToUnit();
            oql.append("'").append(toOrgUnit.getId().toString()).append("'");
        }
        oql.append(")");
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        CompanyOrgUnitInfo firstCompanyOrgInfo = null;
        int size3 = companyColl.size();
        for (int i = 0; i < size3; ++i) {
            CompanyOrgUnitInfo companyOrgInfo = companyColl.get(i);
            if (!companyOrgInfo.isIsLeaf()) continue;
            if (firstCompanyOrgInfo == null) {
                firstCompanyOrgInfo = companyOrgInfo;
            }
            if (firstCompanyOrgInfo.getBaseCurrency().getId().toString().equals(companyOrgInfo.getBaseCurrency().getId().toString())) continue;
            MsgBox.showError((String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DIFF_COMORG_CUR", (String[])new String[]{firstCompanyOrgInfo.getName(), companyOrgInfo.getName()}));
            return false;
        }
        return true;
    }

    public static boolean checkSameCurrencyAndPeriodType(String[] storageOrgIDs) throws BOSException {
        if (storageOrgIDs.length == 0) {
            return true;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id where fromUnit.id in (");
        int size = storageOrgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(storageOrgIDs[i]).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl.size() == 0) {
            return true;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        oql = new StringBuffer();
        oql.append("select  id,name,number,baseCurrency.id,isLeaf,accountPeriodType.id where id in (");
        int size2 = orgRelColl.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            FullOrgUnitInfo toOrgUnit = orgRelColl.get(i).getToUnit();
            oql.append("'").append(toOrgUnit.getId().toString()).append("'");
        }
        oql.append(")");
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        CompanyOrgUnitInfo firstCompanyOrgInfo = null;
        int size3 = companyColl.size();
        for (int i = 0; i < size3; ++i) {
            CompanyOrgUnitInfo companyOrgInfo = companyColl.get(i);
            if (!companyOrgInfo.isIsLeaf()) continue;
            if (firstCompanyOrgInfo == null) {
                firstCompanyOrgInfo = companyOrgInfo;
            }
            if (!firstCompanyOrgInfo.getAccountPeriodType().getId().toString().equals(companyOrgInfo.getAccountPeriodType().getId().toString())) {
                MsgBox.showError((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DIFF_COMORG_PERIODTYPE", (String[])new String[]{firstCompanyOrgInfo.getName(), companyOrgInfo.getName()}));
                return false;
            }
            if (firstCompanyOrgInfo.getBaseCurrency().getId().toString().equals(companyOrgInfo.getBaseCurrency().getId().toString())) continue;
            MsgBox.showError((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DIFF_COMORG_CUR", (String[])new String[]{firstCompanyOrgInfo.getName(), companyOrgInfo.getName()}));
            return false;
        }
        return true;
    }

    public static Set getAuthorizedOrg(OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection coll;
        LinkedHashSet<String> authorizedStorageSet = new LinkedHashSet<String>();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        try {
            coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex0) {
            throw ex0;
        }
        OrgUnitInfo orgUnit = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            orgUnit = (OrgUnitInfo)storageOrgs[i];
            authorizedStorageSet.add(orgUnit.getId().toString());
        }
        return authorizedStorageSet;
    }

    public static boolean isOrgAuthorized(String orgID, OrgType orgType, String permItem) throws BOSException, EASBizException {
        boolean authorized = false;
        Set authorizedStorageSet = IMRptUtils.getAuthorizedOrg(orgType, permItem);
        authorized = authorizedStorageSet.contains(orgID);
        return authorized;
    }

    public static void checkHasAuthorized(String orgID, OrgType orgType, String permItem) {
        try {
            if (!IMRptUtils.isOrgAuthorized(orgID, orgType, permItem)) {
                String youDonnotHave = EASResource.getString((String)rptResource, (String)"YouDonnotHave");
                String noAuthorized = EASResource.getString((String)rptResource, (String)"printPermission");
                IStorageOrgUnit iStorageOrg = StorageOrgUnitFactory.getRemoteInstance();
                StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)iStorageOrg.getValue((IObjectPK)new ObjectUuidPK(orgID));
                if (storageOrgInfo != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(youDonnotHave + " ");
                    sb.append(storageOrgInfo.getName());
                    sb.append(" " + noAuthorized);
                    MsgBox.showError((String)sb.toString());
                    SysUtil.abort();
                }
            }
        }
        catch (EASBizException e) {
            IMRptUtils.handUIException(e);
        }
        catch (BOSException e) {
            IMRptUtils.handUIException(e);
        }
    }

    public static Object[] filterNoAuthorizedOrgs(Object[] orgIDs, OrgType orgType, String permItem) throws EASBizException, BOSException {
        Vector<Object> authOrgsV = new Vector<Object>();
        Set authorizedStorageSet = IMRptUtils.getAuthorizedOrg(orgType, permItem);
        int size = orgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (authorizedStorageSet.contains(orgIDs[i])) continue;
            authOrgsV.add(orgIDs[i]);
        }
        return authOrgsV.toArray();
    }

    public static void setBizMaterialGroup(KDBizPromptBox bizMaterialGroup) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)groupStandardId));
        viewInfo.setFilter(filterInfo);
        bizMaterialGroup.setEntityViewInfo(viewInfo);
    }

    public static void setBizMaterialGroup(KDBizPromptBox bizMaterialGroup, String standardId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        bizMaterialGroup.setDisplayFormat("$number$");
        bizMaterialGroup.setEditFormat("$number$");
        bizMaterialGroup.setCommitFormat("$number$;$helpCode$;$name$;$model$");
        bizMaterialGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)standardId));
        viewInfo.setFilter(filterInfo);
        bizMaterialGroup.setEnabledMultiSelection(false);
        bizMaterialGroup.setEntityViewInfo(viewInfo);
        bizMaterialGroup.setCommitParser((IParser)new MainDataParser("$number$", bizMaterialGroup));
    }

    private static void handUIException(Throwable throwable) {
        ExceptionHandler.handle((Throwable)throwable);
        SysUtil.abort();
    }

    public static void setRptWarehouseFilter(Object[] storageOrgIds, KDBizPromptBox bizWarehouseF7) {
        if (bizWarehouseF7 != null) {
            HashSet<Object> storgageOrgSet = new HashSet<Object>();
            for (int i = 0; i < storageOrgIds.length; ++i) {
                storgageOrgSet.add(storageOrgIds[i]);
            }
            bizWarehouseF7.getQueryAgent().resetRuntimeEntityView();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("storageOrgUnit.id", storgageOrgSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizWarehouseF7.setEditable(true);
            bizWarehouseF7.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForMultiOrg");
            bizWarehouseF7.setDisplayFormat("$number$");
            bizWarehouseF7.setEditFormat("$number$");
            bizWarehouseF7.setCommitFormat("$number$");
            bizWarehouseF7.setEntityViewInfo(viewInfo);
        }
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date) throws BOSException, EASBizException {
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(KEY_ENDDATE, (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and #1 ");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, String periodTypeId) throws BOSException, EASBizException {
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(KEY_ENDDATE, (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        if (periodTypeId != null) {
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1 ");
        }
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    public static boolean checkSameAssign(Object[] storageOrgNums) throws BOSException {
        if (storageOrgNums.length == 0) {
            return true;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id   ").append("where fromUnit.number in (");
        int size = storageOrgNums.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(storageOrgNums[i]).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl == null || orgRelColl.size() == 0) {
            return false;
        }
        String companyOrgID = orgRelColl.get(0).getToUnit().getId().toString();
        int size2 = orgRelColl.size();
        for (int i = 0; i < size2; ++i) {
            if (companyOrgID.equals(orgRelColl.get(i).getToUnit().getId().toString())) continue;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource.notSameAssignCompany"));
            return false;
        }
        return true;
    }

    public static int getMonthNumber(Date d) {
        int month = 0;
        if (d != null) {
            month = (d.getYear() + 1900) * 100 + (d.getMonth() + 1);
        }
        return month;
    }

    public static int getYearNumber(Date d) {
        int year = 0;
        if (d != null) {
            year = d.getYear() + 1900;
        }
        return year;
    }

    public static boolean isFirstDayOfYear(Date date) {
        return date.getMonth() == 0 && date.getDate() == 1;
    }

    public static boolean isLastDayOfYear(Date date) {
        return date.getMonth() == 11 && date.getDate() == 31;
    }

    public static boolean isLastDayOfMonth(Date date) {
        Date cur = new Date();
        cur.setYear(date.getYear());
        cur.setMonth(date.getMonth() + 1);
        cur.setDate(1);
        cur.setDate(cur.getDate() - 1);
        return cur.getYear() == date.getYear() && cur.getMonth() == date.getMonth() && cur.getDate() == date.getDate();
    }

    public static boolean isFirstDayOfMonth(Date date) {
        return date.getDate() == 1;
    }

    public static int getLastDateOfMonth(Date date) {
        Date cur = new Date();
        cur.setYear(date.getYear());
        cur.setMonth(date.getMonth() + 1);
        cur.setDate(1);
        cur.setDate(cur.getDate() - 1);
        return cur.getDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBName(Context ctx) {
        Connection conn = null;
        String dbName = null;
        try {
            conn = DBUtils.getConnection((Context)ctx);
            if (conn != null) {
                dbName = conn.getMetaData().getDatabaseProductName();
            }
        }
        catch (SQLException e) {
            IMRptUtils.handUIException(e);
        }
        finally {
            DBUtils.cleanup(null, (Connection)conn);
        }
        return dbName;
    }

    public static void setParams4Precision(RptParams target, RptParams source) {
        target.setInt(spinAmountPrecission, source.getInt(spinAmountPrecission));
        target.setInt(spinAssQtyPrecission, source.getInt(spinAssQtyPrecission));
        target.setInt(spinPricePrecission, source.getInt(spinPricePrecission));
        target.setInt(spinQtyPrecission, source.getInt(spinQtyPrecission));
    }

    public static String getPeriodTypeId(String[] storageOrgIDs) throws BOSException {
        if (storageOrgIDs.length == 0) {
            return null;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id where fromUnit.id in (");
        int size = storageOrgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(storageOrgIDs[i]).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(4).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"StorageNoAssignCompany"));
            return null;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        oql = new StringBuffer();
        oql.append("select  id,name,number,baseCurrency.id,isLeaf,accountPeriodType.id where id in (");
        int size2 = orgRelColl.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            FullOrgUnitInfo toOrgUnit = orgRelColl.get(i).getToUnit();
            oql.append("'").append(toOrgUnit.getId().toString()).append("'");
        }
        oql.append(")");
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        int size3 = companyColl.size();
        for (int i = 0; i < size3; ++i) {
            CompanyOrgUnitInfo companyOrgInfo = companyColl.get(i);
            if (companyOrgInfo.getAccountPeriodType() == null) continue;
            return companyOrgInfo.getAccountPeriodType().getId().toString();
        }
        return null;
    }

    public static OrgUnitInfo[] getDefaultMainBizOrg(OrgUnitInfo currentMainOrg, String userId, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(userId), (OrgType)orgType, (String)permItem);
        if (currentMainOrg != null && collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                if (!currentMainOrg.getId().toString().equals(collection.get(i).getId().toString())) continue;
                return new OrgUnitInfo[]{currentMainOrg};
            }
        }
        if (collection != null && collection.size() > 0) {
            return new OrgUnitInfo[]{collection.get(0)};
        }
        return null;
    }
}

