/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.rpt.InteventroyAgeFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractIntenventoryAgeUI;
import com.kingdee.eas.scm.im.rpt.client.IntenventoryAgeConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class IntenventoryAgeUI
extends AbstractIntenventoryAgeUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IntenventoryAgeUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResourceForInvAge";
    private static final String rptResName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private boolean firstLoadData;
    private int hasRowCount;

    public IntenventoryAgeUI() throws Exception {
        this.setUITitle(EASResource.getString((String)resClassName, (String)"uiTitle"));
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.firstLoadData = true;
        this.hasRowCount = 0;
        this.tblMain.setEditable(false);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    public String[] getMergeColumnKeys() {
        return null;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new IntenventoryAgeConditionUI();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InteventroyAgeFacadeFactory.getRemoteInstance();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return InteventroyAgeFacadeFactory.getRemoteInstance();
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        super.query();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    public String getTreeCol() {
        if (((Boolean)this.params.getObject("ckBoxLevelGather")).booleanValue()) {
            return "FmaterialGroup";
        }
        return "FStorageOrgName";
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.im.rpt.client.IntenventoryAgeUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        RptParams remoteParam = new RptParams();
        remoteParam = new RptParams();
        remoteParam.putAll(this.params.toMap());
        try {
            if (start == 0 && this.firstLoadData) {
                this.firstLoadData = false;
                RptParams rpt = this.getRemoteInstance().createTempTable(remoteParam);
                this.setTempTable(rpt.getString("tempTable"));
                this.params.setObject("idList", rpt.getObject("idList"));
                this.params.setString("detailTempTable", rpt.getString("detailTempTable"));
                remoteParam.setString("tempTable", rpt.getString("tempTable"));
                KDTableUtil.setHeader((RptTableHeader)this.getHeadStr(this.params), (KDTable)this.tblMain);
                if (this.getTreeCol() != null) {
                    this.tblMain.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                }
                if (this.tHelper != null) {
                    this.tHelper.setDefaultUserData(null);
                }
                this.initUserConfig();
                Map queryHeader = (Map)rpt.getObject("queryHeader");
                SCMRptUtil.setQueryHeader((KDTable)this.tblMain, (ITablePreferenceHelper)this.tHelper, (Map)queryHeader);
                rpt = this.getRemoteInstance().query(remoteParam, start, length);
                this.hasRowCount += length;
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.tblMain.setRowCount(rs.getRowCount());
                this.insertRows(rs, start, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                if (rs.getRowCount() == length) {
                    this.getAllDataOfId();
                }
                this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
            } else {
                ArrayList newList = new ArrayList(length);
                if (this.allIdList != null) {
                    for (int i = start; i < start + length && i < this.allIdList.size(); ++i) {
                        newList.add(this.allIdList.get(i));
                    }
                }
                if (newList != null && newList.size() > 0) {
                    remoteParam.setString("tempTable", this.getTempTable());
                    RptParams rpt = this.getRemoteInstance().query(remoteParam, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.hasRowCount += length;
                    this.insertRows(rs, start, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                    this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
                }
            }
            this.tblMain.getColumn(0).getStyleAttributes().setBackground(Color.white);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
    }

    protected void initListener() {
        Object[] listeners = this.getTable().getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            this.getTable().removeKDTMouseListener((KDTMouseListener)listeners[i + 1]);
        }
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3) {
                    KDTMenuManager tm = IntenventoryAgeUI.this.getMenuManager(IntenventoryAgeUI.this.getTable());
                    if (tm == null) {
                        return;
                    }
                    KDPopupMenu menu = tm.getMenu();
                    if (menu == null) {
                        menu = new KDPopupMenu();
                    }
                    menu.setUserObject((Object)e);
                    if (e.getButton() == 3 && e.getClickCount() == 1) {
                        menu.show(e.getOriginView(), e.getX(), e.getY());
                    }
                } else {
                    int row = e.getRowIndex();
                    int column = e.getColIndex();
                    if (e.getClickCount() == 1) {
                        IntenventoryAgeUI.this.cellClicked(row, column, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public void insertRows(RptRowSet rs, int start, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int j) {
        table.setRefresh(false);
        String none = EASResource.getString((String)resClassName, (String)"none");
        String noMaterialType = none + EASResource.getString((String)resClassName, (String)"materialType");
        String total = EASResource.getString((String)resClassName, (String)"total");
        while (rs.next()) {
            IRow row = this.isExpand ? table.addRow(start++) : table.setRow(start++);
            if (total.equals(rs.getString("FStorageOrgName")) || !((Boolean)this.params.getObject("ckBoxLevelGather")).booleanValue()) {
                handler.setTableRowData(row, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper));
                continue;
            }
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            companyUserObject.setCompanyId(rs.getString("fmaterialgroupid"));
            if (!"X".equals(rs.getString("FmaterialGroup"))) {
                companyUserObject.setName(rs.getString("FmaterialGroup"));
            } else {
                companyUserObject.setName(noMaterialType);
            }
            companyUserObject.setBlockId("FmaterialGroup");
            companyUserObject.setExpanded(false);
            int isleaf = rs.getInt("fisleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("flevel"));
            handler.setTableRowData(row, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper));
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        boolean ckBoxLevelGather = (Boolean)this.params.getObject("ckBoxLevelGather");
        Boolean ckBoxShowGatherLine = (Boolean)this.params.getObject("ckBoxShowGatherLine");
        if (!ckBoxLevelGather || ckBoxShowGatherLine.booleanValue()) {
            // empty if block
        }
        RptParams para = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        para.setString("fparentid", companyUserObject.getCompanyId());
        String tempTable = null;
        tempTable = ckBoxLevelGather ? this.params.getString("detailTempTable") : this.params.getString("tempTable");
        para.setString("tempTable", tempTable);
        para.setString("fmaterialid", (String)row.getCell("fmaterialid").getValue());
        para.setString("fstorageorgunitid", (String)row.getCell("FStorageOrgUnitID").getValue());
        para.setString("findex", row.getCell("findex").getValue().toString());
        para.setObject("isShowWareHouse", (Object)this.params.getBoolean("isShowWareHouse"));
        para.setObject("isShowType", (Object)this.params.getBoolean("isShowType"));
        para.setObject("isShowLocation", (Object)this.params.getBoolean("isShowLocation"));
        para.setObject("isShowLot", (Object)this.params.getBoolean("isShowLot"));
        para.setObject("ckBoxLevelGather", this.params.getObject("ckBoxLevelGather"));
        para.setObject("ckBoxShowGatherLine", this.params.getObject("ckBoxShowGatherLine"));
        para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
        para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
        para.setObject("locationFrom", this.params.getObject("locationFrom"));
        para.setObject("locationTo", this.params.getObject("locationTo"));
        para.setObject("ckBxOnlyShowDetail", this.params.getObject("ckBxOnlyShowDetail"));
        para.setObject("daytitles", this.params.getObject("daytitles"));
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(para, -1, -1, this.getTempTable(), (Object)companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    protected RptTableHeader getHeadStr(RptParams params) {
        RptTableHeader header = new RptTableHeader();
        boolean isShowWareHouse = params.getBoolean("isShowWareHouse");
        boolean isShowType = params.getBoolean("isShowType");
        boolean isShowLocation = params.getBoolean("isShowLocation");
        boolean isShowLot = params.getBoolean("isShowLot");
        boolean isShowAssitProperty = params.getBoolean("isShowAssitProperty");
        boolean isShowProject = params.getBoolean("isShowProject");
        boolean isShowTrackNum = params.getBoolean("isShowTrackNum");
        int arrayLength = 16;
        RptTableColumn col = null;
        col = new RptTableColumn("FStorageOrgName");
        col.setWidth(150);
        header.addColumn(col);
        if (isShowWareHouse) {
            col = new RptTableColumn("FwareHouseNumber");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FwareHouseName");
            col.setWidth(120);
            header.addColumn(col);
            col = new RptTableColumn("FWarehouseID");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            arrayLength += 3;
        }
        col = new RptTableColumn("FStoreType");
        col.setWidth(80);
        header.addColumn(col);
        ++arrayLength;
        if (isShowLocation) {
            col = new RptTableColumn("FLocation");
            col.setWidth(80);
            header.addColumn(col);
            ++arrayLength;
        }
        if (isShowLot) {
            col = new RptTableColumn("FLot");
            col.setWidth(80);
            header.addColumn(col);
            ++arrayLength;
        }
        if (isShowAssitProperty) {
            col = new RptTableColumn("FAssitPropertyName");
            col.setWidth(80);
            header.addColumn(col);
            ++arrayLength;
        }
        if (isShowProject) {
            col = new RptTableColumn("FProjectNumber");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FProjectName");
            col.setWidth(120);
            header.addColumn(col);
            arrayLength += 2;
        }
        if (isShowTrackNum) {
            col = new RptTableColumn("FTrackNumNumber");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FTrackNumName");
            col.setWidth(120);
            header.addColumn(col);
            arrayLength += 2;
        }
        col = new RptTableColumn("FmaterialGroup");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FmaterialNumber");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FmaterialName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("Funit");
        col.setWidth(100);
        header.addColumn(col);
        String pricePattern = PrecisionUtil.getFormatPattern((int)params.getInt("spinPricePrecission"));
        String qtyPattern = PrecisionUtil.getFormatPattern((int)params.getInt("spinQtyPrecission"));
        String amtPattern = PrecisionUtil.getFormatPattern((int)params.getInt("spinAmountPrecission"));
        col = new RptTableColumn("FPrice");
        col.setAligment(2);
        col.setFormatPattern(pricePattern);
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("Fqty");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(qtyPattern);
        header.addColumn(col);
        col = new RptTableColumn("FAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtPattern);
        header.addColumn(col);
        ArrayList alDayTitle = new ArrayList();
        ArrayList alDayValue = new ArrayList();
        if (params.getObject("daytitles") != null) {
            alDayTitle = (ArrayList)params.getObject("daytitles");
        }
        if (params.getObject("dayvalues") != null) {
            alDayValue = (ArrayList)params.getObject("dayvalues");
        }
        int daylen = alDayValue.size();
        for (int i = 0; i < daylen; ++i) {
            col = new RptTableColumn("Fqty" + String.valueOf(i));
            col.setAligment(2);
            col.setFormatPattern(qtyPattern);
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FAmount" + String.valueOf(i));
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern(amtPattern);
            header.addColumn(col);
            arrayLength += 2;
        }
        boolean isHideCol = true;
        col = new RptTableColumn("Flevel");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("findex");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("Fisleaf");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FParentID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("fmaterialid");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialGroupID");
        col.setWidth(isHideCol ? -1 : 120);
        col.setHided(isHideCol);
        header.addColumn(col);
        Object[][] labels = new Object[2][arrayLength];
        int m = 0;
        labels[0][m] = EASResource.getString((String)rptResName, (String)"storageOrgUnit");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"storageOrgUnit");
        ++m;
        if (isShowWareHouse) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"WarehouseNum");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"WarehouseNum");
            labels[0][++m] = EASResource.getString((String)rptResName, (String)"WarehouseName");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"WarehouseName");
            ++m;
            labels[0][++m] = "FWarehouseID";
            labels[1][m] = "FWarehouseID";
        }
        labels[0][m] = EASResource.getString((String)rptResName, (String)"FStoreTypeID");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"FStoreTypeID");
        ++m;
        if (isShowLocation) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"location");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"location");
            ++m;
        }
        if (isShowLot) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"rptmateriallot");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"rptmateriallot");
            ++m;
        }
        if (isShowAssitProperty) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"assistProperty");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"assistProperty");
            ++m;
        }
        if (isShowProject) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"projectNumber");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"projectNumber");
            labels[0][++m] = EASResource.getString((String)rptResName, (String)"projectName");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"projectName");
            ++m;
        }
        if (isShowTrackNum) {
            labels[0][m] = EASResource.getString((String)rptResName, (String)"trackNumber");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"trackNumber");
            labels[0][++m] = EASResource.getString((String)rptResName, (String)"trackName");
            labels[1][m] = EASResource.getString((String)rptResName, (String)"trackName");
            ++m;
        }
        labels[0][m] = EASResource.getString((String)rptResName, (String)"groupname");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"groupname");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"materialNumber");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"materialNumber");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"materialName");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"materialName");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"materialModel");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"materialModel");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"unit");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"unit");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"price");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"price");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"rptQty");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"rptQty");
        labels[0][++m] = EASResource.getString((String)rptResName, (String)"rptamount");
        labels[1][m] = EASResource.getString((String)rptResName, (String)"rptamount");
        ++m;
        for (int i = 0; i < daylen; ++i) {
            labels[0][m] = alDayTitle.get(i);
            labels[1][m] = EASResource.getString((String)rptResName, (String)"rptQty");
            labels[0][++m] = alDayTitle.get(i);
            labels[1][m] = EASResource.getString((String)rptResName, (String)"rptamount");
            ++m;
        }
        labels[0][m] = "Flevel";
        labels[1][m] = "Flevel";
        labels[0][++m] = "findex";
        labels[1][m] = "findex";
        labels[0][++m] = "Fisleaf";
        labels[1][m] = "Fisleaf";
        labels[0][++m] = "FParentID";
        labels[1][m] = "FParentID";
        labels[0][++m] = "FStorageOrgUnitID";
        labels[1][m] = "FStorageOrgUnitID";
        labels[0][++m] = "fmaterialid";
        labels[1][m] = "fmaterialid";
        labels[0][++m] = "FMaterialGroupID";
        labels[1][m] = "FMaterialGroupID";
        ++m;
        header.setLabels(labels, true);
        return header;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams[] cp = ReportQueryConditionHelper.getCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if (this.params == null && cp == null || !useDefaultSolution) {
                this.queryDialog.setHeight(620);
                this.queryDialog.setWidth(500);
                if (this.queryDialog.show()) {
                    CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                    pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                    this.params = rbqp.getCustomCondition();
                    if (pc != null) {
                        this.params.putAll(pc.getCustomCondition().toMap());
                    }
                    ok = true;
                }
            }
            if (this.getUIContext().get("rptParams") == null && cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp[0]);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null && cp[1] != null) {
                    pc.initUIContentLayout();
                    pc.onInit(this.getUIContextInitParams());
                    pc.onLoad();
                    pc.loadFields();
                    pc.setCustomerParams(cp[1]);
                    pc.loadData(null);
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        IntenventoryAgeConditionUI condUI = new IntenventoryAgeConditionUI();
        return condUI;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYMANAGEMENT;
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && ReportQueryConditionHelper.getDefaultSolution() != null) {
            object = ReportQueryConditionHelper.getDefaultSolution().getId();
        }
        return object;
    }
}

