/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.OrderByForLogEnum;
import com.kingdee.eas.scm.im.rpt.client.AbstractInventoryLogFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InventoryLogFilterUI
extends AbstractInventoryLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryLogFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;

    public InventoryLogFilterUI() throws Exception {
        this.setFilterElements();
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.bizProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.bizProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.bizTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.bizTrackNumTo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.bizStorageOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.bizMaterial.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizMaterial, (KDBizPromptBox)this.bizMaterialTo);
        this.bizWarehouse.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizWarehouse, (KDBizPromptBox)this.bizWarehouseTo);
        this.bizLocation.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizLocation, (KDBizPromptBox)this.bizLocationTo);
        this.bizTransaction.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizTransaction, (KDBizPromptBox)this.bizTransactionTo);
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            // empty if block
        }
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.loadGroupStandard();
        this.addListener();
        this.loadGroupStandard();
        this.ckOnlyShowInOut.setSelected(true);
        this.ckShowBill.setSelected(false);
        this.ckOnlyShowExcept.setSelected(false);
        this.ckShowBeginEnd.setSelected(false);
        this.ckShowInventory.setSelected(false);
        this.kcGroupBy.setEnabled(false);
        this.ckShowBill.setEnabled(false);
        this.ckOnlyShowExcept.setEnabled(false);
        this.ckShowBeginEnd.setEnabled(false);
        this.ckShowInventory.setEnabled(false);
        this.ckCheckInventory.setEnabled(false);
        this.ckCheckInventory.setVisible(false);
        this.kcOrderBy.setSelectedItem((Object)OrderByForLogEnum.Null);
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public RptParams getCustomCondition() {
        RptParams para = this.getFilterManager().getRptParams();
        para.setObject("materialGroupStandard", this.comboGroupStandard.getSelectedItem());
        return para;
    }

    private void setFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("bizStorageOrgUnit", (Component)this.bizStorageOrgUnit));
        elements.add((FilterElement)new MultiF7FilterElement("bizMaterial", this.bizMaterial, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizMaterialTo", (Component)this.bizMaterialTo));
        elements.add((FilterElement)new MultiF7FilterElement("bizWarehouse", this.bizWarehouse, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizWarehouseTo", (Component)this.bizWarehouseTo));
        elements.add((FilterElement)new MultiF7FilterElement("bizLocation", this.bizLocation, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizLocationTo", (Component)this.bizLocationTo));
        elements.add((FilterElement)new SingleFilterElement("txtLot", (Component)this.txtLot));
        elements.add((FilterElement)new SingleFilterElement("txtLotTo", (Component)this.txtLotTo));
        elements.add((FilterElement)new SingleFilterElement("bizAsstProp", (Component)this.bizAsstProp));
        elements.add((FilterElement)new SingleFilterElement("bizAsstPropTo", (Component)this.bizAsstPropTo));
        elements.add((FilterElement)new MultiF7FilterElement("bizTransaction", this.bizTransaction, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("bizTransactionTo", (Component)this.bizTransactionTo));
        elements.add((FilterElement)new SingleFilterElement("bizBillType", (Component)this.bizBillType));
        elements.add((FilterElement)new SingleFilterElement("bizBillTypeTo", (Component)this.bizBillTypeTo));
        elements.add((FilterElement)new SingleFilterElement("bizAssProp", (Component)this.bizAsstProp));
        elements.add((FilterElement)new SingleFilterElement("bizAssPropTo", (Component)this.bizAsstPropTo));
        elements.add((FilterElement)new SingleFilterElement("txtBillNumber", (Component)this.txtBillNumber));
        elements.add((FilterElement)new SingleFilterElement("txtBillNumberTo", (Component)this.txtBillNumberTo));
        elements.add((FilterElement)new SingleFilterElement("kcOrderBy", (Component)this.kcOrderBy));
        elements.add((FilterElement)new SingleFilterElement("bizProjectNumFrom", (Component)this.bizProjectNumFrom));
        elements.add((FilterElement)new SingleFilterElement("bizProjectNumTo", (Component)this.bizProjectNumTo));
        elements.add((FilterElement)new SingleFilterElement("bizTrackNumFrom", (Component)this.bizTrackNumFrom));
        elements.add((FilterElement)new SingleFilterElement("bizTrackNumTo", (Component)this.bizTrackNumTo));
        elements.add((FilterElement)new SingleFilterElement("bizStoreType", (Component)this.bizStoreType));
        elements.add((FilterElement)new SingleFilterElement("bizStoreStatus", (Component)this.bizStoreStatus));
        elements.add((FilterElement)new SingleFilterElement("ckOnlyShowInOut", (Component)this.ckOnlyShowInOut));
        elements.add((FilterElement)new SingleFilterElement("ckGroupBy", (Component)this.ckGroupBy));
        elements.add((FilterElement)new SingleFilterElement("kcGroupBy", (Component)this.kcGroupBy));
        elements.add((FilterElement)new SingleFilterElement("ckShowBill", (Component)this.ckShowBill));
        elements.add((FilterElement)new SingleFilterElement("ckOnlyShowExcept", (Component)this.ckOnlyShowExcept));
        elements.add((FilterElement)new SingleFilterElement("ckShowBeginEnd", (Component)this.ckShowBeginEnd));
        elements.add((FilterElement)new SingleFilterElement("ckShowInventory", (Component)this.ckShowInventory));
        elements.add((FilterElement)new SingleFilterElement("ckCheckInventory", (Component)this.ckCheckInventory));
        elements.add((FilterElement)new SingleFilterElement("materialTypeFrom", (Component)this.bizMaterialTypeFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTypeTo", (Component)this.bizMaterialTypeTo));
        SingleFilterElement element = new SingleFilterElement("dpDate", (Component)this.dpDate);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dpDateTo", (Component)this.dpDateTo);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterial, this.bizMaterialTo});
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizMaterial, false, null);
        this.setBizMaterialF7(this.bizMaterialTo, false, null);
    }

    private void addListener() {
        this.ckGroupBy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InventoryLogFilterUI.this.ckGroupBy_stateChanged(e);
                }
                catch (Exception exc) {
                    InventoryLogFilterUI.this.handUIException(exc);
                }
            }
        });
        this.ckShowBill.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    InventoryLogFilterUI.this.ckShowBill_stateChanged(e);
                }
                catch (Exception exc) {
                    InventoryLogFilterUI.this.handUIException(exc);
                }
            }
        });
        this.comboGroupStandard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryLogFilterUI.this.comboGroupStandard_itemStateChanged(e);
            }
        });
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.bizMaterialTypeFrom.getValue() != null || this.bizMaterialTypeTo.getValue() != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (groupInfo != null) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    protected void ckGroupBy_stateChanged(ChangeEvent e) {
        if (this.ckGroupBy.isSelected()) {
            this.kcGroupBy.setEnabled(true);
            this.ckShowBill.setEnabled(true);
            this.ckOnlyShowExcept.setEnabled(false);
            this.ckShowBeginEnd.setEnabled(true);
            this.ckShowInventory.setEnabled(true);
            this.kcOrderBy.setEnabled(false);
            this.kcOrderBy.setSelectedItem((Object)OrderByForLogEnum.Null);
        } else {
            this.ckShowBill.setSelected(false);
            this.ckOnlyShowExcept.setSelected(false);
            this.ckShowBeginEnd.setSelected(false);
            this.ckShowInventory.setSelected(false);
            this.kcGroupBy.setEnabled(false);
            this.ckShowBill.setEnabled(false);
            this.ckOnlyShowExcept.setEnabled(false);
            this.ckShowBeginEnd.setEnabled(false);
            this.ckShowInventory.setEnabled(false);
            this.kcOrderBy.setEnabled(true);
        }
    }

    protected void ckShowBill_stateChanged(ChangeEvent e) {
        if (this.ckShowBill.isSelected()) {
            this.ckOnlyShowExcept.setEnabled(true);
        } else {
            this.ckOnlyShowExcept.setSelected(false);
            this.ckOnlyShowExcept.setEnabled(false);
        }
    }

    @Override
    protected void bizStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.bizStorageOrgUnit_stateChanged(e);
    }

    public void clear() {
        super.clear();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizStorageOrgUnit;
    }

    protected String getViewPermission() {
        return "inventorylog_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean verify() {
        if (this.bizStorageOrgUnit.getText() == null || this.bizStorageOrgUnit.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (this.ckCheckInventory.isSelected()) {
            return true;
        }
        if (this.ckGroupBy.isSelected() && (this.kcGroupBy.getSelectedIndex() == -1 || this.kcGroupBy.getSelectedIndex() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"mustSelectOneGroup"));
            return false;
        }
        Date dateFrom = (Date)this.dpDate.getValue();
        Date dateTo = (Date)this.dpDateTo.getValue();
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.dpDate.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.dpDateTo.requestFocus();
            return false;
        }
        if (dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_BEFORE_START"));
            this.dpDateTo.requestFocus();
            return false;
        }
        if (this.ckShowBeginEnd.isSelected()) {
            String so = this.bizStorageOrgUnit.getText();
            so = so.replaceAll(" ", "");
            StringTokenizer st = new StringTokenizer(so, ";");
            Vector<Object> v = new Vector<Object>();
            while (st.hasMoreElements()) {
                v.add(st.nextElement());
            }
            try {
                if (!IMRptUtils.checkSameAssign(v.toArray())) {
                    return false;
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return true;
    }
}

