/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.LocateDialogUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.rpt.IInventoryTypeGatherReportFacade;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.InventoryTypeGatherReportFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractInventoryTypeGatherReportUI;
import com.kingdee.eas.scm.im.rpt.client.InventoryTypeDetailReportUI;
import com.kingdee.eas.scm.im.rpt.client.InventoryTypeGatherReportConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryTypeGatherReportUI
extends AbstractInventoryTypeGatherReportUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryTypeGatherReportUI.class);
    private boolean firstLoadData = true;
    private RptParams toDetailRptParams;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    public static final String OrgTempTable = "orgTempTable";
    private int hasRowCount = 0;

    public InventoryTypeGatherReportUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toDetailRptParams = new RptParams();
        this.setkdDate();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    public void setkdDate() {
        this.dateFrom.setValue(this.params.getObject("dateFrom"));
        this.dateTo.setValue(this.params.getObject("dateTo"));
    }

    public String[] getMergeColumnKeys() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int colIndex = this.tbl.getSelectManager().getActiveColumnIndex();
            if (this.tbl.getColumnIndex("FMaterialGroupName") != colIndex && this.tbl.getColumnIndex("FStorageOrgName") != colIndex) {
                ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
                ItemAction actView = this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
        this.setkdDate();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InventoryTypeGatherReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        InventoryTypeGatherReportConditionUI condUI = new InventoryTypeGatherReportConditionUI();
        condUI.setSize(548, 600);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        super.query();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        RptParams para = new RptParams();
        para.setString("tempTable", this.getTempTable());
        para.setString(OrgTempTable, this.getOrgTempTable());
        para.setObject("storageOrgUnit", this.params.getObject("storageOrgUnit"));
        para.setObject("fullStorageOrgUnit", this.params.getObject("fullStorageOrgUnit"));
        para.setObject("dateFrom", this.params.getObject("dateFrom"));
        para.setObject("dateTo", this.params.getObject("dateTo"));
        para.setObject("storeType", this.params.getObject("storeType"));
        para.setObject("materialFrom", this.params.getObject("materialFrom"));
        para.setObject("materialTo", this.params.getObject("materialTo"));
        para.setObject("materialTypeFrom", this.params.getObject("materialTypeFrom"));
        para.setObject("materialTypeTo", this.params.getObject("materialTypeTo"));
        para.setObject("materialGroupStandard", this.params.getObject("materialGroupStandard"));
        para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
        para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
        para.setObject("locationFrom", this.params.getObject("locationFrom"));
        para.setObject("locationTo", this.params.getObject("locationTo"));
        para.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
        para.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
        para.setObject("lotFrom", this.params.getObject("lotFrom"));
        para.setObject("lotTo", this.params.getObject("lotTo"));
        para.setObject("txtLotLike", this.params.getObject("txtLotLike"));
        para.setObject("supplierFrom", this.params.getObject("supplierFrom"));
        para.setObject("supplierTo", this.params.getObject("supplierTo"));
        para.setObject("customerFrom", this.params.getObject("customerFrom"));
        para.setObject("customerTo", this.params.getObject("customerTo"));
        para.setObject("ckBxShowsumRow", this.params.getObject("ckBxShowsumRow"));
        para.setObject("ckBoxLevelGather", this.params.getObject("ckBoxLevelGather"));
        para.setObject("ckBoxShowGatherLine", this.params.getObject("ckBoxShowGatherLine"));
        para.setInt("coBoxGatherCondition", this.params.getInt("coBoxGatherCondition"));
        para.setObject("ckBoxStoreTypeGather", this.params.getObject("ckBoxStoreTypeGather"));
        para.setObject("ckBxShowLot", this.params.getObject("ckBxShowLot"));
        para.setObject("ckBxShowAsstAttr", this.params.getObject("ckBxShowAsstAttr"));
        para.setObject("ckBxShowWhs", this.params.getObject("ckBxShowWhs"));
        if (this.params.getObject("ckBxShowLocation") == null) {
            para.setObject("ckBxShowLocation", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        }
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxShowQty", this.params.getObject("ckBxShowQty"));
        para.setObject("ckBxShowAmt", this.params.getObject("ckBxShowAmt"));
        para.setObject("ckBxShowAssistQty", this.params.getObject("ckBxShowAssistQty"));
        para.setObject("ckBxShowPrice", this.params.getObject("ckBxShowPrice"));
        para.setInt("spinQtyPrecission", this.params.getInt("spinQtyPrecission"));
        para.setInt("spinAmountPrecission", this.params.getInt("spinAmountPrecission"));
        para.setInt("spinAssQtyPrecission", this.params.getInt("spinAssQtyPrecission"));
        para.setInt("spinPricePrecission", this.params.getInt("spinPricePrecission"));
        para.setInt("coBoxZeroCondition", this.params.getInt("coBoxZeroCondition"));
        para.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
        para.setObject("amtPermssionOrg", this.params.getObject("amtPermssionOrg"));
        para.setObject("shortNameFrom", this.params.getObject("shortNameFrom"));
        para.setObject("shortNameTo", this.params.getObject("shortNameTo"));
        if (this.params.getObject("ckBxShowMShortName") == null) {
            para.setObject("ckBxShowMShortName", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
        }
        para.setObject("ckBxOnlyShowDetail", this.params.getObject("ckBxOnlyShowDetail"));
        para.setObject("isShowTrackNum", this.params.getObject("isShowTrackNum"));
        para.setObject("isShowProject", this.params.getObject("isShowProject"));
        para.setObject("projectFrom", this.params.getObject("projectFrom"));
        para.setObject("projectTo", this.params.getObject("projectTo"));
        para.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
        para.setObject("trackNumTo", this.params.getObject("trackNumTo"));
        para.setString("detailTempTable", this.params.getString("detailTempTable"));
        para.setObject("noSelectStorageMoveBill", this.params.getObject("noSelectStorageMoveBill"));
        para.setObject("noSelectWarehouseMoveBill", this.params.getObject("noSelectWarehouseMoveBill"));
        para.setObject("cbBxOnlyShowInventoryBill", this.params.getObject("cbBxOnlyShowInventoryBill"));
        Date nowBegin = new Date();
        try {
            if (start == 0 && this.firstLoadData) {
                try {
                    this.firstLoadData = false;
                    RptParams rpt = InventoryTypeGatherReportFacadeFactory.getRemoteInstance().createTempTable(para);
                    this.setTempTable(rpt.getString("tempTable"));
                    this.setOrgTempTable(rpt.getString(OrgTempTable));
                    this.params.setObject("idList", rpt.getObject("idList"));
                    this.params.setObject("tempTable", (Object)this.getTempTable());
                    this.params.setString(OrgTempTable, this.getOrgTempTable());
                    this.params.setObject("detailTempTable", (Object)rpt.getString("detailTempTable"));
                    para.setString("tempTable", this.getTempTable());
                    para.setString(OrgTempTable, this.getOrgTempTable());
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                    this.tbl.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                    if (this.tHelper != null) {
                        this.tHelper.setDefaultUserData(null);
                    }
                    this.initUserConfig();
                    Map queryHeader = (Map)rpt.getObject("queryHeader");
                    if (queryHeader != null && !queryHeader.isEmpty()) {
                        SCMRptUtil.setQueryHeader((KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper, (Map)queryHeader);
                    }
                    boolean ckBxShowMShortName = this.params.getBoolean("ckBxShowMShortName");
                    this.tbl.setRowCount(rpt.getInt("totalCount"));
                    this.fmtColumnPrecision();
                    rpt = InventoryTypeGatherReportFacadeFactory.getRemoteInstance().query(para, start, length);
                    this.hasRowCount += length;
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, start, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                    if (rs.getRowCount() == length) {
                        this.getAllDataOfId();
                    }
                    this.appendFootRow(this.params);
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                    ex.printStackTrace();
                    this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
                return;
            }
            ArrayList newList = new ArrayList(length);
            if (this.allIdList != null) {
                for (int i = start; i < start + length && i < this.allIdList.size(); ++i) {
                    newList.add(this.allIdList.get(i));
                }
            }
            if (newList != null && newList.size() > 0) {
                para.setString("tempTable", this.getTempTable());
                RptParams rpt = InventoryTypeGatherReportFacadeFactory.getRemoteInstance().getDataForIdList(newList, para);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.hasRowCount += length;
                this.insertRows(rs, start, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        Date nowEnd = new Date();
        float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
        logger.debug((Object)("getData used of times : " + waitSecond + " second."));
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        boolean ckBoxLevelGather = (Boolean)this.params.getObject("ckBoxLevelGather");
        boolean ckBoxStoreTypeGather = (Boolean)this.params.getObject("ckBoxStoreTypeGather");
        int coBoxGatherCondition = this.params.getInt("coBoxGatherCondition");
        String none = EASResource.getString((String)resClassName, (String)"none");
        String noMaterialType = none + EASResource.getString((String)resClassName, (String)"materialType");
        String noMaterialCostType = none + EASResource.getString((String)resClassName, (String)"materialCostType");
        while (rs.next()) {
            IRow row = this.isExpand ? table.addRow(insertRowIndex++) : table.setRow(insertRowIndex++);
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            if (rs.getString("FStorageOrgName").equals("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz")) {
                companyUserObject.setCompanyId("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz");
                companyUserObject.setName(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"216_InOutStoreGatherReportUI"));
                companyUserObject.setBlockId("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz");
                companyUserObject.setExpanded(true);
                companyUserObject.setisIconEmpty(true);
                rs.setValue("FStorageOrgName", null);
            } else {
                if (ckBoxLevelGather) {
                    if (coBoxGatherCondition == 0) {
                        companyUserObject.setCompanyId(rs.getString("fmaterialgroupid"));
                        if (!rs.getString("fmaterialgroupname").equals("X")) {
                            companyUserObject.setName(rs.getString("fmaterialgroupname"));
                        } else {
                            companyUserObject.setName(noMaterialType);
                        }
                        companyUserObject.setBlockId(rs.getString("FBlockID"));
                    } else {
                        if (rs.getString("FMaterialCostType") != null && !rs.getString("FMaterialCostType").equals("X")) {
                            int materialcosttype = Integer.parseInt(rs.getString("fmaterialcosttype").trim());
                            rs.setValue("FMaterialCostTypeName", (Object)StoreType.getEnum((int)materialcosttype).getAlias());
                        } else {
                            rs.setValue("FMaterialCostType", (Object)"X");
                            rs.setValue("FMaterialCostTypeName", (Object)noMaterialCostType);
                        }
                        companyUserObject.setCompanyId(rs.getString("fmaterialcosttype"));
                        companyUserObject.setName(rs.getString("FMaterialCostTypeName"));
                        companyUserObject.setBlockId(rs.getString("fmaterialcosttype"));
                    }
                } else if (ckBoxStoreTypeGather) {
                    companyUserObject.setCompanyId(rs.getString("FStoreTypeID"));
                    companyUserObject.setName(rs.getString("FStoreTypeName"));
                    companyUserObject.setBlockId(rs.getString("FStoreTypeID"));
                } else {
                    companyUserObject.setCompanyId(rs.getString("fstorageorgunitid"));
                    companyUserObject.setName(rs.getString("FStorageOrgName"));
                    companyUserObject.setBlockId(rs.getString("fmaterialid"));
                }
                companyUserObject.setExpanded(false);
            }
            int isleaf = rs.getInt("fisleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("flevel"));
            handler.setTableRowData(row, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper));
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return InventoryTypeGatherReportFacadeFactory.getRemoteInstance();
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        boolean ckBoxLevelGather = (Boolean)this.params.getObject("ckBoxLevelGather");
        boolean ckBoxStoreTypeGather = (Boolean)this.params.getObject("ckBoxStoreTypeGather");
        Boolean ckBoxShowGatherLine = (Boolean)this.params.getObject("ckBoxShowGatherLine");
        if (ckBoxLevelGather && ckBoxShowGatherLine.booleanValue() || !ckBoxStoreTypeGather || ckBoxShowGatherLine.booleanValue()) {
            // empty if block
        }
        RptParams para = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        para.setString("fparentid", companyUserObject.getCompanyId());
        Boolean ckBxOnlyShowDetail = (Boolean)this.params.getObject("ckBxOnlyShowDetail");
        String tempTable = null;
        tempTable = ckBxOnlyShowDetail == false ? this.params.getString("detailTempTable") : this.params.getString("tempTable");
        para.setString("tempTable", tempTable);
        para.setString(OrgTempTable, this.getOrgTempTable());
        para.setString("fmaterialid", (String)row.getCell("fmaterialid").getValue());
        para.setString("fstoretypeid", (String)row.getCell("FStoreTypeID").getValue());
        para.setString("fstorageorgunitid", (String)row.getCell("FStorageOrgUnitID").getValue());
        para.setString("findex", row.getCell("FIndex").getValue().toString());
        para.setObject("ckBoxLevelGather", this.params.getObject("ckBoxLevelGather"));
        para.setObject("ckBoxShowGatherLine", this.params.getObject("ckBoxShowGatherLine"));
        para.setInt("coBoxGatherCondition", this.params.getInt("coBoxGatherCondition"));
        para.setObject("ckBoxStoreTypeGather", this.params.getObject("ckBoxStoreTypeGather"));
        para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
        para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
        para.setObject("locationFrom", this.params.getObject("locationFrom"));
        para.setObject("locationTo", this.params.getObject("locationTo"));
        para.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
        para.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
        para.setObject("lotFrom", this.params.getObject("lotFrom"));
        para.setObject("lotTo", this.params.getObject("lotTo"));
        para.setObject("ckBoxLot", this.params.getObject("ckBoxLot"));
        para.setObject("ckBxShowLot", this.params.getObject("ckBxShowLot"));
        para.setObject("ckBxShowAsstAttr", this.params.getObject("ckBxShowAsstAttr"));
        para.setObject("ckBxShowWhs", this.params.getObject("ckBxShowWhs"));
        para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        para.setObject("isShowTrackNum", this.params.getObject("isShowTrackNum"));
        para.setObject("isShowProject", this.params.getObject("isShowProject"));
        if (this.params.getObject("ckBxShowLocation") == null) {
            para.setObject("ckBxShowLocation", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        }
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxShowQty", this.params.getObject("ckBxShowQty"));
        para.setObject("ckBxShowAmt", this.params.getObject("ckBxShowAmt"));
        para.setObject("ckBxShowAssistQty", this.params.getObject("ckBxShowAssistQty"));
        para.setObject("ckBxShowPrice", this.params.getObject("ckBxShowPrice"));
        para.setInt("spinPricePrecission", this.params.getInt("spinPricePrecission"));
        para.setInt("spinAmountPrecission", this.params.getInt("spinAmountPrecission"));
        para.setInt("spinAssQtyPrecission", this.params.getInt("spinAssQtyPrecission"));
        para.setInt("spinQtyPrecission", this.params.getInt("spinQtyPrecission"));
        para.setObject("ckBxOnlyShowDetail", this.params.getObject("ckBxOnlyShowDetail"));
        para.setInt("coBoxZeroCondition", this.params.getInt("coBoxZeroCondition"));
        para.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
        para.setObject("shortNameFrom", this.params.getObject("shortNameFrom"));
        para.setObject("shortNameTo", this.params.getObject("shortNameTo"));
        if (this.params.getObject("ckBxShowMShortName") == null) {
            para.setObject("ckBxShowMShortName", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
        }
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(para, -1, -1, this.getTempTable(), (Object)companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    public void setOrgTempTable(String orgTempTable) {
        this.params.setObject(OrgTempTable, (Object)orgTempTable);
    }

    public String getOrgTempTable() {
        if (this.params == null) {
            return null;
        }
        return this.params.getString(OrgTempTable);
    }

    public String getTreeCol() {
        if (((Boolean)this.params.getObject("ckBoxLevelGather")).booleanValue()) {
            return "FMaterialGroupName";
        }
        if (((Boolean)this.params.getObject("ckBoxStoreTypeGather")).booleanValue()) {
            return "FStoreTypeName";
        }
        return "FStorageOrgName";
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void putDetailParams() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            ICell mCell = row.getCell("fmaterialid");
            ICell oCell = row.getCell("FStorageOrgUnitID");
            ICell storeCell = row.getCell("FStoreTypeID");
            ICell wCell = row.getCell("FWarehouseID");
            ICell pCell = row.getCell("FProjectId");
            ICell tCell = row.getCell("FTrackNumberId");
            ICell locCell = row.getCell("FLocationName");
            ICell lotCell = row.getCell("FLot");
            ICell asstCell = row.getCell("FAssistPropertyID");
            ICell suCell = row.getCell("FSupplierName");
            ICell cuCell = row.getCell("FCustomerName");
            ICell matnameCell = row.getCell("FMaterialName");
            ICell matnumberCell = row.getCell("FMaterialNumber");
            ICell beginQtyCell = null;
            Boolean ckBxByStatUnit = (Boolean)this.params.getObject("ckBxByStatUnit");
            beginQtyCell = ckBxByStatUnit != false ? row.getCell("FOriBeginQty") : row.getCell("FBeginQty");
            ICell beginAmtCell = row.getCell("FBeginAmt");
            ICell beginAssQtyCell = row.getCell("FBeginAssQty");
            if (mCell.getValue() == null || ((String)mCell.getValue()).equals("X")) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"mustContainMaterialColumn"));
                SysUtil.abort();
            }
            Object[] storageOrgUnit = null;
            storageOrgUnit = this.getAllLeafStorageOrg((String)oCell.getValue());
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            for (int i = 0; i < storageOrgUnit.length; ++i) {
                iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(storageOrgUnit[i].toString()), "invTypeDetail_view");
            }
            this.toDetailRptParams.setObject("ckBxShowUpdateInventoryBill", this.params.getObject("cbBxOnlyShowInventoryBill"));
            this.toDetailRptParams.setObject("dateFrom", this.dateFrom.getValue());
            this.toDetailRptParams.setObject("dateTo", this.dateTo.getValue());
            this.toDetailRptParams.setObject("CurrentMaterialID", mCell.getValue());
            this.toDetailRptParams.setObject("storageOrgUnits", (Object)storageOrgUnit);
            this.toDetailRptParams.setObject("storeTypeID", storeCell.getValue());
            this.toDetailRptParams.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
            this.toDetailRptParams.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
            this.toDetailRptParams.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
            this.toDetailRptParams.setObject("noSelectStorageMoveBill", this.params.getObject("noSelectStorageMoveBill"));
            this.toDetailRptParams.setObject("noSelectWarehouseMoveBill", this.params.getObject("noSelectWarehouseMoveBill"));
            this.toDetailRptParams.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
            if (wCell != null && wCell.getValue() != null) {
                this.toDetailRptParams.setObject("warehouseID", wCell.getValue());
            } else {
                if (this.params.getObject("warehouseFrom") != null) {
                    this.toDetailRptParams.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
                }
                if (this.params.getObject("warehouseTo") != null) {
                    this.toDetailRptParams.setObject("warehouseTo", this.params.getObject("warehouseTo"));
                }
            }
            if (pCell != null && pCell.getValue() != null) {
                this.toDetailRptParams.setObject("projectID", pCell.getValue());
            } else {
                if (this.params.getObject("projectFrom") != null) {
                    this.toDetailRptParams.setObject("projectFrom", this.params.getObject("projectFrom"));
                }
                if (this.params.getObject("projectTo") != null) {
                    this.toDetailRptParams.setObject("projectTo", this.params.getObject("projectTo"));
                }
            }
            if (tCell != null && tCell.getValue() != null) {
                this.toDetailRptParams.setObject("trackNumID", tCell.getValue());
            } else {
                if (this.params.getObject("trackNumFrom") != null) {
                    this.toDetailRptParams.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
                }
                if (this.params.getObject("trackNumTo") != null) {
                    this.toDetailRptParams.setObject("trackNumTo", this.params.getObject("trackNumTo"));
                }
            }
            this.toDetailRptParams.setObject("amtPermssionOrg", this.params.getObject("amtPermssionOrg"));
            this.toDetailRptParams.setObject("FMaterialName", matnameCell.getValue());
            this.toDetailRptParams.setObject("FMaterialNumber", matnumberCell.getValue());
            this.toDetailRptParams.setObject("beginQty", beginQtyCell.getValue());
            this.toDetailRptParams.setObject("beginAssQty", beginAssQtyCell.getValue());
            this.toDetailRptParams.setObject("beginAmt", beginAmtCell.getValue());
            this.toDetailRptParams.setBoolean("ckShowBeginEnd", true);
            this.toDetailRptParams.setBoolean("ckShowNoData", true);
            if (wCell != null && wCell.getValue() != null) {
                this.toDetailRptParams.setObject("warehouseID", wCell.getValue());
            } else {
                this.toDetailRptParams.setObject("warehouseID", null);
            }
            if (locCell != null && locCell.getValue() != null) {
                this.toDetailRptParams.setObject("FLocationName", locCell.getValue());
            } else {
                if (this.params.getObject("locationFrom") != null) {
                    this.toDetailRptParams.setObject("locationFrom", this.params.getObject("locationFrom"));
                }
                if (this.params.getObject("locationTo") != null) {
                    this.toDetailRptParams.setObject("locationTo", this.params.getObject("locationTo"));
                }
                this.toDetailRptParams.setObject("FLocationName", null);
            }
            if (lotCell != null && lotCell.getValue() != null) {
                this.toDetailRptParams.setObject("lot", lotCell.getValue());
            } else {
                if (this.params.getObject("lotFrom") != null) {
                    this.toDetailRptParams.setObject("lotFrom", this.params.getObject("lotFrom"));
                }
                if (this.params.getObject("lotTo") != null) {
                    this.toDetailRptParams.setObject("lotTo", this.params.getObject("lotTo"));
                }
                this.toDetailRptParams.setObject("lot", null);
            }
            if (asstCell != null && asstCell.getValue() != null) {
                this.toDetailRptParams.setObject("asstAttrID", asstCell.getValue());
            } else {
                if (this.params.getObject("asstAttrFrom") != null) {
                    this.toDetailRptParams.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
                }
                if (this.params.getObject("asstAttrTo") != null) {
                    this.toDetailRptParams.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
                }
                this.toDetailRptParams.setObject("asstAttrID", null);
            }
            if (suCell != null && suCell.getValue() != null) {
                this.toDetailRptParams.setObject("supplierName", suCell.getValue());
            } else {
                this.toDetailRptParams.setObject("supplierName", null);
                if (this.params.getObject("supplierFrom") != null) {
                    this.toDetailRptParams.setObject("supplierFrom", this.params.getObject("supplierFrom"));
                }
                if (this.params.getObject("supplierTo") != null) {
                    this.toDetailRptParams.setObject("supplierTo", this.params.getObject("supplierTo"));
                }
            }
            if (cuCell != null && cuCell.getValue() != null) {
                this.toDetailRptParams.setObject("FCustomerName", cuCell.getValue());
            } else {
                this.toDetailRptParams.setObject("FCustomerName", null);
                if (this.params.getObject("customerFrom") != null) {
                    this.toDetailRptParams.setObject("customerFrom", this.params.getObject("customerFrom"));
                }
                if (this.params.getObject("customerTo") != null) {
                    this.toDetailRptParams.setObject("customerTo", this.params.getObject("customerTo"));
                }
            }
        }
    }

    private String getRIType(String columnName) {
        if ((columnName = columnName.substring(1, columnName.length() - 3)).equals("PurIn")) {
            return "10";
        }
        if (columnName.equals("PurRt")) {
            return "20";
        }
        if (columnName.equals("SaleOut")) {
            return "40";
        }
        if (columnName.equals("SaleRt")) {
            return "30";
        }
        if (columnName.equals("ReqOut")) {
            return "60";
        }
        if (columnName.equals("ReqRt")) {
            return "50";
        }
        if (columnName.equals("TransIn")) {
            return "70";
        }
        if (columnName.equals("TransOut")) {
            return "80";
        }
        if (columnName.equals("OtherIn")) {
            return "91";
        }
        if (columnName.equals("OtherOut")) {
            return "92";
        }
        if (columnName.equals("ManuIn")) {
            return "11";
        }
        if (columnName.equals("ManuRt")) {
            return "21";
        }
        if (columnName.equals("CostAdjIn")) {
            return "CostAdjIn";
        }
        if (columnName.equals("CostAdjOut")) {
            return "CostAdjOut";
        }
        if (columnName.equals("MoveIn")) {
            return "MoveIn";
        }
        if (columnName.equals("MoveOut")) {
            return "MoveOut";
        }
        if (columnName.equals("CostIn")) {
            return "13";
        }
        if (columnName.equals("CostRtIn")) {
            return "14";
        }
        if (columnName.equals("CostOut")) {
            return "42";
        }
        if (columnName.equals("CostRtOut")) {
            return "43";
        }
        return null;
    }

    protected Object[] getAllLeafStorageOrg(String storageOrgUnitID) {
        Vector<String> v = new Vector<String>();
        Vector<String> leafV = new Vector<String>();
        Object[] fullStorageOrg = (Object[])this.params.getObject("fullStorageOrgUnit");
        OrgUnitInfo currOrg = null;
        OrgUnitInfo storageOrg = null;
        int n = fullStorageOrg.length;
        for (int i = 0; i < n; ++i) {
            String fid = ((OrgUnitInfo)fullStorageOrg[i]).get("id").toString();
            if (!fid.equals(storageOrgUnitID)) continue;
            currOrg = (OrgUnitInfo)fullStorageOrg[i];
            break;
        }
        if (null == currOrg) {
            return leafV.toArray();
        }
        boolean isleaf = currOrg.isIsLeaf();
        String longnumber = (String)currOrg.get("longnumber");
        String longnumber2 = null;
        if (isleaf) {
            v.add(storageOrgUnitID);
        } else {
            int n2 = fullStorageOrg.length;
            for (int i = 0; i < n2; ++i) {
                storageOrg = (OrgUnitInfo)fullStorageOrg[i];
                if (storageOrg.getId() == null || storageOrg.getId().toString().equals(storageOrgUnitID) || (longnumber2 = (String)storageOrg.get("longnumber")).indexOf(longnumber) <= -1) continue;
                v.add(storageOrg.getId().toString());
            }
        }
        Object[] orgs = v.toArray();
        try {
            IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer();
            oql.append("select fid where isBizUnit = 1 and id in (");
            int size = orgs.length;
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    oql.append(",");
                }
                oql.append("'").append(orgs[i]).append("'");
            }
            oql.append(")");
            CoreBaseCollection storageColl = iStorage.getCollection(oql.toString());
            int size2 = storageColl.size();
            for (int i = 0; i < size2; ++i) {
                leafV.add(storageColl.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return leafV.toArray();
    }

    protected void initListener() {
        super.initVirtualCompanyListener();
    }

    protected KDTable getTable() {
        return this.tbl;
    }

    public void fmtColumnPrecision() {
        String qtyFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinQtyPrecission"));
        String amtFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinAmountPrecission"));
        String assistQtyFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinAssQtyPrecission"));
        String priceFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinPricePrecission"));
        int columnCount = this.tbl.getColumnCount();
        String key = "";
        for (int i = 0; i < columnCount; ++i) {
            key = this.tbl.getColumnKey(i);
            if (key.indexOf("Qty") > -1) {
                if (key.indexOf("AssQty") > -1) {
                    this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(assistQtyFmt);
                    continue;
                }
                this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(qtyFmt);
                continue;
            }
            if (key.indexOf("Amt") > -1) {
                this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(amtFmt);
                continue;
            }
            if (key.indexOf("Price") <= -1) continue;
            this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(priceFmt);
        }
    }

    private String getEditUIName() {
        return InventoryTypeDetailReportUI.class.getName();
    }

    public void viewUIPreChecked() {
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.toDetailRptParams = new RptParams();
        this.putDetailParams();
        IMRptUtils.setParams4Precision(this.toDetailRptParams, this.params);
        UIContext uiContext = new UIContext((Object)this);
        String orgStr = this.toStringObjArray((Object[])this.toDetailRptParams.getObject("storageOrgUnits"));
        uiContext.put((Object)"param1", (Object)this.toDetailRptParams.getObject("dateFrom").toString());
        uiContext.put((Object)"param2", (Object)this.toDetailRptParams.getObject("dateTo").toString());
        uiContext.put((Object)"param3", (Object)this.toDetailRptParams.getObject("CurrentMaterialID").toString());
        uiContext.put((Object)"param4", (Object)orgStr);
        if (this.toDetailRptParams.getObject("warehouseID") != null) {
            uiContext.put((Object)"param6", (Object)this.toDetailRptParams.getObject("warehouseID").toString());
        } else {
            uiContext.put((Object)"param6", null);
        }
        uiContext.put((Object)"rptParams", (Object)this.toDetailRptParams);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            IInventoryTypeGatherReportFacade instance = InventoryTypeGatherReportFacadeFactory.getRemoteInstance();
            instance.dropTempTable(this.getOrgTempTable());
            if (this.params != null && this.params.getString("detailTempTable") != null) {
                instance.dropTempTable(this.params.getString("detailTempTable"));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean destroyWindow() {
        if (this.windowMessage != null) {
            this.windowMessage.setVisible(false);
            this.windowMessage.dispose();
        }
        return super.destroyWindow();
    }

    public String toStringObjArray(Object[] objArray) {
        String rtnStr = "";
        if (objArray != null && objArray.length != 0) {
            for (int i = 0; i < objArray.length; ++i) {
                rtnStr = rtnStr + objArray[i] + ",";
            }
        }
        return rtnStr;
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"217_InOutStoreGatherReportUI")).append(" &[dateFrom]");
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"218_InOutStoreGatherReportUI")).append(" &[dateTo]");
        sb.append("&| &| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Date dateFrom = (Date)this.params.getObject("dateFrom");
        Date dateTo = (Date)this.params.getObject("dateTo");
        map.put("dateFrom", IMRptUtils.getFmtDate(dateFrom));
        map.put("dateTo", IMRptUtils.getFmtDate(dateTo));
        return map;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams[] cp = ReportQueryConditionHelper.getCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((cp == null && this.params == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                this.params = rbqp.getCustomCondition();
                if (pc != null) {
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp[0]);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null) {
                    pc.initUIContentLayout();
                    pc.onInit(this.getUIContextInitParams());
                    pc.onLoad();
                    pc.loadFields();
                    pc.setCustomerParams(cp[1]);
                    pc.loadData(null);
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected void getAllDataOfId() {
        if (this.params.getObject("idList") != null) {
            IRowSet result = (IRowSet)this.params.getObject("idList");
            this.allIdList = new ArrayList();
            try {
                while (result.next()) {
                    this.allIdList.add(result.getString("FId"));
                }
                this.getTable().setRowCount(this.allIdList.size());
                this.setButtonEnabled(true);
            }
            catch (SQLException e) {
                this.handUIExceptionAndAbort(e);
            }
        } else {
            super.getAllDataOfId();
        }
    }

    protected IRow appendFootRow(KDTableInsertHandler handler, RptRowSet rs) {
        Boolean ckBxShowsumRow = (Boolean)this.params.getObject("ckBxShowsumRow");
        if (!ckBxShowsumRow.booleanValue()) {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager != null && (footRow = footRowManager.getFootRow(0)) != null) {
                footRowManager.getFoot().removeRow(footRow.getRowIndex());
            }
            return null;
        }
        try {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (rs != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            E.printStackTrace();
            logger.error((Object)E);
            return null;
        }
    }

    protected IRow appendFootRow(RptParams params) {
        Boolean ckBxShowsumRow = (Boolean)params.getObject("ckBxShowsumRow");
        if (!ckBxShowsumRow.booleanValue()) {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager != null && (footRow = footRowManager.getFootRow(0)) != null) {
                footRowManager.getFoot().removeRow(footRow.getRowIndex());
            }
            return null;
        }
        try {
            RptRowSet singleRowSet = null;
            singleRowSet = InventoryTypeGatherReportFacadeFactory.getRemoteInstance().calFootRow(params);
            if (singleRowSet == null) {
                return null;
            }
            DefaultKDTableInsertHandler handler = new DefaultKDTableInsertHandler(singleRowSet);
            if (singleRowSet.next()) {
                singleRowSet.setValue("FStorageOrgName", null);
            }
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (singleRowSet != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])singleRowSet.toRowArray(), (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            E.printStackTrace();
            logger.error((Object)E);
            return null;
        }
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && ReportQueryConditionHelper.getDefaultSolution() != null) {
            object = ReportQueryConditionHelper.getDefaultSolution().getId();
        }
        return object;
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        String uiName = LocateDialogUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"curTable", (Object)this.getDetailTable());
        if (this.getDetailTable() == null) {
            return;
        }
        if (this.getDetailTable().getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoEntry"));
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.ADDNEW, 32);
        uiWindow.show();
    }

    protected KDTable getDetailTable() {
        return this.tbl;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
    }
}

