/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.client.AbstractMatStoreDateAnalyseConditionUI;
import com.kingdee.eas.scm.im.rpt.client.MaterialSerialNumberConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MatStoreDateAnalyseConditionUI
extends AbstractMatStoreDateAnalyseConditionUI {
    private static final long serialVersionUID = 4591974740758845430L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSerialNumberConditionUI.class);
    private boolean firstLoad = true;
    private Object[] fullStorageOrgs;
    private Object[] selectWarehouses;
    private Object[] printStorageOrgs;
    private SCMRptMultiOrgsF7 multiStorageF7;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private int currencyPrecision = 2;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;

    public MatStoreDateAnalyseConditionUI() throws Exception {
        this.addCkBxSimpleNameListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("storageOrgs", this.kDBizStorage.getValue());
        para.setObject("warehouses", this.kDBizWarehs.getValue());
        para.setObject("materialGroupStandard", this.comboGroupStandard.getSelectedItem());
        para.setObject("materialTypeFrom", this.bizMaterialTypeFrom.getValue());
        para.setObject("materialTypeTo", this.bizMaterialTypeTo.getValue());
        para.setObject("materialFrom", this.kDBizMaterialFrom.getValue());
        para.setObject("materialTo", this.kDBizMaterialTo.getValue());
        para.setObject("assistFrom", this.kDBizAssistFrom.getValue());
        para.setObject("assistTo", this.kDBizAssistTo.getValue());
        para.setString("lotFrom", this.txtLotFrom.getText());
        para.setString("lotTo", this.txtLotTo.getText());
        para.setInt("storeDaysAbove", ((Integer)this.kDTxtStorageDateAbove.getValue()).intValue());
        para.setInt("stayDaysAbove", ((Integer)this.kDTxtStayDateAbove.getValue()).intValue());
        para.setBoolean("isStatWarehouse", this.kDCheckInCluWarehs.isSelected());
        para.setBoolean("isStatAssist", this.kDCheckIncluAssist.isSelected());
        para.setBoolean("isStatLot", this.kDCheckIncluLot.isSelected());
        para.setBoolean("isStatUnit", this.kDCheckIncluUnitQty.isSelected());
        para.setBoolean("stayReason", this.kDRadioNoInOut.isSelected());
        para.setObject("fullStorageOrgs", (Object)this.fullStorageOrgs);
        para.setObject("selectWarehouses", (Object)this.selectWarehouses);
        para.setInt("currencyPrecision", this.currencyPrecision);
        para.setObject("printStorageOrgs", (Object)this.printStorageOrgs);
        para.setBoolean("isStatLocation", this.kDCheckInCludeLocation.isSelected());
        para.setBoolean("isStoreFIFO", this.kDRadioFIFO.isSelected());
        para.setBoolean("isStoreAve", this.kDRadioAve.isSelected());
        para.setObject("ckBxShowMShortName", (Object)this.ckBxShowMShortName.isSelected());
        para.setObject("shortNameFrom", (Object)this.txtMShortNameFrom.getText());
        para.setObject("shortNameTo", (Object)this.txtMShortNameTo.getText());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.kDBizStorage.setValue(params.getObject("storageOrgs"));
        this.kDBizWarehs.setValue(params.getObject("warehouses"));
        this.comboGroupStandard.setSelectedItem(params.getObject("materialGroupStandard"));
        this.bizMaterialTypeFrom.setValue(params.getObject("materialTypeFrom"));
        this.bizMaterialTypeTo.setValue(params.getObject("materialTypeTo"));
        this.kDBizMaterialFrom.setValue(params.getObject("materialFrom"));
        this.kDBizMaterialTo.setValue(params.getObject("materialTo"));
        this.kDBizAssistFrom.setValue(params.getObject("assistFrom"));
        this.kDBizAssistTo.setValue(params.getObject("assistTo"));
        this.txtLotFrom.setText(params.getString("lotFrom"));
        this.txtLotTo.setText(params.getString("lotTo"));
        this.kDTxtStorageDateAbove.setValue((Object)new Integer(params.getInt("storeDaysAbove")));
        this.kDTxtStayDateAbove.setValue((Object)new Integer(params.getInt("stayDaysAbove")));
        this.kDCheckInCluWarehs.setSelected(params.getBoolean("isStatWarehouse"));
        this.kDCheckIncluAssist.setSelected(params.getBoolean("isStatAssist"));
        this.kDCheckIncluLot.setSelected(params.getBoolean("isStatLot"));
        this.kDCheckIncluUnitQty.setSelected(params.getBoolean("isStatUnit"));
        this.kDRadioNoInOut.setSelected(params.getBoolean("stayReason"));
        this.kDRadioNoOut.setSelected(!params.getBoolean("stayReason"));
        this.kDCheckInCludeLocation.setSelected(params.getBoolean("isStatLocation"));
        this.kDRadioFIFO.setSelected(params.getBoolean("isStoreFIFO"));
        this.kDRadioAve.setSelected(params.getBoolean("isStoreAve"));
        this.kDCheckInCludeLocation.setSelected(false);
        this.kDRadioFIFO.setSelected(true);
        this.kDRadioAve.setSelected(false);
        if ((Boolean)params.getObject("ckBxShowMShortName") != null) {
            this.ckBxShowMShortName.setSelected(((Boolean)params.getObject("ckBxShowMShortName")).booleanValue());
        } else {
            this.ckBxShowMShortName.setSelected(false);
        }
        this.txtMShortNameFrom.setText((String)params.getObject("shortNameFrom"));
        this.txtMShortNameTo.setText((String)params.getObject("shortNameTo"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        ReportQueryConditionHelper.fillCustomerParams((CustomerParams)customerParams, (Container)((Object)this));
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null) {
            return;
        }
        this.clear();
        ReportQueryConditionHelper.fillComponent((Container)((Object)this), (CustomerParams)cp);
    }

    public void clear() {
        super.clear();
        this.kDBizStorage.setValue(null);
        this.kDBizWarehs.setValue(null);
        this.kDBizMaterialFrom.setValue(null);
        this.kDBizMaterialTo.setValue(null);
        this.kDBizAssistFrom.setValue(null);
        this.kDBizAssistTo.setValue(null);
        this.txtLotFrom.setText("");
        this.txtLotTo.setText("");
        this.kDTxtStorageDateAbove.setValue((Object)new Integer(0));
        this.kDTxtStayDateAbove.setValue((Object)new Integer(0));
        this.kDCheckInCluWarehs.setSelected(false);
        this.kDCheckIncluAssist.setSelected(false);
        this.kDCheckIncluLot.setSelected(false);
        this.kDCheckIncluUnitQty.setSelected(false);
        this.kDRadioNoInOut.setSelected(true);
        this.kDRadioNoOut.setSelected(false);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Control();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.loadGroupStandard();
    }

    private void setF7Control() {
        if (this.firstLoad) {
            this.multiStorageF7 = new SCMRptMultiOrgsF7(this.kDBizStorage, OrgType.Storage, "MatStoreDateAnalyseReport_view", EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
            this.fullStorageOrgs = (Object[])this.multiStorageF7.getFullData();
            this.kDBizStorage.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MatStoreDateAnalyseConditionUI.access$002(MatStoreDateAnalyseConditionUI.this, (Object[])MatStoreDateAnalyseConditionUI.this.multiStorageF7.getFullData());
                    MatStoreDateAnalyseConditionUI.access$202(MatStoreDateAnalyseConditionUI.this, (Object[])MatStoreDateAnalyseConditionUI.this.multiStorageF7.getData());
                    if (MatStoreDateAnalyseConditionUI.this.fullStorageOrgs != null) {
                        Vector<String> vOrgs = new Vector<String>();
                        for (int i = 0; i < MatStoreDateAnalyseConditionUI.this.fullStorageOrgs.length; ++i) {
                            vOrgs.add(((FullOrgUnitInfo)MatStoreDateAnalyseConditionUI.this.fullStorageOrgs[i]).getId().toString());
                        }
                        if (MatStoreDateAnalyseConditionUI.this.fullStorageOrgs.length > 0) {
                            IMRptUtils.setRptWarehouseFilter(vOrgs.toArray(), MatStoreDateAnalyseConditionUI.this.kDBizWarehs);
                        }
                        int size = MatStoreDateAnalyseConditionUI.this.fullStorageOrgs.length;
                        for (int i = 0; i < size; ++i) {
                            CompanyOrgUnitInfo currCom = null;
                            currCom = InvClientUtils.getCompanyInfo(((FullOrgUnitInfo)MatStoreDateAnalyseConditionUI.this.fullStorageOrgs[i]).getId().toString());
                            if (currCom == null) continue;
                            try {
                                MatStoreDateAnalyseConditionUI.this.currencyPrecision = InvClientUtils.getLocalCurrencyPrecision(currCom);
                                return;
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                }
            });
            this.kDBizWarehs.setEnabledMultiSelection(true);
            this.kDBizWarehs.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MatStoreDateAnalyseConditionUI.access$502(MatStoreDateAnalyseConditionUI.this, (Object[])MatStoreDateAnalyseConditionUI.this.kDBizWarehs.getValue());
                }
            });
            this.kDBizWarehs.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    MatStoreDateAnalyseConditionUI.this.kDBizWarehs_willShow(e);
                }
            });
            this.kDCheckInCludeLocation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    MatStoreDateAnalyseConditionUI.this.kDCheckInCludeLocation_actionPerformed(arg0);
                }
            });
            this.kDCheckInCluWarehs.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MatStoreDateAnalyseConditionUI.this.kDCheckInCluWarehs_actionPerformed(e);
                }
            });
            this.comboGroupStandard.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MatStoreDateAnalyseConditionUI.this.comboGroupStandard_itemStateChanged(e);
                }
            });
            this.firstLoad = false;
        }
        InvClientUtils.getMaterialF7ForReportFilterUI(this.kDBizMaterialFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.kDBizMaterialTo, (Object)this);
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.bizMaterialTypeFrom.getValue() != null || this.bizMaterialTypeTo.getValue() != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (null != groupInfo) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    protected void kDBizWarehs_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void storageOrgUnitCheck() {
        Object[] storageOrg;
        if (this.kDBizStorage.getValue() == null || ((Object[])this.kDBizStorage.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        } else if (((Object[])this.kDBizStorage.getValue()).length == 1 && ((storageOrg = (Object[])this.kDBizStorage.getValue())[0] == null || storageOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    public boolean verify() {
        if (this.kDBizStorage.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        this.storageOrgUnitCheck();
        String[] storageOrgIDs = new String[this.fullStorageOrgs.length];
        int size = this.fullStorageOrgs.length;
        for (int i = 0; i < size; ++i) {
            storageOrgIDs[i] = ((FullOrgUnitInfo)this.fullStorageOrgs[i]).getId().toString();
        }
        try {
            if (!IMRptUtils.checkSameCurrency(storageOrgIDs)) {
                return false;
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if ((Integer)this.kDTxtStorageDateAbove.getValue() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storeDaysAboveCannotBellowZero"));
            return false;
        }
        if ((Integer)this.kDTxtStayDateAbove.getValue() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"stayDaysAboveCannotBellowZero"));
            return false;
        }
        return true;
    }

    private void kDCheckInCludeLocation_actionPerformed(ItemEvent arg0) {
        if (this.kDCheckInCludeLocation.isSelected()) {
            this.kDCheckInCluWarehs.setSelected(true);
        }
    }

    private void kDCheckInCluWarehs_actionPerformed(ItemEvent e) {
        if (!this.kDCheckInCluWarehs.isSelected() && this.kDCheckInCludeLocation.isSelected()) {
            this.kDCheckInCluWarehs.setSelected(true);
        }
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    MatStoreDateAnalyseConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    MatStoreDateAnalyseConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
    }

    static /* synthetic */ Object[] access$002(MatStoreDateAnalyseConditionUI x0, Object[] x1) {
        x0.fullStorageOrgs = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$202(MatStoreDateAnalyseConditionUI x0, Object[] x1) {
        x0.printStorageOrgs = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$502(MatStoreDateAnalyseConditionUI x0, Object[] x1) {
        x0.selectWarehouses = x1;
        return x1;
    }
}

