/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.OutStorageGatherFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractOutStorageGatherFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OutStorageGatherFilterUI
extends AbstractOutStorageGatherFilterUI {
    private static final long serialVersionUID = -512319108808601820L;
    private boolean firstLoad = true;
    private Object[] fullAdminOrgs;
    private NewAdminF7 multiadminF7;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private long MAXBI = 100000L;

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("adminOrgFrom", this.bizPromptAdminFrom.getValue());
        para.setObject("bizeDateFrom", this.kDBizeDateFrom.getValue());
        para.setObject("bizeDateTo", this.kDBizeDateTo.getValue());
        para.setObject("materialFrom", this.bizPromptMaterialNumFrom.getValue());
        para.setObject("materialTo", this.bizPromptMaterialNumTo.getValue());
        para.setObject("transactionTypeFrom", this.bizPromptTrsTypeFrom.getValue());
        para.setObject("transactionTypeTo", this.bizPromptTrsTypeTo.getValue());
        para.setBoolean("isStatBaseUnit", this.checkIsBaseUnitStat.isSelected());
        para.setObject("fullAdminOrgs", (Object)this.fullAdminOrgs);
        para.setObject("warehouseFrom", this.kdBizWarehouseFrom.getValue());
        para.setObject("warehouseTo", this.kdBizWarehouseTo.getValue());
        para.setBoolean("isStatByDepart", this.kDRadioDepartment.isSelected());
        para.setBoolean("kDDepNull", this.kDDepNull.isSelected());
        try {
            para.setObject("permmisionOrgs", (Object)SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgType)OrgType.Storage, (String)"OutStorageGatherReport_view"));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizPromptAdminFrom.setValue(params.getObject("adminOrgFrom"));
        this.kDBizeDateFrom.setValue(params.getObject("bizeDateFrom"));
        this.kDBizeDateTo.setValue(params.getObject("bizeDateTo"));
        this.bizPromptMaterialNumFrom.setValue(params.getObject("materialFrom"));
        this.bizPromptMaterialNumTo.setValue(params.getObject("materialTo"));
        this.bizPromptTrsTypeFrom.setValue(params.getObject("transactionTypeFrom"));
        this.bizPromptTrsTypeTo.setValue(params.getObject("transactionTypeTo"));
        this.checkIsBaseUnitStat.setSelected(params.getBoolean("isStatBaseUnit"));
        this.kdBizWarehouseFrom.setValue(params.getObject("warehouseFrom"));
        this.kdBizWarehouseTo.setValue(params.getObject("warehouseTo"));
        if (params.getBoolean("isStatByDepart")) {
            this.kDRadioDepartment.setSelected(true);
            this.kDRadioTransaction.setSelected(false);
        } else {
            this.kDRadioDepartment.setSelected(false);
            this.kDRadioTransaction.setSelected(true);
        }
        if (params.getBoolean("kDDepNull")) {
            this.kDDepNull.setSelected(true);
        } else {
            this.kDDepNull.setSelected(false);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        ReportQueryConditionHelper.fillCustomerParams((CustomerParams)customerParams, (Container)((Object)this));
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null) {
            return;
        }
        this.clear();
        ReportQueryConditionHelper.fillComponent((Container)((Object)this), (CustomerParams)cp);
        if (cp.getBoolean("kDDepNull")) {
            this.kDDepNull.setSelected(true);
        } else {
            this.kDDepNull.setSelected(false);
        }
    }

    public void clear() {
        super.clear();
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.kDBizeDateFrom.setValue((Object)bd);
        this.kDBizeDateTo.setValue((Object)ed);
        this.bizPromptAdminFrom.setValue(null);
        this.bizPromptMaterialNumFrom.setValue(null);
        this.bizPromptMaterialNumTo.setValue(null);
        this.bizPromptTrsTypeFrom.setValue(null);
        this.bizPromptTrsTypeTo.setValue(null);
        this.kdBizWarehouseFrom.setValue(null);
        this.kdBizWarehouseTo.setValue(null);
        this.kDRadioDepartment.setSelected(true);
        this.kDRadioTransaction.setSelected(false);
        this.kDDepNull.setSelected(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptAdminFrom.setEditable(false);
        this.setF7Control();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fullAdminOrgs = this.getDefaultMainBizOrg(OrgType.Admin, null);
        this.bizPromptAdminFrom.setValue((Object)this.fullAdminOrgs);
    }

    private void addListen() {
        this.kDDepNull.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    OutStorageGatherFilterUI.this.kDDepNull_stateChanged(e);
                }
                catch (Exception e1) {
                    OutStorageGatherFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    private void setAdminOrgUnitByUser(OrgType orgType, String permItem) {
        OrgUnitInfo currentMainOrg;
        OrgUnitInfo[] adminOrgs = null;
        HashSet<String> adminSet = new HashSet<String>();
        FullOrgUnitCollection collection = null;
        try {
            collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)orgType, (String)permItem);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        adminOrgs = this.getAdminOrgsFromFullOrgColl(collection);
        if (adminOrgs == null) {
            adminOrgs = new OrgUnitInfo[]{};
        }
        if (adminOrgs.length > 0) {
            adminOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType)) != null && adminOrgs.length > 0) {
            for (int i = 0; i < adminOrgs.length; ++i) {
                String currentMainOrgNum = currentMainOrg.getLongNumber();
                String adminOrgsNum = adminOrgs[i].getLongNumber();
                if (!adminOrgsNum.startsWith(currentMainOrgNum)) continue;
                adminSet.add(adminOrgs[i].getId().toString());
            }
        }
        if (adminSet == null || adminSet.size() < 1) {
            adminSet.add("111111111111111111111111111=");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filerInfo = new FilterInfo();
        filerInfo.getFilterItems().add(new FilterItemInfo("id", adminSet, CompareType.INCLUDE));
        viewInfo.setFilter(filerInfo);
        this.bizPromptAdminFrom.setEntityViewInfo(viewInfo);
        this.multiadminF7.setRootUnitID(currentMainOrg == null ? "111111111111111111111111111=" : currentMainOrg.getId().toString());
    }

    private void setF7Control() {
        if (this.firstLoad) {
            this.multiadminF7 = new NewAdminF7();
            this.multiadminF7.setMultiSelect(true);
            this.multiadminF7.setIsCUFilter(false, false);
            this.bizPromptAdminFrom.setSelector((KDPromptSelector)this.multiadminF7);
            this.bizPromptAdminFrom.setEditable(true);
            this.bizPromptAdminFrom.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)this.multiadminF7));
            this.setAdminOrgUnitByUser(OrgType.Admin, null);
            this.bizPromptAdminFrom.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    Object value = OutStorageGatherFilterUI.this.bizPromptAdminFrom.getValue();
                    if (value == null) {
                        OutStorageGatherFilterUI.access$002(OutStorageGatherFilterUI.this, null);
                    } else if (value instanceof Object[]) {
                        OutStorageGatherFilterUI.access$002(OutStorageGatherFilterUI.this, (Object[])value);
                    } else {
                        OutStorageGatherFilterUI.access$002(OutStorageGatherFilterUI.this, new Object[]{value});
                    }
                    OutStorageGatherFilterUI.this.setWarehouseFilter(OutStorageGatherFilterUI.this.kdBizWarehouseFrom, OutStorageGatherFilterUI.this.fullAdminOrgs);
                    OutStorageGatherFilterUI.this.setWarehouseFilter(OutStorageGatherFilterUI.this.kdBizWarehouseTo, OutStorageGatherFilterUI.this.fullAdminOrgs);
                }
            });
            this.firstLoad = false;
        }
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumTo, (Object)this);
        this.setTransactionTypeF7Filter(this.bizPromptTrsTypeFrom);
        this.setTransactionTypeF7Filter(this.bizPromptTrsTypeTo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    private void setTransactionTypeF7Filter(KDBizPromptBox prmtTransaction) {
        if (prmtTransaction != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0163c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0177c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-016ec0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-015bc0a812fd463ED552", CompareType.EQUALS));
            fi.setMaskString("#0 or #1 or #2 or #3");
            evi.setFilter(fi);
            prmtTransaction.setEntityViewInfo(evi);
        }
    }

    public boolean verify() {
        Date dateFrom = (Date)this.kDBizeDateFrom.getValue();
        Date dateTo = (Date)this.kDBizeDateTo.getValue();
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.kDBizeDateFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.kDBizeDateTo.requestFocus();
            return false;
        }
        if (dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_BEFORE_START"));
            this.kDBizeDateTo.requestFocus();
            return false;
        }
        boolean isDepNull = this.kDDepNull.isSelected();
        if (this.fullAdminOrgs == null || this.fullAdminOrgs.length == 0) {
            ArrayList array = null;
            try {
                array = (ArrayList)PermissionRangeHelper.getUserOrgId(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgRangeType)OrgRangeType.ADMIN_ORG_TYPE);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (array != null) {
                this.fullAdminOrgs = array.toArray();
            }
        }
        return this.verifyBILimit();
    }

    private boolean verifyBILimit() {
        boolean isDepartMent = this.kDRadioDepartment.isSelected();
        Object[] orgInfo = this.fullAdminOrgs;
        int orgNumber = 0;
        if (isDepartMent) {
            orgNumber = orgInfo.length;
        } else {
            TransactionTypeInfo transactionTypeFrom = null;
            TransactionTypeInfo transactionTypeTo = null;
            String transactionTypeFromNum = null;
            String transactionTypeToNum = null;
            if (this.bizPromptTrsTypeFrom.getValue() != null) {
                transactionTypeFrom = (TransactionTypeInfo)this.bizPromptTrsTypeFrom.getValue();
                transactionTypeFromNum = transactionTypeFrom.getNumber();
            }
            if (this.bizPromptTrsTypeTo.getValue() != null) {
                transactionTypeTo = (TransactionTypeInfo)this.bizPromptTrsTypeTo.getValue();
                transactionTypeToNum = transactionTypeTo.getNumber();
            }
            TransactionTypeCollection transactionTypeCollection = null;
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0163c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0177c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-016ec0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-015bc0a812fd463ED552", CompareType.EQUALS));
            if (transactionTypeFromNum != null) {
                fi.getFilterItems().add(new FilterItemInfo("number", (Object)transactionTypeFromNum, CompareType.GREATER_EQUALS));
            }
            if (transactionTypeToNum != null) {
                fi.getFilterItems().add(new FilterItemInfo("number", (Object)transactionTypeToNum, CompareType.LESS_EQUALS));
            }
            if (transactionTypeFromNum != null && transactionTypeToNum != null) {
                fi.setMaskString("(#0 or #1 or #2 or #3) and #4 and #5");
            } else if (transactionTypeFromNum == null && transactionTypeToNum == null) {
                fi.setMaskString("#0 or #1 or #2 or #3 ");
            } else {
                fi.setMaskString("(#0 or #1 or #2 or #3)  and #4 ");
            }
            evi.setFilter(fi);
            try {
                transactionTypeCollection = TransactionTypeFactory.getRemoteInstance().getTransactionTypeCollection(evi);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (transactionTypeCollection != null && transactionTypeCollection.size() > 0) {
                orgNumber = transactionTypeCollection.size();
            }
        }
        String materialNumFrom = null;
        MaterialInfo materialFrom = null;
        MaterialInfo materialTo = null;
        if (this.bizPromptMaterialNumFrom.getValue() != null) {
            materialFrom = (MaterialInfo)this.bizPromptMaterialNumFrom.getValue();
            materialNumFrom = materialFrom.getNumber();
        }
        String mateiialNumTo = null;
        if (this.bizPromptMaterialNumTo.getValue() != null) {
            materialTo = (MaterialInfo)this.bizPromptMaterialNumTo.getValue();
            mateiialNumTo = materialTo.getNumber();
        }
        boolean hasOutOfMax = false;
        long selectMaterial = 0L;
        try {
            selectMaterial = OutStorageGatherFacadeFactory.getRemoteInstance().getMaterialNumber(materialNumFrom, mateiialNumTo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (selectMaterial * (long)orgNumber > this.MAXBI) {
            hasOutOfMax = true;
        }
        if (hasOutOfMax) {
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)resClassName, (String)"outOfStorageBIMessage1") + selectMaterial + EASResource.getString((String)resClassName, (String)"outOfStorageBIMessage2") + orgNumber + EASResource.getString((String)resClassName, (String)"outOfStorageBIMessage3") + selectMaterial * (long)orgNumber + EASResource.getString((String)resClassName, (String)"outOfStorageBIMessage4")));
            this.bizPromptMaterialNumFrom.requestFocus();
            return false;
        }
        return true;
    }

    protected final Object[] getDefaultMainBizOrg(OrgType orgType, String permItem) {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrgs == null) {
            try {
                FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)orgType, (String)permItem);
                this.mainOrgs = this.getAdminOrgsFromFullOrgColl(collection);
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType)) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                Object[] returnAdmins = new AdminOrgUnitInfo[1];
                AdminOrgUnitInfo returnAdmin = new AdminOrgUnitInfo();
                returnAdmin.setId(currentMainOrg.getId());
                returnAdmin.setNumber(currentMainOrg.getNumber());
                returnAdmin.setName(currentMainOrg.getName());
                returnAdmins[0] = returnAdmin;
                return returnAdmins;
            }
        }
        if (this.mainOrgs.length > 0) {
            Object[] returnAdmins = new AdminOrgUnitInfo[1];
            AdminOrgUnitInfo returnAdmin = new AdminOrgUnitInfo();
            returnAdmin.setId(this.mainOrgs[0].getId());
            returnAdmin.setNumber(this.mainOrgs[0].getNumber());
            returnAdmin.setName(this.mainOrgs[0].getName());
            returnAdmins[0] = returnAdmin;
            return returnAdmins;
        }
        return null;
    }

    private OrgUnitInfo[] getAdminOrgsFromFullOrgColl(FullOrgUnitCollection orgs) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                results = new OrgUnitInfo[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    results[i] = collection.get(i);
                }
            }
            return results;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private void setWarehouseFilter(KDBizPromptBox f7, Object[] objects) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (objects == null) {
            f7.setEntityViewInfo(viewInfo);
        } else {
            if (objects != null) {
                int size = objects.length;
                AdminOrgUnitInfo admin = null;
                CompanyOrgUnitInfo company = null;
                StringBuffer maskString = new StringBuffer();
                maskString.append("#0");
                for (int index = 0; index < size; ++index) {
                    admin = (AdminOrgUnitInfo)objects[index];
                    company = InvClientUtils.getCompanyInfo(admin);
                    if (index != 0) {
                        maskString.append(" or #" + index + "");
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)InvClientUtils.getStoragesIDSet(company), CompareType.INCLUDE));
                }
                if (size != 0) {
                    filterInfo.setMaskString(maskString.toString());
                }
                viewInfo.setFilter(filterInfo);
            }
            f7.setEntityViewInfo(viewInfo);
        }
    }

    protected void kDDepNull_stateChanged(ChangeEvent e) throws Exception {
        if (this.kDDepNull.isSelected()) {
            this.kDDepNull.setSelected(true);
            this.bizPromptAdminFrom.setValue(null);
            this.bizPromptAdminFrom.setEnabled(false);
        } else {
            this.kDDepNull.setSelected(false);
            this.bizPromptAdminFrom.setEnabled(true);
        }
    }

    static /* synthetic */ Object[] access$002(OutStorageGatherFilterUI x0, Object[] x1) {
        x0.fullAdminOrgs = x1;
        return x1;
    }
}

