/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.client.AbstractOutTransactionGatherConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class OutTransactionGatherConditionUI
extends AbstractOutTransactionGatherConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(OutTransactionGatherConditionUI.class);
    private boolean firstLoad = true;
    private Object[] fullAdminOrgs;
    private NewAdminF7 multiadminF7;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private OrgUnitInfo[] mainOrgs = null;
    private static final String permItem_view = "outTransGather_view";
    private int idxDefaultMainOrg = -1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("adminOrgFrom", this.bizPromptAdminFrom.getValue());
        para.setObject("bizeDateFrom", this.kDBizeDateFrom.getValue());
        para.setObject("bizeDateTo", this.kDBizeDateTo.getValue());
        para.setObject("materialFrom", this.bizPromptMaterialNumFrom.getValue());
        para.setObject("materialTo", this.bizPromptMaterialNumTo.getValue());
        para.setObject("transactionTypeFrom", this.bizPromptTrsTypeFrom.getValue());
        para.setObject("transactionTypeTo", this.bizPromptTrsTypeTo.getValue());
        para.setBoolean("isStatBaseUnit", this.checkIsBaseUnitStat.isSelected());
        para.setObject("fullAdminOrgs", (Object)this.fullAdminOrgs);
        para.setObject("warehouseFrom", this.kdBizWarehouseFrom.getValue());
        para.setObject("warehouseTo", this.kdBizWarehouseTo.getValue());
        para.setBoolean("isStatByDepart", this.kDRadioDepartment.isSelected());
        try {
            para.setObject("permmisionOrgs", (Object)SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (OrgType)OrgType.Storage, (String)"OutTransactionGatherReport_view"));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizPromptAdminFrom.setValue(params.getObject("adminOrgFrom"));
        this.kDBizeDateFrom.setValue(params.getObject("bizeDateFrom"));
        this.kDBizeDateTo.setValue(params.getObject("bizeDateTo"));
        this.bizPromptMaterialNumFrom.setValue(params.getObject("materialFrom"));
        this.bizPromptMaterialNumTo.setValue(params.getObject("materialTo"));
        this.bizPromptTrsTypeFrom.setValue(params.getObject("transactionTypeFrom"));
        this.bizPromptTrsTypeTo.setValue(params.getObject("transactionTypeTo"));
        this.checkIsBaseUnitStat.setSelected(params.getBoolean("isStatBaseUnit"));
        this.kdBizWarehouseFrom.setValue(params.getObject("warehouseFrom"));
        this.kdBizWarehouseTo.setValue(params.getObject("warehouseTo"));
        if (params.getBoolean("isStatByDepart")) {
            this.kDRadioDepartment.setSelected(true);
            this.kDRadioTransaction.setSelected(false);
        } else {
            this.kDRadioDepartment.setSelected(false);
            this.kDRadioTransaction.setSelected(true);
        }
    }

    public void clear() {
        super.clear();
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.kDBizeDateFrom.setValue((Object)bd);
        this.kDBizeDateTo.setValue((Object)ed);
        this.bizPromptAdminFrom.setValue(null);
        this.bizPromptMaterialNumFrom.setValue(null);
        this.bizPromptMaterialNumTo.setValue(null);
        this.bizPromptTrsTypeFrom.setValue(null);
        this.bizPromptTrsTypeTo.setValue(null);
        this.kdBizWarehouseFrom.setValue(null);
        this.kdBizWarehouseTo.setValue(null);
        this.kDRadioDepartment.setSelected(true);
        this.kDRadioTransaction.setSelected(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptAdminFrom.setEditable(false);
        this.setF7Control();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fullAdminOrgs = this.getDefaultMainBizOrg(OrgType.Admin, null);
        this.bizPromptAdminFrom.setValue((Object)this.fullAdminOrgs);
    }

    private void setF7Control() {
        if (this.firstLoad) {
            this.multiadminF7 = new NewAdminF7();
            this.multiadminF7.setMultiSelect(true);
            this.multiadminF7.setIsCUFilter(false, false);
            this.bizPromptAdminFrom.setSelector((KDPromptSelector)this.multiadminF7);
            this.bizPromptAdminFrom.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)this.multiadminF7));
            this.bizPromptAdminFrom.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    OutTransactionGatherConditionUI.access$002(OutTransactionGatherConditionUI.this, (Object[])OutTransactionGatherConditionUI.this.bizPromptAdminFrom.getValue());
                }
            });
            this.firstLoad = false;
        }
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumTo, (Object)this);
        this.setTransactionTypeF7Filter(this.bizPromptTrsTypeFrom);
        this.setTransactionTypeF7Filter(this.bizPromptTrsTypeTo);
    }

    private void setTransactionTypeF7Filter(KDBizPromptBox prmtTransaction) {
        if (prmtTransaction != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0163c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-0177c0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-016ec0a812fd463ED552", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("BILLTYPE.ID", (Object)"50957179-0105-1000-e000-015bc0a812fd463ED552", CompareType.EQUALS));
            fi.setMaskString("#0 or #1 or #2 or #3");
            evi.setFilter(fi);
            prmtTransaction.setEntityViewInfo(evi);
        }
    }

    public boolean verify() {
        Date dateFrom = (Date)this.kDBizeDateFrom.getValue();
        Date dateTo = (Date)this.kDBizeDateTo.getValue();
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.kDBizeDateFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.kDBizeDateTo.requestFocus();
            return false;
        }
        if (dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_BEFORE_START"));
            this.kDBizeDateTo.requestFocus();
            return false;
        }
        return true;
    }

    protected final Object[] getDefaultMainBizOrg(OrgType orgType, String permItem) {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrgs == null) {
            try {
                FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)orgType, (String)permItem);
                this.mainOrgs = this.getAdminOrgsFromFullOrgColl(collection);
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType)) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                Object[] returnAdmins = new AdminOrgUnitInfo[1];
                AdminOrgUnitInfo returnAdmin = new AdminOrgUnitInfo();
                returnAdmin.setId(currentMainOrg.getId());
                returnAdmin.setNumber(currentMainOrg.getNumber());
                returnAdmin.setName(currentMainOrg.getName());
                returnAdmins[0] = returnAdmin;
                return returnAdmins;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            Object[] returnAdmins = new AdminOrgUnitInfo[1];
            AdminOrgUnitInfo returnAdmin = new AdminOrgUnitInfo();
            returnAdmin.setId(this.mainOrgs[0].getId());
            returnAdmin.setNumber(this.mainOrgs[0].getNumber());
            returnAdmin.setName(this.mainOrgs[0].getName());
            returnAdmins[0] = returnAdmin;
            return returnAdmins;
        }
        return null;
    }

    private OrgUnitInfo[] getAdminOrgsFromFullOrgColl(FullOrgUnitCollection orgs) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                results = new OrgUnitInfo[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    results[i] = collection.get(i);
                }
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    static /* synthetic */ Object[] access$002(OutTransactionGatherConditionUI x0, Object[] x1) {
        x0.fullAdminOrgs = x1;
        return x1;
    }
}

