/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.im.rpt.client.MaterialStayOptionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class PluginForMaterialStayRpt
extends ReportListener {
    private static String resName = "com.kingdee.eas.scm.im.rpt.IMRptForMaterialStayResource";

    public void onInitialize() throws Exception {
        this.reportApplication.addBarItem("findLastBill", EASResource.getString((String)resName, (String)"lastInwarehs"), EASResource.getString((String)resName, (String)"lastInwarehs"), EASResource.getString((String)resName, (String)"lastInwarehs"), "imgTbtn_demandcollateresult", null, "", true, true, false);
    }

    public void onMenuClick(String name) throws Exception {
        super.onMenuClick(name);
        if (name.equals("findLastBill")) {
            if (this.reportApplication.getSelectRows().size() != 1) {
                MsgBox.showInfo((String)EASResource.getString((String)resName, (String)"OnlyOneRow"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaterialStayOptionUI.class.getName(), (Map)uiContext);
            window.show();
            MaterialStayOptionUI materialStayOptionUI = (MaterialStayOptionUI)window.getUIObject();
            if (materialStayOptionUI.isSaveOption()) {
                BillTypeInfo billType = (BillTypeInfo)materialStayOptionUI.optionBizType.getValue();
                if (billType == null) {
                    return;
                }
                if (billType.getId().toString().equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                    this.executeQuery(new String[]{"SaleIssueBillQuery", "SaleIssueBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                    this.executeQuery(new String[]{"PurInWarehsQuery", "PurInWarehsBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-0163c0a812fd463ED552")) {
                    this.executeQuery(new String[]{"MaterialReqBillQuery", "MaterialReqBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-0167c0a812fd463ED552")) {
                    this.executeQuery(new String[]{"ManufactureRecBillQuery", "ManufactureRecBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-016ec0a812fd463ED552")) {
                    this.executeQuery(new String[]{"MoveIssueBillQuery", "MoveIssueBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-0172c0a812fd463ED552")) {
                    this.executeQuery(new String[]{"MoveInWarehsBillQuery", "MoveInWarehsBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) {
                    this.executeQuery(new String[]{"OtherIssueBillQuery", "OtherIssueBillEditUI"});
                } else if (billType.getId().toString().equals("50957179-0105-1000-e000-017bc0a812fd463ED552")) {
                    this.executeQuery(new String[]{"OtherInWarehsBillQuery", "OtherInWarehsBillEditUI"});
                }
            } else {
                return;
            }
        }
    }

    public void onCellClick(CellEvent event) throws Exception {
        super.onCellClick(event);
    }

    private void executeQuery(String[] billName) throws SQLException, BOSException {
        HashMap rowMap = this.reportApplication.getCurrentRow();
        RptParams params = this.reportApplication.getFilter();
        boolean inCluLot = new Boolean((String)params.getObject("inCluLot"));
        boolean inCluLocation = new Boolean((String)params.getObject("inCluLocation"));
        boolean inCluWarehs = new Boolean((String)params.getObject("inCluWarehs"));
        boolean inCluAssist = new Boolean((String)params.getObject("inCluAssist"));
        boolean inCluUnit = new Boolean((String)params.getObject("inCluUnit"));
        String materialNum = (String)rowMap.get("FMATERIALNUM");
        String storageNum = (String)rowMap.get("FSTORAGENUM");
        String warehsNum = (String)rowMap.get("FWAREHOUSENUM");
        String lot = null;
        if (rowMap.get("FLOT") != null) {
            lot = (String)rowMap.get("FLOT");
        }
        String locationNum = null;
        if (rowMap.get("FLOCATIONNUM") != null) {
            locationNum = (String)rowMap.get("FLOCATIONNUM");
        }
        String assistPropertyName = null;
        if (rowMap.get("FASSISTPROPERTYNAME") != null) {
            assistPropertyName = (String)rowMap.get("FASSISTPROPERTYNAME");
        }
        String unitName = null;
        if (rowMap.get("FUNITNAME") != null) {
            unitName = (String)rowMap.get("FUNITNAME");
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", billName[0]);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo queryEV = new EntityViewInfo();
        SorterItemInfo si = new SorterItemInfo("bizDate");
        si.setSortType(SortType.DESCEND);
        queryEV.getSorter().add(si);
        queryEV.getSelector().add("id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("entry.material.number", (Object)materialNum, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)storageNum, CompareType.EQUALS));
        if (inCluWarehs) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.warehouse.number", (Object)warehsNum, CompareType.EQUALS));
        }
        if (inCluLot) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.lot", (Object)lot, CompareType.EQUALS));
        }
        if (inCluLocation) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entry.location.number", (Object)locationNum, CompareType.EQUALS));
        }
        queryEV.setFilter(filterInfo);
        exec.setObjectView(queryEV);
        IRowSet set = exec.executeQuery(0, 1);
        if (!set.next()) {
            MsgBox.showInfo((String)EASResource.getString((String)resName, (String)"noResult"));
            return;
        }
        UIContext cx = new UIContext((Object)this);
        cx.put((Object)"ID", (Object)set.getString("id"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.scm.im.inv.client." + billName[1], (Map)cx, null, OprtState.VIEW);
        uiWindow.show();
    }
}

