/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.rpt.client.AbstractPurRequestExecuteRptFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurRequestExecuteRptFilterUI
extends AbstractPurRequestExecuteRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PurRequestExecuteRptFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private static SCMRptMultiOrgsF7 f7CompanyOrgUnit;

    public PurRequestExecuteRptFilterUI() throws Exception {
        this.isReport = true;
        f7CompanyOrgUnit = new SCMRptMultiOrgsF7(this.prmtCompanyOrgUnit, OrgType.Company, EASResource.getString((String)resClassName, (String)"CompanyOrgUnitMutilF7"));
        f7CompanyOrgUnit.setPermItemName(this.getViewPermission());
        f7CompanyOrgUnit.setUseCache(true);
        f7CompanyOrgUnit.setNeedWait4UIOpen(false);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("numberFrom", (Component)this.prmtNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("numberTo", (Component)this.prmtNumberTo));
        elements.add((FilterElement)new SingleFilterElement("purchaseOrgUnit.number", (Component)this.prmtPurORG));
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStroageUnitStart));
        elements.add((FilterElement)new SingleFilterElement("materialNumFrom", (Component)this.prmtMaterialNumFrom));
        elements.add((FilterElement)new SingleFilterElement("materialNumTo", (Component)this.prmtMaterialNumTo));
        elements.add((FilterElement)new SingleFilterElement("purchaseType", (Component)this.ComboPurchaseType));
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("companyOrgUnitNumber", f7CompanyOrgUnit, this.prmtCompanyOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"CompanyOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("adminOrgUnitNumber", (Component)this.prmtAdminOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("proposerFrom", (Component)this.prmtProposerFrom));
        elements.add((FilterElement)new SingleFilterElement("proposerTo", (Component)this.prmtProposerTo));
        SingleFilterElement element = new SingleFilterElement("bizDateFrom", (Component)this.pkBizDateFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("bizDateTo", (Component)this.pkBizDateTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "companyOrgUnit.id");
        this.setBizOrgF7ByType(this.prmtStroageUnitStart, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setBizOrgF7ByType(this.prmtReceivedOrgUnit, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setBizOrgF7ByType(this.prmtAdminOrgUnit, OrgType.Admin, this.getMainBizOrgType(), true);
        this.setBizOrgF7ByType(this.prmtUseAdminOrgUnit, OrgType.Admin, this.getMainBizOrgType(), true);
        this.prmtStroageUnitStart.setEnabledMultiSelection(false);
        this.prmtReceivedOrgUnit.setEnabledMultiSelection(false);
        this.prmtAdminOrgUnit.setEnabledMultiSelection(false);
        this.prmtUseAdminOrgUnit.setEnabledMultiSelection(false);
        this.setBizMaterialF7(this.prmtMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialNumTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtPurORG, this.prmtStroageUnitStart, this.prmtReceivedOrgUnit, this.prmtAdminOrgUnit, this.prmtUseAdminOrgUnit, this.prmtMaterialNumFrom, this.prmtMaterialNumTo});
        this.prmtPurORG.setDisplayFormat("$number$");
        this.prmtPurORG.setEditFormat("$number$");
        this.prmtPurORG.setEnabled(true);
        this.setBizOrgF7ByType(this.prmtPurORG, OrgType.Purchase, this.getMainBizOrgType(), false);
    }

    public boolean verify() {
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.pkBizDateFrom.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.pkBizDateTo.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.pkBizDateFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.pkBizDateTo.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.pkBizDateTo.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void onLoad() throws Exception {
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        super.onLoad();
        FilterInfo numberFilterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.NOTEQUALS);
        FilterItemInfo item2 = new FilterItemInfo("baseStatus", (Object)new Integer(2), CompareType.NOTEQUALS);
        numberFilterInfo.getFilterItems().add(item);
        numberFilterInfo.getFilterItems().add(item2);
        this.addF7Filter(this.prmtNumberFrom, numberFilterInfo);
        this.addF7Filter(this.prmtNumberTo, numberFilterInfo);
        FilterInfo materialFilterInfo = new FilterInfo();
        FilterItemInfo materialItem = new FilterItemInfo("status", (Object)"1", CompareType.EQUALS);
        materialFilterInfo.getFilterItems().add(materialItem);
        this.addF7Filter(this.prmtMaterialNumFrom, materialFilterInfo);
        this.addF7Filter(this.prmtMaterialNumTo, materialFilterInfo);
        Calendar c = Calendar.getInstance();
        if (this.pkBizDateFrom.getValue() != null && this.pkBizDateFrom.getValue() instanceof Date) {
            c.setTime((Date)this.pkBizDateFrom.getValue());
        }
        c.set(2, c.get(2) - 1);
        this.pkBizDateFrom.setValue((Object)c.getTime());
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(true);
        this.ComboPurchaseType.setSelectedItem((Object)PurchaseTypeEnum.PURCHASE);
        this.prmtAdminOrgUnit.setCommitFormat("$id$");
        this.prmtAdminOrgUnit.setDisplayFormat("$id$");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkBizDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.pkBizDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.ComboPurchaseType.setSelectedItem((Object)PurchaseTypeEnum.PURCHASE);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    public void afterMainOrgChanged(String ids) {
        this.prmtNumberFrom.setEntityViewInfo(super.setEntityViewInfo(SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id"), "companyOrgUnit.id", ids));
        this.prmtNumberTo.setEntityViewInfo(super.setEntityViewInfo(SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id"), "companyOrgUnit.id", ids));
        FilterInfo numberFilterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.NOTEQUALS);
        FilterItemInfo item2 = new FilterItemInfo("baseStatus", (Object)new Integer(2), CompareType.NOTEQUALS);
        numberFilterInfo.getFilterItems().add(item);
        numberFilterInfo.getFilterItems().add(item2);
        this.addF7Filter(this.prmtNumberFrom, numberFilterInfo);
        this.addF7Filter(this.prmtNumberTo, numberFilterInfo);
        this.setSubContractF7Filters();
    }

    protected String getPropertyOfMainBizOrg() {
        return "companyOrgUnit.id";
    }

    @Override
    protected void ComboPurchaseType_itemStateChanged(ItemEvent e) throws Exception {
        super.ComboPurchaseType_itemStateChanged(e);
        this.setSubContractF7Filters();
    }

    @Override
    protected void prmtMaterialNumFrom_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMaterialNumFrom_dataChanged(e);
    }

    @Override
    protected void prmtMaterialNumTo_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMaterialNumTo_dataChanged(e);
    }

    private void setSubContractF7Filters() {
        PurchaseTypeEnum pt = (PurchaseTypeEnum)this.ComboPurchaseType.getSelectedItem();
        boolean isSubContract = pt != null ? !pt.equals((Object)PurchaseTypeEnum.PURCHASE) : false;
        this.setBillF7(this.prmtNumberFrom, isSubContract);
        this.setBillF7(this.prmtNumberTo, isSubContract);
        this.setMaterialF7(this.prmtMaterialNumFrom, isSubContract);
        this.setMaterialF7(this.prmtMaterialNumTo, isSubContract);
    }

    private void setBillF7(KDBizPromptBox bizSupplierBox, boolean isSubContract) {
        this.addF7Filter(bizSupplierBox, this.getBillFilter(isSubContract));
    }

    private FilterInfo getBillFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        info = isSubContract ? new FilterItemInfo("purchaseType", (Object)new Integer(1)) : new FilterItemInfo("purchaseType", (Object)new Integer(0));
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    private void addF7Filter(KDBizPromptBox bizMaterialBox, FilterInfo filterInfo) {
        if (bizMaterialBox != null) {
            EntityViewInfo entityViewInfo = bizMaterialBox.getEntityViewInfo();
            if (entityViewInfo == null || !FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
            } else {
                try {
                    entityViewInfo.getFilter().mergeFilter(filterInfo, "and");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            bizMaterialBox.setEntityViewInfo(entityViewInfo);
        }
    }

    private void setMaterialF7(KDBizPromptBox bizMaterialBox, boolean isSubContract) {
        bizMaterialBox.setEntityViewInfo(null);
        FilterInfo materialFilterInfo = new FilterInfo();
        FilterItemInfo materialItem = new FilterItemInfo("status", (Object)"1", CompareType.EQUALS);
        materialFilterInfo.getFilterItems().add(materialItem);
        this.addF7Filter(bizMaterialBox, materialFilterInfo);
        this.addF7Filter(bizMaterialBox, this.getMaterialFilter(isSubContract));
    }

    private FilterInfo getMaterialFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        if (isSubContract) {
            info = new FilterItemInfo("isOutsourcedPart", (Object)new Integer(1));
        }
        if (info == null) {
            return null;
        }
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    public void clear() {
        super.getFilterManager().clearAll();
        this.setDefaultValue();
        OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
        if (aOrgUnitInfo != null && this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setValue((Object)new OrgUnitInfo[]{aOrgUnitInfo.castToFullOrgUnitInfo()});
        }
    }

    protected String getViewPermission() {
        return "PurRequestExecuteReportView";
    }
}

