/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.OnWayAmtEnum;
import com.kingdee.eas.scm.im.rpt.client.AbstractStockTransferRptConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class StockTransferRptConditionUI
extends AbstractStockTransferRptConditionUI {
    private static final long serialVersionUID = -5269143866497858337L;
    private boolean firstLoad = true;
    private SCMRptMultiOrgsF7 f7 = null;
    private Object[] fullStorageOrgUnit;
    private String firstCur = null;
    private int amtPrecision = 4;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private static final String permItem = "stocktransferrpt_view";
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;

    public StockTransferRptConditionUI() throws Exception {
        this.addCkBxSimpleNameListener();
        this.prmtStorage.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.firstLoad) {
            this.comboGroupStandard.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StockTransferRptConditionUI.this.comboGroupStandard_itemStateChanged(e);
                }
            });
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.loadGroupStandard();
            InvClientUtils.getMaterialF7ForReportFilterUI(this.prmtMaterialFrom, (Object)this);
            InvClientUtils.getMaterialF7ForReportFilterUI(this.prmtMaterialTo, (Object)this);
            this.prmtMaterialFrom.setEnabledMultiSelection(true);
            F7MaterialMultiUISelectorAdaptor selectorMaterial = (F7MaterialMultiUISelectorAdaptor)this.prmtMaterialFrom.getSelector();
            selectorMaterial.setIsMultiSelect(true);
            SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
            this.f7 = new SCMRptMultiOrgsF7(this.prmtStorage, OrgType.Storage, permItem, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
            this.prmtStorage.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    StockTransferRptConditionUI.access$102(StockTransferRptConditionUI.this, (Object[])StockTransferRptConditionUI.this.f7.getFullData());
                }
            });
            this.initDateCom();
            this.kDRadioAll.setSelected(true);
            this.firstLoad = false;
        }
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.prmtMaterGrFrom.getValue() != null || this.prmtMaterGrTo.getValue() != null) {
            this.prmtMaterGrFrom.setValue(null);
            this.prmtMaterGrTo.setValue(null);
        }
        if (groupInfo != null) {
            IMRptUtils.setBizMaterialGroup(this.prmtMaterGrFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.prmtMaterGrTo, groupInfo.getId().toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void clear() {
        this.prmtMaterGrFrom.setValue(null);
        this.prmtMaterGrTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtStorage.setValue((Object)this.getDefaultMainBizOrg());
        this.ckBxByStatUnit.setSelected(false);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.combolOnWayAmt.setSelectedItem((Object)OnWayAmtEnum.OnWayAmt_All);
        this.initDateCom();
        this.kDRadioAll.setSelected(true);
        this.kDRadioOrder.setSelected(false);
        this.kDRadioStock.setSelected(false);
        try {
            this.loadGroupStandard();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initDateCom() {
        Date date = new Date();
        this.dateTo.setValue((Object)IMRptUtils.getDate(date));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(7, -6);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        this.dateFrom.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("dateFrom", this.dateFrom.getValue());
        para.setObject("dateTo", this.dateTo.getValue());
        para.setObject("materialGroupStandard", this.comboGroupStandard.getSelectedItem());
        para.setObject("materialFrom", this.prmtMaterialFrom.getValue());
        para.setObject("materialTo", this.prmtMaterialTo.getValue());
        para.setObject("matGrFrom", this.prmtMaterGrFrom.getValue());
        para.setObject("matGrTo", this.prmtMaterGrTo.getValue());
        para.setObject("sotrageOrg", this.prmtStorage.getValue());
        para.setObject("fullSotrageOrg", (Object)this.fullStorageOrgUnit);
        this.amtPrecision = 4;
        if (this.firstCur != null) {
            try {
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.firstCur));
                if (currency != null) {
                    this.amtPrecision = currency.getPrecision();
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        para.setInt("amtPrecision", this.amtPrecision);
        para.setObject("ckBxByStatUnit", (Object)this.ckBxByStatUnit.isSelected());
        para.setObject(this.kDRadioAll.getName(), (Object)this.kDRadioAll.isSelected());
        para.setObject(this.kDRadioOrder.getName(), (Object)this.kDRadioOrder.isSelected());
        para.setObject(this.kDRadioStock.getName(), (Object)this.kDRadioStock.isSelected());
        para.setObject("ckBxShowMShortName", (Object)this.ckBxShowMShortName.isSelected());
        para.setObject("shortNameFrom", (Object)this.txtMShortNameFrom.getText());
        para.setObject("shortNameTo", (Object)this.txtMShortNameTo.getText());
        para.setObject("combolOnWayAmt", this.combolOnWayAmt.getSelectedItem());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.dateFrom.setValue(params.getObject("dateFrom"));
        this.dateTo.setValue(params.getObject("dateTo"));
        this.prmtMaterialFrom.setValue(params.getObject("materialFrom"));
        this.prmtMaterialTo.setValue(params.getObject("materialTo"));
        this.comboGroupStandard.setSelectedItem(params.getObject("materialGroupStandard"));
        this.prmtMaterGrFrom.setValue(params.getObject("matGrFrom"));
        this.prmtMaterGrTo.setValue(params.getObject("matGrTo"));
        this.prmtStorage.setValue(params.getObject("sotrageOrg"));
        this.amtPrecision = params.getInt("amtPrecision");
        this.ckBxByStatUnit.setSelected(((Boolean)params.getObject("ckBxByStatUnit")).booleanValue());
        this.kDRadioAll.setSelected(((Boolean)params.getObject(this.kDRadioAll.getName())).booleanValue());
        this.kDRadioOrder.setSelected(((Boolean)params.getObject(this.kDRadioOrder.getName())).booleanValue());
        this.kDRadioStock.setSelected(((Boolean)params.getObject(this.kDRadioStock.getName())).booleanValue());
        this.ckBxByStatUnit.setSelected(((Boolean)params.getObject("ckBxByStatUnit")).booleanValue());
        if ((Boolean)params.getObject("ckBxShowMShortName") != null) {
            this.ckBxShowMShortName.setSelected(((Boolean)params.getObject("ckBxShowMShortName")).booleanValue());
        } else {
            this.ckBxShowMShortName.setSelected(false);
        }
        this.txtMShortNameFrom.setText((String)params.getObject("shortNameFrom"));
        this.txtMShortNameTo.setText((String)params.getObject("shortNameTo"));
        this.combolOnWayAmt.setSelectedItem(params.getObject("combolOnWayAmt"));
    }

    public String getUITitle() {
        return InvClientUtils.getResource("StockTransferMaterialRPT") + "-" + InvClientUtils.getResource("Query");
    }

    private void showError(String error) {
        MsgBox.showError((String)EASResource.getString((String)resClassName, (String)error));
    }

    public boolean verify() {
        if (this.prmtStorage.getValue() == null) {
            this.showError("storageOrgUnitNotNull");
            return false;
        }
        if (this.prmtStorage.getValue() instanceof Object[]) {
            Object[] temp = (Object[])this.prmtStorage.getValue();
            if (temp == null || temp.length == 0 || temp.length == 1 && temp[0] == null) {
                this.showError("storageOrgUnitNotNull");
                return false;
            }
            String[] storageOrgIDs = new String[this.fullStorageOrgUnit.length];
            int size = this.fullStorageOrgUnit.length;
            for (int i = 0; i < size; ++i) {
                storageOrgIDs[i] = ((FullOrgUnitInfo)this.fullStorageOrgUnit[i]).getId().toString();
            }
            try {
                if (!IMRptUtils.checkSameCurrency(storageOrgIDs)) {
                    return false;
                }
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        Date datefrom = (Date)this.dateFrom.getValue();
        Date dateto = (Date)this.dateTo.getValue();
        if (datefrom == null) {
            this.showError("STARTDATE_NOT_NULL");
            return false;
        }
        if (dateto == null) {
            this.showError("END_DATE_NULL");
            return false;
        }
        if (dateto.compareTo(datefrom) < 0) {
            this.showError("END_BEFORE_START");
            return false;
        }
        Date bdate = IMRptUtils.getDate(dateto);
        this.dateTo.setValue((Object)new Date(bdate.getTime() + 86400000L - 1L));
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    StockTransferRptConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    StockTransferRptConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
    }

    protected OrgUnitInfo[] getDefaultMainBizOrg() {
        try {
            OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Storage);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            return IMRptUtils.getDefaultMainBizOrg(currentMainOrg, userId, OrgType.Storage, permItem);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    static /* synthetic */ Object[] access$102(StockTransferRptConditionUI x0, Object[] x1) {
        x0.fullStorageOrgUnit = x1;
        return x1;
    }
}

