/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.StockTransferRptFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractStockTransferRptUI;
import com.kingdee.eas.scm.im.rpt.client.StockTransferRptConditionUI;
import com.kingdee.eas.scm.im.rpt.client.StockTransferRptDetailUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StockTransferRptUI
extends AbstractStockTransferRptUI {
    private static final long serialVersionUID = 4514775218036135494L;
    private static final Logger logger = CoreUIObject.getLogger(StockTransferRptUI.class);
    private static final String TB_ISSUEORGID = "issueOrgID";
    private static final String TB_RECEIPTORGID = "receiptOrgID";
    private static final String TB_MATERIALID = "materialID";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALNUM = "materialNum";
    private static final String TB_ISSUEORGNAME = "issueStorageOrg";
    private static final String TB_ISSUEORGNAME2 = "parentid";
    private static final String TB_RECEIPTORGNAME = "inStorageOrg";
    private boolean firstLoadData = true;
    private int amtPrecision = 4;
    private static final String PERNITEM_PRINT = "stocktransferrpt_print";

    public StockTransferRptUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                StockTransferRptUI.this.tbl_afterDataFill(e);
            }
        });
        this.enableExportExcel(this.tbl);
        this.dateFrom.setEnabled(false);
        this.dateTo.setEnabled(false);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return StockTransferRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        StockTransferRptConditionUI conditionUI = new StockTransferRptConditionUI();
        conditionUI.setSize(508, 300);
        return conditionUI;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected void query() {
        this.dateFrom.setValue(this.params.getObject("dateFrom"));
        this.dateTo.setValue(this.params.getObject("dateTo"));
        this.amtPrecision = this.params.getInt("amtPrecision");
        this.tbl.removeRows();
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.im.rpt.client.StockTransferRptUI";
    }

    public boolean isAsynchronism() {
        return false;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        Boolean ckBxByStatUnit = (Boolean)this.params.getObject("ckBxByStatUnit");
        if (ckBxByStatUnit.booleanValue()) {
            this.tbl.getColumn("baseUnit").getStyleAttributes().setHided(true);
            this.tbl.getColumn("statUnit").getStyleAttributes().setHided(false);
        } else {
            this.tbl.getColumn("statUnit").getStyleAttributes().setHided(true);
            this.tbl.getColumn("baseUnit").getStyleAttributes().setHided(false);
        }
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        RptParams para = new RptParams();
        try {
            if (from == 0 && this.firstLoadData) {
                int freezeCol;
                this.firstLoadData = false;
                para.setObject("dateFrom", this.params.getObject("dateFrom"));
                para.setObject("dateTo", this.params.getObject("dateTo"));
                para.setObject("storageOrg", this.params.getObject("fullSotrageOrg"));
                para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
                para.setObject("kDRadioAll", this.params.getObject("kDRadioAll"));
                para.setObject("kDRadioOrder", this.params.getObject("kDRadioOrder"));
                para.setObject("kDRadioStock", this.params.getObject("kDRadioStock"));
                para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
                para.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
                para.setString("shortNameFrom", this.params.getString("shortNameFrom"));
                para.setString("shortNameTo", this.params.getString("shortNameTo"));
                para.setObject("combolOnWayAmt", this.params.getObject("combolOnWayAmt"));
                Object t = this.params.getObject("materialFrom");
                if (t != null) {
                    para.setObject("materialFrom", t);
                }
                if ((t = this.params.getObject("materialTo")) != null) {
                    para.setString("materialTo", ((MaterialInfo)t).getNumber());
                }
                if ((t = this.params.getObject("matGrFrom")) != null) {
                    para.setObject("matGrFrom", (Object)((MaterialGroupInfo)t));
                }
                if ((t = this.params.getObject("matGrTo")) != null) {
                    para.setObject("matGrTo", (Object)((MaterialGroupInfo)t));
                }
                if ((t = this.params.getObject("materialGroupStandard")) != null) {
                    para.setObject("materialGroupStandard", (Object)((MaterialGroupStandardInfo)t));
                }
                RptParams rp = StockTransferRptFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rp.getString("tempTable"));
                this.tbl.setRowCount(rp.getInt("verticalCount"));
                Boolean ckBxShowMShortName = (Boolean)this.params.getObject("ckBxShowMShortName");
                if (ckBxShowMShortName != null && ckBxShowMShortName.booleanValue()) {
                    this.tbl.getColumn("materialShortName").getStyleAttributes().setHided(false);
                    freezeCol = this.tbl.getColumnIndex("materialShortName");
                    this.tbl.getViewManager().setFreezeView(-1, freezeCol + 1);
                } else {
                    this.tbl.getColumn("materialShortName").getStyleAttributes().setHided(true);
                    freezeCol = this.tbl.getColumnIndex(TB_MATERIALNAME);
                    this.tbl.getViewManager().setFreezeView(-1, freezeCol + 1);
                }
                para.setString("tempTable", this.getTempTable());
                this.initUserConfig();
                RptParams rpt = StockTransferRptFacadeFactory.getRemoteInstance().query(para, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                if (rs.getRowCount() == len) {
                    this.getAllDataOfId();
                }
                this.appendFootRow(rpt);
            } else {
                ArrayList newList = new ArrayList(len);
                if (this.allIdList != null) {
                    for (int i = from; i < from + len && i < this.allIdList.size(); ++i) {
                        newList.add(this.allIdList.get(i));
                    }
                }
                if (newList != null && newList.size() > 0) {
                    para.setString("tempTable", this.getTempTable());
                    RptParams rpt = StockTransferRptFacadeFactory.getRemoteInstance().getDataForIdList(newList, para);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, from, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        if (rowIndex > 0) {
            int rIndex;
            for (rIndex = rowIndex - 1; rIndex > 0 && table.getRow(rIndex) == null; --rIndex) {
            }
            rowIndex = rIndex + 1;
        }
        int rowIndexStart = rowIndex;
        String oldMater = null;
        String newMater = null;
        String oldOrg = null;
        String newOrg = null;
        int qtyPrecision = this.params.getInt("spinQtyPrecission");
        this.amtPrecision = this.params.getInt("spinAmountPrecission");
        while (rs.next()) {
            rs.setValue("FIssueBaseQty", (Object)rs.getBigDecimal("FIssueBaseQty").setScale(qtyPrecision, 4));
            rs.setValue("FReceiptBaseQty", (Object)rs.getBigDecimal("FReceiptBaseQty").setScale(qtyPrecision, 4));
            rs.setValue("FOnWayBaseQty", (Object)rs.getBigDecimal("FOnWayBaseQty").setScale(qtyPrecision, 4));
            rs.setValue("FDamageBaseQty", (Object)rs.getBigDecimal("FDamageBaseQty").setScale(qtyPrecision, 4));
            rs.setValue("FIssueAmt", (Object)rs.getBigDecimal("FIssueAmt").setScale(this.amtPrecision, 4));
            rs.setValue("FDamageAmt", (Object)rs.getBigDecimal("FDamageAmt").setScale(this.amtPrecision, 4));
            rs.setValue("FAllocateQty", (Object)rs.getBigDecimal("FAllocateQty").setScale(qtyPrecision, 4));
            rs.setValue("FExportAmt", (Object)rs.getBigDecimal("FExportAmt").setScale(this.amtPrecision, 4));
            rs.setValue("FImportAmt", (Object)rs.getBigDecimal("FImportAmt").setScale(this.amtPrecision, 4));
            rs.setValue("FOnWayAmt", (Object)rs.getBigDecimal("FOnWayAmt").setScale(this.amtPrecision, 4));
        }
        rs.reset();
        for (int i = 0; i < rs.getRowCount(); ++i) {
            if (i != 0) {
                rs.moveTo(i - 1);
                oldMater = rs.getString("FMaterialID");
                oldOrg = rs.getString("FIssueOrgID");
                rs.moveTo(i);
                newMater = rs.getString("FMaterialID");
                newOrg = rs.getString("FIssueOrgID");
            } else {
                rs.moveTo(i);
                newMater = rs.getString("FMaterialID");
                newOrg = rs.getString("FIssueOrgID");
            }
            IRow row = this.isExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            companyUserObject.setCompanyId(rs.getString("FIssueOrgID"));
            companyUserObject.setName(rs.getString("FIssueStorageName"));
            companyUserObject.setBlockId(rs.getString("FMaterialID"));
            companyUserObject.setExpanded(false);
            int isleaf = rs.getInt("FIsLeaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            if (newMater != null && !newMater.equals(oldMater) || newOrg != null && !newOrg.equals(oldOrg)) {
                companyUserObject.setName(rs.getString("FIssueStorageName"));
            } else {
                companyUserObject.setName("");
                companyUserObject.setisIconEmpty(true);
            }
            companyUserObject.setLevel(rs.getInt("FLevel"));
            handler.setTableRowData(row, rs.toRowArray());
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        this.tbl_afterDataFill(rowIndexStart, rowIndexStart + rs.getRowCount());
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    public void doExpand(SimpleCompanyUserObject companyUserObject, int rowIndex) throws Exception {
        int rowCount = this.getTable().getRowCount();
        if (companyUserObject.isLeaf() || companyUserObject.isIconEmpty()) {
            return;
        }
        this.getTable().setRefresh(false);
        this.isExpand = true;
        if (companyUserObject.isExpanded()) {
            IRow row2;
            String compblockId = companyUserObject.getBlockId();
            for (int i = rowIndex + 1; i < rowCount && (row2 = this.getTable().getRow(i)) != null; ++i) {
                SimpleCompanyUserObject company2 = (SimpleCompanyUserObject)row2.getCell(this.getTreeCol()).getValue();
                if (company2 == null || company2.getLevel() == companyUserObject.getLevel() || company2.getLevel() <= companyUserObject.getLevel()) continue;
                if (!compblockId.equals(company2.getBlockId())) break;
                row2.getStyleAttributes().setHided(true);
                if (company2.getLevel() != companyUserObject.getLevel() || !row2.getStyleAttributes().isHided()) continue;
                row2.getStyleAttributes().setHided(false);
            }
            companyUserObject.setExpanded(false);
        } else if (companyUserObject.isHasExpanded()) {
            this.expandRow(rowIndex);
            companyUserObject.setExpanded(true);
        } else {
            RptParams pp = this.findData(rowIndex, companyUserObject);
            RptRowSet rs = (RptRowSet)pp.getObject("rowset");
            if (pp.getObject("LevelCount") != null) {
                this.insertRowIndex = pp.getInt("LevelCount");
                this.insertRowIndex = this.insertRowIndex == 0 ? rowIndex + 1 : (this.insertRowIndex += rowIndex);
                this.insertRows(rs, this.insertRowIndex, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            } else {
                this.insertRows(rs, rowIndex + 1, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            }
            this.insertRowCount += rs.getRowCount();
            this.getTable().setRowCount(this.getTable().getRowCount() + rs.getRowCount());
            this.setMergeRow(rowIndex);
            companyUserObject.setExpanded(true);
            companyUserObject.setHasExpanded(true);
        }
        this.getTable().setRefresh(true);
        this.getTable().reLayoutAndPaint();
        this.isExpand = false;
    }

    private void setMergeRow(int rowIndex) {
        SimpleCompanyUserObject company2;
        IRow row2;
        int i;
        String treeCol;
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        int mergeRowCount = 0;
        int mergeStartRow = 0;
        IRow row = this.getTable().getRow(rowIndex);
        SimpleCompanyUserObject company = (SimpleCompanyUserObject)row.getCell(treeCol = this.getTreeCol()).getValue();
        if (company == null) {
            return;
        }
        for (i = rowIndex; i >= 0; --i) {
            row2 = this.getTable().getRow(i);
            company2 = (SimpleCompanyUserObject)row2.getCell(treeCol).getValue();
            if (company2 == null) continue;
            if (!company.getBlockId().equals(company2.getBlockId())) break;
            mergeStartRow = i;
        }
        for (i = rowIndex; i < this.getTable().getRowCount() && (row2 = this.getTable().getRow(i)) != null; ++i) {
            company2 = (SimpleCompanyUserObject)row2.getCell(treeCol).getValue();
            if (company2 == null) continue;
            if (company2.getLevel() == 1 && i > rowIndex || !company.getBlockId().equals(company2.getBlockId())) break;
            ++rowIndex;
            ++mergeRowCount;
        }
        int colIndex = 0;
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            for (int i2 = 0; i2 < mergeColumnKeys.length; ++i2) {
                colIndex = this.getTable().getColumn(mergeColumnKeys[i2]).getColumnIndex();
                KDTMergeManager mm = this.getTable().getMergeManager();
                mm.mergeBlock(mergeStartRow, colIndex, rowIndex - 1, colIndex);
            }
        }
    }

    public String getUITitle() {
        return InvClientUtils.getResource("StockTransferMaterialRPT");
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{TB_MATERIALNUM, TB_MATERIALNAME, "materialShortName", "materialModel"};
        return strMergeColKeys;
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        int freezeCol = this.tbl.getColumnIndex(TB_ISSUEORGNAME);
        this.tbl.getViewManager().setFreezeView(-1, freezeCol - 1);
    }

    public void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tbl.getRow(this.getSelectRowIndex());
        if (row == null) {
            return;
        }
        Object temp = row.getCell("index").getValue();
        if (temp == null) {
            return;
        }
        if (temp instanceof Integer && (Integer)temp != 0) {
            return;
        }
        if (temp instanceof BigDecimal && ((BigDecimal)temp).compareTo(InvClientUtils.ZERO) != 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"dateFrom", this.dateFrom.getValue());
        uiContext.put((Object)"dateTo", this.dateTo.getValue());
        uiContext.put((Object)"ISSUEORGID", row.getCell(TB_ISSUEORGID).getValue());
        uiContext.put((Object)"RECEIPTORGID", row.getCell(TB_RECEIPTORGID).getValue());
        uiContext.put((Object)"MATERIALID", row.getCell(TB_MATERIALID).getValue());
        uiContext.put((Object)"MATERIALNAME", row.getCell(TB_MATERIALNAME).getValue());
        uiContext.put((Object)"MATERIALNUM", row.getCell(TB_MATERIALNUM).getValue());
        uiContext.put((Object)"ISSUEORGNAME", row.getCell(TB_ISSUEORGNAME2).getValue());
        uiContext.put((Object)"RECEIPTORGNAME", row.getCell(TB_RECEIPTORGNAME).getValue());
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private int getSelectRowIndex() {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    private String getEditUIName() {
        return StockTransferRptDetailUI.class.getName();
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        int t;
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        pp.setString("FMaterialID", row.getCell(TB_MATERIALID).getValue().toString());
        pp.setString("FParentID", companyUserObject.getCompanyId().toString());
        int level = companyUserObject.getLevel();
        pp.setInt("FLevel", level);
        pp.setString("tempTable", this.getTempTable());
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(pp, -1, -1, this.getTempTable(), (Object)companyUserObject);
        if (level == 1 && (t = result.getInt("LevelCount")) > 100) {
            int rowCount = this.tbl.getRowCount3();
            int s = t - rowCount + rowIndex;
            for (int i = 1; i <= s; ++i) {
                this.tbl.getRow(rowCount + i);
            }
        }
        return result;
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return StockTransferRptFacadeFactory.getRemoteInstance();
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        String scale = PrecisionUtil.getFormatString((int)this.params.getInt("spinQtyPrecission"));
        for (int i = from; i <= last; ++i) {
            this.tbl.getRow(i).getCell("issueQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("inQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("onWayQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("wayDamageQty").getStyleAttributes().setNumberFormat(scale);
        }
    }

    public void tbl_afterDataFill(int rowStart, int rowEnd) {
        int from = rowStart;
        int last = rowEnd;
        String scale = PrecisionUtil.getFormatString((int)this.params.getInt("spinQtyPrecission"));
        String amtScale = PrecisionUtil.getFormatString((int)this.params.getInt("spinAmountPrecission"));
        for (int i = from; i <= last; ++i) {
            if (this.tbl.getRow(i) == null) continue;
            this.tbl.getRow(i).getCell("issueQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("inQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("onWayQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("wayDamageQty").getStyleAttributes().setNumberFormat(scale);
            this.tbl.getRow(i).getCell("stockAmt").getStyleAttributes().setNumberFormat(amtScale);
            this.tbl.getRow(i).getCell("importAmt").getStyleAttributes().setNumberFormat(amtScale);
            this.tbl.getRow(i).getCell("exportAmt").getStyleAttributes().setNumberFormat(amtScale);
            this.tbl.getRow(i).getCell("onWayAmt").getStyleAttributes().setNumberFormat(amtScale);
            this.tbl.getRow(i).getCell("wayDamageAmt").getStyleAttributes().setNumberFormat(amtScale);
        }
    }

    protected void initListener() {
        Object[] listeners = this.getTable().getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            this.getTable().removeKDTMouseListener((KDTMouseListener)listeners[i + 1]);
        }
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3) {
                    KDTMenuManager tm = StockTransferRptUI.this.getMenuManager(StockTransferRptUI.this.getTable());
                    if (tm == null) {
                        return;
                    }
                    KDPopupMenu menu = tm.getMenu();
                    if (menu == null) {
                        menu = new KDPopupMenu();
                    }
                    menu.setUserObject((Object)e);
                    if (e.getButton() == 3 && e.getClickCount() == 1) {
                        menu.show(e.getOriginView(), e.getX(), e.getY());
                    }
                } else {
                    int row = e.getRowIndex();
                    int column = e.getColIndex();
                    if (e.getClickCount() == 1) {
                        StockTransferRptUI.this.cellClicked(row, column, e.getX(), e.getY());
                    } else if (e.getClickCount() == 2) {
                        StockTransferRptUI.this.tblDoubleClicked(row, column, e.getX(), e.getY());
                        try {
                            StockTransferRptUI.this.tbl_tableClicked(e);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                    }
                }
            }
        });
    }

    public String getTreeCol() {
        return TB_ISSUEORGNAME;
    }

    protected KDTable getTable() {
        return this.tbl;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DATE_FROM")).append(" &[DateFrom]");
        sb.append("&|").append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DATE_TO")).append(" &[DateTo]");
        sb.append("&|\u3000&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        DateFormat df = DateFormat.getDateInstance(2);
        String temp = df.format((Date)this.params.getObject("dateFrom"));
        map.put("DateFrom", temp);
        temp = df.format((Date)this.params.getObject("dateTo"));
        map.put("DateTo", temp);
        return map;
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    protected void preparePrintPage(KDTable tblMain) {
        if (this.params.getObject("fullSotrageOrg") != null) {
            Object[] orgs = (Object[])this.params.getObject("fullSotrageOrg");
            for (int i = 0; i < orgs.length; ++i) {
                IMRptUtils.checkHasAuthorized(((FullOrgUnitInfo)orgs[i]).getId().toString(), OrgType.Storage, PERNITEM_PRINT);
            }
        }
        super.preparePrintPage(tblMain);
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams[] cp = ReportQueryConditionHelper.getCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if (this.params == null && cp == null || !useDefaultSolution) {
                this.queryDialog.setHeight(450);
                this.queryDialog.setWidth(508);
                if (this.queryDialog.show()) {
                    CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                    pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                    this.params = rbqp.getCustomCondition();
                    if (pc != null) {
                        this.params.putAll(pc.getCustomCondition().toMap());
                    }
                    ok = true;
                }
            }
            if (this.getUIContext().get("rptParams") == null && cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp[0]);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null && cp[1] != null) {
                    pc.initUIContentLayout();
                    pc.onInit(this.getUIContextInitParams());
                    pc.onLoad();
                    pc.loadFields();
                    pc.setCustomerParams(cp[1]);
                    pc.loadData(null);
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYMANAGEMENT;
    }

    protected IRow appendFootRow(RptParams params) {
        try {
            RptRowSet rs = (RptRowSet)params.getObject("totalset");
            if (rs == null || params == null) {
                return null;
            }
            DefaultKDTableInsertHandler handler = new DefaultKDTableInsertHandler(rs);
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (rs != null && handler != null) {
                this.dropZero(rs, new String[]{"FAllocateQty", "FIssueBaseQty", "FReceiptBaseQty", "FOnWayBaseQty", "FDamageBaseQty", "FIssueAmt", "FExportAmt", "FImportAmt", "FOnWayAmt", "FDamageAmt"}, 0);
                handler.setTableRowData(footRow, rs.toRowArray());
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            E.printStackTrace();
            logger.error((Object)E);
            return null;
        }
    }

    private void dropZero(RptRowSet rs, String[] keys, int key) {
        BigDecimal qty = null;
        Object newQty = null;
        NumberFormat num = NumberFormat.getInstance();
        Object qtyStr = null;
        rs.moveTo(-1);
        while (rs.next()) {
            for (int i = 0; i < keys.length; ++i) {
                qty = rs.getBigDecimal(keys[i]);
                rs.setValue(keys[i], (Object)qty);
            }
        }
        if (key == 0) {
            rs.moveTo(0);
        } else {
            rs.moveTo(-1);
        }
    }
}

