/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.util;

import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RptParamSqlUtil {
    private static Logger logger = Logger.getLogger(RptParamSqlUtil.class);
    public static final String SQL_AND = " AND ";
    public static final String SQL_OR = " OR ";
    public static final String SQL_IN = " IN ";

    public static String getQuerySql(String queryField, Object filterVal) {
        return RptParamSqlUtil.getQuerySql(queryField, filterVal, null, null, CompareType.GREATER_EQUALS);
    }

    public static String getQuerySql(String queryField, Object filterVal, Class<?> clz, String methodName) {
        return RptParamSqlUtil.getQuerySql(queryField, filterVal, clz, methodName, CompareType.GREATER_EQUALS);
    }

    public static String getQuerySql(String queryField, Object filterVal, Class<?> clz, String methodName, CompareType condition) {
        if (filterVal == null) {
            return "";
        }
        try {
            if (filterVal instanceof String) {
                return RptParamSqlUtil.createQuerySql(filterVal, queryField, condition);
            }
            if (clz != null && clz.isInstance(filterVal)) {
                if (StringUtils.isNotBlank((String)methodName)) {
                    Method method = clz.getMethod(methodName, new Class[0]);
                    filterVal = method.invoke(filterVal, new Object[0]);
                }
                return RptParamSqlUtil.createQuerySql(filterVal, queryField, condition);
            }
            if (filterVal instanceof Collection && ((Collection)filterVal).size() > 0) {
                return RptParamSqlUtil.createMultiQuerySql(filterVal, queryField, clz, methodName);
            }
            if (filterVal instanceof Object[] && ((Object[])filterVal).length > 0 && clz != null && clz.isInstance(((Object[])filterVal)[0])) {
                String[] numArray = SCMUtil.getF7Numbers((Object)filterVal);
                if (numArray[0] != null) {
                    return RptParamSqlUtil.createQuerySql(numArray[0], queryField, condition);
                }
                if (numArray[1] != null) {
                    return " and " + queryField + " in (" + numArray[1] + ")";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getQuerySql error", (Throwable)e);
        }
        return "";
    }

    public static String getMaterialGroupQuerySql(Object materialGroupInfo, String field, boolean isNeedOrLikeFilter) {
        StringBuilder queryBuffer = new StringBuilder();
        if (materialGroupInfo instanceof MaterialGroupInfo) {
            queryBuffer.append(SQL_AND).append("(").append(field).append(" >= '").append(((MaterialGroupInfo)materialGroupInfo).getLongNumber()).append("' ");
            if (isNeedOrLikeFilter) {
                queryBuffer.append(SQL_OR).append(field).append(" LIKE '").append(((MaterialGroupInfo)materialGroupInfo).getLongNumber()).append("!%'");
            }
            queryBuffer.append(")");
        } else if (materialGroupInfo instanceof List && ((List)materialGroupInfo).size() > 0) {
            StringBuilder queryInBuilder = new StringBuilder();
            StringBuilder queryOrBuilder = new StringBuilder();
            queryBuffer.append(SQL_AND).append("(").append(field).append(SQL_IN).append("(");
            for (MaterialGroupInfo entry : (List)materialGroupInfo) {
                queryInBuilder.append("'").append(entry.getLongNumber()).append("',");
                queryOrBuilder.append(SQL_OR).append(field).append(" LIKE '").append(entry.getLongNumber()).append("!%' ");
            }
            queryBuffer.append(queryInBuilder.substring(0, queryInBuilder.length() - 1)).append(") ");
            if (isNeedOrLikeFilter) {
                queryBuffer.append(queryOrBuilder.toString());
            }
            queryBuffer.append(")");
        }
        return queryBuffer.toString();
    }

    public static Object getObject(Map<String, Object> map, String filed) {
        if (!map.containsKey(filed)) {
            return null;
        }
        Object obj = map.get(filed);
        if (obj instanceof Collection && ((Collection)obj).size() == 0) {
            return null;
        }
        return obj;
    }

    public static Object getObject(RptParams params, String filed) {
        if (!params.containsKey(filed)) {
            return null;
        }
        Object obj = params.getObject(filed);
        if (obj instanceof Collection && ((Collection)obj).size() == 0) {
            return null;
        }
        if (obj instanceof Object[] && ((Object[])obj).length == 0) {
            return null;
        }
        return obj;
    }

    public static Boolean isNotBlank(RptParams params, String filed) {
        Object val = RptParamSqlUtil.getObject(params, filed);
        if (val instanceof String) {
            return StringUtils.isNotBlank((String)val.toString());
        }
        return val != null;
    }

    private static String createQuerySql(Object filterVal, String filterFiled, CompareType condition) {
        if (StringUtils.isBlank((String)filterVal.toString())) {
            return "";
        }
        String querySql = filterFiled + " " + condition + " '" + filterVal.toString() + "'\t\n";
        return SQL_AND + querySql;
    }

    private static String createMultiQuerySql(Object filterVal, String filterFiled, Class<?> clz, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Collection objectList = (Collection)filterVal;
        Method method = clz == null || StringUtils.isBlank((String)methodName) ? null : clz.getMethod(methodName, new Class[0]);
        StringBuilder queryBuffer = new StringBuilder();
        queryBuffer.append(SQL_AND).append(filterFiled).append(SQL_IN).append("(");
        for (Object obj : objectList) {
            Object result = method == null ? obj : method.invoke(obj, new Object[0]);
            if (result == null || !StringUtils.isNotBlank((String)result.toString())) continue;
            queryBuffer.append("'").append(result.toString()).append("',");
        }
        return queryBuffer.substring(0, queryBuffer.length() - 1) + ") ";
    }
}

