/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteforother.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteforother.InterfaceExecuteLogCollection;
import com.kingdee.shr.inteforother.InterfaceExecuteLogFactory;
import com.kingdee.shr.inteforother.InterfaceExecuteLogInfo;
import com.kingdee.shr.inteforother.InterfaceMainConfigInfo;
import com.kingdee.shr.inteforother.service.AbstractHRInterfaceForOtherService;
import com.kingdee.shr.inteforother.util.HRMainSqlHelper;
import com.kingdee.shr.inteforother.vo.InteMainResult;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRMainReadDefaultService
extends AbstractHRInterfaceForOtherService {
    private static Logger logger = LoggerFactory.getLogger(HRMainReadDefaultService.class);

    @Override
    protected InteMainResult _executeData(Context ctx, InterfaceMainConfigInfo inteMainConfig) throws BOSException, EASBizException {
        String queryImpl = inteMainConfig.getQueryImpl();
        if (logger.isInfoEnabled()) {
            logger.info("HRMainReadDefaultService._executeData: " + queryImpl);
        }
        InteMainResult dataResult = new InteMainResult();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)queryImpl));
        String sqlSource = exec.getSQL();
        int page = inteMainConfig.getInt("page");
        int pageSize = inteMainConfig.getInt("pageSize");
        PagingHelper p = new PagingHelper();
        HRMainSqlHelper.queryTotal(ctx, sqlSource, dataResult);
        String realSql = p.getPagingSqlNoOptmize(ctx, sqlSource, (page - 1) * pageSize, pageSize);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)realSql);
        List<HashMap<String, Object>> rows = HRMainReadDefaultService.getRsListData(rs);
        dataResult.setRows(rows);
        dataResult.setPage(page);
        dataResult.setPageSize(pageSize);
        dataResult.setRecords(rs.size());
        return dataResult;
    }

    @Override
    protected InteMainResult _afterExecuteGetData(Context ctx, InterfaceMainConfigInfo inteMainConfig, InteMainResult result, IObjectPK logPK) throws BOSException, EASBizException {
        long records = result.getRecords();
        String oql = "where id = '" + logPK + "'";
        InterfaceExecuteLogCollection coll = InterfaceExecuteLogFactory.getLocalInstance(ctx).getInterfaceExecuteLogCollection(oql);
        if (coll != null && coll.size() > 0) {
            InterfaceExecuteLogInfo logInfo = coll.get(0);
            logInfo.setDataCount(records);
            logInfo.setIsSuccess(true);
            InterfaceExecuteLogFactory.getLocalInstance(ctx).update(logPK, logInfo);
        }
        return super._afterExecuteGetData(ctx, inteMainConfig, result, logPK);
    }
}

