/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.self.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.self.config.generator.ConfigDataGeneratator;
import com.kingdee.shr.self.model.ConfigData;
import com.kingdee.shr.self.util.HRXmlReader;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class SelfCacheHelper {
    private static final String CACHE_TYPE = "shr.shrSelf";

    private static String querySql() {
        StringBuffer sql = new StringBuffer("select config.fnumber,config.fconfigname,config.fbelongelement,").append(" config.ftemplateurl,config.ferrortemplateurl,config.fservicename,config.fexternaldataclass,config.fparam,").append(" config.fconfig,ext.fconfig fextend").append(" from T_MGR_ManagerConfig config").append(" left join T_MGR_ManagerConfigExt ext on ext.fparentid = config.fid").append(" where config.fstate = 1 and config.fbelongelement = ? ");
        return sql.toString();
    }

    private static ConfigData parseConfig(IRowSet rs, HRXmlReader reader, boolean install) throws SQLException, BOSException {
        ConfigData configData = ConfigDataGeneratator.getInstance().getConfigDta(rs, reader);
        return configData;
    }

    public static ConfigData getConfigData(Context ctx, String belongElement) throws BOSException {
        if (StringUtils.isEmpty((String)belongElement)) {
            return null;
        }
        ConfigData configData = (ConfigData)SelfCacheHelper.getCacheValue(belongElement);
        if (null == configData) {
            configData = SelfCacheHelper.getConfigDataByDB(ctx, belongElement);
        }
        return configData;
    }

    private static ConfigData getConfigDataByDB(Context ctx, String belongElement) throws BOSException {
        ConfigData configData = null;
        HRXmlReader reader = new HRXmlReader();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SelfCacheHelper.querySql(), (Object[])new Object[]{belongElement});
        try {
            while (rs.next()) {
                configData = SelfCacheHelper.parseConfig(rs, reader, true);
                SelfCacheHelper.setCacheValue(belongElement, configData);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return configData;
    }

    private static void setCacheValue(String key, Object value) {
        CacheService.getInstance().put(CACHE_TYPE, key, value);
    }

    private static Object getCacheValue(String key) {
        return CacheService.getInstance().get(CACHE_TYPE, key);
    }

    public static void removeByKey(String key) {
        CacheService.getInstance().remove(CACHE_TYPE, key);
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }
}

