/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.IMessageSendInfo;
import com.kingdee.shr.smsplatform.ISmsTemplate;
import com.kingdee.shr.smsplatform.MessageSendInfoFactory;
import com.kingdee.shr.smsplatform.MessageSendInfoInfo;
import com.kingdee.shr.smsplatform.SmsTemplateCollection;
import com.kingdee.shr.smsplatform.SmsTemplateFactory;
import com.kingdee.shr.smsplatform.app.sendStutusEnum;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import com.kingdee.shr.smsplatform.util.SmsHttpUtils;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSSendEntry {
    private static final Logger log = LoggerFactory.getLogger(SMSSendEntry.class);
    private static final String logPrefix = "SMSSendEntry.sendSMS,";

    public static String maskPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || 11 != phoneNumber.length()) {
            return phoneNumber;
        }
        String prefix = phoneNumber.substring(0, 3);
        String suffix = phoneNumber.substring(7);
        return prefix + "****" + suffix;
    }

    public static Map<String, Object> sendSMS(ISMSStrategy smsStrategy, Context ctx) {
        String label41;
        String errorDesc = label41 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label41", (Context)ctx);
        String smsId = null;
        IMessageSendInfo messageSendInfo = null;
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("code", -1);
        String content = null;
        SmsTemplateCollection messageTemplateColl = null;
        log.error(String.format("%ssms send:[%s],start...", logPrefix, SMSSendEntry.maskPhoneNumber(smsStrategy.getPhone())));
        try {
            if (!smsStrategy.valid(ctx)) {
                String label34 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label34", (Context)ctx);
                maps.put("errMsg", label34);
                return maps;
            }
            String tempNumber = smsStrategy.analyTempNumber(ctx);
            messageSendInfo = MessageSendInfoFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("clouduuid", (Object)tempNumber));
            view.setFilter(filter);
            ISmsTemplate smsTemplate = SmsTemplateFactory.getLocalInstance(ctx);
            messageTemplateColl = smsTemplate.getSmsTemplateCollection(view);
            if (null == messageTemplateColl || 1 != messageTemplateColl.size()) {
                String label37 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label37", (Context)ctx);
                throw new BOSException(label37);
            }
            if (null == messageTemplateColl.get(0) || StringUtils.isBlank((CharSequence)messageTemplateColl.get(0).getTempContent())) {
                String label36 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label36", (Context)ctx);
                throw new BOSException(label36);
            }
            content = smsStrategy.analyContent(messageTemplateColl.get(0).getTempContent(), ctx);
            HashMap<String, String> header = SMSSendEntry.getHeader(ctx);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tempNumber", tempNumber);
            params.put("phone", smsStrategy.getPhone());
            params.put("content", "true".equals(content) ? "" : content);
            String domain = SMSSendEntry.getCloudDomain("'BASE'", ctx);
            if (StringUtils.isBlank((CharSequence)domain)) {
                String label38 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label38", (Context)ctx);
                throw new BOSException(label38);
            }
            String url = domain + "/message/smssend/send";
            String resp = SmsHttpUtils.post(url, header, params);
            JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
            if (null == resultJsonObject || 200 != resultJsonObject.getIntValue("code")) {
                String label35 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label35", (Context)ctx);
                throw new BOSException(label35);
            }
            JSONObject data = JSONObject.parseObject((String)resultJsonObject.getString("data"));
            if (null == data || 0 != data.getIntValue("errorcode")) {
                errorDesc = null == data || StringUtils.isBlank((CharSequence)data.getString("errormsg")) ? label41 : data.getString("errormsg");
                String label40 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label40", (Context)ctx);
                throw new BOSException(String.format(label40, errorDesc));
            }
            smsId = data.getString("data");
            if (StringUtils.isBlank((CharSequence)smsId)) {
                String label42 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label42", (Context)ctx);
                throw new BOSException(label42);
            }
            MessageSendInfoInfo messageSendI = SMSSendEntry.assemMessageSendInfo2Suc(smsStrategy, messageTemplateColl, ctx, content, smsId);
            try {
                messageSendInfo.save((CoreBaseInfo)messageSendI);
            }
            catch (Exception e) {
                if (e instanceof SQLAccessException || e instanceof SQLIntegrityConstraintViolationException) {
                    log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
                }
                throw e;
            }
            maps.put("code", 0);
            String label39 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label39", (Context)ctx);
            maps.put("errMsg", label39);
            maps.put("data", smsId);
        }
        catch (BOSException e) {
            if (null != messageSendInfo) {
                try {
                    if (!StringUtils.isBlank((CharSequence)e.getLocalizedMessage())) {
                        errorDesc = e.getLocalizedMessage();
                    }
                    messageSendInfo.save((CoreBaseInfo)SMSSendEntry.assemMessageSendInfo2Fai(smsStrategy.getPhone(), messageTemplateColl, ctx, content, errorDesc));
                }
                catch (Exception ex) {
                    log.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            maps.put("errMsg", e.getLocalizedMessage());
        }
        catch (Exception e) {
            if (null != messageSendInfo) {
                try {
                    messageSendInfo.save((CoreBaseInfo)SMSSendEntry.assemMessageSendInfo2Fai(smsStrategy.getPhone(), messageTemplateColl, ctx, content, errorDesc));
                }
                catch (Exception ex) {
                    log.error(logPrefix + ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            log.error(logPrefix + e.getMessage(), (Throwable)e);
            maps.put("errMsg", "occur system error,please contact admin\uff01");
        }
        return maps;
    }

    public static HashMap<String, String> getHeader(Context ctx) throws BOSException {
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() > 0) {
                configInfo = coll.get(0);
            }
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("tenantId", configInfo.getServiceID());
            header.put("token", configInfo.getAccessToken());
            return header;
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
            log.error(label0 + e.getMessage(), (Throwable)e);
            throw new BOSException(label0);
        }
    }

    private static MessageSendInfoInfo assemMessageSendInfo2Suc(ISMSStrategy smsStrategy, SmsTemplateCollection messageTemplateColl, Context ctx, String placeholdersVal, String smsId) throws BOSException {
        MessageSendInfoInfo messageSendInfo = new MessageSendInfoInfo();
        messageSendInfo.setPhone(smsStrategy.getPhone());
        messageSendInfo.setAreaCode("86");
        messageSendInfo.setSmsTemplate(messageTemplateColl.get(0));
        messageSendInfo.setPlaceholdersValue(placeholdersVal);
        messageSendInfo.setSmsNumber(smsId);
        messageSendInfo.setSendResultDesc(" ");
        messageSendInfo.setSendStatus(sendStutusEnum.PUSH_SUC);
        messageSendInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        String content = messageTemplateColl.get(0).getTempContent();
        if (null == smsStrategy.getPlaceholders2Var() || 0 == smsStrategy.getPlaceholders2Var().size()) {
            messageSendInfo.setRemark(content);
            return messageSendInfo;
        }
        for (int i = 0; i < placeholdersVal.split("\\|").length; ++i) {
            content = content.replace(smsStrategy.getPlaceholders2Var().get(i), placeholdersVal.split("\\|")[i]);
        }
        messageSendInfo.setRemark(content);
        return messageSendInfo;
    }

    private static MessageSendInfoInfo assemMessageSendInfo2Fai(String phone, SmsTemplateCollection messageTemplateColl, Context ctx, String content, String errorDesc) {
        MessageSendInfoInfo messageSendInfo = new MessageSendInfoInfo();
        try {
            messageSendInfo.setPhone(phone);
            messageSendInfo.setAreaCode("86");
            if (null == messageTemplateColl || 1 != messageTemplateColl.size()) {
                messageSendInfo.setSmsTemplate(null);
            } else {
                messageSendInfo.setSmsTemplate(messageTemplateColl.get(0));
            }
            messageSendInfo.setPlaceholdersValue(content);
            messageSendInfo.setSendResultDesc(errorDesc);
            messageSendInfo.setSendStatus(sendStutusEnum.PUSH_ERR);
            messageSendInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return messageSendInfo;
    }

    public static String getCloudDomain(String stype, Context ctx) throws BOSException {
        try {
            ICloudServiceURLConfig icUrlConfig = CloudServiceURLConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceURLConfigInfo csConfigInfo = icUrlConfig.getCloudServiceURLConfigInfo(" where state=1 and serviceType=" + stype);
            return csConfigInfo.getServiceURL();
        }
        catch (Exception e) {
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            String label43 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label43", (Context)ctx);
            throw new BOSException(label43);
        }
    }
}

