/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.AbstractTaxDraftCalculateFacadeControllerBean;
import com.kingdee.eas.tm.td.AutoCreateRepParamInfo;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftCalculateFacadeFactory;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillInfo;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxDraftReportCalculateParams;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDraftCalculateFacadeControllerBean
extends AbstractTaxDraftCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.TaxDraftCalculateFacadeControllerBean");

    @Override
    protected List _batchCalc(Context ctx, TaxDraftRecordCollection reportCollection, Map param) throws BOSException, EASBizException {
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxDraftRecordInfo reportInfo = reportCollection.get(i);
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0001");
            params.setString("reportType", "report");
            params.setString("IsBatchQueueCalc", "true");
            if (param != null) {
                params.setObject("isCalc", param.get("isCalc"));
                params.setObject("isConfirm", param.get("isConfirm"));
                params.setObject("isTakeData", param.get("isTakeData"));
            } else {
                params.setBoolean("isCalc", true);
            }
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0001", "(" + RptUtil.getReportResource((String)"ReportCalcMsg", (Locale)ctx.getOriginLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        return resultList;
    }

    @Override
    public List batchCalc(Context ctx, TaxOtherReportCollection reportCollection) throws BOSException, EASBizException {
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxOtherReportInfo reportInfo = reportCollection.get(i);
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0001");
            params.setString("reportType", "report");
            params.setString("IsBatchQueueCalc", "true");
            params.setBoolean("isCalc", true);
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0001", "(" + RptUtil.getReportResource((String)"ReportCalcMsg", (Locale)ctx.getOriginLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        return resultList;
    }

    private JobConfig creteJobCfg(Context ctx, ReportBaseInfo reportInfo, String number, String action) {
        String res = "com.kingdee.eas.basedata.common.perf.PerfResource";
        String leftSign = ResourceBase.getString((String)res, (String)"LEFT", (Locale)ctx.getOriginLocale());
        String rightSign = ResourceBase.getString((String)res, (String)"RIGHT", (Locale)ctx.getOriginLocale());
        String title = leftSign + RptUtil.getReportResource((String)"ReportCalcNumber", (Locale)ctx.getOriginLocale()) + reportInfo.getNumber();
        title = title + " " + RptUtil.getReportResource((String)"ReportCalcName", (Locale)ctx.getOriginLocale()) + reportInfo.getName() + rightSign + action;
        String taskType = reportInfo.getId().toString();
        JobConfig jobCfg = new JobConfig();
        jobCfg.setNumber(number);
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setTaskType(taskType);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex("rptcalculate");
        return jobCfg;
    }

    @Override
    protected Map _batchSave(Context ctx, TaxDraftRecordCollection reportCollection, Map param) throws BOSException, EASBizException {
        String recordType = RecordTypeEnum.DraftItem.getAlias();
        if (param != null && param.get("recordType") != null) {
            recordType = (String)param.get("recordType");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map> resultList = new ArrayList<Map>();
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxDraftRecordInfo reportInfo = reportCollection.get(i);
            if (DraftStatusEnum.AUDIT.equals((Object)reportInfo.getDraftStatus())) {
                errorMsg.add(reportInfo.getNumber() + ":" + TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "CONFIRM_NOT_AUDIT", TDUtils.getLocale(), new Object[]{recordType}));
                continue;
            }
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0003");
            params.setString("reportType", "report");
            if (param != null) {
                params.setObject("isCalc", param.get("isCalc"));
                params.setObject("isConfirm", param.get("isConfirm"));
                params.setObject("isTakeData", param.get("isTakeData"));
            } else {
                params.setBoolean("isConfirm", true);
            }
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0003", "(" + TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportConfirm", ctx.getLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        result.put("retMsg", ((Object)resultList).toString());
        result.put("errorMsg", errorMsg);
        return result;
    }

    @Override
    protected Map _batchSave(Context ctx, TaxOtherReportCollection reportCollection) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<Map> resultList = new ArrayList<Map>();
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxOtherReportInfo reportInfo = reportCollection.get(i);
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0003");
            params.setString("reportType", "report");
            params.setString("permItem", "td_taxotherreport_comfire_save");
            params.setString("logItem", "taxotherreport_comfire_save");
            params.setBoolean("isConfirm", true);
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0003", "(" + TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportConfirm", ctx.getLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        result.put("retMsg", ((Object)resultList).toString());
        return result;
    }

    private String getTdResource(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getTdResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getTaxDraftResource(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getTaxDraftResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)key, (Locale)ctx.getLocale());
    }

    private void buildDraftBillInfo(String fieldKey, Object fieldValue, TaxDraftConfirmBillInfo info) throws ParseException {
        if (fieldValue == null) {
            return;
        }
        if ("companyOrgUnit".equals(fieldKey)) {
            info.setDescription(fieldValue.toString());
        } else if ("itemNumber".equals(fieldKey)) {
            info.setItemNumber(fieldValue.toString());
        } else if ("itemName".equals(fieldKey)) {
            info.setItemName(fieldValue.toString());
        } else if ("startDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            info.setStartDate((Date)fieldValue);
        } else if ("endDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            info.setEndDate((Date)fieldValue);
        } else if ("amount".equals(fieldKey)) {
            info.setAmount(new BigDecimal(fieldValue.toString()));
        }
    }

    @Override
    protected List _batchTakeData(Context ctx, TaxDraftRecordCollection reportCollection, Map param) throws BOSException, EASBizException {
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxDraftRecordInfo reportInfo = reportCollection.get(i);
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0002");
            params.setString("reportType", "report");
            if (param != null) {
                params.setObject("isCalc", param.get("isCalc"));
                params.setObject("isConfirm", param.get("isConfirm"));
                params.setObject("isTakeData", param.get("isTakeData"));
            } else {
                params.setBoolean("isTakeData", true);
            }
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0002", "(" + TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportTakeData", ctx.getLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        return resultList;
    }

    @Override
    protected Map _autoCreateReport(Context ctx, Map params) throws BOSException, EASBizException {
        List paramsList = (List)params.get("paramsList");
        boolean isCalc = (Boolean)params.get("isCalc");
        boolean isConfirm = (Boolean)params.get("isConfirm");
        boolean isTakeData = (Boolean)params.get("isTakeData");
        TaxDraftRecordCollection draftColl = new TaxDraftRecordCollection();
        TaxDraftRecordCollection accountColl = new TaxDraftRecordCollection();
        ArrayList<String> exceptionList = new ArrayList<String>();
        HashMap paramMap = new HashMap();
        int successCount = 0;
        ITaxDraftRecord factory = TaxDraftRecordFactory.getLocalInstance(ctx);
        for (int i = 0; i < paramsList.size(); ++i) {
            AutoCreateRepParamInfo paramInfo = (AutoCreateRepParamInfo)paramsList.get(i);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)paramInfo.getCompanyOrgID(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)paramInfo.getTaxTypeID(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)paramInfo.getPeriodID(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)paramInfo.getRecordType(), CompareType.EQUALS));
            ev.setFilter(filter);
            ev.setSelector(TDSelectorFactory.getTaxDraftRecordSelectors());
            TaxDraftRecordCollection recordColl = factory.getTaxDraftRecordCollection(ev);
            if (recordColl.size() > 0) {
                for (int j = 0; j < recordColl.size(); ++j) {
                    TaxDraftRecordInfo oldInfo = recordColl.get(j);
                    TaxDraftRecordInfo newInfo = this.getNewRecordInfo(ctx, paramInfo, oldInfo);
                    try {
                        factory.save((CoreBaseInfo)newInfo);
                        ++successCount;
                    }
                    catch (Exception e) {
                        exceptionList.add(e.getMessage());
                    }
                    if (0 == newInfo.getRecordType().getValue()) {
                        accountColl.add(newInfo);
                        continue;
                    }
                    draftColl.add(newInfo);
                }
                continue;
            }
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(paramInfo.getCompanyOrgID()));
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(paramInfo.getPeriodID()));
            exceptionList.add(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", "ReportNotExists", ctx.getLocale(), new Object[]{company.getName(), periodInfo.getNumber() + ""}));
        }
        if (draftColl.size() > 0) {
            TaxDraftCalculateFacadeFactory.getLocalInstance(ctx).batchCalc(draftColl, params);
        }
        if (accountColl.size() > 0) {
            TaxDraftCalculateFacadeFactory.getLocalInstance(ctx).batchTakeData(accountColl, params);
        }
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("exceptionList", exceptionList);
        ret.put("successCount", Integer.valueOf(successCount));
        return ret;
    }

    public TaxDraftRecordInfo getNewRecordInfo(Context ctx, AutoCreateRepParamInfo paramInfo, TaxDraftRecordInfo oldInfo) throws EASBizException, BOSException {
        String targetPeriondID = paramInfo.getTargetPeriondID();
        PeriodInfo targetPeriodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(targetPeriondID));
        TaxDraftRecordInfo newInfo = oldInfo;
        newInfo.setId(BOSUuid.create((String)"2A607F02"));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = oldInfo.getNumber() + targetPeriodInfo.getNumber();
        try {
            number = iCodingRuleManager.getNumber((IObjectValue)newInfo, newInfo.getCompanyOrgUnit().getId().toString(), "ownerMenu", "ownerMenu");
        }
        catch (CodingRuleException codingRuleException) {
            // empty catch block
        }
        newInfo.setNumber(number);
        newInfo.setName(oldInfo.getName());
        newInfo.setRptPeriod(targetPeriodInfo);
        newInfo.setRptPeriodFrom(null);
        newInfo.setRptPeriodTo(null);
        newInfo.setRelateRecordAccount(null);
        Date startDate = targetPeriodInfo.getBeginDate();
        Timestamp endDate = targetPeriodInfo.getEndDate();
        newInfo.setStartDate(startDate);
        newInfo.setEndDate(endDate);
        newInfo.setYear(targetPeriodInfo.getPeriodYear());
        newInfo.setPeriod((short)targetPeriodInfo.getPeriodNumber());
        newInfo.setRelateRecord(null);
        newInfo.setIsVoucher(false);
        newInfo.setVoucherID(null);
        newInfo.setVoucherNumber(null);
        newInfo.setVoucherType(null);
        newInfo.setAuditor(null);
        newInfo.setAuditTime(null);
        newInfo.setDraftStatus(DraftStatusEnum.SAVE);
        newInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        newInfo.setCreateTime(new Timestamp(new Date().getTime()));
        newInfo.setLastUpdateUser(null);
        newInfo.setLastUpdateTime(null);
        return newInfo;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxType.id"));
        sic.add(new SelectorItemInfo("taxType.number"));
        sic.add(new SelectorItemInfo("taxType.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        return sic;
    }

    @Override
    protected List _batchCalcReport(Context ctx, TaxDraftRecordCollection reportCollection, boolean isTakeData, boolean isCalc, boolean isConfirm) throws BOSException, EASBizException {
        TaxDraftReportCalculateParams params = null;
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 0; i < reportCollection.size(); ++i) {
            params = new TaxDraftReportCalculateParams();
            TaxDraftRecordInfo reportInfo = reportCollection.get(i);
            params.setObject("CompanyInfo", ContextUtil.getCurrentFIUnit((Context)ctx));
            params.setObject("UserInfo", ctx.get((Object)"UserInfo"));
            params.setString("reportInfoId", reportInfo.getId().toString());
            params.setObject("reportInfo", reportInfo);
            params.setString("transactionName", "TD_CALC_0002");
            params.setString("reportType", "report");
            params.setBoolean("isTakeData", isTakeData);
            params.setBoolean("isCalc", isCalc);
            params.setBoolean("isConfirm", isConfirm);
            JobConfig jobCfg = this.creteJobCfg(ctx, reportInfo, "TD_CALC_0002", "(" + TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportTakeData", ctx.getLocale()) + ")");
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) continue;
            Map jobMap = iJob.executeJob(new JobParam((Object)params), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            resultList.add(jobMap);
        }
        return resultList;
    }
}

