/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.tm.td.account.engine.util.AccountUtil;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class KsqlUtil {
    public static String createTempTableWithNewTx(Context ctx, String createSql) throws BOSException {
        try {
            Method method = KsqlUtil.class.getDeclaredMethod("createTempTable4NewTx", Context.class, String.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new KsqlUtil());
            Object value = txInvoker.invoke(method, new Object[]{ctx, createSql}, 3);
            return value.toString();
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    String createTempTable4NewTx(Context ctx, String createSql) throws BOSException {
        return KsqlUtil.createTempTable(ctx, createSql);
    }

    public static void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            KsqlUtil.execute(statement, sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static void execute(Connection conn, String[] sql) throws BOSException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer(64);
        try {
            statement = conn.createStatement();
            KsqlUtil.execute(statement, sql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    private static void execute(Statement statement, String[] sql) throws SQLException {
        StringBuffer sqlstr = new StringBuffer(64);
        if (!AccountUtil.isEmpty(sql)) {
            int n = sql.length;
            for (int i = 0; i < n; ++i) {
                statement.addBatch(sql[i]);
                sqlstr.append(sql[i]).append("\r\n");
            }
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    public static int getDBType(Context ctx) throws BOSException {
        int dbType = 0;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return dbType;
    }

    public static int getDBType(Connection con) throws BOSException {
        int dbType = 0;
        try {
            dbType = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return dbType;
    }

    public static boolean isOracle(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 2 || dbType == 7 || dbType == 8;
    }

    public static boolean isDB2(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 1;
    }

    public static boolean isSQLServer(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 3;
    }
}

