/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.formula;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaColumnParams;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaParams;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.cloud.utils.CheckFormulaUtil;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaHelper {
    private static Logger logger = Logger.getLogger(FormulaHelper.class);
    public static final String ACCOUNT_FORMULA_PARAMS = "AccountFormulaParams";
    public static final String DIVIDE_SPLIT_CHAR = "_\\$\\$_";
    public static final String DIVIDE_CHAR = "_$$_";

    public static Object[][] getSheetData(Sheet sheet, AccountConfigInfo config) {
        int rowFrom = config.getFillRow() > 0 ? config.getFillRow() - 1 : config.getFillRow();
        int rowTo = sheet.getRows().getMaxIntMark();
        int colFrom = config.getFillColumn() > 0 ? config.getFillColumn() - 1 : config.getFillColumn();
        int colTo = colFrom + config.getEntry().size();
        if (rowTo - rowFrom == 0) {
            return null;
        }
        Object[][] data = new Object[rowTo - rowFrom][colTo - colFrom];
        Object[] rowData = null;
        int columnSize = config.getEntry().size();
        for (int i = rowFrom + 1; i <= rowTo; ++i) {
            rowData = new Object[columnSize];
            for (int j = colFrom; j < colTo; ++j) {
                rowData[j - colFrom] = sheet.getRange(i, j).getValue().getValue();
            }
            data[i - (rowFrom + 1)] = rowData;
        }
        return data;
    }

    public static Book initBook(Context ctx, TaxDraftRecordInfo reportInfo) throws BOSException, EASBizException {
        Book book = null;
        if (reportInfo.getData() != null) {
            try {
                book = reportInfo.getBook();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            book = Book.Manager.getNewBook((String)"Sheet1", (int)3);
        }
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        adapter.initReportProperties((IObjectValue)reportInfo, ctx);
        try {
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return book;
    }

    public static List<Object[]> getVolidData(Context ctx, AccountConfigInfo configInfo, Object[][] sheetData, String formula, String formulaMask) throws BOSException, EASBizException {
        List<Object> volidData = new ArrayList<Object[]>();
        if (sheetData == null) {
            return volidData;
        }
        if (StringUtils.isEmpty((String)formula)) {
            volidData = Arrays.asList(sheetData);
        } else {
            List<Boolean> resultList = FormulaHelper.checkBatchDataFormula(ctx, sheetData, configInfo, formula, formulaMask);
            int size = resultList.size();
            for (int i = 0; i < size; ++i) {
                if (!resultList.get(i).booleanValue()) continue;
                volidData.add(sheetData[i]);
            }
        }
        return volidData;
    }

    public static List<Object[]> getUniqueData(Context ctx, AccountConfigInfo configInfo, List<Object[]> volidData, String uniqueField) throws BOSException, EASBizException {
        ArrayList<Object[]> uniqueData = new ArrayList<Object[]>();
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Object[] rowData2 = null;
        List<String> dimFields = Arrays.asList(uniqueField.split(","));
        String dimKey = null;
        int index = -1;
        for (Object[] rowData2 : volidData) {
            dimKey = "";
            for (int i = 0; i < dimFields.size(); ++i) {
                if (i != 0) {
                    dimKey = dimKey + DIVIDE_CHAR;
                }
                index = FormulaHelper.getAccountConfigEntryIndex(configInfo, dimFields.get(i).toString());
                dimKey = dimKey + FormulaHelper.getFieldDimValue(rowData2[index], configInfo.getEntry().get(index).getDataType().getValue());
            }
            if (map.containsKey(dimKey)) continue;
            uniqueData.add(rowData2);
            map.put(dimKey, rowData2);
        }
        return uniqueData;
    }

    public static boolean checkDataFormula(Context ctx, int rowIndex, Object[] rowData, AccountConfigInfo configInfo, String formula, String formulaMask) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rowIndex", rowIndex);
        param.put("rowData", rowData);
        param.put("configInfo", configInfo);
        param.put("filterInfo", FormulaHelper.getFilterInfo(formula, formulaMask));
        return CheckFormulaUtil.computeIfClause(ctx, formula, param, null);
    }

    public static List<Boolean> checkBatchDataFormula(Context ctx, Object[][] sheetData, AccountConfigInfo configInfo, String formula, String formulaMask) throws EASBizException, BOSException {
        HashMap<String, Object> param = null;
        Object[] rowData = null;
        ArrayList<String> clauseFormulaList = new ArrayList<String>();
        String clauseFormula = null;
        logger.error((Object)("FormulaHelper :formula:" + formula + ";formulaMask:" + formulaMask));
        configInfo.getEntry().sort("seq");
        FilterInfo filterInfo = new FilterInfo();
        if (sheetData.length > 0) {
            filterInfo = FormulaHelper.getFilterInfo(formula, formulaMask);
        }
        logger.error((Object)("FormulaHelper :configInfo:" + configInfo));
        logger.error((Object)("FormulaHelper :filterInfo:" + filterInfo.toString()));
        int size = sheetData.length;
        for (int i = 0; i < size; ++i) {
            rowData = sheetData[i];
            param = new HashMap<String, Object>();
            param.put("rowIndex", i);
            param.put("rowData", rowData);
            param.put("configInfo", configInfo);
            param.put("filterInfo", filterInfo);
            clauseFormula = CheckFormulaUtil.getIfClauseFormula(ctx, formula, param, null);
            clauseFormulaList.add(clauseFormula);
        }
        logger.error((Object)("FormulaHelper :clauseFormulaList:" + ((Object)clauseFormulaList).toString()));
        return CheckFormulaUtil.computeIfClause(ctx, clauseFormulaList);
    }

    public static FilterInfo getFilterInfo(String formula, String formulaMask) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)formula)) {
            try {
                filterInfo = new FilterInfo(formula);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            if (!StringUtils.isEmpty((String)formulaMask)) {
                filterInfo.setMaskString(formulaMask);
            }
        }
        return filterInfo;
    }

    public static BigDecimal[] arrayElemSum(BigDecimal[] a, BigDecimal[] b) {
        BigDecimal[] c = new BigDecimal[a.length];
        for (int i = 0; i < a.length; ++i) {
            BigDecimal r;
            c[i] = r = a[i].add(b[i]);
        }
        return c;
    }

    public static ArrayList getBasePointList(Sheet sheet) {
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int columnCount = sheet.getCols().getMaxIntMark() + 1;
        ArrayList<Point> list = new ArrayList<Point>();
        Point point = null;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (!FormulaHelper.isBasePointCell(sheet, i, j)) continue;
                point = new Point(j, i);
                list.add(point);
            }
        }
        return list;
    }

    public static boolean isBasePointCell(Sheet sheet, int rowIndex, int colIndex) {
        Range range = sheet.getRange(rowIndex, colIndex);
        String json = (String)range.getUserObject(ACCOUNT_FORMULA_PARAMS);
        return !StringUtils.isEmpty((String)json);
    }

    public static AccountFormulaParams getParametersFromCell(Sheet sheet, int rowIndex, int colIndex) {
        Range range = sheet.getRange(rowIndex, colIndex);
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        String json = (String)range.getUserObject(ACCOUNT_FORMULA_PARAMS);
        Gson gson = new Gson();
        AccountFormulaParams formulaParams = (AccountFormulaParams)gson.fromJson(json, AccountFormulaParams.class);
        return formulaParams;
    }

    public static void saveBasePointCell(Sheet sheet, Point basePoint, AccountFormulaParams formulaParams) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        Gson gson = new Gson();
        range.setUserObject(ACCOUNT_FORMULA_PARAMS, (Object)gson.toJson((Object)formulaParams));
    }

    public static Point getBasePoint(Sheet sheet, Point point, ArrayList basePointList) {
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            Point element = (Point)basePointList.get(i);
            if (!FormulaHelper.getRectangle(sheet, element).contains(point)) continue;
            return element;
        }
        return null;
    }

    public static Rectangle getRectangle(Sheet sheet, Point basePoint) {
        AccountFormulaParams formulaParams = FormulaHelper.getParametersFromCell(sheet, basePoint.y, basePoint.x);
        if (formulaParams != null) {
            int headWidth = formulaParams.getColCounter();
            int bodyHeight = formulaParams.getRowCounter();
            if (bodyHeight == 0) {
                bodyHeight = 1;
            }
            return new Rectangle(basePoint.x, basePoint.y, headWidth, bodyHeight);
        }
        return null;
    }

    public static int getHeadSize(AccountFormulaParams formulaParams) {
        AccountFormulaColumnParams columnInfo2 = null;
        ArrayList<Integer> headIndexes = new ArrayList<Integer>();
        for (AccountFormulaColumnParams columnInfo2 : formulaParams.getColumnParams()) {
            if (!columnInfo2.getIsVisible()) continue;
            headIndexes.add(columnInfo2.getSeq());
        }
        int size = headIndexes.size();
        if (formulaParams.isInsertSeq()) {
            ++size;
        }
        return size;
    }

    public static List<AccountFormulaColumnParams> getHeadColumns(AccountFormulaParams formulaParams) {
        AccountFormulaColumnParams columnInfo2 = null;
        ArrayList<AccountFormulaColumnParams> headColumns = new ArrayList<AccountFormulaColumnParams>();
        for (AccountFormulaColumnParams columnInfo2 : formulaParams.getColumnParams()) {
            if (!columnInfo2.getIsVisible()) continue;
            headColumns.add(columnInfo2);
        }
        return headColumns;
    }

    public static AccountFormulaColumnParams getColumn(List<AccountFormulaColumnParams> columns, int seq) {
        AccountFormulaColumnParams columnInfo2 = null;
        for (AccountFormulaColumnParams columnInfo2 : columns) {
            if (columnInfo2.getSeq() != seq) continue;
            return columnInfo2;
        }
        return null;
    }

    public static int getColumnIndex(List<AccountFormulaColumnParams> columns, AccountFormulaColumnParams column) {
        AccountFormulaColumnParams myColumn = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            myColumn = columns.get(i);
            if (myColumn.getSeq() != column.getSeq()) continue;
            return i;
        }
        return -1;
    }

    public static int getAccountConfigEntryIndex(AccountConfigInfo configInfo, String name) {
        AccountConfigEntryCollection entry = configInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entry.get(i);
            if (!entryInfo.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static BigDecimal getBigDecimalValue(Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(value.toString());
        }
        return BigDecimal.ZERO;
    }

    public static List<AccountFormulaColumnParams> getMatchColumns(List<AccountFormulaColumnParams> columns) {
        ArrayList<AccountFormulaColumnParams> matchColumns = new ArrayList<AccountFormulaColumnParams>();
        AccountFormulaColumnParams columnInfo2 = null;
        for (AccountFormulaColumnParams columnInfo2 : columns) {
            if (columnInfo2.getMatchField() == null || StringUtils.isEmpty((String)columnInfo2.getMatchField().trim())) continue;
            matchColumns.add(columnInfo2);
        }
        return matchColumns;
    }

    public static List<AccountFormulaColumnParams> getHideColumns(AccountFormulaParams formulaParams) {
        ArrayList<AccountFormulaColumnParams> hideColumns = new ArrayList<AccountFormulaColumnParams>();
        AccountFormulaColumnParams columnInfo2 = null;
        for (AccountFormulaColumnParams columnInfo2 : formulaParams.getColumnParams()) {
            if (columnInfo2.getMatchField() == null || StringUtils.isEmpty((String)columnInfo2.getMatchField().trim()) || columnInfo2.getIsVisible()) continue;
            hideColumns.add(columnInfo2);
        }
        return hideColumns;
    }

    public static Map<String, Object[]> buildMatchDataMap(Object[][] data, List<AccountFormulaColumnParams> matchColumns, AccountFormulaParams formulaParams) {
        HashMap<String, Object[]> dataMap = new HashMap<String, Object[]>();
        Object[] rowData2 = null;
        String key = null;
        Object value = null;
        AccountFormulaColumnParams column = null;
        List<AccountFormulaColumnParams> headColumns = FormulaHelper.getHeadColumns(formulaParams);
        List<AccountFormulaColumnParams> hideColumns = FormulaHelper.getHideColumns(formulaParams);
        ArrayList<AccountFormulaColumnParams> dataColumns = new ArrayList<AccountFormulaColumnParams>();
        dataColumns.addAll(headColumns);
        dataColumns.addAll(hideColumns);
        for (Object[] rowData2 : data) {
            key = "";
            int size = matchColumns.size();
            for (int j = 0; j < size; ++j) {
                column = matchColumns.get(j);
                if (j != 0) {
                    key = key + DIVIDE_CHAR;
                }
                value = rowData2[FormulaHelper.getColumnIndex(dataColumns, column)];
                key = key + FormulaHelper.getFieldDimValue(value, column.getDataType());
            }
            dataMap.put(key, rowData2);
        }
        return dataMap;
    }

    public static String getFieldDimValue(Object value, String dataType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (value != null) {
            if (value instanceof Date || value instanceof Timestamp || value instanceof GregorianCalendar) {
                if (value instanceof GregorianCalendar) {
                    value = ((GregorianCalendar)value).getTime();
                }
                if ("Date".equals(dataType)) {
                    return dateFormat.format(value);
                }
                if ("Timestamp".equals(dataType)) {
                    return timeStampFormat.format(value);
                }
            } else {
                return value.toString();
            }
        }
        return "NULL";
    }

    public static Object getFieldDimValueObject(String value, AccountFormulaColumnParams column) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)value)) {
            if ("Date".equals(column.getDataType())) {
                try {
                    return dateFormat.parse(value);
                }
                catch (ParseException e) {
                    return "";
                }
            }
            if ("Timestamp".equals(column.getDataType())) {
                try {
                    return timeStampFormat.parse(value);
                }
                catch (ParseException e) {
                    return "";
                }
            }
            if ("NULL".equals(value.toString())) {
                return "";
            }
            return value.toString();
        }
        return "";
    }
}

