/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.ITableLocate;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigStatusEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataImportFacadeFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractAccountConfigOrgTreeListUI;
import com.kingdee.eas.tm.td.basedata.client.DataImportWizardUI;
import com.kingdee.eas.tm.td.basedata.client.wizard.AccountConfigWizard;
import com.kingdee.eas.tm.td.basedata.client.wizard.AccountConfigWizardModel;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportTypeEnum;
import com.kingdee.eas.tm.td.utils.OrgTreeBuilder;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.vat.client.VatAccountConfigOrgTreeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AccountConfigOrgTreeListUI
extends AbstractAccountConfigOrgTreeListUI
implements TreeSelectionListener {
    private static final Logger logger = CoreUIObject.getLogger(AccountConfigOrgTreeListUI.class);
    private OrgTreeBuilder builder;
    Map<String, OrgNodeUserDefineInfo> _OrgNodeMap = null;
    public static final String TBL_ID = "id";
    public static final String TBL_STATE = "relation.state";
    public static final String TBL_RELATIONID = "relation.id";
    public static final String TBL_COMPANYID = "company.id";
    private ITableLocate locate;
    private Map selectRelationIdsMap = new HashMap();

    protected OrgType getOrgType() {
        return OrgType.Company;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    protected void initTree() throws Exception {
        this.treeView.setShowControlPanel(false);
        KDTreeNode treeNodeRoot = new KDTreeNode((Object)OrgType.Company);
        treeNodeRoot.removeAllChildren();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)treeNodeRoot));
        this._OrgNodeMap = RptNewUIUtil.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (String[])new String[]{this.getPermissionItem("view")}, (OrgType)this.getOrgType());
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
        OrgUnitInfo orgUnitInfo = null;
        ArrayList<String> existIDs = new ArrayList<String>();
        for (int i = 0; i < orgUnits.length; ++i) {
            orgUnitInfo = orgUnits[i];
            existIDs.add(orgUnitInfo.getId().toString());
        }
        Set<String> keys = this._OrgNodeMap.keySet();
        ArrayList<String> notExistIDs = new ArrayList<String>();
        for (String id : keys) {
            if (existIDs.contains(id)) continue;
            notExistIDs.add(id);
        }
        this.builder = new OrgTreeBuilder(this.treeMain, treeNodeRoot, this._OrgNodeMap);
        this.builder.initOrgTree();
        this.builder.buildOrgTree();
    }

    protected abstract String getPermissionItem(String var1);

    protected abstract AccountTypeInfo getAccountTypeInfo();

    protected Object getRootObject() {
        return this.getRootName();
    }

    public void onLoad() throws Exception {
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.tblMain.setEnabled(false);
        super.onLoad();
        this.treeView.setShowControlPanel(true);
        this.btnImport.addAssistMenuItem((Action)((Object)this.actionPartImport));
        this.builder.selectedOrgNodeByGivenCompany(null);
        this.valueChanged(null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String orgId = "";
        if (treeNode != null && !treeNode.getUserObject().toString().equals(OrgType.Company.getAlias())) {
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)treeNode.getUserObject();
            orgId = orgInfo.getOrgPK();
            return orgId;
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(new FilterInfo());
            this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
            FilterInfo filterInfo = this.getDialogViewFilterForQuery();
            if (filterInfo.getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(true), "AND");
            } else {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(false), "AND");
            }
            this.mainQuery.getFilter().mergeFilter(this.getDialogViewFilterForQuery(), "AND");
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.tblMain.removeRows();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        try {
            OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
            OrgUnitInfo orgUnitInfo = null;
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitInfo = orgUnits[i];
                orgSet.add(orgUnitInfo.getId().toString());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (orgSet.size() == 0) {
            orgSet.add("111111111111111111111111111=");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo(TBL_COMPANYID, orgSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }

    protected void execQuery() {
        try {
            FilterInfo filterInfo = this.getDialogViewFilterForQuery();
            if (filterInfo.getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(true), "AND");
            } else {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(false), "AND");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    protected FilterInfo getDialogViewFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getDialog().getEntityViewInfoResult() != null) {
            filterInfo = this.getDialog().getCommonFilter();
        }
        return filterInfo;
    }

    protected FilterInfo getSelectedNodeFilterForQuery(boolean isSupportAll) {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getSelectedNodeKeyValue() != null) {
            filterInfo.appendFilterItem(TBL_COMPANYID, (Object)this.getSelectedNodeKeyValue());
        } else if (!isSupportAll) {
            filterInfo.getFilterItems().add(new FilterItemInfo(TBL_COMPANYID, (Object)"111111111111111111111111111=", CompareType.EQUALS));
        }
        return filterInfo;
    }

    private Set getAccountIdsByParams(Set orgSet) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)orgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("account.*"));
        view.setSelector(selector);
        OrgToAccountRelationCollection coll = null;
        OrgToAccountRelationInfo relationInfo = null;
        try {
            coll = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                relationInfo = coll.get(i);
                idSet.add(relationInfo.getAccount().getId().toString());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return idSet;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        String orgID = null;
        orgID = action.equals(this.actionAddNew) ? this.getSelectTreeOrgID() : this.getSelectTableOrgID();
        try {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            uiContext.put((Object)"companyInfo", (Object)companyInfo);
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return VatAccountConfigOrgTreeEditUI.class.getName();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return AccountConfigFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add", 0);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"rootName"))) {
            this.getUIContext().put("parentNode", "root");
        }
        if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getText().equals(OrgType.Company.getAlias())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"add_InOrgUnit"));
                SysUtil.abort();
            }
            super.actionAddNew_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("edit", 1);
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("remove", 2);
        if (this.confirmRemove()) {
            String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
            String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("billIds", ids);
            params.put("relationIds", relationIds);
            ArrayList idList = this.getSelectedIdValues();
            ArrayList errorList = new ArrayList();
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            try {
                Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)idList);
                boolean isReqError = TDUtils.isLocked(map);
                if (isReqError) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"LOCK_ERROR"));
                    return;
                }
                errorList = AccountConfigFactory.getRemoteInstance().remove(params);
            }
            finally {
                mutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
            }
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.refresh(e);
        }
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String relationId = (String)row.getCell(TBL_RELATIONID).getValue();
        OrgToAccountRelationInfo relationInfo = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(relationId));
        if (relationInfo.getState().equals((Object)AccountConfigStatusEnum.ACTIVE)) {
            MsgBox.showInfo((String)this.getResource("ActiveNotEdit"));
            SysUtil.abort();
        }
        if (!relationInfo.isIsCompanyAdd()) {
            MsgBox.showInfo((String)this.getResource("MSG_EDIT_ERROR"));
            SysUtil.abort();
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)key);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancelcancel", 2);
        this.prepare4CancelOrCancelCancel();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    private void prepare4CancelOrCancelCancel() {
        this.checkSelected();
        String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
        String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
        this.selectRelationIdsMap = new HashMap();
        for (int i = 0; i < ids.length; ++i) {
            this.selectRelationIdsMap.put(ids[i], relationIds[i]);
        }
    }

    protected void runCancelCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        AccountConfigFactory.getRemoteInstance().active(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void runCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        AccountConfigFactory.getRemoteInstance().inActive(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancel", 2);
        this.prepare4CancelOrCancelCancel();
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    private void checkPermission(String actionType, int authType) throws BOSException, EASBizException {
        String permissionItem = this.getPermissionItem(actionType);
        ArrayList<String> orgList = new ArrayList<String>();
        if (authType == 0) {
            KDTreeNode selectNode = this.getSelectedTreeNode();
            if (selectNode == null || !(selectNode.getUserObject() instanceof OrgNodeUserDefineInfo)) {
                return;
            }
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)selectNode.getUserObject();
            String orgId = orgInfo.getOrgPK();
            orgList.add(orgId);
        } else if (authType == 1) {
            this.checkSelected();
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
            String orgId = (String)row.getCell(TBL_COMPANYID).getValue();
            orgList.add(orgId);
        } else if (authType == 2) {
            this.checkSelected();
            String[] orgIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_COMPANYID);
            orgList.addAll(Arrays.asList(orgIds));
        }
        for (int i = 0; i < orgList.size(); ++i) {
            this.checkPermission(orgList.get(i).toString(), permissionItem);
        }
    }

    private String getSelectTreeOrgID() {
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode == null || !(selectNode.getUserObject() instanceof OrgNodeUserDefineInfo)) {
            return null;
        }
        OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)selectNode.getUserObject();
        String orgId = orgInfo.getOrgPK();
        return orgId;
    }

    private String getSelectTableOrgID() {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String orgId = (String)row.getCell(TBL_COMPANYID).getValue();
        return orgId;
    }

    private void checkPermission(String orgId, String permissionItem) throws EASBizException, BOSException {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    public static boolean isCanModify(String accountID, String companyOrgUnitID, String accountTypeID) throws BOSException {
        OrgToAccountRelationInfo relationInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accountTypeID, CompareType.EQUALS));
        view.setFilter(filter);
        OrgToAccountRelationCollection coll = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationCollection(view);
        return coll.size() <= 0 || (relationInfo = coll.get(0)) == null || relationInfo.getCompanyOrgUnit() == null || relationInfo.isIsCompanyAdd();
    }

    @Override
    public void actionDataSourceSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("datasource", 1);
        String orgID = this.getSelectTableOrgID();
        String accountId = this.getSelectedKeyValue();
        Set dataSourceIds = DataSourceToAccountFactory.getRemoteInstance().getDataSourceByAccount(accountId, null, orgID);
        UIContext uiContext = new UIContext();
        uiContext.put("dataSourceIds", dataSourceIds);
        uiContext.put("accountId", accountId);
        uiContext.put("orgUnitId", null);
        uiContext.put("companyOrgUnitID", orgID);
        uiContext.put("dsType", DSTypeEnum.Account);
        uiContext.put("isCanModify", AccountConfigOrgTreeListUI.isCanModify(accountId, orgID, this.getAccountTypeInfo().getId().toString()));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getDataSourceListUI(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionDataModelSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("getdata", 1);
        String orgID = this.getSelectTableOrgID();
        String accountId = this.getSelectedKeyValue();
        Set dataSourceIds = DataSourceToAccountFactory.getRemoteInstance().getDataSourceByAccount(accountId, null, orgID);
        if (dataSourceIds.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NEED_ADD_DATASOURCE"));
            return;
        }
        UIContext uiContext = new UIContext();
        uiContext.put("dataSourceSet", dataSourceIds);
        uiContext.put("accountId", accountId);
        uiContext.put("orgUnitId", orgID);
        uiContext.put("dsType", DSTypeEnum.Account);
        uiContext.put("isCanModify", AccountConfigOrgTreeListUI.isCanModify(accountId, orgID, this.getAccountTypeInfo().getId().toString()));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getTakeDataContditionListUI(), (Map)uiContext);
        uiWindow.show();
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"import_InOrgUnit"));
            SysUtil.abort();
        }
        if (selectNode.getParent() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"root_noImport"));
            SysUtil.abort();
        }
        TreePath[] paths = this.treeMain.getSelectionPaths();
        ArrayList<String> companyIds = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            KDTreeNode treeNode = (KDTreeNode)paths[i].getLastPathComponent();
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)treeNode.getUserObject();
            String orgId = orgInfo.getOrgPK();
            companyIds.add(orgId);
        }
        ArrayList<DataImportParams> impartParams = new ArrayList<DataImportParams>();
        String companyId2 = null;
        DataImportParams importParam = null;
        for (String companyId2 : companyIds) {
            importParam = new DataImportParams();
            importParam.setImportType(DataImportTypeEnum.ACCOUNT);
            importParam.setCompanyId(companyId2);
            importParam.setAccountTypeID(this.getAccountTypeInfo().getId().toString());
            importParam.setTaxTypeID(null);
            importParam.setImportCuId(null);
            importParam.setDraftItems(null);
            importParam.setAccounts(null);
            importParam.setImportPermItem(this.getPermissionItem("import"));
            impartParams.add(importParam);
        }
        HashMap<String, ArrayList<DataImportParams>> params = new HashMap<String, ArrayList<DataImportParams>>();
        params.put("importParams", impartParams);
        Map ret = DataImportFacadeFactory.getRemoteInstance().dataImport(params);
        int successCount = (Integer)ret.get("successCount");
        List detailList = (List)ret.get("detailList");
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"IMPORT_SUCCESS_FAILED", (Object[])new Object[]{successCount}), (String)TDUtils.buildErrorMsg(detailList), (int)1);
        this.valueChanged(null);
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.locate != null) {
            this.locate.stopLocate();
        }
        this.locate = this.getTableLocate();
        this.tblMain.refresh();
        this.valueChanged(null);
        if (this.locate != null) {
            this.locate.locate();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getKeyFieldName() {
        return TBL_ID;
    }

    protected String getDataSourceListUI() {
        return "com.kingdee.eas.tm.td.basedata.client.DataSourceListUI";
    }

    protected String getTakeDataContditionListUI() {
        return "com.kingdee.eas.tm.td.basedata.client.TakeDataContditionListUI";
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
    }

    @Override
    public void actionPartImport_actionPerformed(ActionEvent e) throws Exception {
        TaxItemTypeInfo taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(this.getAccountTypeInfo().getTaxTypeItem().getId().toString()));
        String taxFlag = taxType.getSimName().toLowerCase();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_IMPORTTYPE, (Object)DataImportTypeEnum.ACCOUNT);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_TAXTYPE, null);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_ACCOUNTTYPE, (Object)this.getAccountTypeInfo());
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_PERMITEM_VIEWCU, (Object)TDPermissionUtil.getAccountConfigPermissionItem("view", taxFlag, false));
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_PERMITEM_VIEWCOMPANY, (Object)TDPermissionUtil.getAccountConfigPermissionItem("import", taxFlag, true));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataImportWizardUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        DataImportWizardUI wizardUI = (DataImportWizardUI)uiWindow.getUIObject();
        if (!wizardUI.isCancel()) {
            HashMap<String, List<DataImportParams>> params = new HashMap<String, List<DataImportParams>>();
            params.put("importParams", wizardUI.getImportParams());
            Map ret = DataImportFacadeFactory.getRemoteInstance().dataImport(params);
            int successCount = (Integer)ret.get("successCount");
            List detailList = (List)ret.get("detailList");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"IMPORT_SUCCESS_FAILED", (Object[])new Object[]{successCount}), (String)TDUtils.buildErrorMsg(detailList), (int)1);
            this.valueChanged(null);
        }
    }

    @Override
    public void actionAddWizard_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add", 0);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"rootName"))) {
            this.getUIContext().put("parentNode", "root");
        }
        if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getText().equals(OrgType.Company.getAlias())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"add_InOrgUnit"));
                SysUtil.abort();
            }
            String orgID = this.getSelectTreeOrgID();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            AccountConfigWizardModel model = new AccountConfigWizardModel();
            model.setUiClassName(this.getEditUIName());
            model.setCompany(companyInfo);
            new AccountConfigWizard((CoreUI)this, model);
            this.refresh(null);
        }
    }
}

