/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractDataImportWizardUI;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportTypeEnum;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataImportWizardUI
extends AbstractDataImportWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(DataImportWizardUI.class);
    public static String UICONTEXT_IMPORTTYPE = "importType";
    public static String UICONTEXT_TAXTYPE = "taxType";
    public static String UICONTEXT_ACCOUNTTYPE = "accountType";
    public static String UICONTEXT_PERMITEM_VIEWCU = "permItem_viewcu";
    public static String UICONTEXT_PERMITEM_VIEWCOMPANY = "permItem_viewcompany";
    private static String ROOT_CU_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private DataChangeListener prmtCUListener = null;
    private TaxItemTypeInfo taxType = null;
    private AccountTypeInfo accountType = null;
    private DataImportTypeEnum importType = null;
    private String permItem_viewcu = null;
    private String permItem_viewcompany = null;
    private String importCuId = null;
    private List<DataImportParams> importParams = null;
    private boolean isCancel = true;
    private Set companyIds = new HashSet();
    private Set cuIds = new HashSet();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initControl();
        this.loadFields();
        this.initParameter();
    }

    private void initContext() throws EASBizException, BOSException {
        this.importType = (DataImportTypeEnum)((Object)this.getUIContext().get(UICONTEXT_IMPORTTYPE));
        this.taxType = (TaxItemTypeInfo)this.getUIContext().get(UICONTEXT_TAXTYPE);
        this.accountType = (AccountTypeInfo)this.getUIContext().get(UICONTEXT_ACCOUNTTYPE);
        this.permItem_viewcu = (String)this.getUIContext().get(UICONTEXT_PERMITEM_VIEWCU);
        this.permItem_viewcompany = (String)this.getUIContext().get(UICONTEXT_PERMITEM_VIEWCOMPANY);
        this.companyIds = TDPermissionUtil.getPermissionUnits(OrgType.Company, this.permItem_viewcompany);
        this.cuIds.add(ROOT_CU_ID);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this.cuIds.add(coll.get(i).getCU().getId().toString());
        }
    }

    private void initControl() {
        this.draftItemContainer.setVisible(DataImportTypeEnum.DRAFTITEM.equals((Object)this.importType));
        this.accountContainer.setVisible(DataImportTypeEnum.ACCOUNT.equals((Object)this.importType));
        this.prmtCompany.setEnabledMultiSelection(true);
    }

    private void initParameter() {
        this.importCuId = ROOT_CU_ID;
        this.prmtCU.setValue((Object)SysContext.getSysContext().getCurrentCtrlUnit());
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListener();
        try {
            this.initFilter();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void removeListener() {
        if (this.prmtCUListener == null) {
            this.prmtCU.removeDataChangeListener(this.prmtCUListener);
        }
    }

    public void initListener() {
        super.initListener();
        if (this.prmtCUListener == null) {
            this.prmtCUListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        DataImportWizardUI.this.prmtCU_dataChanged(eventObj);
                    }
                    catch (Exception e) {
                        DataImportWizardUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtCU.addDataChangeListener(this.prmtCUListener);
    }

    private void prmtCU_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        if (this.prmtCU.getValue() == null) {
            this.prmtCU.setValue(e.getOldValue());
            return;
        }
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtCU.getValue();
        this.clear();
        this.importCuId = ROOT_CU_ID;
        if (this.existsConfig()) {
            this.importCuId = orgUnit.getId().toString();
        }
        this.initCompanyF7Filter();
        this.initDraftItemF7Filter();
        this.initAccountF7Filter();
    }

    private void clear() {
        this.prmtCompany.setValue(null);
        this.prmtDraftItem.setValue(null);
        this.prmtAccount.setValue(null);
    }

    private void initFilter() throws EASBizException, BOSException {
        this.initCuF7Filter();
        this.initCompanyF7Filter();
        this.initDraftItemF7Filter();
        this.initAccountF7Filter();
    }

    private void initCuF7Filter() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.cuIds, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCU.setEntityViewInfo(view);
    }

    private void initCompanyF7Filter() throws EASBizException, BOSException {
        OrgUnitInfo cu = (OrgUnitInfo)this.prmtCU.getValue();
        if (cu == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!ROOT_CU_ID.equals(cu.getId().toString())) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
    }

    private void initDraftItemF7Filter() {
        OrgUnitInfo cu = (OrgUnitInfo)this.prmtCU.getValue();
        if (cu == null || this.taxType == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)this.importCuId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)this.taxType.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtDraftItem.setEntityViewInfo(view);
    }

    private void initAccountF7Filter() {
        OrgUnitInfo cu = (OrgUnitInfo)this.prmtCU.getValue();
        if (cu == null || this.accountType == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)this.importCuId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.accountType.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtAccount.setEntityViewInfo(view);
    }

    private boolean existsConfig() throws EASBizException, BOSException {
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.prmtCU.getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
        if (DataImportTypeEnum.DRAFTITEM.equals((Object)this.importType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)this.taxType.getId().toString(), CompareType.EQUALS));
            return OrgToDraftItemFactory.getRemoteInstance().exists(filter);
        }
        if (DataImportTypeEnum.ACCOUNT.equals((Object)this.importType)) {
            filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.accountType.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            return OrgToAccountRelationFactory.getRemoteInstance().exists(filter);
        }
        return false;
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.prmtCU.getValue() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TDBaseDataResource", (String)"CU"));
        }
        if (this.prmtCompany.getValue() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TDBaseDataResource", (String)"Company"));
        }
        if (this.prmtDraftItem.getValue() == null && DataImportTypeEnum.DRAFTITEM.equals((Object)this.importType)) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TDBaseDataResource", (String)"DraftItem"));
        }
        if (this.prmtAccount.getValue() == null && DataImportTypeEnum.ACCOUNT.equals((Object)this.importType)) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TDBaseDataResource", (String)"Account"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TDBaseDataResource", (String)"NotNull"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.innerStoreFields();
    }

    private void innerStoreFields() {
        List companyIds = TDUtils.getF7Value(this.prmtCompany.getValue());
        ArrayList<DataImportParams> paramsList = new ArrayList<DataImportParams>();
        String companyId2 = null;
        DataImportParams importParam = null;
        for (String companyId2 : companyIds) {
            importParam = new DataImportParams();
            importParam.setImportPermItem(this.permItem_viewcompany);
            importParam.setImportType(this.importType);
            importParam.setCompanyId(companyId2);
            importParam.setAccountTypeID(this.accountType != null ? this.accountType.getId().toString() : null);
            importParam.setTaxTypeID(this.taxType != null ? this.taxType.getId().toString() : null);
            importParam.setImportCuId(this.importCuId);
            importParam.setDraftItems(TDUtils.getF7Value(this.prmtDraftItem.getValue()));
            importParam.setAccounts(TDUtils.getF7Value(this.prmtAccount.getValue()));
            paramsList.add(importParam);
        }
        this.importParams = paramsList;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.storeFields();
        this.isCancel = false;
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    public List<DataImportParams> getImportParams() {
        return this.importParams;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

