/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.TableUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceStastusEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceToCalcFormulaFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.RelationTypeEnum;
import com.kingdee.eas.tm.td.basedata.TakeDataDirectionEnum;
import com.kingdee.eas.tm.td.basedata.client.AbstractDataSourceEditUI;
import com.kingdee.eas.tm.td.basedata.client.CommonDataSourceFilterUI;
import com.kingdee.eas.tm.td.basedata.client.DataSourceEntryEditUI;
import com.kingdee.eas.tm.td.basedata.client.DataTableImportUI;
import com.kingdee.eas.tm.td.basedata.util.EntityDataUtil;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisFacadeFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DataSourceEditUI
extends AbstractDataSourceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataSourceEditUI.class);
    private SelectorListener billSelectorListener;
    private PreChangeListener billPreChangeListener;
    private DataChangeListener changeListener;
    private DefaultKingdeeTreeNode root;
    private DraftItemInfo draftItemInfo;
    private OrgToDraftItemInfo orgToDraftItemInfo;
    private String draftItemId;
    private String orgUnitId;
    private String companyOrgUnitID;
    private String taxTypeId;
    private DataSourceInfo dataSourceInfo;
    private DSTypeEnum dsType;
    private String accountId;
    private String taxAnlsItemID;
    private String dataFetchId;
    private Boolean isCanModify = true;
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private Map btnMap = new HashMap();

    public DataSourceEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        this.draftItemId = (String)this.getUIContext().get("draftItemId");
        this.orgUnitId = (String)this.getUIContext().get("orgUnitId");
        this.dsType = (DSTypeEnum)((Object)this.getUIContext().get("dsType"));
        this.accountId = (String)this.getUIContext().get("accountId");
        this.companyOrgUnitID = (String)this.getUIContext().get("companyOrgUnitID");
        this.taxAnlsItemID = (String)this.getUIContext().get("taxAnlsItemID");
        this.dataFetchId = (String)this.getUIContext().get("dataFetchId");
        this.isCanModify = this.getUIContext().get("isCanModify") == null ? true : (Boolean)this.getUIContext().get("isCanModify");
        super.onLoad();
        if (!this.isCanModify.booleanValue()) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
    }

    private void mainTableChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == e.getOldValue()) {
            return;
        }
        EntityObjectInfo srcEntity = (EntityObjectInfo)this.prmtBillType.getUserObject();
        EntityObjectInfo entityObjectInfo = new EntityObjectInfo();
        entityObjectInfo = EntityDataUtil.getEntryEntityObject(srcEntity);
        this.editData.getEntry().clear();
        this.kDTree2.setModel(null);
        if (srcEntity != null) {
            DataSourceEntryInfo table = this.createNewTableData();
            table.setIsMainTable(true);
            table.setBosType(srcEntity.getType().toString());
            table.setName(srcEntity.getAlias());
            table.setTableName(srcEntity.getTable().getName());
            table.setTableAlias(TDUtils.toLowerCaseFirstOne(srcEntity.getName()));
            table.setParentTable(null);
            table.setJoinCondition(null);
            if (entityObjectInfo != null) {
                this.root = this.addTreeNode(null, table);
                this.kDTree2.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
            } else {
                this.root = this.addTreeNode(null, table);
                this.kDTree2.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
            }
            if (this.txtName.getText() == null) {
                this.txtName.setText(srcEntity.getAlias());
            }
            this.editData.setBillBosType(srcEntity.getType().toString());
            this.editData.getEntry().add(table);
        }
    }

    private String getJoinCondition(EntityObjectInfo srcEntity, EntityObjectInfo destEntity) {
        String parantID = EntityDataUtil.getParentRelFileds(destEntity);
        if (parantID == null) {
            return null;
        }
        String condition = srcEntity.getName() + ".FID=" + destEntity.getName() + "." + parantID;
        return condition;
    }

    private DefaultKingdeeTreeNode addTreeNode(DefaultKingdeeTreeNode parent, DataSourceEntryInfo table) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getName());
        treeNode.setCustomIcon((Icon)ResourceManager.getIcon(TableUI.class, (String)"bos_table.gif"));
        if (parent == null) {
            return treeNode;
        }
        this.kDTree2.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parent);
        this.kDTree2.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.kDTree2.expandAllNodes(true, (TreeNode)this.root);
        return treeNode;
    }

    private DataSourceEntryInfo createNewTableData() {
        DataSourceEntryInfo info = new DataSourceEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setIsMainTable(false);
        info.setParent(this.editData);
        info.setJoinType(RelationTypeEnum.Left_Join);
        return info;
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null && e.getData() instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)e.getData();
            if (entity != null) {
                e.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void initQueryBillF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            EntitySelector selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"choseBill"), EntitySelectorType.FullEntity);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.showUIContent();
        this.innerLoadFileds();
        this.initBtnStatus();
        this.addListener();
    }

    private void initBtnStatus() {
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.btnFilter.setVisible(false);
        this.btnNews.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnFilter.setEnabled(true);
        this.prmtBillType.setEditable(false);
        DataSourceStastusEnum state = this.editData.getState();
        boolean isLight = false;
        if (DataSourceStastusEnum.INACTIVE.equals((Object)state) || DataSourceStastusEnum.SAVE.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (DataSourceStastusEnum.SAVE.equals((Object)state) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
        if (!this.isCanModify.booleanValue()) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
    }

    private void showUIContent() {
        if (this.editData.getId() != null) {
            this.btnState.setSelectedItem((Object)this.editData.getState());
            this.comboDataDirection.setSelectedItem((Object)this.editData.getDataDirection());
        } else {
            this.comboDataDirection.setSelectedItem((Object)TakeDataDirectionEnum.forward);
            this.btnState.setSelectedItem((Object)DataSourceStastusEnum.ADDNEW);
        }
        if (this.draftItemId != null) {
            try {
                this.comboDataDirection.setEnabled(true);
                DraftItemInfo draftItemInfo = DraftItemFactory.getRemoteInstance().getDraftItemInfo((IObjectPK)new ObjectUuidPK(this.draftItemId));
                this.txtDraftItemName.setText(draftItemInfo.getName());
                this.txtDraftItemNumber.setText(draftItemInfo.getNumber());
                this.txtDraftItemNumberContainer.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"DraftItemNumber"));
                this.txtDraftItemNameContainer.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"DraftItemName"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (this.accountId != null) {
            try {
                this.comboDataDirection.setEnabled(false);
                AccountConfigInfo accountInfo = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(this.accountId));
                this.txtDraftItemName.setText(accountInfo.getName());
                this.txtDraftItemNumber.setText(accountInfo.getNumber());
                this.txtDraftItemNumberContainer.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"AccountConfigNumber"));
                this.txtDraftItemNameContainer.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"AccountConfigName"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (this.dataFetchId != null) {
            this.txtDraftItemNumberContainer.setVisible(false);
            this.txtDraftItemNameContainer.setVisible(false);
        } else if (DSTypeEnum.Formula.equals((Object)this.dsType)) {
            this.txtDraftItemNumberContainer.setVisible(false);
            this.txtDraftItemNameContainer.setVisible(false);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && DataSourceStastusEnum.ACTIVE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void innerLoadFileds() {
        try {
            DataSourceEntryInfo mainTable = this.editData.getMainTable();
            if (mainTable != null) {
                this.prmtBillType.setValue((Object)mainTable.getName());
            } else {
                this.prmtBillType.setValue(null);
            }
            this.fillTreeNode(mainTable);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillTreeNode(DataSourceEntryInfo mainTable) {
        if (mainTable == null) {
            this.kDTree2.setModel(null);
            return;
        }
        this.root = this.addTreeNode(null, mainTable);
        this.fillChildrenNode(this.root, mainTable);
        this.kDTree2.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.kDTree2.expandAllNodes(true, (TreeNode)this.root);
    }

    private void fillChildrenNode(DefaultKingdeeTreeNode root, DataSourceEntryInfo table) {
        if (table == null) {
            return;
        }
        try {
            DataSourceEntryCollection coll = table.getChildren(this.editData.getEntry());
            for (int i = 0; i < coll.size(); ++i) {
                DefaultKingdeeTreeNode node = this.addTreeNode(root, coll.get(i));
                DataSourceEntryInfo userInfo = (DataSourceEntryInfo)node.getUserObject();
                if (userInfo.getTableAlias().equals("AccountView")) {
                    return;
                }
                this.fillChildrenNode(node, coll.get(i));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addListener() {
        if (this.billSelectorListener == null) {
            this.billSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    DataSourceEditUI.this.initQueryBillF7(e);
                }
            };
        }
        this.prmtBillType.addSelectorListener(this.billSelectorListener);
        if (this.billPreChangeListener == null) {
            this.billPreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        DataSourceEditUI.this.transBillTypeResult(e);
                        e.setResult(1);
                    }
                    catch (Exception err) {
                        ExceptionHandler.handle((Throwable)err);
                    }
                }
            };
        }
        this.prmtBillType.addPreChangeListener(this.billPreChangeListener);
        if (this.changeListener == null) {
            this.changeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        DataSourceEditUI.this.mainTableChanged(eventObj);
                    }
                    catch (Exception e) {
                        DataSourceEditUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtBillType.addDataChangeListener(this.changeListener);
    }

    private void removeListener() {
        this.prmtBillType.removeSelectorListener(this.billSelectorListener);
        this.prmtBillType.removePreChangeListener(this.billPreChangeListener);
        this.prmtBillType.removeDataChangeListener(this.changeListener);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnState.getSelectedItem().equals((Object)DataSourceStastusEnum.ADDNEW)) {
            this.btnState.setSelectedItem((Object)DataSourceStastusEnum.SAVE);
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData.getState() != null && DataSourceStastusEnum.ACTIVE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        if (this.dsType != null && 0 == this.dsType.getValue()) {
            this.addDSToAccount(pk);
        } else if (this.dsType != null && 2 == this.dsType.getValue()) {
            this.addDSToAnls(pk);
        } else if (this.dsType != null && 3 == this.dsType.getValue()) {
            this.addDSToDataFetch(pk);
        } else if (this.dsType != null && DSTypeEnum.Formula == this.dsType) {
            this.addDSToCalcFormula(pk);
        } else {
            this.addDSToDraftItem(pk);
        }
        super.doAfterSubmit(pk);
    }

    private void addDSToDraftItem(IObjectPK pk) {
        try {
            DraftItemToDataSourceFactory.getRemoteInstance().addDraftItemDataSource(this.orgUnitId, this.draftItemId, pk.toString(), this.companyOrgUnitID);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addDSToAccount(IObjectPK pk) {
        try {
            DataSourceToAccountFactory.getRemoteInstance().addAccountDataSource(this.accountId, pk.toString(), this.orgUnitId, this.companyOrgUnitID);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addDSToCalcFormula(IObjectPK pk) {
        try {
            DataSourceToCalcFormulaFactory.getRemoteInstance().addCalcFormulaDataSource(null, pk.toString(), this.orgUnitId, this.companyOrgUnitID);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addDSToAnls(IObjectPK pk) {
        try {
            TaxAnalysisFacadeFactory.getRemoteInstance().addAnlsDataSource(this.taxAnlsItemID, pk.toString());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addDSToDataFetch(IObjectPK pk) {
        try {
            DataFetchFactory.getRemoteInstance().addDataSourceToDataFetch(this.dataFetchId, pk.toString());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionSetFilter_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        if (this.editData.getId() == null) {
            uiContext.put("filterDataSource", this.editData);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.CommonDataSourceFilterUI", (Map)uiContext);
        CommonDataSourceFilterUI filterPanel = (CommonDataSourceFilterUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!filterPanel.isCancel()) {
            this.editData.setFilterString(filterPanel.getFilterInfo().toString());
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtBillType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"billtype_nonull"));
            this.prmtBillType.requestFocus();
            SysUtil.abort();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue objectValue;
        if (!UtilRequest.isPrepare((String)"ActionCopy", (CoreUIObject)this)) {
            this.checkModified();
        }
        if (this.editData != null && !OprtState.VIEW.equals(this.getOprtState()) && (objectValue = (IObjectValue)this.getUIContext().get("CURRENT.VO")) != null) {
            try {
                String id = this.idList.getID(this.idList.getCurrentIndex());
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.copyDataQueryInfo(this.editData);
        this.unLockUI();
        this.setFieldsNull((AbstractObjectValue)this.editData);
        this.setOprtState("ADDNEW");
        this.setDataObject((IObjectValue)this.editData);
        EventListener[] lsts = this.removeDetailTableListener(KDTPropertyChangeListener.class);
        this.loadFields();
        this.restoreDetailTableListener(KDTPropertyChangeListener.class, lsts);
        this.showCopyAddNew();
        this.actionCopy.setEnabled(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.setDefaultFocused();
    }

    private void copyDataQueryInfo(DataSourceInfo editData) {
        editData.setId(null);
        editData.setNumber(null);
        DataSourceEntryInfo table = null;
        DataSourceEntryInfo otherTable = null;
        DataSourceEntryCollection coll = editData.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            table = coll.get(i);
            BOSUuid oldId = table.getId();
            BOSUuid newId = BOSUuid.create((BOSObjectType)editData.getBOSType());
            table.setId(newId);
            for (int j = 0; j < coll.size(); ++j) {
                otherTable = coll.get(j);
                if (otherTable.getParentTable() == null || !otherTable.getParentTable().getId().equals((Object)oldId)) continue;
                otherTable.setParentTable(table);
            }
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        DataSourceInfo info = (DataSourceInfo)newData;
        info.setNumber(TDUtils.getNumberString());
        info.setName(null);
        info.setState(DataSourceStastusEnum.SAVE);
    }

    protected IObjectValue createNewData() {
        DataSourceInfo info = new DataSourceInfo();
        if (this.draftItemId == null || this.draftItemId.length() > 0) {
            // empty if block
        }
        if (DSTypeEnum.Formula.equals((Object)this.dsType)) {
            info.setType(DSTypeEnum.Formula);
        }
        info.setIsScheduled(false);
        info.setNumber(TDUtils.getNumberString());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataSourceFactory.getRemoteInstance();
    }

    public void checkEditDsEntry() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            SysUtil.abort();
        }
        if (this.prmtBillType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"billtype_nonull"));
            this.prmtBillType.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditDsEntry();
        this.checkSelectPath();
        TreePath path = this.kDTree2.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        DataSourceEntryInfo parent = (DataSourceEntryInfo)node.getUserObject();
        DataSourceEntryInfo table = this.createNewTableData();
        table.setParentTable(parent);
        UIContext uiContext = new UIContext();
        uiContext.put("DataSource", this.editData);
        uiContext.put("DataSourceEntry", table);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataSourceEntryEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataSourceEntryEditUI tableEditUI = (DataSourceEntryEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            this.editData.getEntry().add(table);
            this.addTreeNode(node, table);
            this.kDTree2.repaint();
        }
        super.actionNew_actionPerformed(e);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditDsEntry();
        UIContext uiContext = new UIContext();
        uiContext.put("BosType", this.editData.getBillBosType());
        uiContext.put("DataQuery", this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataTableImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataTableImportUI importUI = (DataTableImportUI)uiWindow.getUIObject();
        if (importUI.isConfirm()) {
            this.fillTreeNode(this.editData.getMainTable());
            this.kDTree2.repaint();
        }
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditDsEntry();
        this.checkSelectPath();
        TreePath path = this.kDTree2.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        DataSourceEntryInfo oldTable = (DataSourceEntryInfo)node.getUserObject();
        DataSourceEntryInfo newTable = (DataSourceEntryInfo)oldTable.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("DataSource", this.editData);
        uiContext.put("DataSourceEntry", newTable);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataSourceEntryEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        DataSourceEntryEditUI tableEditUI = (DataSourceEntryEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            newTable.setParent(this.editData);
            this.editData.getEntry().remove(oldTable);
            this.editData.getEntry().add(newTable);
            this.updateTreeNode(node, newTable);
            this.kDTree2.repaint();
        }
    }

    private void updateTreeNode(DefaultKingdeeTreeNode node, DataSourceEntryInfo table) {
        if (node == null || table == null) {
            return;
        }
        node.setText(table.getName());
        node.setCustomIcon((Icon)ResourceManager.getIcon(TableUI.class, (String)"bos_table.gif"));
        node.setUserObject((Object)table);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditDsEntry();
        this.checkSelectPath();
        TreePath path = this.kDTree2.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        if (this.confirmRemove()) {
            this.deleteTreeNode(node);
            this.kDTree2.removeAllChildrenFromParent((MutableTreeNode)node);
            this.kDTree2.removeNodeFromParent((MutableTreeNode)node);
            this.kDTree2.repaint();
        }
    }

    private void checkSelectPath() {
        TreePath path = this.kDTree2.getSelectionPath();
        if (path == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"121_DataQueryEditUI"));
            SysUtil.abort();
        }
    }

    private void deleteTreeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        for (int i = 0; i < count; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.deleteTreeNode(child);
        }
        DataSourceEntryInfo table = (DataSourceEntryInfo)node.getUserObject();
        this.editData.getEntry().remove(table);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableEdit() {
        if (DataSourceStastusEnum.ACTIVE.equals((Object)this.editData.getState())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"state_saveBanEdit"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() {
        if (DataSourceStastusEnum.ACTIVE.equals((Object)this.editData.getState())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_activeDelete"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("entry.parentTable.*"));
        selector.add(new SelectorItemInfo("entry.parent.*"));
        return selector;
    }
}

