/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataImportFacadeFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemCollection;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractDraftItemOrgTreeListUI;
import com.kingdee.eas.tm.td.basedata.client.DataImportWizardUI;
import com.kingdee.eas.tm.td.basedata.client.DraftItemEditUI;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportTypeEnum;
import com.kingdee.eas.tm.td.utils.OrgTreeBuilder;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class DraftItemOrgTreeListUI
extends AbstractDraftItemOrgTreeListUI
implements TreeSelectionListener {
    private static final Logger logger = CoreUIObject.getLogger(DraftItemOrgTreeListUI.class);
    private OrgTreeBuilder builder;
    Map<String, OrgNodeUserDefineInfo> _OrgNodeMap = null;
    public static final String TBL_ID = "id";
    public static final String TBL_RELATIONID = "relation.id";
    public static final String TBL_COMPANYID = "company.id";
    private Map selectRelationIdsMap = new HashMap();

    protected OrgType getOrgType() {
        return OrgType.Company;
    }

    protected void initTree() throws Exception {
        this.treeView.setShowControlPanel(false);
        KDTreeNode treeNodeRoot = new KDTreeNode((Object)OrgType.Company);
        treeNodeRoot.removeAllChildren();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)treeNodeRoot));
        this._OrgNodeMap = RptNewUIUtil.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (String[])new String[]{this.getPermissionItem("view")}, (OrgType)this.getOrgType());
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
        OrgUnitInfo orgUnitInfo = null;
        ArrayList<String> existIDs = new ArrayList<String>();
        for (int i = 0; i < orgUnits.length; ++i) {
            orgUnitInfo = orgUnits[i];
            existIDs.add(orgUnitInfo.getId().toString());
        }
        Set<String> keys = this._OrgNodeMap.keySet();
        ArrayList<String> notExistIDs = new ArrayList<String>();
        for (String id : keys) {
            if (existIDs.contains(id)) continue;
            notExistIDs.add(id);
        }
        this.builder = new OrgTreeBuilder(this.treeMain, treeNodeRoot, this._OrgNodeMap);
        this.builder.initOrgTree();
        this.builder.buildOrgTree();
    }

    protected abstract String getPermissionItem(String var1);

    protected abstract TaxItemTypeInfo getTaxItemTypeInfo();

    protected Object getRootObject() {
        return this.getRootName();
    }

    public void onLoad() throws Exception {
        this.btnDataSource.setEnabled(true);
        this.btnTakeDataContdition.setEnabled(true);
        this.kDMenuItem1.setEnabled(true);
        this.kDMenuItem2.setEnabled(true);
        this.btnImport.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.tblMain.setEnabled(false);
        super.onLoad();
        this.treeView.setShowControlPanel(true);
        this.btnImport.addAssistMenuItem((Action)((Object)this.actionPartImport));
        this.builder.selectedOrgNodeByGivenCompany(null);
        this.valueChanged(null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("edit", 1);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String relationId = (String)row.getCell(TBL_RELATIONID).getValue();
        OrgToDraftItemInfo relationInfo = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemInfo((IObjectPK)new ObjectUuidPK(relationId));
        if (relationInfo.getState().equals((Object)DraftItemStatus.AWAKEN)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"state_saveBanEdit"));
            SysUtil.abort();
        }
        if (!relationInfo.isIsCompanyAdd()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"MSG_EDIT_ERROR"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        int i;
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"import_InOrgUnit"));
            SysUtil.abort();
        }
        ArrayList<String> companyIds = new ArrayList<String>();
        if (selectNode.getParent() == null) {
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "DraftItemImportConfirm", TDUtils.getLocale())))) {
                int count = this.treeMain.getRowCount();
                for (i = 1; i < count; ++i) {
                    TreePath path = this.treeMain.getPathForRow(i);
                    KDTreeNode node = (KDTreeNode)path.getLastPathComponent();
                    OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)node.getUserObject();
                    String orgId = orgInfo.getOrgPK();
                    companyIds.add(orgId);
                }
            } else {
                SysUtil.abort();
            }
        } else {
            TreePath[] paths = this.treeMain.getSelectionPaths();
            for (i = 0; i < paths.length; ++i) {
                KDTreeNode treeNode = (KDTreeNode)paths[i].getLastPathComponent();
                OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)treeNode.getUserObject();
                String orgId = orgInfo.getOrgPK();
                companyIds.add(orgId);
            }
        }
        ArrayList<DataImportParams> impartParams = new ArrayList<DataImportParams>();
        String companyId2 = null;
        DataImportParams importParam = null;
        for (String companyId2 : companyIds) {
            importParam = new DataImportParams();
            importParam.setImportType(DataImportTypeEnum.DRAFTITEM);
            importParam.setCompanyId(companyId2);
            importParam.setAccountTypeID(null);
            importParam.setTaxTypeID(this.getTaxItemTypeInfo().getId().toString());
            importParam.setImportCuId(null);
            importParam.setDraftItems(null);
            importParam.setAccounts(null);
            importParam.setImportPermItem(this.getPermissionItem("import"));
            impartParams.add(importParam);
        }
        HashMap<String, ArrayList<DataImportParams>> params = new HashMap<String, ArrayList<DataImportParams>>();
        params.put("importParams", impartParams);
        Map ret = DataImportFacadeFactory.getRemoteInstance().dataImport(params);
        int successCount = (Integer)ret.get("successCount");
        List detailList = (List)ret.get("detailList");
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"IMPORT_SUCCESS_FAILED", (Object[])new Object[]{successCount}), (String)TDUtils.buildErrorMsg(detailList), (int)1);
        this.valueChanged(null);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private String getSelectTreeOrgID() {
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode == null || !(selectNode.getUserObject() instanceof OrgNodeUserDefineInfo)) {
            return null;
        }
        OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)selectNode.getUserObject();
        String orgId = orgInfo.getOrgPK();
        return orgId;
    }

    private String getSelectTableOrgID() {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String orgId = (String)row.getCell(TBL_COMPANYID).getValue();
        return orgId;
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String orgId = "";
        if (treeNode != null && !treeNode.getUserObject().toString().equals(OrgType.Company.getAlias())) {
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)treeNode.getUserObject();
            orgId = orgInfo.getOrgPK();
            return orgId;
        }
        return null;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancelcancel", 2);
        this.prepare4CancelOrCancelCancel();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    private void prepare4CancelOrCancelCancel() {
        this.checkSelected();
        String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
        String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
        this.selectRelationIdsMap = new HashMap();
        for (int i = 0; i < ids.length; ++i) {
            this.selectRelationIdsMap.put(ids[i], relationIds[i]);
        }
    }

    protected void runCancelCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        DraftItemFactory.getRemoteInstance().active(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void runCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        DraftItemFactory.getRemoteInstance().inActive(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancel", 2);
        this.prepare4CancelOrCancelCancel();
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add", 0);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"rootName"))) {
            this.getUIContext().put("parentNode", "root");
        }
        if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getText().equals(OrgType.Company.getAlias())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"add_InOrgUnit"));
                SysUtil.abort();
            }
            super.actionAddNew_actionPerformed(e);
        }
    }

    private void checkPermission(String actionType, int authType) throws BOSException, EASBizException {
        String permissionItem = this.getPermissionItem(actionType);
        ArrayList<String> orgList = new ArrayList<String>();
        if (authType == 0) {
            KDTreeNode selectNode = this.getSelectedTreeNode();
            if (selectNode == null || !(selectNode.getUserObject() instanceof OrgNodeUserDefineInfo)) {
                return;
            }
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)selectNode.getUserObject();
            String orgId = orgInfo.getOrgPK();
            orgList.add(orgId);
        } else if (authType == 1) {
            this.checkSelected();
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
            String orgId = (String)row.getCell(TBL_COMPANYID).getValue();
            orgList.add(orgId);
        } else if (authType == 2) {
            this.checkSelected();
            String[] orgIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_COMPANYID);
            orgList.addAll(Arrays.asList(orgIds));
        }
        for (int i = 0; i < orgList.size(); ++i) {
            this.checkPermission(orgList.get(i).toString(), permissionItem);
        }
    }

    private void checkPermission(String orgId, String permissionItem) throws EASBizException, BOSException {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.refresh();
        this.valueChanged(null);
    }

    protected String getEditUIName() {
        return DraftItemEditUI.class.getName();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public static boolean isCanModify(String draftItemID, String companyOrgUnitID, String taxTypeID) throws BOSException {
        OrgToDraftItemInfo relationInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)taxTypeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("draftItem.id", (Object)draftItemID, CompareType.EQUALS));
        view.setFilter(filter);
        OrgToDraftItemCollection coll = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemCollection(view);
        return coll.size() <= 0 || (relationInfo = coll.get(0)) == null || relationInfo.getCompanyOrgUnit() == null || relationInfo.isIsCompanyAdd();
    }

    @Override
    public void actionDataSource_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        String draftItemId = this.getSelectedKeyValue();
        this.checkSelected();
        this.checkPermission("datasource", 1);
        String orgID = this.getSelectTableOrgID();
        if (draftItemId != null && draftItemId.length() > 0) {
            IRowSet res = OrgToDraftItemFactory.getRemoteInstance().getDataSourceByItem(draftItemId, null, orgID);
            HashSet<String> dataSourceIds = new HashSet<String>();
            while (res.next()) {
                dataSourceIds.add(res.getString("dataSourceID"));
            }
            if (dataSourceIds != null && dataSourceIds.size() > 0) {
                uiContext.put("dataSourceIds", dataSourceIds);
            }
            uiContext.put("draftItemId", draftItemId);
            uiContext.put("orgUnitId", null);
            uiContext.put("companyOrgUnitID", orgID);
            uiContext.put("dsType", DSTypeEnum.DraftItem);
            uiContext.put("isCanModify", DraftItemOrgTreeListUI.isCanModify(draftItemId, orgID, this.getTaxItemTypeInfo().getId().toString()));
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.DataSourceListUI", (Map)uiContext);
            uiWindow.show();
        }
        super.actionDataSource_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("remove", 2);
        if (this.confirmRemove()) {
            String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
            String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("billIds", ids);
            params.put("relationIds", relationIds);
            ArrayList idList = this.getSelectedIdValues();
            ArrayList errorList = new ArrayList();
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            try {
                Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)idList);
                boolean isReqError = TDUtils.isLocked(map);
                if (isReqError) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"LOCK_ERROR"));
                    return;
                }
                errorList = DraftItemFactory.getRemoteInstance().remove(params);
            }
            finally {
                mutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
            }
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.refresh(e);
        }
    }

    @Override
    public void actionTakeDataContdition_actionPerformed(ActionEvent e) throws Exception {
        Set dataSourceIds;
        this.checkSelected();
        UIContext uiContext = new UIContext();
        String draftItemID = this.getSelectedKeyValue();
        String orgID = this.getSelectTableOrgID();
        this.checkPermission("getdata", 1);
        if (draftItemID == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            SysUtil.abort();
        }
        if ((dataSourceIds = DraftItemToDataSourceFactory.getRemoteInstance().getDataSourceByParam(null, draftItemID, orgID)).size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NEED_ADD_DATASOURCE"));
            return;
        }
        uiContext.put("draftItemId", draftItemID);
        uiContext.put("orgUnitId", orgID);
        uiContext.put("dataSourceSet", dataSourceIds);
        uiContext.put("dsType", DSTypeEnum.DraftItem);
        uiContext.put("isCanModify", DraftItemOrgTreeListUI.isCanModify(draftItemID, orgID, this.getTaxItemTypeInfo().getId().toString()));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.TakeDataContditionListUI", (Map)uiContext);
        uiWindow.show();
    }

    private Set getSelectTreeNodes() {
        if (this.getSelectedTreeNode().getUserObject().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.bd.DraftItemResource", (String)"rootName"))) {
            this.getUIContext().put("parentNode", "root");
        } else if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode().getText().equals(OrgType.Company.getAlias())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.bd.DraftItemResource", (String)"add_InOrgUnit"));
                SysUtil.abort();
            }
            OrgNodeUserDefineInfo orgUserDefineInfo = (OrgNodeUserDefineInfo)this.getSelectedTreeNode().getUserObject();
            String string = orgUserDefineInfo.getOrgPK();
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(new FilterInfo());
            this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
            FilterInfo filterInfo = this.getDialogViewFilterForQuery();
            if (filterInfo.getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(true), "AND");
            } else {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(false), "AND");
            }
            this.mainQuery.getFilter().mergeFilter(this.getDialogViewFilterForQuery(), "AND");
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.tblMain.removeRows();
    }

    protected void execQuery() {
        try {
            FilterInfo filterInfo = this.getDialogViewFilterForQuery();
            if (filterInfo.getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(true), "AND");
            } else {
                this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(false), "AND");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        try {
            OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
            OrgUnitInfo orgUnitInfo = null;
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitInfo = orgUnits[i];
                orgSet.add(orgUnitInfo.getId().toString());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (orgSet.size() == 0) {
            orgSet.add("111111111111111111111111111=");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo(TBL_COMPANYID, orgSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)this.getTaxItemTypeInfo().getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }

    protected FilterInfo getDialogViewFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getDialog().getEntityViewInfoResult() != null) {
            filterInfo = this.getDialog().getCommonFilter();
        }
        return filterInfo;
    }

    protected FilterInfo getSelectedNodeFilterForQuery(boolean isSupportAll) {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getSelectedNodeKeyValue() != null) {
            filterInfo.appendFilterItem(TBL_COMPANYID, (Object)this.getSelectedNodeKeyValue());
        } else if (!isSupportAll) {
            filterInfo.getFilterItems().add(new FilterItemInfo(TBL_COMPANYID, (Object)"111111111111111111111111111=", CompareType.EQUALS));
        }
        return filterInfo;
    }

    private Set getDraftItemIdsByParam(Set orgSet) {
        try {
            return OrgToDraftItemFactory.getRemoteInstance().getDraftItemIdsByParam(orgSet, this.getTaxItemTypeInfo().getId().toString(), OrgType.Company);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return DraftItemFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        ItemAction action = this.getActionFromActionEvent(e);
        String orgID = null;
        orgID = action.equals(this.actionAddNew) ? this.getSelectTreeOrgID() : this.getSelectTableOrgID();
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            uiContext.put((Object)"companyInfo", (Object)companyInfo);
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
    }

    protected void SelectNode() throws EASBizException, BOSException, Exception {
    }

    @Override
    public void actionPartImport_actionPerformed(ActionEvent e) throws Exception {
        String taxFlag = this.getTaxItemTypeInfo().getSimName().toLowerCase();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_IMPORTTYPE, (Object)DataImportTypeEnum.DRAFTITEM);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_TAXTYPE, (Object)this.getTaxItemTypeInfo());
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_ACCOUNTTYPE, null);
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_PERMITEM_VIEWCU, (Object)TDPermissionUtil.getDraftItemPermissionItem("view", taxFlag, false));
        uiContext.put((Object)DataImportWizardUI.UICONTEXT_PERMITEM_VIEWCOMPANY, (Object)TDPermissionUtil.getDraftItemPermissionItem("import", taxFlag, true));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataImportWizardUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        DataImportWizardUI wizardUI = (DataImportWizardUI)uiWindow.getUIObject();
        if (!wizardUI.isCancel()) {
            HashMap<String, List<DataImportParams>> params = new HashMap<String, List<DataImportParams>>();
            params.put("importParams", wizardUI.getImportParams());
            Map ret = DataImportFacadeFactory.getRemoteInstance().dataImport(params);
            int successCount = (Integer)ret.get("successCount");
            List detailList = (List)ret.get("detailList");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"IMPORT_SUCCESS_FAILED", (Object[])new Object[]{successCount}), (String)TDUtils.buildErrorMsg(detailList), (int)1);
            this.valueChanged(null);
        }
    }
}

