/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.bot.engine.sql.BotKSqlFunctions;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.service.formula.builder.FormulaBuilderUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.tm.td.basedata.client.AbstractEntityFormulaUI;
import com.kingdee.eas.tm.td.basedata.client.EntityFormula;
import com.kingdee.eas.tm.td.basedata.util.EntityPropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.EntityTreeUtil;
import com.kingdee.eas.tm.td.basedata.util.FunctionInfo;
import com.kingdee.eas.tm.td.basedata.util.KSQLFunctions;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityFormulaUI
extends AbstractEntityFormulaUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityFormulaUI.class);
    private static final long serialVersionUID = 1L;
    private KSQLFunctions sqlFunc;
    private ActionListener actionListener;
    private List formulaFunctionLists = new ArrayList();
    private boolean lastIsDigit;
    private boolean isCancel;
    private EntityFormula formulaInfo;
    private CompanyOrgUnitInfo fieldModel;
    private String propertyName;

    public EntityFormulaUI() throws Exception {
        this.formulaFunctionLists.add(new BotKSqlFunctions(this.getLocale()));
        this.sqlFunc = new KSQLFunctions(this.getLocale());
        this.initFunctionTree();
        this.treeFunc.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntityFormulaUI.this.treeFuncs_mouseClicked(e);
            }
        });
        this.treeDataQuery.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntityFormulaUI.this.treeDataQuery_mouseClicked(e);
            }
        });
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityFormulaUI.this.actionOPButton_actionPerformed(e);
            }
        };
        this.tblPanelEdit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EntityFormulaUI.this.tabbedPaneOutmost_stateChanged(e);
            }
        });
        this.btnAllCase.addActionListener(this.actionListener);
        this.btnElse.addActionListener(this.actionListener);
        this.btnEnd.addActionListener(this.actionListener);
        this.btnBra.addActionListener(this.actionListener);
        this.btnCase.addActionListener(this.actionListener);
        this.btnWhen.addActionListener(this.actionListener);
        this.btnThen.addActionListener(this.actionListener);
        this.btnAdd.addActionListener(this.actionListener);
        this.btnSub.addActionListener(this.actionListener);
        this.btnMul.addActionListener(this.actionListener);
        this.btnDiv.addActionListener(this.actionListener);
        this.btnEquals.addActionListener(this.actionListener);
        this.btnClear.addActionListener(this.actionListener);
        this.btnOne.addActionListener(this.actionListener);
        this.btnTwo.addActionListener(this.actionListener);
        this.btnThree.addActionListener(this.actionListener);
        this.btnFour.addActionListener(this.actionListener);
        this.btnFive.addActionListener(this.actionListener);
        this.btnSix.addActionListener(this.actionListener);
        this.btnSeven.addActionListener(this.actionListener);
        this.btnEight.addActionListener(this.actionListener);
        this.btnNight.addActionListener(this.actionListener);
        this.btnZero.addActionListener(this.actionListener);
        this.btnDot.addActionListener(this.actionListener);
        this.btnNull.addActionListener(this.actionListener);
        this.btnLeftBra.addActionListener(this.actionListener);
        this.btnRigthBra.addActionListener(this.actionListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnComfire.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.formulaInfo = (EntityFormula)this.getUIContext().get("EntityFormula");
        this.fieldModel = (CompanyOrgUnitInfo)this.getUIContext().get("fieldModel");
        this.propertyName = (String)this.getUIContext().get("propertyName");
        this.txtFormulaDesc.setFont(new Font("SansSerif", 0, 13));
        this.txtFormulaExpr.setFont(new Font("SansSerif", 0, 15));
        this.txtFormulaDesc.setText(this.formulaInfo.getFormualAlias());
        this.initDataQueryTree();
    }

    private void initDataQueryTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"122_DataQueryFormulaUI"));
        try {
            root = EntityTreeUtil.getDataQueryRoot(this.formulaInfo.getEntityList());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (root == null) {
            this.treeDataQuery.setModel(null);
        } else {
            this.treeDataQuery.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.treeDataQuery.expandOnLevel(3);
            this.treeDataQuery.setToggleClickCount(1);
        }
    }

    private void initFunctionTree() {
        this.treeFunc.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.getFunctionRoot()));
        this.treeFunc.setRootVisible(false);
        this.treeFunc.setToggleClickCount(1);
    }

    private DefaultKingdeeTreeNode getFunctionRoot() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"Function");
        this.addCategoryFunction(root, this.sqlFunc.CATEGORY_MATH, this.sqlFunc.getMathFunctions());
        this.addCategoryFunction(root, this.sqlFunc.CATEGORY_STRING, this.sqlFunc.getStringFunctions());
        this.addCategoryFunction(root, this.sqlFunc.CATEGORY_DATE, this.sqlFunc.getDateFunctions());
        return root;
    }

    private void addCategoryFunction(DefaultKingdeeTreeNode root, String category, List<FunctionInfo> functions) {
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)category);
        treeNode.setText(category);
        root.add((MutableTreeNode)treeNode);
        if (functions == null || functions.size() == 0) {
            return;
        }
        for (int i = 0; i < functions.size(); ++i) {
            this.addTreeNode(treeNode, functions.get(i));
        }
    }

    private void addTreeNode(DefaultKingdeeTreeNode parent, FunctionInfo function) {
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)function);
        treeNode.setText(function.getFuncName());
        parent.add((MutableTreeNode)treeNode);
    }

    private void treeFuncs_mouseClicked(MouseEvent e) {
        DefaultKingdeeTreeNode treeNode;
        Object obj;
        TreePath tp = this.treeFunc.getSelectionPath();
        boolean selectResult = this.selectTreeFuncs(tp);
        if (e.getClickCount() == 2 && selectResult && (obj = (treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent()).getUserObject()) instanceof FunctionInfo) {
            String s = "";
            s = s + ((FunctionInfo)obj).getFuncName();
            s = s + "()";
            s = " " + s + " ";
            this.addText(s);
        }
    }

    private void treeDataQuery_mouseClicked(MouseEvent e) {
        DefaultKingdeeTreeNode treeNode;
        Object obj;
        TreePath tp = this.treeDataQuery.getSelectionPath();
        boolean selectResult = this.selectDataQueryField(tp);
        if (e.getClickCount() == 1 && selectResult && (obj = (treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent()).getUserObject()) instanceof EntityPropertyMeta) {
            String s = "";
            s = s + ((EntityPropertyMeta)obj).getFullAlias();
            s = " " + s + " ";
            this.addText(s);
        }
    }

    private boolean selectTreeFuncs(TreePath tp) {
        if (tp == null) {
            return false;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        Object obj = treeNode.getUserObject();
        if (obj instanceof FunctionInfo) {
            String description = ((FunctionInfo)obj).getFuncDesc();
            description = description.replaceAll("\\<br\\>\\<\\/br\\>", "\n");
            this.txtFuncDescription.setText(description);
            return true;
        }
        this.txtFuncDescription.setText("");
        return false;
    }

    private boolean selectDataQueryField(TreePath tp) {
        if (tp == null) {
            return false;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        Object obj = treeNode.getUserObject();
        if (obj instanceof EntityPropertyMeta) {
            String description = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"123_DataQueryFormulaUI", (String[])new String[]{((EntityPropertyMeta)obj).getDataType()});
            this.txtFieldDesc.setText(description);
            return true;
        }
        this.txtFieldDesc.setText("");
        return false;
    }

    private void actionOPButton_actionPerformed(ActionEvent e) {
        KDWorkButton butten = (KDWorkButton)e.getSource();
        String text = "";
        if (butten.equals(this.btnAllCase)) {
            text = "CASE  WHEN  THEN  ELSE  END";
            this.lastIsDigit = false;
        } else if (butten.equals(this.btnClear)) {
            this.txtFormulaDesc.setText(text);
            this.lastIsDigit = false;
        } else if (butten.equals(this.btnBra)) {
            text = " ( )";
            this.lastIsDigit = false;
        } else if (butten.equals(this.btnOne) || butten.equals(this.btnTwo) || butten.equals(this.btnThree) || butten.equals(this.btnFour) || butten.equals(this.btnFive) || butten.equals(this.btnSix) || butten.equals(this.btnSeven) || butten.equals(this.btnEight) || butten.equals(this.btnNight) || butten.equals(this.btnZero) || butten.equals(this.btnDot) || butten.equals(this.btnSub)) {
            text = this.lastIsDigit ? butten.getText() : " " + butten.getText();
            this.lastIsDigit = true;
        } else {
            text = " " + butten.getText();
            this.lastIsDigit = false;
        }
        this.addText(text);
    }

    private void addText(String text) {
        StringBuffer sb = new StringBuffer();
        String str = this.txtFormulaDesc.getText();
        int caretPo = this.txtFormulaDesc.getCaretPosition();
        String left = str.substring(0, caretPo);
        String right = str.substring(caretPo);
        sb.append(left);
        sb.append(text);
        sb.append(right);
        this.txtFormulaDesc.setText(sb.toString());
        this.txtFormulaDesc.requestFocus();
        this.txtFormulaDesc.setSelectionStart(caretPo);
        this.txtFormulaDesc.setSelectionEnd(caretPo + text.length());
    }

    public void tabbedPaneOutmost_stateChanged(ChangeEvent e) {
        if (this.tblPanelEdit.getSelectedComponent() == this.txtFormulaExpr) {
            String formulaAlias = this.txtFormulaDesc.getText().trim();
            try {
                this.txtFormulaExpr.setText(this.formulaInfo.getFormualExprByAlias(formulaAlias));
            }
            catch (ParserException ex) {
                FormulaBuilderUtil.showMessageDialog((Component)((Object)this), (String)ex.getMessage());
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public EntityFormula getData() {
        return this.formulaInfo;
    }

    private void innerStoreFormual() throws ParserException {
        String formulaAlias = this.txtFormulaDesc.getText().trim();
        this.formulaInfo.getFormualExprByAlias(formulaAlias);
    }

    @Override
    public void actionComfire_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.innerStoreFormual();
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }
}

