/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractTakeDataContditionListUI;
import com.kingdee.eas.tm.td.basedata.client.TakeDataContditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class TakeDataContditionListUI
extends AbstractTakeDataContditionListUI {
    private String orgUnitId;
    private String draftItemId;
    private DSTypeEnum dsType;
    private String accountId;
    private Set dataSource = null;
    private Boolean isCanModify = true;
    private static final String COL_STATE = "takeDataStatus";

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"dataSourceIds", (Object)this.dataSource);
        uiContext.put((Object)"draftItemId", (Object)this.draftItemId);
        uiContext.put((Object)"orgUnitId", (Object)this.orgUnitId);
        uiContext.put((Object)"dsType", (Object)this.dsType);
        uiContext.put((Object)"accountId", (Object)this.accountId);
        uiContext.put((Object)"isCanModify", (Object)this.isCanModify);
    }

    public void onLoad() throws Exception {
        this.orgUnitId = (String)this.getUIContext().get("orgUnitId");
        this.draftItemId = (String)this.getUIContext().get("draftItemId");
        this.dsType = (DSTypeEnum)((Object)this.getUIContext().get("dsType"));
        this.accountId = (String)this.getUIContext().get("accountId");
        this.dataSource = (Set)this.getUIContext().get("dataSourceSet");
        this.isCanModify = this.getUIContext().get("isCanModify") == null ? true : (Boolean)this.getUIContext().get("isCanModify");
        super.onLoad();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        if (!this.isCanModify.booleanValue()) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TakeDataContditionFactory.getRemoteInstance();
    }

    protected void execQuery() {
        try {
            this.mainQuery.clearExtendedProperties();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
            this.mainQuery.getFilter().mergeFilter(this.getDialogViewFilterForQuery(), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    protected FilterInfo getDialogViewFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getDialog().getEntityViewInfoResult() != null) {
            filterInfo = this.getDialog().getCommonFilter();
        }
        return filterInfo;
    }

    protected String getEditUIName() {
        return TakeDataContditionUI.class.getName();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String dsId = this.getSelectedKeyValue();
        if (dsId == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            return;
        }
        Map uiContext = this.getUIContext();
        String contditionID = this.getIdByDataSourceID(dsId);
        uiContext.put("dsId", dsId);
        uiContext.put("ID", contditionID);
        String uistate = OprtState.VIEW;
        if (contditionID == null || "".equals(contditionID)) {
            uistate = OprtState.ADDNEW;
        }
        this.openEditUI(uiContext, uistate);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String dsId = this.getSelectedKeyValue();
        if (dsId == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            return;
        }
        Map uiContext = this.getUIContext();
        String contditionID = this.getIdByDataSourceID(dsId);
        uiContext.put("dsId", dsId);
        uiContext.put("ID", contditionID);
        String uistate = OprtState.EDIT;
        if (contditionID == null || "".equals(contditionID)) {
            uistate = OprtState.ADDNEW;
        } else {
            this.checkStateEnableEdit();
        }
        this.openEditUI(uiContext, uistate);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String dsId = this.getSelectedKeyValue();
        if (dsId == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            return;
        }
        String contditionID = this.getIdByDataSourceID(dsId);
        if (contditionID != null && !contditionID.equals("")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"takeDataCondition_Exist"));
            return;
        }
        this.getUIContext().put("dsId", dsId);
        super.actionAddNew_actionPerformed(e);
        this.refresh(null);
    }

    private String getIdByDataSourceID(String dataSourceID) throws EASBizException, BOSException {
        return TakeDataContditionFactory.getRemoteInstance().getIdBySourceId(dataSourceID);
    }

    private void openEditUI(Map uiContext, String oprtState) throws UIException {
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), uiContext, null, oprtState) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), uiContext, null, oprtState);
        uiWindow.show();
        try {
            this.refresh(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void checkStateEnableEdit() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getString().equals("1")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"state_saveBanEdit"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getString().equals("1")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_activeDelete"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String dsId = this.getSelectedKeyValue();
        if (dsId == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            return;
        }
        String contditionID = this.getIdByDataSourceID(dsId);
        if (contditionID == null || "".equals(contditionID)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"takeDataCondition_Not_Exist"));
            return;
        }
        this.checkStateEnableRemove();
        if (this.confirmRemove()) {
            TakeDataContditionFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(contditionID));
            this.refresh(null);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                String dsId = ids.get(i).toString();
                String contditionID = this.getIdByDataSourceID(dsId);
                if (contditionID != null && !contditionID.equals("")) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)contditionID));
                    TakeDataContditionInfo conditionInfo = TakeDataContditionFactory.getRemoteInstance().getTakeDataContditionInfo((IObjectPK)pk);
                    TakeDataContditionFactory.getRemoteInstance().cancelCancel((IObjectPK)pk, (CoreBaseInfo)conditionInfo);
                    continue;
                }
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"takeDataCondition_Not_Exist"));
            }
            this.tblMain.refresh();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                String dsId = ids.get(i).toString();
                String contditionID = this.getIdByDataSourceID(dsId);
                if (contditionID != null && !contditionID.equals("")) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)contditionID));
                    TakeDataContditionInfo conditionInfo = TakeDataContditionFactory.getRemoteInstance().getTakeDataContditionInfo((IObjectPK)pk);
                    TakeDataContditionFactory.getRemoteInstance().cancel((IObjectPK)pk, (CoreBaseInfo)conditionInfo);
                    continue;
                }
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"takeDataCondition_Not_Exist"));
            }
            this.tblMain.refresh();
        }
    }

    protected IIDList getSelectedKeyValues() {
        return super.getSelectedKeyValues();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.dataSource, CompareType.INCLUDE));
        return filter;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }
}

