/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeSignEnum;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxItemTypeListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TaxItemTypeListUI
extends AbstractTaxItemTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxItemTypeListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public TaxItemTypeListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void initBtnStatus() {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            this.checkSelected();
            this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
            this.uiHelper.batchOperation("delete", this.tblMain, this.getKeyFieldName(), "number", "DB8AF7A6");
            this.refreshList();
        }
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        TaxItemTypeInfo info = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (TaxItemTypeSignEnum.Menu.equals((Object)info.getSign())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "Error_Edit", this.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.basedata.client.TaxItemTypeEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxItemTypeFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public boolean isSupportedBatchActions() {
        return true;
    }
}

