/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeFactory;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxReportTypeListUI;
import com.kingdee.eas.tm.td.basedata.client.TaxReportTypeEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TaxReportTypeListUI
extends AbstractTaxReportTypeListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTypeListUI.class);
    private ListUIHelper uiHelper = new ListUIHelper(this);
    private String currentCUID;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return TaxReportTypeEditUI.class.getName();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportTypeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = TaxReportTypeFactory.getRemoteInstance().cancel(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append((String)errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) {
        ArrayList ids = this.getSelectedIdValues();
        try {
            if (this.confirmRemove()) {
                this.checkSelected();
                this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
                TDUtils.tryLock(ids);
                ArrayList result = TaxReportTypeFactory.getRemoteInstance().batchDelete(new HashSet(ids));
                String error = "";
                StringBuffer errorDetail = new StringBuffer();
                if (result != null && !result.isEmpty()) {
                    error = EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"REMOVE_ERROR");
                    for (int i = 0; i < result.size(); ++i) {
                        errorDetail.append(result.get(i)).append("\r\n");
                    }
                    MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail.toString(), (int)1);
                }
                this.refreshList();
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) {
        ArrayList ids = this.getSelectedIdValues();
        try {
            this.checkSelected();
            this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
            TDUtils.tryLock(ids);
            String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
            String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
            if (this.confirmDialog(cancelMsg)) {
                ArrayList errorList = TaxReportTypeFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
                if (errorList.size() > 0) {
                    StringBuffer errorDetailMSG = new StringBuffer();
                    for (int i = 0; i < errorList.size(); ++i) {
                        errorDetailMSG.append((String)errorList.get(i)).append("\n");
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
                }
                this.actionRefresh_actionPerformed(e);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }
}

