/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.AutoCreateRepParamInfo;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftCalculateFacadeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractReportBatchCopyUI;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportBatchCopyUI
extends AbstractReportBatchCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportBatchCopyUI.class);
    private TaxItemTypeInfo taxType = null;
    private RecordTypeEnum recordType = null;
    private String orgID = null;
    private CompanyOrgUnitInfo company = null;
    private String permissionName = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        this.taxType = (TaxItemTypeInfo)uiCtx.get("taxType");
        this.recordType = (RecordTypeEnum)((Object)uiCtx.get("recordType"));
        this.permissionName = (String)uiCtx.get("permissionName");
        this.orgID = (String)uiCtx.get("orgID");
        this.loadData();
        this.initControl();
        this.setPeriodFilter();
        this.setCompanyFilter();
    }

    private void loadData() throws EASBizException, BOSException {
        if (this.orgID != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("accountPeriodType.*"));
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.orgID), sic);
        } else {
            this.company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        }
    }

    private void setCompanyFilter() {
        if (StringUtils.isEmpty((String)this.permissionName)) {
            return;
        }
        try {
            Set orgIds = TDPermissionUtil.getPermissionUnits(OrgType.Company, this.permissionName);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INCLUDE));
            ev.setFilter(filter);
            this.bizCompany.setEntityViewInfo(ev);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setPeriodFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        this.bizPeriod.setEntityViewInfo(ev);
        this.bizTargetPeriod.setEntityViewInfo(ev);
    }

    private void initControl() {
        if (RecordTypeEnum.Account.equals((Object)this.recordType)) {
            this.cbTakeData.setVisible(true);
        } else {
            this.cbTakeData.setVisible(false);
        }
        this.bizCompany.setHistoryRecordEnabled(false);
        this.bizPeriod.setHistoryRecordEnabled(false);
        this.bizTargetPeriod.setHistoryRecordEnabled(false);
        this.bizCompany.setValue((Object)this.company);
    }

    private Object[] getF7Value(KDBizPromptBox box) {
        Object[] objs = null;
        IObjectValue obj = null;
        if (box.getValue() == null) {
            return null;
        }
        if (box.getValue() instanceof IObjectValue) {
            obj = (IObjectValue)box.getValue();
            objs = new Object[]{obj};
        } else {
            objs = (Object[])box.getValue();
        }
        ArrayList<Object> objList = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            objList.add(objs[i]);
        }
        return objList.toArray();
    }

    private boolean verify() {
        Object[] targetPeriods;
        PeriodInfo period;
        Object[] companys = this.getF7Value(this.bizCompany);
        if (companys == null || companys.length == 0) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "COMPANYISNULL", TDUtils.getLocale()));
            SysUtil.abort();
        }
        if ((period = (PeriodInfo)this.bizPeriod.getValue()) == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "PERIODISNULL", TDUtils.getLocale()));
            SysUtil.abort();
        }
        if ((targetPeriods = this.getF7Value(this.bizTargetPeriod)) == null || targetPeriods.length == 0) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "TARGETPERIODISNULL", TDUtils.getLocale()));
            SysUtil.abort();
        }
        return true;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        Object[] companys = this.getF7Value(this.bizCompany);
        Object[] targetPeriods = this.getF7Value(this.bizTargetPeriod);
        PeriodInfo period = (PeriodInfo)this.bizPeriod.getValue();
        boolean isCalc = this.cbCalc.isSelected();
        boolean isConfirm = this.cbConfirm.isSelected();
        boolean isTakeData = false;
        if (this.cbTakeData.isVisible()) {
            isTakeData = this.cbTakeData.isSelected();
        }
        ArrayList<AutoCreateRepParamInfo> paramsList = new ArrayList<AutoCreateRepParamInfo>();
        CompanyOrgUnitInfo company = null;
        PeriodInfo targetPeriod = null;
        AutoCreateRepParamInfo paramInfo = null;
        for (int i = 0; i < companys.length; ++i) {
            company = (CompanyOrgUnitInfo)companys[i];
            for (int j = 0; j < targetPeriods.length; ++j) {
                targetPeriod = (PeriodInfo)targetPeriods[j];
                paramInfo = new AutoCreateRepParamInfo();
                paramInfo.setCompanyOrgID(company.getId().toString());
                paramInfo.setPeriodID(period.getId().toString());
                paramInfo.setRecordType(this.recordType.getValue());
                paramInfo.setTaxTypeID(this.taxType.getId().toString());
                paramInfo.setTargetPeriondID(targetPeriod.getId().toString());
                paramsList.add(paramInfo);
            }
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("paramsList", paramsList);
        params.put("isCalc", Boolean.valueOf(isCalc));
        params.put("isConfirm", Boolean.valueOf(isConfirm));
        params.put("isTakeData", Boolean.valueOf(isTakeData));
        Map ret = TaxDraftCalculateFacadeFactory.getRemoteInstance().autoCreateReport(params);
        List exceptionList = (List)ret.get("exceptionList");
        int successCount = (Integer)ret.get("successCount");
        String msg = "";
        String detailMsg = "";
        msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", "copyPartSuccess", TDUtils.getLocale(), new Object[]{successCount, exceptionList.size()});
        detailMsg = this.buildExceptionMsg(exceptionList);
        this.getUIWindow().close();
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)detailMsg, (int)1);
    }

    private String buildExceptionMsg(List exceptionList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exceptionList.size(); ++i) {
            sb.append(exceptionList.get(i)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

