/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.client.AbstractShowEditorPanelUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.CheckAccountEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.CheckItemEditUI;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.log4j.Logger;

public class ShowEditorPanelUI
extends AbstractShowEditorPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(ShowEditorPanelUI.class);
    private Map params = null;
    private String[] htmls = null;
    private Object content;

    public void onLoad() throws Exception {
        super.onLoad();
        this.params = (Map)this.getUIContext().get("params");
        this.htmls = (String[])this.params.get("htmls");
        this.btnCancel.setVisible(false);
        this.btnOk.setEnabled(true);
        this.btnPrint.setEnabled(true);
        super.setUIMenuBar(null);
        super.setUIToolBar(null);
        super.removeMainStatusBar();
        this.itemEditorPane.setEditable(false);
        this.itemEditorPane.setContentType("text/html");
        this.accountEditPanel.setEditable(false);
        this.accountEditPanel.setContentType("text/html");
        if (this.htmls != null) {
            this.itemEditorPane.setText(this.htmls[0]);
            this.accountEditPanel.setText(this.htmls[1]);
        }
        this.itemEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowEditorPanelUI.this.handleHyperlinkUpdate(e);
                }
            }
        });
        this.accountEditPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowEditorPanelUI.this.handleHyperlinkUpdate(e);
                }
            }
        });
        if (this.htmls == null || StringUtils.isEmpty((String)this.htmls[1]) || this.htmls[1].indexOf("\u68c0\u67e5\u7ed3\u679c") < 0) {
            this.kDTabbedPane1.remove((Component)this.kDScrollPane2);
        }
        if (this.htmls == null || StringUtils.isEmpty((String)this.htmls[0]) || this.htmls[0].indexOf("\u68c0\u67e5\u7ed3\u679c") < 0) {
            this.kDTabbedPane1.remove((Component)this.kDScrollPane1);
        }
        this.itemEditorPane.setCaretPosition(0);
        this.accountEditPanel.setCaretPosition(0);
    }

    protected void handleHyperlinkUpdate(HyperlinkEvent e) {
        this.openLink(e);
    }

    private void openLink(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KDEditorPane pane = (KDEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                String s = e.getDescription();
                String[] data = s.split(",");
                if (data.length < 2) {
                    return;
                }
                String billType = data[0];
                String billId = data[1];
                if ("0".equals(billType)) {
                    try {
                        this.viewReport(billId);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage());
                    }
                } else if ("1".equals(billType)) {
                    try {
                        if (pane == this.itemEditorPane) {
                            this.viewCheckItem(billId);
                        } else if (pane == this.accountEditPanel) {
                            this.viewCheckAccount(billId);
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage());
                    }
                }
            }
        }
    }

    public void viewReport(String billId) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        TaxDraftRecordInfo reportInfo = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordInfo((IObjectPK)pk, TDSelectorFactory.getTaxDraftRecordSelectors());
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"InitDataObject", (Object)reportInfo);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTaxDraftRptUI(reportInfo), (Map)uiContext, null, this.oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    protected String getTaxDraftRptUI(TaxDraftRecordInfo reportInfo) {
        String taxFlag = reportInfo.getTaxType().getSimName();
        String recordType = reportInfo.getRecordType().getName();
        return TDUtils.getTaxDraftRptUI(taxFlag, recordType);
    }

    public void viewCheckItem(String billId) throws Exception {
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ID", (Object)billId);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CheckItemEditUI.class.getName(), (Map)uiContext, null, this.oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    public void viewCheckAccount(String billId) throws Exception {
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ID", (Object)billId);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CheckAccountEditUI.class.getName(), (Map)uiContext, null, this.oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDEditorPane kdPanel = new KDEditorPane();
        kdPanel.setContentType("text/html");
        KDEditorPane pane = null;
        pane = this.kDTabbedPane1.getSelectedComponent() == this.kDScrollPane1 ? this.itemEditorPane : this.accountEditPanel;
        String[] strKDContent = pane.getText().split("<br>");
        if (null != strKDContent && strKDContent.length != 0) {
            int iLength = strKDContent.length - 1;
            KDTable table = new KDTable(1, 0, iLength);
            for (int i = 0; i < iLength; ++i) {
                kdPanel.setText(strKDContent[i]);
                table.getRow(i).getCell(0).setValue((Object)kdPanel.getDocument().getText(0, kdPanel.getDocument().getLength()));
            }
            table.getColumn(0).setWidth(640);
            table.getPrintManager().setParent((Component)((Object)this));
            table.setPrintConfigDefault(false, false, false, false, false);
            table.getPrintManager().print();
        }
    }
}

