/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.DraftRecordTypeEnum;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.ReportSrcSystem;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractTaxDraftEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.check.ReportCheck;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.CheckUtils;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.TaxMsgBox;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class TaxDraftEditUI
extends AbstractTaxDraftEditUI
implements ItemListener,
DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(TaxDraftEditUI.class);
    protected TaxDraftRecordInfo copyRecordInfo;
    private CompanyOrgUnitInfo cou;
    private CodingRuleInfo codingRule = null;
    private DataChangeListener periodDataChangeListener = null;
    private DataChangeListener relateAccountDataChangeListener = null;
    private DataChangeListener templetReportDataChangeListener = null;

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
    }

    protected void removeListener() {
        this.selectDraftRecordType.removeItemListener((ItemListener)this);
        this.prmtCompanyOrgUnit.removeDataChangeListener((DataChangeListener)this);
        this.prmtTempletReport.removeDataChangeListener(this.templetReportDataChangeListener);
    }

    protected void beforeLoad() {
        if (this.getUIContext().get("recordInfo") != null) {
            this.copyRecordInfo = (TaxDraftRecordInfo)this.getUIContext().get("recordInfo");
        }
        String companyOrgUnit = null;
        if (this.getUIContext().get("companyOrgUnit") != null) {
            companyOrgUnit = (String)this.getUIContext().get("companyOrgUnit");
        } else if (this.getUIContext().get("companyUnit") != null) {
            companyOrgUnit = (String)this.getUIContext().get("companyUnit");
        }
        if (companyOrgUnit != null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("accountPeriodType.*"));
                this.cou = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnit), sic);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void afterLoad() {
        this.initControl();
        this.setF7Filter();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initNumber() {
        boolean isIsModifiable = true;
        try {
            Object[] orgUnitObj = this.getCompanyOrgUnitValue();
            CompanyOrgUnitInfo unitInfo = null;
            if (orgUnitObj != null && orgUnitObj.length == 1) {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                unitInfo = (CompanyOrgUnitInfo)orgUnitObj[0];
                this.codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, unitInfo.getId().toString(), "ownerMenu");
                if (!this.codingRule.isIsModifiable()) {
                    isIsModifiable = false;
                }
            } else {
                this.codingRule = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"init number error");
        }
        this.number.setEditable(isIsModifiable);
    }

    protected void initControl() {
        if (RecordTypeEnum.Account.equals((Object)this.getRecordType())) {
            this.prmtRelateAccount.setEnabled(true);
            this.prmtRelateAccount.setRequired(true);
            this.selectDraftRecordType.setEnabled(false);
            this.selectDraftRecordTypeContainer.setVisible(false);
            this.prmtRelateNextAccountContainer.setVisible(true);
            this.prmtRelateDraftRecordContainer.setVisible(false);
        } else {
            this.prmtRelateAccount.setEnabled(false);
            this.prmtRelateAccount.setRequired(false);
            this.selectDraftRecordType.setEnabled(true);
            this.prmtRelateNextAccountContainer.setVisible(false);
            this.prmtRelateAccountContainer.setVisible(false);
            this.prmtRelateDraftRecordContainer.setVisible(true);
            if (RecordTypeEnum.TaxDeclare.equals((Object)this.getRecordType()) || RecordTypeEnum.AnnualTaxDeclare.equals((Object)this.getRecordType())) {
                if (DraftRecordTypeEnum.normalRecord.equals(this.selectDraftRecordType.getSelectedItem())) {
                    this.prmtRelateDraftRecord.setEnabled(false);
                } else {
                    this.prmtRelateDraftRecord.setEnabled(true);
                }
            }
        }
        if (this.copyRecordInfo != null) {
            this.prmtCompanyOrgUnit.setEnabledMultiSelection(true);
            try {
                if (this.getTaxTypeInfo() != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(this.getTaxTypeInfo().getId().toString())) {
                    this.prmtBuildingTaxesGroup.setEnabledMultiSelection(true);
                } else {
                    this.prmtBuildingTaxesGroup.setEnabledMultiSelection(false);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.prmtCompanyOrgUnit.setEditFormat("$number$");
            this.prmtCompanyOrgUnit.setDisplayFormat("$name$");
            this.prmtCompanyOrgUnit.setCommitFormat("$number$");
            this.prmtCompanyOrgUnit.setEnabled(true);
        } else {
            this.prmtBuildingTaxesGroup.setEnabledMultiSelection(false);
            this.prmtCompanyOrgUnit.setEnabled(false);
        }
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        if (this.copyRecordInfo != null) {
            this.setDataObject((IObjectValue)this.copyRecordInfo);
        } else {
            this.prmtCompanyOrgUnit.setValue((Object)this.cou);
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.prmtRelateAccount.setEnabled(false);
            }
        }
        this.name.setMaxLength(255);
        this.number.setMaxLength(20000);
        this.discription.setMaxLength(200);
        this.prmtPeriod.setCommitFormat("$number$");
        this.prmtPeriodFrom.setCommitFormat("$number$");
        this.prmtPeriodTo.setCommitFormat("$number$");
        this.initNumber();
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW)) {
            this.prmtTempletReport.setEnabled(true);
        } else {
            this.prmtTempletReport.setEnabled(false);
        }
    }

    protected void addListener() {
        this.selectDraftRecordType.addItemListener((ItemListener)this);
        this.prmtCompanyOrgUnit.addDataChangeListener((DataChangeListener)this);
        if (this.periodDataChangeListener == null) {
            this.periodDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent ev) {
                    TaxDraftEditUI.this.periodChange();
                }
            };
        }
        this.prmtPeriod.addDataChangeListener(this.periodDataChangeListener);
        if (this.relateAccountDataChangeListener == null) {
            this.relateAccountDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent ev) {
                    TaxDraftEditUI.this.prmtRelateAccountChange();
                }
            };
        }
        this.prmtRelateAccount.addDataChangeListener(this.relateAccountDataChangeListener);
        if (this.templetReportDataChangeListener == null) {
            this.templetReportDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent ev) {
                    TaxDraftEditUI.this.templetReportChange(ev);
                }
            };
        }
        this.prmtTempletReport.addDataChangeListener(this.templetReportDataChangeListener);
    }

    protected void templetReportChange(DataChangeEvent e) {
        if (this.prmtTempletReport.getValue() == null) {
            return;
        }
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        TaxReportTemplateInfo templetReportInfo = (TaxReportTemplateInfo)this.prmtTempletReport.getValue();
        if (templetReportInfo.getBillRange() != null) {
            this.prmtBillRange.setValue((Object)templetReportInfo.getBillRange());
        }
    }

    private void prmtRelateAccountChange() {
        try {
            this.setPrmtRelateRecordAccountFilter();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void setF7Filter() {
        try {
            this.setPrmtOrgUnitFilter();
            this.setPrmtRelateAccountFilter();
            this.setPrmtPeriodFilter();
            this.setPrmtRelateRecordAccountFilter();
            this.setTempletReportFilter();
            this.setPrmtRelateDraftRecordFilterByCompanyUnit();
            this.setPrmtBillRange();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setPrmtOrgUnitFilter() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.cou != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.cou.getId().toString(), CompareType.EQUALS));
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("add"));
            OrgUnitInfo orgUnitInfo = null;
            HashSet<String> existIDs = new HashSet<String>();
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitInfo = orgUnits[i];
                existIDs.add(orgUnitInfo.getId().toString());
            }
            if (existIDs.size() == 0) {
                existIDs.add("111111111111111111111111111=");
            }
            filter.getFilterItems().add(new FilterItemInfo("id", existIDs, CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        this.prmtCompanyOrgUnit.setEntityViewInfo(ev);
    }

    private void setPrmtRelateDraftRecordFilter() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.cou != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.cou.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)this.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("draftStatus", (Object)3));
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
            OrgUnitInfo orgUnitInfo = null;
            HashSet<String> existIDs = new HashSet<String>();
            for (int i = 0; i < orgUnits.length; ++i) {
                orgUnitInfo = orgUnits[i];
                existIDs.add(orgUnitInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", existIDs, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)this.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("draftStatus", (Object)3));
        }
        try {
            TaxItemTypeInfo taxTypeInfo = this.getTaxTypeInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxTypeInfo.getId().toString()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        ev.setFilter(filter);
    }

    private void setPrmtRelateDraftRecordFilterByCompanyUnit() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object[] orgUnitObj = null;
        boolean isMutiOrg = false;
        if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            orgUnitObj = new Object[]{unitInfo};
            this.prmtRelateNextAccount.setEnabled(true);
        } else {
            orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
        }
        OrgUnitInfo orgUnitInfo = null;
        orgUnitInfo = (OrgUnitInfo)orgUnitObj[0];
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)this.getRecordType().getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("draftStatus", (Object)3));
        try {
            TaxItemTypeInfo taxTypeInfo = this.getTaxTypeInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxTypeInfo.getId().toString()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        ev.setFilter(filter);
    }

    protected void setPrmtBillRange() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        TaxItemTypeInfo taxItemTypeInfo = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        HashSet<Integer> recordTypeSet = new HashSet<Integer>();
        recordTypeSet.add(this.getRecordType().getValue());
        recordTypeSet.add(-1);
        filter.getFilterItems().add(new FilterItemInfo("recordType", recordTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("taxType.number", (Object)taxItemTypeInfo.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxType.number", null, CompareType.EMPTY));
        filter.setMaskString("#0 AND (#1 OR #2)");
        ev.setFilter(filter);
        this.prmtBillRange.setEntityViewInfo(ev);
    }

    protected void setPrmtRelateRecordAccountFilter() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String relateAccountId = "111111111111111111";
        String companyID = "1111111111111111";
        if (this.prmtRelateAccount.getValue() != null) {
            relateAccountId = ((AccountConfigInfo)this.prmtRelateAccount.getValue()).getId().toString();
        }
        Object[] orgUnitObj = null;
        boolean isMutiOrg = false;
        if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            orgUnitObj = new Object[]{unitInfo};
        } else {
            orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
        }
        if (orgUnitObj != null && orgUnitObj.length > 1) {
            isMutiOrg = true;
        }
        if (!isMutiOrg) {
            companyID = ((CompanyOrgUnitInfo)orgUnitObj[0]).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)this.getRecordType().getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relateAccount.id", (Object)relateAccountId, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtRelateNextAccount.setEntityViewInfo(ev);
    }

    private void setPrmtPeriodFilter() {
        if (this.cou == null && this.copyRecordInfo == null) {
            return;
        }
        String accountPeriodTypeId = null;
        if (this.cou != null) {
            accountPeriodTypeId = this.cou.getAccountPeriodType().getId().toString();
        } else {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("accountPeriodType.*"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.copyRecordInfo.getCompanyOrgUnit().getId().toString()), sic);
                accountPeriodTypeId = company.getAccountPeriodType().getId().toString();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)accountPeriodTypeId, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtPeriod.setEntityViewInfo(ev);
        this.prmtPeriodFrom.setEntityViewInfo(ev);
        this.prmtPeriodTo.setEntityViewInfo(ev);
    }

    protected String getClassAlise() {
        if (this.editData == null) {
            return super.getClassAlise();
        }
        RecordTypeEnum recordType = this.editData.getRecordType();
        return recordType.getAlias();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setVisible(true);
        this.btnSave.setVisible(true);
        this.btnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnComfire.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
    }

    protected abstract String getPermissionItem(String var1);

    protected abstract AccountTypeInfo getAccountTypeInfo() throws Exception;

    protected abstract TaxItemTypeInfo getTaxTypeInfo() throws Exception;

    protected abstract RecordTypeEnum getRecordType();

    protected void setPrmtRelateAccountFilter() throws Exception {
        int i;
        if (!RecordTypeEnum.Account.equals((Object)this.getRecordType())) {
            return;
        }
        EntityViewInfo reView = new EntityViewInfo();
        FilterInfo reFilter = new FilterInfo();
        if (this.copyRecordInfo != null) {
            CompanyOrgUnitInfo unitInfo = null;
            Object[] orgUnitObj = null;
            if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
                unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
                orgUnitObj = new Object[]{unitInfo};
            } else {
                orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
            }
            HashSet<String> existIDs = new HashSet<String>();
            for (i = 0; i < orgUnitObj.length; ++i) {
                existIDs.add(((CompanyOrgUnitInfo)orgUnitObj[i]).getId().toString());
            }
            reFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", existIDs, CompareType.INCLUDE));
            reFilter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        } else if (this.cou != null) {
            reFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.cou.getId().toString(), CompareType.EQUALS));
            reFilter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            OrgUnitInfo[] orgUnits = TDPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, this.getPermissionItem("view"));
            OrgUnitInfo orgUnitInfo = null;
            HashSet<String> existIDs = new HashSet<String>();
            for (int i2 = 0; i2 < orgUnits.length; ++i2) {
                orgUnitInfo = orgUnits[i2];
                existIDs.add(orgUnitInfo.getId().toString());
            }
            reFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", existIDs, CompareType.INCLUDE));
            reFilter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        }
        reFilter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        reView.setFilter(reFilter);
        SelectorItemCollection reSic = new SelectorItemCollection();
        reSic.add(new SelectorItemInfo("account.id"));
        reView.setSelector(reSic);
        OrgToAccountRelationCollection reColl = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationCollection(reView);
        HashSet<String> idSet = new HashSet<String>();
        int size = reColl.size();
        for (i = 0; i < size; ++i) {
            idSet.add(reColl.get(i).getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relation.id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        this.prmtRelateAccount.setEntityViewInfo(ev);
    }

    protected void periodChange() {
        PeriodInfo periodInfo = (PeriodInfo)this.prmtPeriod.getValue();
        if (periodInfo == null) {
            return;
        }
        this.startDate.setValue((Object)periodInfo.getBeginDate());
        this.endDate.setValue((Object)periodInfo.getEndDate());
        this.editData.setYear(periodInfo.getPeriodYear());
        this.editData.setPeriod((short)periodInfo.getPeriodNumber());
        this.prmtPeriodFrom.setValue(null);
        this.prmtPeriodTo.setValue(null);
    }

    protected IObjectValue createNewData() {
        if (this.copyRecordInfo != null) {
            try {
                String newNumber = this.getNewNumberByUnit(this.copyRecordInfo, this.copyRecordInfo.getCompanyOrgUnit().getId().toString());
                this.copyRecordInfo.setNumber(newNumber);
            }
            catch (Exception e1) {
                logger.error((Object)"set number error");
            }
            return this.copyRecordInfo;
        }
        TaxDraftRecordInfo info = new TaxDraftRecordInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setSourceType(RptSrcTypeEnum.NORMAL);
        info.setDraftStatus(DraftStatusEnum.SAVE);
        info.setSubPeriodType(PeriodTypeEnum.MONTHLY);
        info.setOwnerMenu(this.getOwnerMenu());
        try {
            info.setTaxType(this.getTaxTypeInfo());
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        info.setRecordType(this.getRecordType());
        info.setDraftRecordType(DraftRecordTypeEnum.normalRecord);
        info.setCompanyOrgUnit(this.cou);
        info.setSrcSystem(ReportSrcSystem.MANUAL);
        try {
            String newNumber = this.getNewNumberByUnit(info, this.cou.getId().toString());
            info.setNumber(newNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    protected abstract OwnerMenuEnum getOwnerMenu();

    protected ICoreBase getBizInterface() throws Exception {
        return TaxDraftRecordFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doActionForSaveOrSubmit(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            return;
        }
        this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("remove"));
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getCompanyOrgUnit() != null) {
            this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("add"));
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.doActionForSaveOrSubmit(e);
    }

    protected void doActionForSaveOrSubmit(ActionEvent e) throws Exception {
        ItemAction action = this.getActionFromActionEvent(e);
        boolean isSubmit = action.equals(this.actionSubmit);
        boolean isCopy = this.copyRecordInfo != null;
        this.beforeSaveOrSubmit(e, isSubmit, isCopy);
        IObjectPK pk = this.doSaveOrSubmit(e, isSubmit, isCopy);
        this.afterSaveOrSubmit(pk, isSubmit);
    }

    protected void checkBeforeSaveOrSubmit(boolean isSubmit, boolean isCopy) throws Exception {
        String nameStr;
        Object[] orgUnitObj;
        String[] numStr;
        String numberStr;
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"companyNoNull"));
            SysUtil.abort();
        }
        if ((numberStr = this.number.getText()) == null || StringUtils.isEmpty((String)numberStr)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NumberBlank"));
            SysUtil.abort();
        }
        if (isCopy && (numStr = numberStr.split(";")).length != (orgUnitObj = this.getCompanyOrgUnitValue()).length) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NotEnoughNumber"));
            SysUtil.abort();
        }
        if ((nameStr = this.name.getText()) == null || StringUtils.isEmpty((String)nameStr)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NAME_NOT_NULL"));
            SysUtil.abort();
        }
        if (this.prmtPeriod.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"PERIOD_NOT_NULL"));
            SysUtil.abort();
        }
        if (this.startDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"beginDateNoNull"));
            SysUtil.abort();
        }
        if (this.endDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"endDateNoNull"));
            SysUtil.abort();
        }
        if (RecordTypeEnum.Account.equals((Object)this.getRecordType()) && this.prmtRelateAccount.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ACCOUNT_NOT_NULL"));
            SysUtil.abort();
        }
        ITaxDraftRecord iFactory = (ITaxDraftRecord)this.getBizInterface();
        iFactory.checkNumberDup((IObjectValue)this.editData);
    }

    protected void beforeSaveOrSubmit(ActionEvent e, boolean isSubmit, boolean isCopy) throws Exception {
        this.checkBeforeSaveOrSubmit(isSubmit, isCopy);
        if (isSubmit) {
            this.doBeforeSubmit(e);
        } else {
            this.doBeforeSave(e);
        }
    }

    protected IObjectPK doSaveOrSubmit(ActionEvent e, boolean isSubmit, boolean isCopy) throws Exception {
        ReportCheck reportCheck;
        String[] htmls;
        int result;
        Object[] units = this.getCompanyOrgUnitValue();
        IObjectPK pk = null;
        String[] numStr = null;
        if (isCopy) {
            numStr = this.number.getText().split(";");
        }
        TaxDraftRecordInfo recordInfo = null;
        CompanyOrgUnitInfo unit = null;
        TaxDraftRecordCollection recordColl = new TaxDraftRecordCollection();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < units.length; ++i) {
            unit = (CompanyOrgUnitInfo)units[i];
            if (isCopy) {
                recordInfo = (TaxDraftRecordInfo)this.editData.clone();
                recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
                recordInfo.setCompanyOrgUnit(unit);
                recordInfo.setNumber(numStr[i]);
                recordInfo.setDraftStatus(DraftStatusEnum.SAVE);
            } else {
                recordInfo = this.editData;
            }
            recordColl.add(recordInfo);
            if (!isSubmit) continue;
            ids.add(recordInfo.getId().toString());
        }
        int errorCount = 0;
        StringBuffer errorDetail = new StringBuffer();
        Map promptMap = new HashMap();
        Map enableSubmitMap = new HashMap();
        Set checkIds = new HashSet();
        boolean isNeedAsk = false;
        String askMsg = null;
        String askDetailMsg = null;
        Map ret = null;
        boolean isAddNew = false;
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW)) {
            isAddNew = true;
        }
        if (isSubmit && !isAddNew) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", ids);
            params.put("recordType", (Object)this.getRecordType());
            ret = TaxDraftRecordFactory.getRemoteInstance().beforeSubmit(params);
            promptMap = (Map)ret.get("promptMap");
            checkIds = (Set)ret.get("checkIds");
            enableSubmitMap = (Map)ret.get("enableSubmitMap");
            promptMap = (Map)ret.get("promptMap");
            isNeedAsk = (Boolean)ret.get("isNeedAsk");
            askMsg = (String)ret.get("askMsg");
            askDetailMsg = (String)ret.get("askDetailMsg");
            if (isNeedAsk) {
                result = TaxMsgBox.showReportConfirm4a(askMsg, askDetailMsg, null);
                if (result == 99) {
                    htmls = null;
                    if (ret != null && ret.get("checkResultMap") != null) {
                        reportCheck = new ReportCheck();
                        htmls = reportCheck.exportCheckResult(ret);
                    }
                    params = new HashMap();
                    params.put("htmls", htmls);
                    CheckUtils.showEditorPanel(params);
                    SysUtil.abort();
                } else if (result != 0) {
                    SysUtil.abort();
                }
            }
        }
        TaxReportTemplateInfo templetReportInfo = (TaxReportTemplateInfo)this.prmtTempletReport.getValue();
        if (isAddNew && templetReportInfo != null) {
            templetReportInfo = (TaxReportTemplateInfo)TaxReportTemplateFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(templetReportInfo.getId().toString()), TaxReportTemplateInfo.getSelectors());
        }
        for (int i = 0; i < recordColl.size(); ++i) {
            recordInfo = recordColl.get(i);
            if (isAddNew && templetReportInfo != null) {
                recordInfo.setData(templetReportInfo.getData());
            }
            try {
                if (isSubmit) {
                    if (!enableSubmitMap.containsKey(recordInfo.getId().toString()) && !isAddNew) {
                        throw new TDException(TDException.ERROR_MSG, new Object[]{promptMap.get(recordInfo.getId().toString())});
                    }
                    this.checkPermission(recordInfo.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("submit"));
                    pk = TaxDraftRecordFactory.getRemoteInstance().submit((CoreBaseInfo)recordInfo);
                    continue;
                }
                String actionType = null;
                actionType = this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW) ? "add" : "edit";
                this.checkPermission(recordInfo.getCompanyOrgUnit().getId().toString(), this.getPermissionItem(actionType));
                pk = TaxDraftRecordFactory.getRemoteInstance().save((CoreBaseInfo)recordInfo);
                continue;
            }
            catch (Exception ex) {
                if (ex.getCause() != null) {
                    errorDetail.append(ex.getCause().getMessage()).append("\n");
                } else {
                    errorDetail.append(ex.getMessage()).append("\n");
                }
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.getUIWindow().hide();
            if (isSubmit) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitSuccess"));
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"saveSuccess"));
            }
        } else if (errorCount == units.length) {
            if (isSubmit) {
                result = TaxMsgBox.showReportDetailAndOK((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitFailure"), errorDetail.toString(), 8188, null);
                if (result == 99) {
                    htmls = null;
                    if (ret != null && ret.get("checkResultMap") != null) {
                        reportCheck = new ReportCheck();
                        htmls = reportCheck.exportCheckResult(ret);
                    }
                    HashMap<String, String[]> params = new HashMap<String, String[]>();
                    params.put("htmls", htmls);
                    CheckUtils.showEditorPanel(params);
                    SysUtil.abort();
                } else if (result != 0) {
                    SysUtil.abort();
                }
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"saveFailure"), (String)errorDetail.toString(), (int)0);
            }
        } else {
            this.getUIWindow().hide();
            if (isSubmit) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitPartSuccess", (Object[])new Object[]{units.length - errorCount, errorCount}), (String)errorDetail.toString(), (int)0);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"savePartSuccess", (Object[])new Object[]{units.length - errorCount, errorCount}), (String)errorDetail.toString(), (int)0);
            }
        }
        return pk;
    }

    protected void afterSaveOrSubmit(IObjectPK pk, boolean isSubmit) throws Exception {
        boolean isOpenRptView = true;
        Object[] orgUnitObj = this.getCompanyOrgUnitValue();
        if (orgUnitObj.length > 1) {
            isOpenRptView = false;
        }
        if (isOpenRptView && pk != null) {
            TaxDraftRecordInfo taxDraftRecordInfo = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordInfo(pk, TDSelectorFactory.getTaxDraftRecordSelectors());
            UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
            uiContext.put((Object)"InitDataObject", (Object)taxDraftRecordInfo);
            uiContext.put((Object)"isSubmit", (Object)isSubmit);
            if (isSubmit) {
                uiContext.put((Object)"submitRecordID", (Object)(taxDraftRecordInfo.getId() == null ? "" : taxDraftRecordInfo.getId().toString()));
            }
            this.openProcessUI(uiContext, this.getOprtState());
        }
    }

    private Object[] getCompanyOrgUnitValue() {
        Object[] orgUnitObj = null;
        CompanyOrgUnitInfo unitInfo = null;
        if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
            unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            orgUnitObj = new Object[]{unitInfo};
        } else {
            orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
        }
        return orgUnitObj;
    }

    protected void checkPermission(String orgId, String permissionItem) throws EASBizException, BOSException {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SUBMIT)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"statesNoSubmit"));
            SysUtil.abort();
        }
        this.selectStates.setSelectedItem((Object)DraftStatusEnum.AUDIT);
        super.actionAudit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.AUDIT)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"statesNoAudit"));
            SysUtil.abort();
        }
        this.selectStates.setSelectedItem((Object)DraftStatusEnum.SAVE);
        super.actionUnAudit_actionPerformed(e);
    }

    @Override
    public void actionComfire_actionPerformed(ActionEvent e) throws Exception {
        super.actionComfire_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getCompanyOrgUnit() != null) {
            this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("add"));
        }
        this.beforeCopy(this.editData);
        super.actionCopy_actionPerformed(e);
        this.copyRecordInfo = this.editData;
        this.cou = null;
        this.afterLoad();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxDraftRecordInfo info = (TaxDraftRecordInfo)newData;
        info.setIsVoucher(false);
        info.setVoucherID(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setNumber(null);
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(new Date().getTime()));
        info.setLastUpdateUser(null);
        info.setLastUpdateTime(null);
        info.setBuildingTaxesGroup(null);
        info.setDraftStatus(DraftStatusEnum.SAVE);
        try {
            String newNumber = this.getNewNumberByUnit(info, info.getCompanyOrgUnit().getId().toString());
            info.setNumber(newNumber);
        }
        catch (Exception e1) {
            logger.error((Object)"set number error");
        }
    }

    private void beforeCopy(TaxDraftRecordInfo recordInfo) {
        if (!RecordTypeEnum.Account.equals((Object)recordInfo.getRecordType()) && DraftRecordTypeEnum.changRecord.equals((Object)recordInfo.getDraftRecordType())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ChangRecordCannotCopy"));
            SysUtil.abort();
        }
    }

    protected void openProcessUI(UIContext uiContext, String oprtState) throws UIException {
        this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTaxDraftRptUI(), (Map)uiContext, null, oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaxDraftEditUI.this.uiWindow.show();
            }
        });
    }

    protected abstract String getTaxDraftRptUI();

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.selectDraftRecordType) && e.getStateChange() == 1) {
            if (e.getItem().equals((Object)DraftRecordTypeEnum.normalRecord)) {
                if (RecordTypeEnum.TaxDeclare.equals((Object)this.getRecordType()) || RecordTypeEnum.AnnualTaxDeclare.equals((Object)this.getRecordType())) {
                    this.prmtRelateDraftRecord.setValue(null);
                    this.prmtRelateDraftRecord.setEnabled(false);
                }
            } else {
                if (RecordTypeEnum.TaxDeclare.equals((Object)this.getRecordType()) || RecordTypeEnum.AnnualTaxDeclare.equals((Object)this.getRecordType())) {
                    this.prmtRelateDraftRecord.setEnabled(true);
                }
                Object[] orgUnitObj = null;
                CompanyOrgUnitInfo unitInfo = null;
                if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
                    unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
                    orgUnitObj = new Object[]{unitInfo};
                } else {
                    orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
                }
                if (orgUnitObj != null && orgUnitObj.length > 1) {
                    this.selectDraftRecordType.setSelectedItem((Object)DraftRecordTypeEnum.normalRecord);
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ChangRecordCannotCopy"));
                    SysUtil.abort();
                } else {
                    this.prmtCompanyOrgUnit.setEnabledMultiSelection(false);
                }
            }
        }
    }

    public String getNewNumberByUnit(TaxDraftRecordInfo info, String bizOrgUnitID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (info.getCU() == null) {
            info.setCU(info.getCompanyOrgUnit().getCU());
        }
        return iCodingRuleManager.getNumber((IObjectValue)info, bizOrgUnitID, "ownerMenu", "ownerMenu");
    }

    protected boolean isEqual(Object o1, Object o2) {
        int i;
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        Object[] org1 = null;
        Object[] org2 = null;
        CompanyOrgUnitInfo unitInfo = null;
        if (o1 instanceof CompanyOrgUnitInfo) {
            unitInfo = (CompanyOrgUnitInfo)o1;
            org1 = new Object[]{unitInfo};
        } else {
            org1 = (Object[])o1;
        }
        if (o2 instanceof CompanyOrgUnitInfo) {
            unitInfo = (CompanyOrgUnitInfo)o2;
            org2 = new Object[]{unitInfo};
        } else {
            org2 = (Object[])o2;
        }
        if (org1.length != org2.length) {
            return false;
        }
        HashMap<String, CompanyOrgUnitInfo> org1Map = new HashMap<String, CompanyOrgUnitInfo>();
        for (i = 0; i < org1.length; ++i) {
            unitInfo = (CompanyOrgUnitInfo)org1[i];
            org1Map.put(unitInfo.getId().toString(), unitInfo);
        }
        for (i = 0; i < org2.length; ++i) {
            unitInfo = (CompanyOrgUnitInfo)org2[i];
            if (org1Map.get(unitInfo.getId().toString()) != null) continue;
            return false;
        }
        return true;
    }

    public void dataChanged(DataChangeEvent e) {
        if (!e.getSource().equals(this.prmtCompanyOrgUnit)) {
            return;
        }
        if (e.getNewValue() != null && this.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        if (e.getNewValue() == null && !this.isEqual(e.getNewValue(), e.getOldValue())) {
            try {
                this.setPrmtRelateDraftRecordFilter();
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
        try {
            this.setPrmtRelateAccountFilter();
        }
        catch (Exception e3) {
            this.handleException(e3);
        }
        if (this.copyRecordInfo == null || this.prmtCompanyOrgUnit.getValue() == null) {
            return;
        }
        TaxDraftRecordInfo tempInfo = (TaxDraftRecordInfo)this.copyRecordInfo.clone();
        this.number.setText("");
        StringBuffer numbersb = new StringBuffer();
        Object[] orgUnitObj = null;
        boolean isMutiOrg = false;
        if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            orgUnitObj = new Object[]{unitInfo};
            this.prmtRelateNextAccount.setEnabled(true);
        } else {
            orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
        }
        if (orgUnitObj != null && orgUnitObj.length > 1) {
            isMutiOrg = true;
        } else if (orgUnitObj != null && orgUnitObj.length == 1) {
            this.setPrmtRelateDraftRecordFilterByCompanyUnit();
        }
        this.prmtRelateNextAccount.setValue(null);
        if (isMutiOrg) {
            this.prmtRelateNextAccount.setEnabled(false);
        } else {
            this.prmtRelateNextAccount.setEnabled(true);
            try {
                this.setPrmtRelateRecordAccountFilter();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
        for (int i = 0; i < orgUnitObj.length; ++i) {
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)orgUnitObj[i];
            tempInfo.setCompanyOrgUnit(companyOrgUnit);
            String newNumber = "";
            try {
                newNumber = this.getNewNumberByUnit(tempInfo, companyOrgUnit.getId().toString());
                numbersb.append(newNumber).append(";");
                continue;
            }
            catch (EASBizException e1) {
                logger.error((Object)e1.getMessage());
                continue;
            }
            catch (BOSException e2) {
                logger.error((Object)e2.getMessage());
            }
        }
        this.number.setText(numbersb.toString());
        this.initNumber();
    }

    protected void setTempletReportFilter() throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)this.getTaxTypeInfo().getId().toString(), CompareType.EQUALS));
        if (this.getRecordType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)this.getRecordType().getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtTempletReport.setEntityViewInfo(ev);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billRange.id"));
        sic.add(new SelectorItemInfo("billRange.number"));
        sic.add(new SelectorItemInfo("billRange.name"));
        this.prmtTempletReport.setSelectorCollection(sic);
    }
}

