/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.TaxReportStatusEnum;
import com.kingdee.eas.tm.td.client.AbstractTaxOtherReportEditUI;
import com.kingdee.eas.tm.td.client.TaxOtherReportUIHelper;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxOtherReportEditUI
extends AbstractTaxOtherReportEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxOtherReportEditUI.class);
    private CompanyOrgUnitInfo company = null;
    private DataChangeListener companyDataChangeListener = null;
    private DataChangeListener periodDataChangeListener = null;
    private NewCompanyF7 companySelector = null;

    public void onLoad() throws Exception {
        this.initContext();
        super.onLoad();
        this.initControl();
    }

    private void initContext() throws EASBizException, BOSException {
        if (OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.editData = (TaxOtherReportInfo)this.getUIContext().get("InitDataObject");
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
    }

    private void initControl() {
        this.companySelector = new NewCompanyF7((IUIObject)this);
        this.companySelector.setShowAssistantOrg(false);
        this.companySelector.setIsCUFilter(false);
        this.companySelector.setShowVirtual(true);
        this.companySelector.setContainSealUp(false);
        this.companySelector.setNeedAddAssistant(true);
        this.companySelector.setMultiSelect(true);
        this.companySelector.setPermissionItem("td_taxotherreport_view");
        this.prmtCompanyOrgUnit.setSelector((KDPromptSelector)this.companySelector);
        this.prmtCompanyOrgUnit.setHistoryRecordEnabled(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtCompanyOrgUnit.setValue((Object)this.company);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initComponents();
        try {
            this.initFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initComponents() {
        if (this.companySelector != null) {
            this.companySelector.setMultiSelect(OprtState.COPYADDNEW.equals(this.getOprtState()));
        }
        this.prmtReportTemplate.setEnabled(this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void removeListener() {
        if (this.companyDataChangeListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.companyDataChangeListener);
        }
        if (this.periodDataChangeListener != null) {
            this.prmtRptPeriod.removeDataChangeListener(this.periodDataChangeListener);
        }
    }

    private void addListener() {
        if (this.companyDataChangeListener == null) {
            this.companyDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        TaxOtherReportEditUI.this.prmtCompanyOrgUnit_dataChanged(eventObj);
                    }
                    catch (Exception e) {
                        TaxOtherReportEditUI.this.handUIException(e);
                    }
                }
            };
            this.prmtCompanyOrgUnit.addDataChangeListener(this.companyDataChangeListener);
        }
        if (this.periodDataChangeListener == null) {
            this.periodDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    TaxOtherReportEditUI.this.prmtRptPeriod_dataChanged(eventObj);
                }
            };
            this.prmtRptPeriod.addDataChangeListener(this.periodDataChangeListener);
        }
    }

    private void prmtCompanyOrgUnit_dataChanged(DataChangeEvent e) throws BOSException, EASBizException {
        if (e.getNewValue() == null) {
            return;
        }
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        HashSet companyIds = new HashSet(TDUtils.getF7Value(e.getNewValue()));
        if (companyIds.size() > 1 && !TDUtils.hasSameAccountPeriodType(new HashSet(companyIds))) {
            this.prmtCompanyOrgUnit.setValue(e.getOldValue());
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "hasSameAccountPeriodType_error", null));
            SysUtil.abort();
        }
        this.initPeriodFilter();
    }

    private void prmtRptPeriod_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return;
        }
        if (TDUtils.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        PeriodInfo periodInfo = (PeriodInfo)this.prmtRptPeriod.getValue();
        this.pkStartDate.setValue((Object)periodInfo.getBeginDate());
        this.pkEndDate.setValue((Object)periodInfo.getEndDate());
        this.editData.setYear(periodInfo.getPeriodYear());
        this.editData.setPeriod((short)periodInfo.getPeriodNumber());
        this.prmtRptPeriodFrom.setValue(null);
        this.prmtRptPeriodTo.setValue(null);
    }

    private void initFilter() throws EASBizException, BOSException {
        this.initReportTypeFilter();
        this.initReportTemplateFilter();
        this.initPeriodFilter();
        this.initBillRangeFilter();
    }

    private void initReportTypeFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportType.setEntityViewInfo(view);
    }

    private void initReportTemplateFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportTemplate.setEntityViewInfo(view);
    }

    private void initPeriodFilter() throws EASBizException, BOSException {
        List companys = TDUtils.getF7ValueObject(this.prmtCompanyOrgUnit.getValue());
        if (companys.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(0);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.*"));
        CompanyOrgUnitInfo cou = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        String accountPeriodTypeId = cou.getAccountPeriodType().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)accountPeriodTypeId, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtRptPeriod.setEntityViewInfo(view);
        this.prmtRptPeriodFrom.setEntityViewInfo(view);
        this.prmtRptPeriodTo.setEntityViewInfo(view);
    }

    private void initBillRangeFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)"-1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxType", null, CompareType.IS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBillRange.setEntityViewInfo(view);
    }

    protected IObjectValue createNewData() {
        TaxOtherReportInfo reportInfo = new TaxOtherReportInfo();
        reportInfo.setSubPeriodType(PeriodTypeEnum.MONTHLY);
        reportInfo.setState(TaxReportStatusEnum.SAVE);
        return reportInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxOtherReportFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxOtherReportUIHelper.setFieldNull((TaxOtherReportInfo)newData);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        if (this.isBatchOperation()) {
            this.storeFields();
            this.batchOperation("save");
        } else {
            this.innerStoreFields();
            if (this.prmtCompanyOrgUnit.getValue() != null && this.prmtCompanyOrgUnit.getValue() instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] companys = (OrgUnitInfo[])this.prmtCompanyOrgUnit.getValue();
                this.editData.setCompanyOrgUnit((CompanyOrgUnitInfo)companys[0]);
            }
            super.actionSave_actionPerformed(e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.setOprtState(OprtState.COPYADDNEW);
        this.loadFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        if (this.isBatchOperation()) {
            this.storeFields();
            this.batchOperation("submit");
        } else {
            if (this.editData.getId() != null && SCMClientUtils.checkAllBizObjInWfProcess((String[])new String[]{this.editData.getId().toString()})) {
                this.actionMultiapprove_actionPerformed(null);
                return;
            }
            this.innerStoreFields();
            super.actionSubmit_actionPerformed(e);
        }
    }

    private void innerStoreFields() throws EASBizException, BOSException {
        TaxOtherReportTemplateInfo templetInfo = this.getTemplateInfo();
        if (templetInfo != null) {
            this.editData.setData(templetInfo.getData());
        }
    }

    private TaxOtherReportTemplateInfo getTemplateInfo() throws EASBizException, BOSException {
        TaxOtherReportTemplateInfo templetInfo = (TaxOtherReportTemplateInfo)this.prmtReportTemplate.getValue();
        if (templetInfo != null) {
            templetInfo = (TaxOtherReportTemplateInfo)TaxOtherReportTemplateFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()), TaxOtherReportTemplateInfo.getSelectors());
        }
        return templetInfo;
    }

    private void checkRequiredFields() {
        List companyIds;
        String[] nums;
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001").append(this.contNumber.getBoundLabelText());
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001").append(this.contName.getBoundLabelText());
        }
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            sb.append("\u3001").append(this.contCompanyOrgUnit.getBoundLabelText());
        }
        if (this.prmtReportType.getValue() == null) {
            sb.append("\u3001").append(this.contReportType.getBoundLabelText());
        }
        if (this.prmtRptPeriod.getValue() == null) {
            sb.append("\u3001").append(this.contRptPeriod.getBoundLabelText());
        }
        if (this.pkStartDate.getValue() == null) {
            sb.append("\u3001").append(this.contStartDate.getBoundLabelText());
        }
        if (this.pkEndDate.getValue() == null) {
            sb.append("\u3001").append(this.contEndDate.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if (OprtState.COPYADDNEW.equals(this.getOprtState()) && (nums = this.txtNumber.getText().split(";")).length != (companyIds = TDUtils.getF7Value(this.prmtCompanyOrgUnit.getValue())).size()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NotEnoughNumber"));
            SysUtil.abort();
        }
    }

    private boolean isBatchOperation() {
        List companyIds = TDUtils.getF7Value(this.prmtCompanyOrgUnit.getValue());
        return companyIds.size() > 1;
    }

    private void batchOperation(String method) throws Exception {
        Throwable[] ex = null;
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        List companys = TDUtils.getF7ValueObject(this.prmtCompanyOrgUnit.getValue());
        String[] nums = this.txtNumber.getText().split(";");
        TaxOtherReportTemplateInfo templetInfo = this.getTemplateInfo();
        TaxOtherReportCollection reportColl = new TaxOtherReportCollection();
        TaxOtherReportInfo reportInfo = null;
        for (int i = 0; i < companys.size(); ++i) {
            reportInfo = (TaxOtherReportInfo)this.editData.clone();
            reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
            reportInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)companys.get(i));
            reportInfo.setNumber(nums[i]);
            reportInfo.setState(TaxReportStatusEnum.SAVE);
            reportInfo.setData(templetInfo != null ? templetInfo.getData() : reportInfo.getData());
            reportColl.add(reportInfo);
        }
        ArrayList<String> exceptionIds = new ArrayList<String>();
        HashMap<String, String> mapNumber = new HashMap<String, String>();
        if (reportColl.size() > 0) {
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[reportColl.size()];
            for (int i = 0; i < reportColl.size(); ++i) {
                BatchExecuteParamsEntry entry;
                if (reportColl.get(i) == null) continue;
                paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{CoreBaseInfo.class}, new Object[]{reportColl.get(i)});
            }
            BatchExecuteResult result = this.getBizInterface().batchExecute(method, new Class[]{CoreBaseInfo.class}, paramEntries);
            ex = result.getExceptions();
            for (int i = 0; i < ex.length; ++i) {
                if (ex[i] == null) continue;
                exceptionMap.put(reportColl.get(i).getId().toString(), ex[i]);
                mapNumber.put(reportColl.get(i).getId().toString(), reportColl.get(i).getNumber());
                exceptionIds.add(reportColl.get(i).getId().toString());
            }
        }
        StringBuffer errorMsg = new StringBuffer();
        Iterator lter = exceptionIds.iterator();
        String operatorName = method.equals("save") ? this.btnSave.getText() : this.btnSubmit.getText();
        String numbetMsg = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "oprtDetail", null, new Object[]{operatorName});
        while (lter.hasNext()) {
            String id = (String)lter.next();
            errorMsg.append(MessageFormat.format(numbetMsg, mapNumber.get(id)));
            if (!exceptionMap.isEmpty()) {
                errorMsg.append("\uff0c" + ExceptionMessageUtility.getMessage((Throwable)((Throwable)exceptionMap.get(id))) + "\n");
                continue;
            }
            errorMsg.append("\n");
        }
        if (exceptionIds.size() > 0) {
            String oprtError = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "oprtError", null, new Object[]{operatorName});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)oprtError, (String)errorMsg.toString(), (int)8188);
        } else {
            this.getUIWindow().hide();
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "oprtSuccess", null, new Object[]{operatorName}));
        }
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String[] boID = new String[]{this.getSelectBOID()};
        if (boID[0] == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            this.abort();
        }
        MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])boID);
    }
}

