/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeFactory;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.client.AbstractBackupDataTypeListUI;
import com.kingdee.eas.tm.td.cloud.client.BackupDataTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BackupDataTypeListUI
extends AbstractBackupDataTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BackupDataTypeListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        BackupDataTypeInfo info = BackupDataTypeFactory.getRemoteInstance().getBackupDataTypeInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.isIsPreinstall()) {
            MsgBox.showInfo((String)(info.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Preinstall_Not_Edit")));
            SysUtil.abort();
            return;
        }
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            MsgBox.showInfo((String)(info.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Active_NotEdit")));
            SysUtil.abort();
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList result = BackupDataTypeFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
        String error = "";
        String errorDetail = "";
        if (result != null && !result.isEmpty()) {
            error = EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"REMOVE_ERROR");
            errorDetail = this.buildErrorMsg(result);
            MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
        }
        this.refreshList();
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return BackupDataTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BackupDataTypeFactory.getRemoteInstance();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = BackupDataTypeFactory.getRemoteInstance().cancel(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append((String)errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList errorList = BackupDataTypeFactory.getRemoteInstance().cancelCancel(new HashSet(this.getSelectedIdValues()));
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append((String)errorList.get(i)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG.toString(), (int)8188);
        }
        this.actionRefresh_actionPerformed(e);
    }
}

