/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.UserGroupFactory;
import com.kingdee.eas.tm.td.cloud.client.AbstractGroupAssignViewUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class GroupAssignViewUI
extends AbstractGroupAssignViewUI {
    private static final Logger logger = CoreUIObject.getLogger(GroupAssignViewUI.class);
    public static final int VIEW_USER = 0;
    public static final int VIEW_GROUP = 1;
    public static final int VIEW_OWNGROUP = 2;
    private int viewType = -1;
    private FilterInfo filterInfo = null;
    private DataChangeListener prmtUserListener = null;
    private DataChangeListener prmtGroupListener = null;
    private GroupInfo group = null;
    private GroupInfo defaultGroup = null;
    UserInfo user = null;
    private static final Color DEFAULT_ORG_COLOR = Color.cyan;
    public static final String TBL_GROUPNUMBER = "group.number";
    public static final String TBL_GROUPNAME = "group.name";
    public static final String TBL_USERNUMBER = "user.number";
    public static final String TBL_USERNAME = "user.name";
    public static final String TBL_ISDEFAULT = "isDefault";
    public static final String[] userColumns = new String[]{"user.number", "user.name"};
    public static final String[] groupColumns = new String[]{"group.number", "group.name"};
    private KDTDataFillListener kdtfListener = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
    }

    private void removeListener() {
        if (this.prmtUserListener != null) {
            this.prmtUser.removeDataChangeListener(this.prmtUserListener);
        }
        if (this.prmtGroupListener != null) {
            this.prmtGroup.removeDataChangeListener(this.prmtGroupListener);
        }
        if (this.kdtfListener != null) {
            this.tblMain.removeKDTDataFillListener(this.kdtfListener);
        }
    }

    private void initListeners() {
        if (this.prmtUserListener == null) {
            this.prmtUserListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        GroupAssignViewUI.this.user_datachange(e);
                    }
                    catch (Exception ex) {
                        GroupAssignViewUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtUser.addDataChangeListener(this.prmtUserListener);
        if (this.prmtGroupListener == null) {
            this.prmtGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        GroupAssignViewUI.this.group_itemchange(e);
                    }
                    catch (Exception ex) {
                        GroupAssignViewUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtGroup.addDataChangeListener(this.prmtGroupListener);
        this.kdtfListener = new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    GroupAssignViewUI.this.kdtTable_afterTableRequestData(e);
                }
                catch (EASBizException e1) {
                    GroupAssignViewUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    GroupAssignViewUI.this.handUIException(e1);
                }
            }
        };
        this.tblMain.addKDTDataFillListener(this.kdtfListener);
    }

    protected void kdtTable_afterTableRequestData(KDTDataRequestEvent e) throws EASBizException, BOSException {
        if (this.viewType == 0) {
            return;
        }
        IRow row = null;
        int rowCount = this.tblMain.getRowCount3();
        if (rowCount > 0) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                boolean isDefault;
                row = this.tblMain.getRow2(i);
                if (row == null || !(isDefault = ((Boolean)row.getCell(TBL_ISDEFAULT).getValue()).booleanValue())) continue;
                row.getStyleAttributes().setBackground(DEFAULT_ORG_COLOR);
                this.txtDefaultContext.setText(row.getCell(TBL_GROUPNAME).getValue().toString());
                break;
            }
        }
    }

    private void user_datachange(DataChangeEvent e) throws EASBizException, BOSException {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        this.user = (UserInfo)e.getNewValue();
        this.initFilterInfo();
        this.execQuery();
    }

    private void group_itemchange(DataChangeEvent e) throws EASBizException, BOSException {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        this.group = (GroupInfo)e.getNewValue();
        this.initFilterInfo();
        this.execQuery();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    public void afterLoad() throws EASBizException, BOSException {
        this.initContext();
        this.setUITitle();
        this.initBtnStatus();
        this.loadFields();
        this.initControl();
        this.initFilterInfo();
        this.execQuery();
    }

    private void initContext() {
        this.user = SysContext.getSysContext().getCurrentUserInfo();
        this.viewType = (Integer)this.getUIContext().get("viewType");
        String groupID = (String)this.getUIContext().get("group");
        try {
            if (!StringUtils.isEmpty((String)groupID)) {
                this.group = GroupFactory.getRemoteInstance().getGroupInfo((IObjectPK)new ObjectUuidPK(groupID));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initBtnStatus() {
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnView.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnSetDefaultGroup.setVisible(false);
    }

    private void initFilterInfo() {
        String groupID = null;
        String userID = null;
        if (this.group != null) {
            groupID = this.group.getId().toString();
        }
        if (this.user != null) {
            userID = this.user.getId().toString();
        }
        FilterInfo filterInfo = new FilterInfo();
        if (this.viewType == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID, CompareType.EQUALS));
        } else if (this.viewType == 1 || this.viewType == 2) {
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userID, CompareType.EQUALS));
        }
        this.filterInfo = filterInfo;
    }

    private FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    protected void execQuery() {
        this.mainQuery.setFilter(this.getFilterInfo());
        super.execQuery();
    }

    protected void setUITitle() {
        if (0 == this.viewType) {
            this.setUITitle("\u6309\u5206\u7ec4\u67e5\u8be2\u7528\u6237");
        } else if (1 == this.viewType) {
            this.setUITitle("\u6309\u7528\u6237\u67e5\u8be2\u5206\u7ec4");
        } else if (2 == this.viewType) {
            this.setUITitle("\u6211\u7684\u5206\u7ec4\u8303\u56f4");
        }
    }

    private void initControl() {
        this.setTableColumnVisible(userColumns, 0 != this.viewType);
        this.setTableColumnVisible(groupColumns, 0 == this.viewType);
        this.groupContainer.setVisible(0 == this.viewType);
        this.userContainer.setVisible(0 != this.viewType);
        this.prmtUser.setEnabled(2 != this.viewType);
        this.txtDefaultHead.setVisible(0 != this.viewType);
        this.txtDefaultHead.setForeground(Color.BLUE);
        this.txtDefaultContext.setVisible(0 != this.viewType);
        this.txtDefaultContext.setForeground(Color.BLUE);
        this.prmtUser.setValue((Object)this.user);
        this.prmtGroup.setValue((Object)this.group);
    }

    private void setTableColumnVisible(String[] columns, boolean isHided) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            this.tblMain.getColumn(columns[i]).getStyleAttributes().setHided(isHided);
        }
    }

    @Override
    public void actionSetDefaultGroup_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        UserGroupFactory.getRemoteInstance().setDefaultGroup(billID);
        this.actionRefresh_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }
}

