/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckAccountViewListUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckAccountViewListUI
extends AbstractCheckAccountViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckAccountViewListUI.class);
    private int viewType = -1;
    private DataChangeListener prmtCompanyListener = null;
    private DataChangeListener prmtCheckAccountListener = null;
    private FilterInfo filterInfo = null;
    public static final String TBL_COMPANYNUMBER = "company.number";
    public static final String TBL_COMPANYNAME = "company.name";
    public static final String TBL_CODE = "company.code";
    public static final String[] companyView = new String[]{"company.number", "company.name", "company.code"};
    public static final String TBL_CHECKACCTNUMBER = "checkAcct.number";
    public static final String TBL_CHECKACCTNAME = "checkAcct.name";
    public static final String TBL_TAXTYPE = "taxType.name";
    public static final String TBL_CHECKITEMTYPE = "checkItemType.name";
    public static final String TBL_ACCOUNTNUMBER = "account.number";
    public static final String TBL_ACOUNTNAME = "account.name";
    public static final String[] checkAcctView = new String[]{"checkAcct.number", "checkAcct.name", "taxType.name", "checkItemType.name", "account.number", "account.name"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad(null);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
    }

    private void removeListener() {
        if (this.prmtCompanyListener != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        }
        if (this.prmtCheckAccountListener != null) {
            this.prmtCheckAcct.removeDataChangeListener(this.prmtCheckAccountListener);
        }
    }

    private void initListeners() {
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        CheckAccountViewListUI.this.companyChange(e);
                    }
                    catch (Exception ex) {
                        CheckAccountViewListUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        if (this.prmtCheckAccountListener == null) {
            this.prmtCheckAccountListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        CheckAccountViewListUI.this.checkAcctChange(e);
                    }
                    catch (Exception ex) {
                        CheckAccountViewListUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtCheckAcct.addDataChangeListener(this.prmtCheckAccountListener);
    }

    protected void companyChange(DataChangeEvent e) throws Exception {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)e.getNewValue();
        this.initFilterInfo(companyInfo.getId().toString(), null);
        this.execQuery();
    }

    private FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    protected void execQuery() {
        this.mainQuery.setFilter(this.getFilterInfo());
        super.execQuery();
        this.setVisibleByViewType();
    }

    private void setVisibleByViewType() {
        if (this.viewType == 0) {
            this.kDLabelContainer1.setVisible(false);
            this.kDLabelContainer2.setVisible(true);
            this.setTableColumnVisible(companyView, false);
            this.setTableColumnVisible(checkAcctView, true);
        } else if (this.viewType == 1) {
            this.kDLabelContainer1.setVisible(true);
            this.kDLabelContainer2.setVisible(false);
            this.setTableColumnVisible(companyView, true);
            this.setTableColumnVisible(checkAcctView, false);
        }
    }

    private void setTableColumnVisible(String[] columns, boolean isHided) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            this.tblMain.getColumn(columns[i]).getStyleAttributes().setHided(isHided);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void checkAcctChange(DataChangeEvent e) throws Exception {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        CheckAccountInfo itemInfo = (CheckAccountInfo)e.getNewValue();
        this.initFilterInfo(null, itemInfo.getId().toString());
        this.execQuery();
    }

    private void initFilterInfo(String companyID, String billId) {
        FilterInfo filterInfo = new FilterInfo();
        if (this.viewType == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAcct.id", (Object)billId, CompareType.EQUALS));
        } else if (this.viewType == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        }
        this.filterInfo = filterInfo;
    }

    public void afterLoad(Map uiContext) throws EASBizException, BOSException {
        Map uictx = uiContext;
        if (uictx == null) {
            uictx = this.getUIContext();
        }
        this.viewType = (Integer)uictx.get("viewType");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)uictx.get("company");
        String billId = (String)uictx.get("billId");
        if (!StringUtils.isEmpty((String)billId)) {
            CheckAccountInfo check = CheckAccountFactory.getRemoteInstance().getCheckAccountInfo((IObjectPK)new ObjectUuidPK(billId));
            this.prmtCheckAcct.setValue((Object)check);
        }
        this.prmtCompany.setValue((Object)company);
        this.initBtnStatus();
        this.setVisibleByViewType();
        this.initFilterInfo(company.getId().toString(), billId);
        this.execQuery();
        this.loadFields();
    }

    protected void initBtnStatus() {
        this.actionAddNew.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionView.setVisible(false);
        this.actionQuery.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckAccountViewFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

