/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckBaseCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckBaseInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ICheckBase;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckAssignUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CheckAssignUI
extends AbstractCheckAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckAssignUI.class);
    private ActionListener companySearchListener = null;
    private ActionListener itemSearchListener = null;
    private KDTEditAdapter companyForAssignedListener = null;
    private String oldItemSearchCondition = "";
    private String oldComSearchCondition = "";
    ArrayList itemAssignedIDList = new ArrayList();
    private CheckTypeEnum checkType = null;
    private CompanyOrgUnitCollection couCols = new CompanyOrgUnitCollection();
    private CheckBaseCollection checkCols = new CheckBaseCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.rbAssigned.setEnabled(true);
        this.rbNotAssigned.setEnabled(true);
        this.btnAllSelect.setEnabled(true);
        this.btnAllDisSelect.setEnabled(true);
        this.checkType = (CheckTypeEnum)((Object)this.getUIContext().get("checkType"));
        this.loadFields();
        this.tblAccountForAssigned.getColumn("indexType").getStyleAttributes().setHided(CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType));
        this.tblAccountForAssigned.getIndexColumn().getStyleAttributes().setHided(true);
    }

    @Override
    public void loadFields() {
        this.removeLiseners();
        super.loadFields();
        this.loadCompanyForAssigned(null);
        this.loadItemForAssigned();
        this.loadSelectedStatus();
        this.fillFilterFields();
        this.initLiseners();
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblAccountForAssigned);
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblCompanyForAssigned);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.companyTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.itemTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
    }

    private void initLiseners() {
        if (this.companySearchListener == null) {
            this.companySearchListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckAssignUI.this.onClickForBtnCompanySearch();
                }
            };
        }
        this.btnCompanySearch.addActionListener(this.companySearchListener);
        if (this.itemSearchListener == null) {
            this.itemSearchListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckAssignUI.this.onClickForBtnItemSearch();
                }
            };
        }
        this.btnItemSearch.addActionListener(this.itemSearchListener);
        if (this.companyForAssignedListener == null) {
            this.companyForAssignedListener = new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    if (e.getColIndex() == 1) {
                        KDTable tblCompany = (KDTable)e.getSource();
                        IRow row = tblCompany.getRow(e.getRowIndex());
                        if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                            row.getCell("selected").setValue((Object)Boolean.TRUE);
                        } else {
                            row.getCell("selected").setValue((Object)Boolean.FALSE);
                        }
                        CheckAssignUI.this.loadSelectedStatus();
                        CheckAssignUI.this.itemFastQuery();
                    }
                }
            };
        }
        this.tblCompanyForAssigned.addKDTEditListener((KDTEditListener)this.companyForAssignedListener);
    }

    private void removeLiseners() {
        this.btnCompanySearch.removeActionListener(this.companySearchListener);
        this.btnItemSearch.removeActionListener(this.itemSearchListener);
        this.tblCompanyForAssigned.removeKDTEditListener((KDTEditListener)this.companyForAssignedListener);
    }

    private void onClickForBtnCompanySearch() {
        String text = this.companyTextField.getText();
        String filter = ((FilterFieldItem)this.companySearchField.getSelectedItem()).getName();
        StringBuffer newCondition = new StringBuffer();
        if ("number".equals(filter)) {
            newCondition.append("  number like '%").append(text).append("%'");
        } else if ("name".equals(filter)) {
            newCondition.append("  name like '%").append(text).append("%'");
        }
        if (!newCondition.equals(this.oldComSearchCondition)) {
            this.oldComSearchCondition = newCondition.toString();
            if (StringUtils.isEmpty((String)text)) {
                this.loadCompanyForAssigned(null);
            } else {
                this.loadCompanyForAssigned(this.oldComSearchCondition);
            }
            this.loadSelectedStatus();
        }
    }

    private void onClickForBtnItemSearch() {
        String text = StringUtils.trim((String)this.itemTextField.getText());
        String newCondition = this.itemSearchField.getSelectedItem().toString() + text;
        if (!newCondition.equals(this.oldItemSearchCondition)) {
            this.loadItemForAssigned();
            this.loadSelectedStatus();
            this.itemFastQuery();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllDisSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.selectall.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.modfiys.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSelectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDisselectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCompanySearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnItemSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    protected void loadCompanyForAssigned(String filterStr) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!StringUtils.isEmpty((String)filterStr)) {
                filter.getFilterItems().add(new FilterItemInfo(filterStr));
            }
            SorterItemInfo dsf = new SorterItemInfo("number");
            dsf.setSortType(SortType.ASCEND);
            evi.getSorter().add(dsf);
            filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)true));
            evi.setFilter(filter);
            CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
            this.tblCompanyForAssigned.checkParsed();
            this.tblCompanyForAssigned.removeRows();
            if (companyColl != null && companyColl.size() > 0) {
                CompanyOrgUnitInfo child = null;
                int count = companyColl.size();
                for (int i = 0; i < count; ++i) {
                    IRow row = this.tblCompanyForAssigned.addRow();
                    child = companyColl.get(i);
                    row.getCell("id").setUserObject((Object)child);
                    row.getCell("selected").setValue((Object)Boolean.FALSE);
                    row.getCell("selected").getStyleAttributes().setLocked(false);
                    row.getCell("companyNumber").setValue((Object)child.getNumber());
                    row.getCell("companyNumber").setUserObject((Object)child);
                    row.getCell("companyName").setValue((Object)child.getName());
                    row.getCell("code").setValue((Object)child.getCode());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void fillFilterFields() {
        this.itemSearchField.removeAllItems();
        this.companySearchField.removeAllItems();
        this.itemSearchField.addItems((Object[])this.getItemFilterFields());
        this.companySearchField.addItems((Object[])this.getCompanyFilterFields());
    }

    private FilterFieldItem[] getCompanyFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem("number", "\u7f16\u7801", ConstDataType.STRING), new FilterFieldItem("name", "\u540d\u79f0", ConstDataType.STRING)};
        }
        return ffis;
    }

    private FilterFieldItem[] getItemFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType) ? new FilterFieldItem[4] : new FilterFieldItem[]{new FilterFieldItem("number", "\u7f16\u7801", ConstDataType.STRING), new FilterFieldItem("name", "\u540d\u79f0", ConstDataType.STRING), new FilterFieldItem("taxType", "\u7a0e\u79cd", ConstDataType.STRING)};
            if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
                ffis[3] = new FilterFieldItem("indexType", "\u6307\u6807\u7c7b\u578b", ConstDataType.STRING);
            }
        }
        return ffis;
    }

    @Override
    public void actionSelectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)true);
        }
        this.rbAssigned.setSelected(false);
        this.rbNotAssigned.setSelected(false);
    }

    protected void loadItemForAssigned() {
        try {
            CheckBaseCollection checkColl = (CheckBaseCollection)this.getAllItemForAssign();
            if (checkColl != null) {
                this.tblAccountForAssigned.checkParsed();
                this.tblAccountForAssigned.removeRows();
                int count = checkColl.size();
                for (int i = 0; i < count; ++i) {
                    IRow row = this.tblAccountForAssigned.addRow();
                    CheckBaseInfo checkInfo = checkColl.get(i);
                    row.getCell("id").setValue((Object)checkInfo.getId().toString());
                    row.getCell("selected").setValue((Object)false);
                    row.getCell("number").setValue((Object)checkInfo.getNumber());
                    row.getCell("number").setUserObject((Object)checkInfo);
                    row.getCell("name").setValue((Object)checkInfo.getName());
                    row.getCell("taxType").setValue((Object)checkInfo.getTaxType().getName());
                    if (!CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) continue;
                    row.getCell("indexType").setValue((Object)((CheckIndexInfo)checkInfo).getIndexType().getName());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected IObjectCollection getAllItemForAssign() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxType.*"));
        if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
            sic.add(new SelectorItemInfo("indexType.*"));
        }
        view.setSelector(sic);
        CheckBaseCollection checkBaseColl = this.getBizInterface().getCheckBaseCollection(view);
        return checkBaseColl != null && checkBaseColl.size() > 0 ? checkBaseColl : new CheckBaseCollection();
    }

    protected ICheckBase getBizInterface() throws BOSException {
        ICheckBase checkBase = null;
        if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
            checkBase = CheckItemFactory.getRemoteInstance();
        } else if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
            checkBase = CheckIndexFactory.getRemoteInstance();
        }
        return checkBase;
    }

    @Override
    public void actionAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbNotAssigned.setSelected(false);
        this.btnAssign.setText("\u53cd\u5206\u914d");
        this.btnAssign.setToolTipText("\u53cd\u5206\u914d");
        this.loadSelectedStatus();
        this.itemFastQuery();
    }

    @Override
    public void actionNotAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbAssigned.setSelected(false);
        this.btnAssign.setText("\u5206\u914d");
        this.btnAssign.setToolTipText("\u5206\u914d");
        this.loadSelectedStatus();
        this.itemFastQuery();
    }

    private void itemFastQuery() {
        String text = StringUtils.trim((String)this.itemTextField.getText());
        String newCondition = this.itemSearchField.getSelectedItem().toString() + text;
        String filter = ((FilterFieldItem)this.itemSearchField.getSelectedItem()).getName();
        this.oldItemSearchCondition = newCondition;
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            CheckBaseInfo checkInfo = (CheckBaseInfo)row.getCell("number").getUserObject();
            if ("number".equals(filter) && !row.getStyleAttributes().isHided() && !checkInfo.getNumber().contains(text)) {
                row.getStyleAttributes().setHided(true);
            }
            if ("name".equals(filter) && !row.getStyleAttributes().isHided() && !checkInfo.getName().contains(text)) {
                row.getStyleAttributes().setHided(true);
            }
            if ("taxType".equals(filter) && !row.getStyleAttributes().isHided() && !checkInfo.getTaxType().getName().contains(text)) {
                row.getStyleAttributes().setHided(true);
            }
            if (!"indexType".equals(filter) || !CheckTypeEnum.TAXINDEX.equals((Object)this.checkType) || row.getStyleAttributes().isHided() || ((CheckIndexInfo)checkInfo).getIndexType().getName().contains(text)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void actionDisselectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)false);
        }
        this.loadSelectedStatus();
    }

    private void hideTblItemForAssigned() {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            row.getCell("selected").setValue((Object)false);
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void loadSelectedStatus() {
        this.hideTblItemForAssigned();
        boolean isAssigned = this.rbAssigned.isSelected();
        ArrayList showList = null;
        this.getAssignedItemIdList();
        showList = this.itemAssignedIDList;
        if (showList != null) {
            int count = this.tblAccountForAssigned.getRowCount();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblAccountForAssigned.getRow(i);
                CheckBaseInfo info = (CheckBaseInfo)row.getCell("number").getUserObject();
                String id = info.getId().toString();
                if (showList.contains(id) && isAssigned) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                if (isAssigned || !this.rbNotAssigned.isSelected() || showList.contains(id)) continue;
                row.getStyleAttributes().setHided(false);
            }
        }
    }

    protected void getAssignedItemIdList() {
        this.itemAssignedIDList.clear();
        HashSet<String> uncatchCompanyIDList = new HashSet<String>();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            CompanyOrgUnitInfo company;
            String companyId;
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue() || StringUtils.isEmpty((String)(companyId = (company = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject()).getId().toString()))) continue;
            uncatchCompanyIDList.add(companyId);
        }
        try {
            if (uncatchCompanyIDList != null && uncatchCompanyIDList.size() > 0) {
                this.itemAssignedIDList = (ArrayList)CheckViewFactory.getRemoteInstance().getCheckIDList(uncatchCompanyIDList, this.checkType);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    protected void companyTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.onClickForBtnCompanySearch();
        }
    }

    @Override
    protected void itemTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.onClickForBtnItemSearch();
        }
    }

    protected void verify() {
        this.storeFields();
        this.verifyInput();
    }

    protected void verifyInput() {
    }

    @Override
    public void storeFields() {
        this.storeCompanyAssigned();
        this.storeItemAssigned();
    }

    protected void storeCompanyAssigned() {
        this.couCols.clear();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject()).clone();
            this.couCols.add(info);
        }
    }

    protected void storeItemAssigned() {
        boolean assign = this.rbAssigned.isSelected();
        this.checkCols.clear();
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            CheckBaseInfo info;
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (!assign) {
                if (row.getStyleAttributes().isHided() || !((Boolean)row.getCell("selected").getValue()).booleanValue() || this.itemAssignedIDList.contains((info = (CheckBaseInfo)((CheckBaseInfo)row.getCell("number").getUserObject()).clone()).getId().toString())) continue;
                this.checkCols.add(info);
                continue;
            }
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue() || !this.itemAssignedIDList.contains((info = (CheckBaseInfo)((CheckBaseInfo)row.getCell("number").getUserObject()).clone()).getId().toString())) continue;
            this.checkCols.add(info);
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        boolean check = false;
        int rowcount = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            check = true;
            break;
        }
        if (check) {
            int i;
            boolean isAssign;
            this.verify();
            CompanyOrgUnitCollection couCols = this.getCouCols();
            CheckBaseCollection checkCols = this.getCheckCols();
            if (couCols == null || checkCols == null) {
                return;
            }
            if (couCols.size() == 0 || checkCols.size() == 0) {
                if (this.rbAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e8b\u9879\u53cd\u5206\u914d");
                }
                if (this.rbNotAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e8b\u9879\u5206\u914d");
                }
                return;
            }
            boolean bl = isAssign = !this.rbAssigned.isSelected();
            if (!isAssign) {
                StringBuffer confirmStr = new StringBuffer();
                confirmStr.append("\u5f53\u524d\u9009\u4e2d").append(couCols.size()).append("\u4e2a\u7ec4\u7ec7\u548c").append(checkCols.size()).append("\u4e2a\u4e8b\u9879\uff0c\u786e\u8ba4\u53cd\u5206\u914d\uff1f");
                if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)confirmStr.toString()))) {
                    return;
                }
            }
            List errorList = CheckViewFactory.getRemoteInstance().assignCheck((IObjectCollection)couCols, (IObjectCollection)checkCols, this.checkType, isAssign);
            if (isAssign && (errorList == null || errorList.size() == 0)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u4e8b\u9879\u5206\u914d\u6210\u529f");
            } else if (!isAssign) {
                if (!(isAssign || errorList != null && errorList.size() != 0)) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u4e8b\u9879\u53cd\u5206\u914d\u6210\u529f");
                } else if (!isAssign) {
                    // empty if block
                }
            }
            this.loadCompanyForAssigned(this.oldComSearchCondition);
            HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
            int count = couCols.size();
            for (i = 0; i < count; ++i) {
                CompanyOrgUnitInfo info = couCols.get(i);
                companyMap.put(info.getId().toString(), info);
            }
            count = this.tblCompanyForAssigned.getRowCount();
            for (i = 0; i < count; ++i) {
                IRow row = this.tblCompanyForAssigned.getRow(i);
                CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
                if (!companyMap.containsKey(info.getId().toString())) continue;
                row.getCell("selected").setValue((Object)Boolean.TRUE);
            }
            this.rbAssigned.setSelected(true);
            this.btnAssign.setText("\u53cd\u5206\u914d");
            this.btnAssign.setToolTipText("\u53cd\u5206\u914d");
            this.rbNotAssigned.setSelected(false);
            this.tblAccountForAssigned.getLayoutManager().scrollRowToShow(0);
            this.loadSelectedStatus();
            this.itemFastQuery();
        } else {
            MsgBox.showInfo((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7");
        }
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)true);
        }
    }

    @Override
    public void actionAllDisselect_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)false);
        }
    }

    public CompanyOrgUnitCollection getCouCols() {
        return this.couCols;
    }

    public CheckBaseCollection getCheckCols() {
        return this.checkCols;
    }

    public class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        public FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }
}

