/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexRangeEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DiffTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.OperateSymbolEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.RiskLevelEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckIndexEditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CheckIndexEditUI
extends AbstractCheckIndexEditUI
implements ItemListener {
    private static final Logger logger = CoreUIObject.getLogger(CheckIndexEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private static final String TB_RANGE = "range";
    private static final String TB_PROMPT = "prompt";
    private static final String TB_RISKLEVEL = "riskLevel";
    private KDTEditAdapter entryTableChange = null;
    private KDTMouseListener entryTableMouseClick = null;
    private static int RANGE_PRECISION = 9;
    private OperateSymbolEnum oldOperate = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private Map btnMap = new HashMap();

    public CheckIndexEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    protected void initListener() {
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CheckIndexInfo editData = (CheckIndexInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setName(editData.getName() + "Copy");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initIndexTypeFilter();
        this.afterLoad();
    }

    protected void initIndexTypeFilter() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        this.prmtIndexType.setEntityViewInfo(entityViewInfo);
    }

    @Override
    protected void afterLoad() {
        super.afterLoad();
        this.initEntryEditor();
        this.setEntryPrompt();
        this.initOldData((IObjectValue)this.editData);
        OperateSymbolEnum oldOperate = (OperateSymbolEnum)((Object)this.comboOperateSymbol.getSelectedItem());
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.addEventLisener();
        this.initBtnStatus();
        this.reInitBtnStatus();
        this.initComponents();
    }

    private void reInitBtnStatus() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        EnableStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EnableStateEnum.DISABLE.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    private void initComponents() {
        if (this.editData == null) {
            return;
        }
        DiffTypeEnum rangeType = this.editData.getRangeType();
        if (DiffTypeEnum.STANDARDPERENT.equals((Object)rangeType)) {
            this.kdtRangeEntry.getHeadRow(0).getCell(0).setValue((Object)"\u504f\u5dee\u8303\u56f4\uff08%\uff09");
        } else {
            this.kdtRangeEntry.getHeadRow(0).getCell(0).setValue((Object)"\u504f\u5dee\u8303\u56f4");
        }
    }

    private void addEventLisener() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        CheckIndexEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception ex) {
                        CheckIndexEditUI.this.handUIException(ex);
                    }
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        CheckIndexEditUI.this.kdtEntries_editStarting(e);
                    }
                    catch (Exception ex) {
                        CheckIndexEditUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.entryTableMouseClick == null) {
            this.entryTableMouseClick = new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                }
            };
        }
        this.getDetailTable().addKDTMouseListener(this.entryTableMouseClick);
        this.comboOperateSymbol.addItemListener((ItemListener)this);
        this.comboRangeType.addItemListener((ItemListener)this);
    }

    protected void operateSymbol_dataChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            OperateSymbolEnum operate = (OperateSymbolEnum)((Object)e.getItem());
            if (OperateSymbolEnum.EQUAL.equals((Object)this.oldOperate) && !OperateSymbolEnum.EQUAL.equals((Object)operate) && this.kdtRangeEntry.getRowCount() > 2) {
                int result = MsgBox.showConfirm3((String)"\u5207\u6362\u7b49\u5f0f\u5173\u7cfb\u5c06\u91cd\u65b0\u521d\u59cb\u5316\u5206\u5f55\uff0c\u786e\u8ba4\u5207\u6362\u5417\uff1f");
                if (result != 0) {
                    this.comboOperateSymbol.setSelectedItem((Object)this.oldOperate, false);
                    return;
                }
                this.storeFields();
                this.editData.getRangeEntry().clear();
                CheckIndexRangeEntryInfo entryInfo = (CheckIndexRangeEntryInfo)this.createNewDetailData(this.getDetailTable());
                entryInfo.setSeq(1);
                entryInfo.setRiskLevel(RiskLevelEnum.getEnum("0"));
                entryInfo.setRange(BigDecimal.ZERO);
                this.editData.getRangeEntry().add(entryInfo);
                entryInfo = (CheckIndexRangeEntryInfo)this.createNewDetailData(this.getDetailTable());
                entryInfo.setSeq(2);
                entryInfo.setRange(null);
                entryInfo.setRiskLevel(RiskLevelEnum.getEnum("1"));
                this.editData.getRangeEntry().add(entryInfo);
                this.loadFields();
            }
            this.setEntryPrompt();
        } else if (e.getStateChange() == 2) {
            this.oldOperate = (OperateSymbolEnum)((Object)e.getItem());
        }
    }

    protected void rangeType_dataChanged() {
        DiffTypeEnum rangeType = (DiffTypeEnum)((Object)this.comboRangeType.getSelectedItem());
        if (DiffTypeEnum.STANDARDPERENT.equals((Object)rangeType)) {
            this.kdtRangeEntry.getHeadRow(0).getCell(0).setValue((Object)"\u504f\u5dee\u8303\u56f4\uff08%\uff09");
        } else {
            this.kdtRangeEntry.getHeadRow(0).getCell(0).setValue((Object)"\u504f\u5dee\u8303\u56f4");
        }
    }

    protected void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        IRow row = this.kdtRangeEntry.getRow(e.getRowIndex());
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtRangeEntry.getColumnKey(colIndex);
        if (TB_RISKLEVEL.equalsIgnoreCase(fieldName)) {
            RiskLevelEnum riskLevel = (RiskLevelEnum)((Object)e.getValue());
            if (RiskLevelEnum.Level0.equals((Object)riskLevel)) {
                e.setCancel(true);
                return;
            }
        } else if (TB_RANGE.equalsIgnoreCase(fieldName)) {
            RiskLevelEnum riskLevel = (RiskLevelEnum)((Object)this.kdtRangeEntry.getCell(rowIndex, TB_RISKLEVEL).getValue());
            if (RiskLevelEnum.Level3.equals((Object)riskLevel)) {
                e.setCancel(true);
                return;
            }
            if (!OperateSymbolEnum.EQUAL.equals(this.comboOperateSymbol.getSelectedItem()) && rowIndex == 1) {
                e.setCancel(true);
                return;
            }
        }
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.kdtRangeEntry.getRow(e.getRowIndex());
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtRangeEntry.getColumnKey(colIndex);
        if (TB_RANGE.equalsIgnoreCase(fieldName)) {
            BigDecimal nextRange;
            BigDecimal preRange;
            BigDecimal range = (BigDecimal)e.getValue();
            if (range == null) {
                return;
            }
            int index = rowIndex - 1;
            if (index >= 0 && (preRange = (BigDecimal)this.kdtRangeEntry.getCell(rowIndex - 1, TB_RANGE).getValue()) != null && range.compareTo(preRange) <= 0) {
                row.getCell(TB_RANGE).setValue(e.getOldValue());
                MsgBox.showInfo((Component)((Object)this), (String)"\u504f\u5dee\u8303\u56f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u4e00\u6761\u5206\u5f55");
                return;
            }
            index = rowIndex + 1;
            if (index < this.kdtRangeEntry.getRowCount() && (nextRange = (BigDecimal)this.kdtRangeEntry.getCell(rowIndex + 1, TB_RANGE).getValue()) != null && range.compareTo(nextRange) >= 0) {
                row.getCell(TB_RANGE).setValue(e.getOldValue());
                MsgBox.showInfo((Component)((Object)this), (String)"\u504f\u5dee\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u4e0b\u4e00\u6761\u5206\u5f55");
                return;
            }
            RiskLevelEnum riskLevel = (RiskLevelEnum)((Object)this.kdtRangeEntry.getCell(rowIndex, TB_RISKLEVEL).getValue());
            this.autoAddLine(rowIndex, range, riskLevel);
            this.setEntryPrompt();
        } else if (TB_RISKLEVEL.equalsIgnoreCase(fieldName)) {
            RiskLevelEnum riskLevel = (RiskLevelEnum)((Object)e.getValue());
            RiskLevelEnum rowRiskLevel = null;
            for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                rowRiskLevel = (RiskLevelEnum)((Object)this.kdtRangeEntry.getCell(i, TB_RISKLEVEL).getValue());
                if (riskLevel.equals((Object)rowRiskLevel) && i != rowIndex) {
                    this.kdtRangeEntry.getCell(rowIndex, TB_RISKLEVEL).setValue(e.getOldValue());
                    MsgBox.showInfo((Component)((Object)this), (String)"\u98ce\u9669\u7a0b\u5ea6\u4e0d\u80fd\u91cd\u590d");
                    return;
                }
                rowRiskLevel = (RiskLevelEnum)((Object)this.kdtRangeEntry.getCell(rowIndex - 1, TB_RISKLEVEL).getValue());
                if (riskLevel.getValue().compareTo(rowRiskLevel.getValue()) >= 0) continue;
                row.getCell(TB_RISKLEVEL).setValue(e.getOldValue());
                MsgBox.showInfo((Component)((Object)this), (String)"\u98ce\u9669\u7b49\u7ea7\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u4e00\u6761\u5206\u5f55");
                return;
            }
        }
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NUMBER"));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NAME"));
        }
        if (this.prmtTaxType.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"TAXTYPE"));
        }
        if (this.prmtIndexType.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"INDEXTYPENAME"));
        }
        if (this.txtLFormula.getText().isEmpty()) {
            sb.append("\u3001\u6307\u6807\u8ba1\u7b97\u503c");
        }
        if (this.txtRFormula.getText().isEmpty()) {
            sb.append("\u3001\u6307\u6807\u5bf9\u6807\u503c");
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 1024) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
            if (this.txtLFormula.getText().getBytes("utf8").length > 255) {
                sb.append("\u3001\u6307\u6807\u8ba1\u7b97\u503c");
            }
            if (this.txtRFormula.getText().getBytes("utf8").length > 255) {
                sb.append("\u3001\u6307\u6807\u5bf9\u6807\u503c");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if (this.getDetailTable().getRowCount() < 2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)TDRESOURCE, (String)"RISKLEVEL_NOT_NULL"));
            SysUtil.abort();
            return;
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = CheckIndexFactory.getRemoteInstance().checkNumberDup(null, this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)TDRESOURCE, (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setOprtState(OprtState.EDIT);
        this.reInitBtnStatus();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private String getPrompt(int rowIndex, OperateSymbolEnum operate, BigDecimal range) {
        StringBuffer prompt = new StringBuffer();
        if (OperateSymbolEnum.EQUAL.equals((Object)operate)) {
            if (rowIndex == 0) {
                prompt.append("<=").append(range.toPlainString());
            } else if (rowIndex == this.getDetailTable().getRowCount() - 1) {
                BigDecimal preRange = (BigDecimal)this.kdtRangeEntry.getCell(rowIndex - 1, TB_RANGE).getValue();
                prompt.append(">").append(preRange.toPlainString());
            } else {
                BigDecimal preRange = (BigDecimal)this.kdtRangeEntry.getCell(rowIndex - 1, TB_RANGE).getValue();
                prompt.append("(").append(preRange.toPlainString()).append(",").append("").append(range.toPlainString()).append("]");
            }
        } else if (rowIndex == 0) {
            prompt.append(operate.getAlias()).append(range.toPlainString());
        } else {
            BigDecimal preRange = (BigDecimal)this.kdtRangeEntry.getCell(rowIndex - 1, TB_RANGE).getValue();
            prompt.append(this.getReverseSymbol(operate).getAlias()).append(preRange.toPlainString());
        }
        return prompt.toString();
    }

    private OperateSymbolEnum getReverseSymbol(OperateSymbolEnum operate) {
        OperateSymbolEnum reverseSymbol = null;
        if (OperateSymbolEnum.LESS.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.MOREANDEQUAL;
        } else if (OperateSymbolEnum.MORE.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.LESSANDEQUAL;
        } else if (OperateSymbolEnum.LESSANDEQUAL.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.MORE;
        } else if (OperateSymbolEnum.MOREANDEQUAL.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.LESS;
        } else if (OperateSymbolEnum.UNEQUAL.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.EQUAL;
        } else if (OperateSymbolEnum.EQUAL.equals((Object)operate)) {
            reverseSymbol = OperateSymbolEnum.UNEQUAL;
        }
        return reverseSymbol;
    }

    private void setEntryPrompt() {
        OperateSymbolEnum operate = (OperateSymbolEnum)((Object)this.comboOperateSymbol.getSelectedItem());
        for (int i = 0; i < this.kdtRangeEntry.getRowCount(); ++i) {
            BigDecimal range = (BigDecimal)this.kdtRangeEntry.getCell(i, TB_RANGE).getValue();
            this.kdtRangeEntry.getCell(i, TB_PROMPT).setValue((Object)this.getPrompt(i, operate, range));
            if (i != this.kdtRangeEntry.getRowCount() - 1) continue;
            this.kdtRangeEntry.getCell(i, TB_RANGE).setValue(null);
        }
    }

    protected void autoAddLine(int rowIndex, BigDecimal range, RiskLevelEnum riskLevel) {
        if (rowIndex != this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int level = Integer.parseInt(riskLevel.getValue());
        if (level == 3) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(this.getDetailTable());
        CheckIndexRangeEntryInfo entryInfo = (CheckIndexRangeEntryInfo)detailData;
        entryInfo.setSeq(this.editData.getRangeEntry().size() + 1);
        entryInfo.setRiskLevel(RiskLevelEnum.getEnum(level + 1 + ""));
        OperateSymbolEnum operate = (OperateSymbolEnum)((Object)this.comboOperateSymbol.getSelectedItem());
        entryInfo.setPrompt(this.getPrompt(rowIndex + 1, operate, range));
        if (detailData != null) {
            IRow row = this.getDetailTable().addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.getDetailTable(), detailData);
            this.loadLineFields(this.getDetailTable(), row, detailData);
            this.afterAddLine(this.getDetailTable(), detailData);
        }
    }

    private void removeEventLisener() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
        this.getDetailTable().removeKDTMouseListener(this.entryTableMouseClick);
        this.comboOperateSymbol.removeItemListener((ItemListener)this);
        this.comboRangeType.removeItemListener((ItemListener)this);
    }

    private void initEntryEditor() {
        this.setEnumEditor(this.getDetailTable(), TB_RISKLEVEL, RiskLevelEnum.class.getName());
        this.getDetailTable().getColumn(TB_PROMPT).getStyleAttributes().setLocked(true);
        KDFormattedTextField range = new KDFormattedTextField();
        range.setDataType(1);
        range.setPrecision(RANGE_PRECISION);
        range.setSupportedEmpty(true);
        range.setRemoveingZeroInDispaly(false);
        range.setNegatived(false);
        range.setHorizontalAlignment(4);
        KDTDefaultCellEditor rangeEditor = new KDTDefaultCellEditor((JTextField)range);
        this.kdtRangeEntry.getColumn(TB_RANGE).setEditor((ICellEditor)rangeEditor);
        this.kdtRangeEntry.getColumn(TB_RANGE).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)RANGE_PRECISION));
        KDTSortManager topSortManager = new KDTSortManager(this.kdtRangeEntry);
        topSortManager.setSortAuto(false);
        topSortManager.setEnableSortable(false);
        for (int i = 0; i < this.kdtRangeEntry.getColumnCount(); ++i) {
            this.kdtRangeEntry.getColumn(i).setSortable(false);
        }
    }

    protected IObjectValue createNewData() {
        CheckIndexInfo info = new CheckIndexInfo();
        info.setOperateSymbol(OperateSymbolEnum.EQUAL);
        info.setRangeType(DiffTypeEnum.STANDARDVALUE);
        CheckIndexRangeEntryInfo entryInfo = (CheckIndexRangeEntryInfo)this.createNewDetailData(this.getDetailTable());
        entryInfo.setSeq(1);
        entryInfo.setRiskLevel(RiskLevelEnum.getEnum("0"));
        entryInfo.setRange(BigDecimal.ZERO);
        info.getRangeEntry().add(entryInfo);
        entryInfo = (CheckIndexRangeEntryInfo)this.createNewDetailData(this.getDetailTable());
        entryInfo.setSeq(2);
        entryInfo.setRange(null);
        entryInfo.setRiskLevel(RiskLevelEnum.getEnum("1"));
        info.getRangeEntry().add(entryInfo);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckIndexFactory.getRemoteInstance();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.tableContainer.add((Action)this.actionRemoveLine));
        for (int i = 0; i < btnList.size(); ++i) {
            KDWorkButton btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CheckIndexRangeEntryInfo entryInfo = new CheckIndexRangeEntryInfo();
        return entryInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtRangeEntry;
    }

    @Override
    public void actionLFormula_actionPerformed(ActionEvent e) throws Exception {
        this.openFormula(true, true);
    }

    @Override
    public void actionRFormula_actionPerformed(ActionEvent e) throws Exception {
        this.openFormula(false, true);
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk && this.isLeft) {
            this.txtLFormula.setText(this.txtLFormula.getText() + formulaLine);
        } else if (isOk && !this.isLeft) {
            this.txtRFormula.setText(this.txtRFormula.getText() + formulaLine);
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.getDetailTable());
        boolean hasFirst = false;
        for (int i = 0; i < indexs.length; ++i) {
            if (indexs[i] != 0) continue;
            hasFirst = true;
        }
        if (hasFirst) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6b63\u5e38\u7684\u504f\u5dee\u8303\u56f4\u4e0d\u80fd\u5220\u9664");
            return;
        }
        if (this.getDetailTable().getRowCount() == 2) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u98ce\u9669\u7a0b\u5ea6\u81f3\u5c11\u5b9a\u4e49\u4e00\u4e2a\u7b49\u7ea7");
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
        this.setEntryPrompt();
    }

    protected void initTableKeyStroke(KDTable table, boolean isDownArrow) {
    }

    @Override
    protected CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXINDEX;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = CheckIndexFactory.getRemoteInstance().checkNumberDup(null, this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)TDRESOURCE, (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData.getState() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.comboOperateSymbol)) {
            this.operateSymbol_dataChanged(e);
        } else if (e.getSource().equals(this.comboRangeType)) {
            this.rangeType_dataChanged();
        }
    }
}

